/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jd.core.v1.model.classfile.ClassFile;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.declaration.AnnotationDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.BaseFormalParameter;
import org.jd.core.v1.model.javasyntax.declaration.BodyDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ClassDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ConstructorDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.Declaration;
import org.jd.core.v1.model.javasyntax.declaration.DeclarationVisitor;
import org.jd.core.v1.model.javasyntax.declaration.EnumDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.FieldDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.FieldDeclarator;
import org.jd.core.v1.model.javasyntax.declaration.FormalParameter;
import org.jd.core.v1.model.javasyntax.declaration.InterfaceDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.LocalVariableDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.LocalVariableDeclarator;
import org.jd.core.v1.model.javasyntax.declaration.MethodDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.StaticInitializerDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.TypeDeclaration;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.ConstructorInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor;
import org.jd.core.v1.model.javasyntax.expression.FieldReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.NewExpression;
import org.jd.core.v1.model.javasyntax.expression.ObjectTypeReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.SuperConstructorInvocationExpression;
import org.jd.core.v1.model.javasyntax.statement.BaseStatement;
import org.jd.core.v1.model.javasyntax.statement.ForEachStatement;
import org.jd.core.v1.model.javasyntax.statement.LocalVariableDeclarationStatement;
import org.jd.core.v1.model.javasyntax.statement.Statement;
import org.jd.core.v1.model.javasyntax.statement.StatementVisitor;
import org.jd.core.v1.model.javasyntax.statement.Statements;
import org.jd.core.v1.model.javasyntax.statement.TryStatement;
import org.jd.core.v1.model.javasyntax.statement.TypeDeclarationStatement;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileBodyDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileClassDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileMemberDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileStaticInitializerDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileTypeDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileConstructorInvocationExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileLocalVariableReferenceExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileNewExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileSuperConstructorInvocationExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.AbstractLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.AbstractUpdateExpressionVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.SearchFirstLineNumberVisitor;
import org.jd.core.v1.util.DefaultList;

public class InitInnerClassVisitor
extends AbstractJavaSyntaxVisitor {
    private final UpdateFieldDeclarationsAndReferencesVisitor updateFieldDeclarationsAndReferencesVisitor = new UpdateFieldDeclarationsAndReferencesVisitor();
    private final DefaultList<String> syntheticInnerFieldNames = new DefaultList();
    private String outerTypeFieldName;

    @Override
    public void visit(AnnotationDeclaration declaration) {
        this.safeAccept((Declaration)declaration.getBodyDeclaration());
    }

    @Override
    public void visit(ClassDeclaration declaration) {
        this.safeAccept((Declaration)declaration.getBodyDeclaration());
    }

    @Override
    public void visit(EnumDeclaration declaration) {
        this.safeAccept((Declaration)declaration.getBodyDeclaration());
    }

    @Override
    public void visit(InterfaceDeclaration declaration) {
        this.safeAccept((Declaration)declaration.getBodyDeclaration());
    }

    @Override
    public void visit(BodyDeclaration declaration) {
        ClassFileBodyDeclaration bodyDeclaration = (ClassFileBodyDeclaration)declaration;
        this.outerTypeFieldName = null;
        this.syntheticInnerFieldNames.clear();
        this.safeAcceptListDeclaration(bodyDeclaration.getMethodDeclarations());
        bodyDeclaration.setOuterTypeFieldName(this.outerTypeFieldName);
        if (!this.syntheticInnerFieldNames.isEmpty()) {
            bodyDeclaration.setSyntheticInnerFieldNames((DefaultList<String>)new DefaultList(this.syntheticInnerFieldNames));
        }
        if (this.outerTypeFieldName != null || !this.syntheticInnerFieldNames.isEmpty()) {
            this.updateFieldDeclarationsAndReferencesVisitor.visit(bodyDeclaration);
        }
    }

    @Override
    public void visit(ConstructorDeclaration declaration) {
        BaseFormalParameter parameters;
        ClassFileConstructorDeclaration cfcd = (ClassFileConstructorDeclaration)declaration;
        ClassFile classFile = cfcd.getClassFile();
        ClassFile outerClassFile = classFile.getOuterClassFile();
        boolean removeFirstParameter = false;
        this.syntheticInnerFieldNames.clear();
        if (cfcd.getStatements().isList()) {
            Iterator iterator = cfcd.getStatements().iterator();
            while (iterator.hasNext()) {
                Statement statement = (Statement)iterator.next();
                if (statement.isExpressionStatement()) {
                    Expression e;
                    Expression expression = statement.getExpression();
                    if (expression.isSuperConstructorInvocationExpression()) break;
                    if (expression.isConstructorInvocationExpression()) {
                        if (outerClassFile == null || classFile.isStatic()) break;
                        removeFirstParameter = true;
                        break;
                    }
                    if (expression.isBinaryOperatorExpression() && (e = expression.getLeftExpression()).isFieldReferenceExpression()) {
                        String name = e.getName();
                        if (name.startsWith("this$")) {
                            this.outerTypeFieldName = name;
                            removeFirstParameter = true;
                        } else if (name.startsWith("val$")) {
                            this.syntheticInnerFieldNames.add((Object)name);
                        }
                    }
                }
                iterator.remove();
            }
        }
        if ((parameters = cfcd.getFormalParameters()) != null) {
            if (parameters.isList()) {
                int size;
                int count;
                DefaultList list = parameters.getList();
                if (removeFirstParameter) {
                    list.remove(0);
                }
                if ((count = this.syntheticInnerFieldNames.size()) > 0 && (size = list.size()) > 0 && count <= size) {
                    list.subList(size - count, size).clear();
                }
            } else if (removeFirstParameter || !this.syntheticInnerFieldNames.isEmpty()) {
                cfcd.setFormalParameters(null);
            }
        }
        if (outerClassFile != null) {
            String internalTypeName;
            String outerTypeName = outerClassFile.getInternalTypeName();
            int min = (internalTypeName = cfcd.getClassFile().getInternalTypeName()).startsWith(outerTypeName + "$") ? outerTypeName.length() + 1 : internalTypeName.lastIndexOf(36) + 1;
            if (Character.isDigit(internalTypeName.charAt(min))) {
                int i = internalTypeName.length();
                boolean anonymousFlag = true;
                while (--i > min) {
                    if (Character.isDigit(internalTypeName.charAt(i))) continue;
                    anonymousFlag = false;
                    break;
                }
                if (anonymousFlag) {
                    cfcd.setFlags(cfcd.getFlags() | 0x200);
                    cfcd.getBodyDeclaration().setAnonymous(anonymousFlag);
                }
            }
        }
    }

    @Override
    public void visit(MethodDeclaration declaration) {
    }

    @Override
    public void visit(StaticInitializerDeclaration declaration) {
    }

    protected class UpdateFieldDeclarationsAndReferencesVisitor
    extends AbstractUpdateExpressionVisitor {
        private ClassFileBodyDeclaration bodyDeclaration;
        private boolean syntheticField;

        protected UpdateFieldDeclarationsAndReferencesVisitor() {
        }

        @Override
        public void visit(BodyDeclaration declaration) {
            this.bodyDeclaration = (ClassFileBodyDeclaration)declaration;
            this.safeAcceptListDeclaration(this.bodyDeclaration.getFieldDeclarations());
            this.safeAcceptListDeclaration(this.bodyDeclaration.getMethodDeclarations());
        }

        @Override
        public void visit(FieldDeclaration declaration) {
            this.syntheticField = false;
            declaration.getFieldDeclarators().accept((DeclarationVisitor)this);
            if (this.syntheticField) {
                declaration.setFlags(declaration.getFlags() | 0x1000);
            }
        }

        @Override
        public void visit(FieldDeclarator declarator) {
            String name = declarator.getName();
            if (name.equals(InitInnerClassVisitor.this.outerTypeFieldName) || InitInnerClassVisitor.this.syntheticInnerFieldNames.contains((Object)name)) {
                this.syntheticField = true;
            }
        }

        @Override
        public void visit(StaticInitializerDeclaration declaration) {
        }

        @Override
        public void visit(MethodDeclaration declaration) {
            this.safeAccept(declaration.getStatements());
        }

        @Override
        public void visit(NewExpression expression) {
            if (expression.getParameters() != null) {
                expression.setParameters(this.updateBaseExpression(expression.getParameters()));
                expression.getParameters().accept((ExpressionVisitor)this);
            }
            this.safeAccept((Declaration)expression.getBodyDeclaration());
        }

        @Override
        public void visit(FieldReferenceExpression expression) {
            if (expression.getName().startsWith("this$")) {
                if (expression.getInternalTypeName().equals(this.bodyDeclaration.getInternalTypeName())) {
                    if (expression.getName().equals(InitInnerClassVisitor.this.outerTypeFieldName)) {
                        ObjectType objectType = (ObjectType)expression.getType();
                        FieldReferenceExpression exp = expression.getExpression() == null ? expression : expression.getExpression();
                        expression.setExpression((Expression)new ObjectTypeReferenceExpression(exp.getLineNumber(), objectType.createType(null)));
                        expression.setName("this");
                    }
                } else {
                    ObjectType objectType;
                    ClassFileBodyDeclaration cfbd;
                    String outerInternalTypeName;
                    ClassFileTypeDeclaration typeDeclaration = this.bodyDeclaration.getInnerTypeDeclaration(expression.getInternalTypeName());
                    if (typeDeclaration != null && typeDeclaration.isClassDeclaration() && (outerInternalTypeName = (cfbd = (ClassFileBodyDeclaration)typeDeclaration.getBodyDeclaration()).getOuterBodyDeclaration().getInternalTypeName()).equals((objectType = (ObjectType)expression.getType()).getInternalName())) {
                        FieldReferenceExpression exp = expression.getExpression() == null ? expression : expression.getExpression();
                        expression.setExpression((Expression)new ObjectTypeReferenceExpression(exp.getLineNumber(), objectType.createType(null)));
                        expression.setName("this");
                    }
                }
            } else if (expression.getName().startsWith("val$")) {
                expression.setName(expression.getName().substring(4));
                expression.setExpression(null);
            } else {
                super.visit(expression);
            }
        }

        @Override
        protected Expression updateExpression(Expression expression) {
            if (expression.isLocalVariableReferenceExpression() && expression.getName() != null && expression.getName().equals(InitInnerClassVisitor.this.outerTypeFieldName) && expression.getType().isObjectType()) {
                ObjectType objectType = (ObjectType)expression.getType();
                if (this.bodyDeclaration.getOuterBodyDeclaration().getInternalTypeName().equals(objectType.getInternalName())) {
                    return new FieldReferenceExpression((Type)objectType, (Expression)new ObjectTypeReferenceExpression(expression.getLineNumber(), objectType.createType(null)), objectType.getInternalName(), "this", objectType.getDescriptor());
                }
            }
            return expression;
        }
    }

    public static class UpdateNewExpressionVisitor
    extends AbstractJavaSyntaxVisitor {
        private final TypeMaker typeMaker;
        private ClassFileBodyDeclaration bodyDeclaration;
        private ClassFile classFile;
        private final Map<String, String> finalLocalVariableNameMap = new HashMap<String, String>();
        private final DefaultList<ClassFileClassDeclaration> localClassDeclarations = new DefaultList();
        private final Set<NewExpression> newExpressions = new HashSet<NewExpression>();
        private int lineNumber;

        public UpdateNewExpressionVisitor(TypeMaker typeMaker) {
            this.typeMaker = typeMaker;
        }

        @Override
        public void visit(BodyDeclaration declaration) {
            this.bodyDeclaration = (ClassFileBodyDeclaration)declaration;
            this.safeAcceptListDeclaration(this.bodyDeclaration.getMethodDeclarations());
        }

        @Override
        public void visit(ConstructorDeclaration declaration) {
            this.classFile = ((ClassFileConstructorDeclaration)declaration).getClassFile();
            this.finalLocalVariableNameMap.clear();
            this.localClassDeclarations.clear();
            this.safeAccept(declaration.getStatements());
            if (!this.finalLocalVariableNameMap.isEmpty()) {
                UpdateParametersAndLocalVariablesVisitor visitor = new UpdateParametersAndLocalVariablesVisitor();
                declaration.getStatements().accept((StatementVisitor)visitor);
                if (declaration.getFormalParameters() != null) {
                    declaration.getFormalParameters().accept((DeclarationVisitor)visitor);
                }
            }
            if (!this.localClassDeclarations.isEmpty()) {
                this.localClassDeclarations.sort(Comparator.comparing(ClassFileMemberDeclaration::getFirstLineNumber));
                declaration.accept((DeclarationVisitor)new AddLocalClassDeclarationVisitor());
            }
        }

        @Override
        public void visit(MethodDeclaration declaration) {
            this.finalLocalVariableNameMap.clear();
            this.localClassDeclarations.clear();
            this.safeAccept(declaration.getStatements());
            if (!this.finalLocalVariableNameMap.isEmpty()) {
                UpdateParametersAndLocalVariablesVisitor visitor = new UpdateParametersAndLocalVariablesVisitor();
                declaration.getStatements().accept((StatementVisitor)visitor);
                if (declaration.getFormalParameters() != null) {
                    declaration.getFormalParameters().accept((DeclarationVisitor)visitor);
                }
            }
            if (!this.localClassDeclarations.isEmpty()) {
                this.localClassDeclarations.sort(Comparator.comparing(ClassFileMemberDeclaration::getFirstLineNumber));
                declaration.accept((DeclarationVisitor)new AddLocalClassDeclarationVisitor());
            }
        }

        @Override
        public void visit(StaticInitializerDeclaration declaration) {
            this.finalLocalVariableNameMap.clear();
            this.localClassDeclarations.clear();
            this.safeAccept(declaration.getStatements());
            if (!this.finalLocalVariableNameMap.isEmpty()) {
                declaration.getStatements().accept((StatementVisitor)new UpdateParametersAndLocalVariablesVisitor());
            }
            if (!this.localClassDeclarations.isEmpty()) {
                this.localClassDeclarations.sort(Comparator.comparing(ClassFileMemberDeclaration::getFirstLineNumber));
                declaration.accept((DeclarationVisitor)new AddLocalClassDeclarationVisitor());
            }
        }

        @Override
        public void visit(Statements list) {
            if (!list.isEmpty()) {
                ListIterator iterator = list.listIterator();
                while (iterator.hasNext()) {
                    Statement s = (Statement)iterator.next();
                    s.accept((StatementVisitor)this);
                    if (this.lineNumber != 0 || this.localClassDeclarations.isEmpty()) continue;
                    iterator.previous();
                    for (TypeDeclaration typeDeclaration : this.localClassDeclarations) {
                        iterator.add(new TypeDeclarationStatement(typeDeclaration));
                    }
                    this.localClassDeclarations.clear();
                    iterator.next();
                }
            }
        }

        @Override
        public void visit(NewExpression expression) {
            if (this.newExpressions.add(expression)) {
                ClassFileNewExpression ne = (ClassFileNewExpression)expression;
                ClassFileBodyDeclaration cfbd = null;
                if (ne.getBodyDeclaration() == null) {
                    ObjectType type = ne.getObjectType();
                    String internalName = type.getInternalName();
                    ClassFileTypeDeclaration typeDeclaration = this.bodyDeclaration.getInnerTypeDeclaration(internalName);
                    if (typeDeclaration == null) {
                        for (ClassFileBodyDeclaration bd = this.bodyDeclaration; bd != null; bd = bd.getOuterBodyDeclaration()) {
                            if (!bd.getInternalTypeName().equals(internalName)) continue;
                            cfbd = bd;
                            break;
                        }
                    } else if (typeDeclaration.isClassDeclaration()) {
                        ClassFileClassDeclaration cfcd = (ClassFileClassDeclaration)typeDeclaration;
                        cfbd = (ClassFileBodyDeclaration)cfcd.getBodyDeclaration();
                        if (type.getQualifiedName() == null && type.getName() != null) {
                            cfcd.setFlags(cfcd.getFlags() & 0xFFFFEFFF);
                            this.localClassDeclarations.add((Object)cfcd);
                            this.bodyDeclaration.removeInnerType(internalName);
                            this.lineNumber = ne.getLineNumber();
                        }
                    }
                } else {
                    cfbd = (ClassFileBodyDeclaration)ne.getBodyDeclaration();
                }
                if (cfbd != null) {
                    BaseExpression parameters = ne.getParameters();
                    BaseType parameterTypes = ne.getParameterTypes();
                    if (parameters != null) {
                        DefaultList<String> syntheticInnerFieldNames = cfbd.getSyntheticInnerFieldNames();
                        if (parameters.isList()) {
                            DefaultList list = parameters.getList();
                            DefaultList types = parameterTypes.getList();
                            if (cfbd.getOuterTypeFieldName() != null) {
                                list.removeFirst();
                                types.removeFirst();
                            }
                            if (syntheticInnerFieldNames != null) {
                                int size = list.size();
                                int count = syntheticInnerFieldNames.size();
                                List lastParameters = list.subList(size - count, size);
                                Iterator parameterIterator = lastParameters.iterator();
                                Iterator syntheticInnerFieldNameIterator = syntheticInnerFieldNames.iterator();
                                while (parameterIterator.hasNext()) {
                                    Expression param = (Expression)parameterIterator.next();
                                    String syntheticInnerFieldName = (String)syntheticInnerFieldNameIterator.next();
                                    if (param.isCastExpression()) {
                                        param = param.getExpression();
                                    }
                                    if (!param.isLocalVariableReferenceExpression()) continue;
                                    AbstractLocalVariable lv = ((ClassFileLocalVariableReferenceExpression)param).getLocalVariable();
                                    String localVariableName = syntheticInnerFieldName.substring(4);
                                    this.finalLocalVariableNameMap.put(lv.getName(), localVariableName);
                                }
                                lastParameters.clear();
                                types.subList(size - count, size).clear();
                            }
                        } else if (cfbd.getOuterTypeFieldName() != null) {
                            ne.setParameters(null);
                            ne.setParameterTypes(null);
                        } else if (syntheticInnerFieldNames != null) {
                            Expression param = (Expression)parameters.getFirst();
                            if (param.isCastExpression()) {
                                param = param.getExpression();
                            }
                            if (param.isLocalVariableReferenceExpression()) {
                                AbstractLocalVariable lv = ((ClassFileLocalVariableReferenceExpression)param).getLocalVariable();
                                String localVariableName = ((String)syntheticInnerFieldNames.getFirst()).substring(4);
                                this.finalLocalVariableNameMap.put(lv.getName(), localVariableName);
                                ne.setParameters(null);
                                ne.setParameterTypes(null);
                            }
                        }
                        parameters = ne.getParameters();
                        if (parameters != null && parameters.size() > 0 && ((Expression)parameters.getLast()).isNullExpression() && ((Type)(parameterTypes = ne.getParameterTypes()).getLast()).getName() == null) {
                            if (parameters.isList()) {
                                parameters.getList().removeLast();
                                parameterTypes.getList().removeLast();
                            } else {
                                ne.setParameters(null);
                                ne.setParameterTypes(null);
                            }
                        }
                    }
                }
            }
            this.safeAccept(expression.getParameters());
        }

        @Override
        public void visit(SuperConstructorInvocationExpression expression) {
            ClassFileSuperConstructorInvocationExpression scie = (ClassFileSuperConstructorInvocationExpression)expression;
            BaseExpression parameters = scie.getParameters();
            if (parameters != null && parameters.size() > 0) {
                TypeMaker.TypeTypes superTypeTypes;
                Type firstParameterType = ((Expression)parameters.getFirst()).getType();
                if (firstParameterType.isObjectType() && !this.classFile.isStatic() && this.bodyDeclaration.getOuterTypeFieldName() != null && (superTypeTypes = this.typeMaker.makeTypeTypes(this.classFile.getSuperTypeName())) != null && superTypeTypes.getThisType().isInnerObjectType() && this.typeMaker.isRawTypeAssignable(superTypeTypes.getThisType().getOuterType(), (ObjectType)firstParameterType)) {
                    scie.setParameters(this.removeFirstItem(parameters));
                    scie.setParameterTypes(this.removeFirstItem(scie.getParameterTypes()));
                }
                expression.setParameters(this.removeLastSyntheticParameter(scie.getParameters(), scie.getParameterTypes()));
            }
        }

        @Override
        public void visit(ConstructorInvocationExpression expression) {
            ClassFileConstructorInvocationExpression cie = (ClassFileConstructorInvocationExpression)expression;
            BaseExpression parameters = cie.getParameters();
            if (parameters != null && parameters.size() > 0) {
                if (this.bodyDeclaration.getOuterTypeFieldName() != null) {
                    cie.setParameters(this.removeFirstItem(parameters));
                    cie.setParameterTypes(this.removeFirstItem(cie.getParameterTypes()));
                }
                cie.setParameters(this.removeLastSyntheticParameter(cie.getParameters(), cie.getParameterTypes()));
            }
            this.safeAccept(parameters);
        }

        protected BaseExpression removeFirstItem(BaseExpression parameters) {
            if (parameters.isList()) {
                parameters.getList().removeFirst();
            } else {
                parameters = null;
            }
            return parameters;
        }

        protected BaseType removeFirstItem(BaseType types) {
            if (types.isList()) {
                types.getList().removeFirst();
            } else {
                types = null;
            }
            return types;
        }

        protected BaseExpression removeLastSyntheticParameter(BaseExpression parameters, BaseType parameterTypes) {
            if (parameters != null && parameters.size() > 0 && ((Expression)parameters.getLast()).isNullExpression() && ((Type)parameterTypes.getLast()).getName() == null) {
                if (parameters.isList()) {
                    parameters.getList().removeLast();
                } else {
                    parameters = null;
                }
            }
            return parameters;
        }

        protected class UpdateParametersAndLocalVariablesVisitor
        extends AbstractJavaSyntaxVisitor {
            private boolean fina1;

            protected UpdateParametersAndLocalVariablesVisitor() {
            }

            @Override
            public void visit(FormalParameter declaration) {
                if (UpdateNewExpressionVisitor.this.finalLocalVariableNameMap.containsKey(declaration.getName())) {
                    declaration.setFinal(true);
                    declaration.setName(UpdateNewExpressionVisitor.this.finalLocalVariableNameMap.get(declaration.getName()));
                }
            }

            @Override
            public void visit(TryStatement.CatchClause statement) {
                if (UpdateNewExpressionVisitor.this.finalLocalVariableNameMap.containsKey(statement.getName())) {
                    statement.setFinal(true);
                }
                super.visit(statement);
            }

            @Override
            public void visit(ForEachStatement statement) {
                if (UpdateNewExpressionVisitor.this.finalLocalVariableNameMap.containsKey(statement.getName())) {
                    statement.setFinal(true);
                }
                super.visit(statement);
            }

            @Override
            public void visit(LocalVariableDeclarationStatement statement) {
                this.fina1 = false;
                statement.getLocalVariableDeclarators().accept((DeclarationVisitor)this);
                statement.setFinal(this.fina1);
            }

            @Override
            public void visit(LocalVariableDeclaration declaration) {
                this.fina1 = false;
                declaration.getLocalVariableDeclarators().accept((DeclarationVisitor)this);
                declaration.setFinal(this.fina1);
            }

            @Override
            public void visit(LocalVariableDeclarator declarator) {
                if (UpdateNewExpressionVisitor.this.finalLocalVariableNameMap.containsKey(declarator.getName())) {
                    this.fina1 = true;
                    declarator.setName(UpdateNewExpressionVisitor.this.finalLocalVariableNameMap.get(declarator.getName()));
                }
            }
        }

        protected class AddLocalClassDeclarationVisitor
        extends AbstractJavaSyntaxVisitor {
            private final SearchFirstLineNumberVisitor searchFirstLineNumberVisitor = new SearchFirstLineNumberVisitor();
            private int lineNumber = 0;

            protected AddLocalClassDeclarationVisitor() {
            }

            @Override
            public void visit(ConstructorDeclaration declaration) {
                ClassFileConstructorDeclaration cfcd = (ClassFileConstructorDeclaration)declaration;
                cfcd.setStatements(this.addLocalClassDeclarations(cfcd.getStatements()));
            }

            @Override
            public void visit(MethodDeclaration declaration) {
                ClassFileMethodDeclaration cfmd = (ClassFileMethodDeclaration)declaration;
                cfmd.setStatements(this.addLocalClassDeclarations(cfmd.getStatements()));
            }

            @Override
            public void visit(StaticInitializerDeclaration declaration) {
                ClassFileStaticInitializerDeclaration cfsid = (ClassFileStaticInitializerDeclaration)declaration;
                cfsid.setStatements(this.addLocalClassDeclarations(cfsid.getStatements()));
            }

            protected BaseStatement addLocalClassDeclarations(BaseStatement statements) {
                if (!UpdateNewExpressionVisitor.this.localClassDeclarations.isEmpty()) {
                    if (statements.isStatements()) {
                        statements.accept((StatementVisitor)this);
                    } else {
                        ClassFileClassDeclaration declaration = (ClassFileClassDeclaration)UpdateNewExpressionVisitor.this.localClassDeclarations.get(0);
                        this.searchFirstLineNumberVisitor.init();
                        statements.accept((StatementVisitor)this.searchFirstLineNumberVisitor);
                        if (this.searchFirstLineNumberVisitor.getLineNumber() != -1) {
                            this.lineNumber = this.searchFirstLineNumberVisitor.getLineNumber();
                        }
                        if (declaration.getFirstLineNumber() <= this.lineNumber) {
                            Statements list = new Statements();
                            Iterator declarationIterator = UpdateNewExpressionVisitor.this.localClassDeclarations.iterator();
                            list.add((Object)new TypeDeclarationStatement((TypeDeclaration)declaration));
                            declarationIterator.next();
                            declarationIterator.remove();
                            while (declarationIterator.hasNext() && (declaration = (ClassFileClassDeclaration)declarationIterator.next()).getFirstLineNumber() <= this.lineNumber) {
                                list.add((Object)new TypeDeclarationStatement((TypeDeclaration)declaration));
                                declarationIterator.remove();
                            }
                            if (statements.isList()) {
                                list.addAll((Collection)statements.getList());
                            } else {
                                list.add((Object)((Statement)statements.getFirst()));
                            }
                            statements = list;
                        } else {
                            statements.accept((StatementVisitor)this);
                        }
                    }
                }
                return statements;
            }

            @Override
            public void visit(Statements list) {
                if (!UpdateNewExpressionVisitor.this.localClassDeclarations.isEmpty() && !list.isEmpty()) {
                    ListIterator statementIterator = list.listIterator();
                    Iterator declarationIterator = UpdateNewExpressionVisitor.this.localClassDeclarations.iterator();
                    ClassFileClassDeclaration declaration = (ClassFileClassDeclaration)declarationIterator.next();
                    while (statementIterator.hasNext()) {
                        Statement statement = (Statement)statementIterator.next();
                        this.searchFirstLineNumberVisitor.init();
                        statement.accept((StatementVisitor)this.searchFirstLineNumberVisitor);
                        if (this.searchFirstLineNumberVisitor.getLineNumber() != -1) {
                            this.lineNumber = this.searchFirstLineNumberVisitor.getLineNumber();
                        }
                        while (declaration.getFirstLineNumber() <= this.lineNumber) {
                            statementIterator.previous();
                            statementIterator.add(new TypeDeclarationStatement((TypeDeclaration)declaration));
                            statementIterator.next();
                            declarationIterator.remove();
                            if (!declarationIterator.hasNext()) {
                                return;
                            }
                            declaration = (ClassFileClassDeclaration)declarationIterator.next();
                        }
                    }
                }
            }
        }
    }
}

