/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import java.util.List;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;
import org.jd.core.v1.model.classfile.ClassFile;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.declaration.AnnotationDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.BodyDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ClassDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ConstructorDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.Declaration;
import org.jd.core.v1.model.javasyntax.declaration.EnumDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.FieldDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.InterfaceDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.MethodDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.StaticInitializerDeclaration;
import org.jd.core.v1.model.javasyntax.statement.BaseStatement;
import org.jd.core.v1.model.javasyntax.statement.Statements;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileBodyDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorOrMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ByteCodeWriter;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ControlFlowGraphReducer;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.LocalVariableMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.StatementMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;

public class CreateInstructionsVisitor
extends AbstractJavaSyntaxVisitor {
    private final TypeMaker typeMaker;

    public CreateInstructionsVisitor(TypeMaker typeMaker) {
        this.typeMaker = typeMaker;
    }

    @Override
    public void visit(AnnotationDeclaration declaration) {
        this.safeAccept((Declaration)declaration.getBodyDeclaration());
    }

    @Override
    public void visit(BodyDeclaration declaration) {
        ClassFileBodyDeclaration bodyDeclaration = (ClassFileBodyDeclaration)declaration;
        List<ClassFileConstructorOrMethodDeclaration> methods = bodyDeclaration.getMethodDeclarations();
        block0: for (ClassFileConstructorOrMethodDeclaration method : methods) {
            if ((method.getFlags() & 0x1040) != 0) {
                method.accept(this);
                continue;
            }
            if ((method.getFlags() & 0x48) == 8) {
                if (!method.getMethod().getName().startsWith("access$")) continue;
                method.setFlags(method.getFlags() | 0x40);
                method.accept(this);
                continue;
            }
            if (method.getParameterTypes() == null) continue;
            if (method.getParameterTypes().isList()) {
                for (Type type : method.getParameterTypes()) {
                    if (!type.isObjectType() || type.getName() != null) continue;
                    method.setFlags(method.getFlags() | 0x1000);
                    method.accept(this);
                    continue block0;
                }
                continue;
            }
            Type type = (Type)method.getParameterTypes().getFirst();
            if (!type.isObjectType() || type.getName() != null) continue;
            method.setFlags(method.getFlags() | 0x1000);
            method.accept(this);
            break;
        }
        for (ClassFileConstructorOrMethodDeclaration method : methods) {
            if ((method.getFlags() & 0x1040) != 0) continue;
            method.accept(this);
        }
    }

    @Override
    public void visit(FieldDeclaration declaration) {
    }

    @Override
    public void visit(ConstructorDeclaration declaration) {
        this.createParametersVariablesAndStatements((ClassFileConstructorOrMethodDeclaration)declaration, true);
    }

    @Override
    public void visit(MethodDeclaration declaration) {
        this.createParametersVariablesAndStatements((ClassFileConstructorOrMethodDeclaration)declaration, false);
    }

    @Override
    public void visit(StaticInitializerDeclaration declaration) {
        this.createParametersVariablesAndStatements((ClassFileConstructorOrMethodDeclaration)declaration, false);
    }

    public void createParametersVariablesAndStatements(ClassFileConstructorOrMethodDeclaration comd, boolean constructor) {
        ClassFile classFile = comd.getClassFile();
        Method method = comd.getMethod();
        Code attributeCode = method.getCode();
        LocalVariableMaker localVariableMaker = new LocalVariableMaker(this.typeMaker, comd, constructor);
        if (attributeCode == null) {
            localVariableMaker.make(false, this.typeMaker);
        } else {
            StatementMaker statementMaker = new StatementMaker(this.typeMaker, localVariableMaker, comd);
            boolean containsLineNumber = attributeCode.getLineNumberTable() != null;
            List<ControlFlowGraphReducer> preferredReducers = ControlFlowGraphReducer.getPreferredReducers();
            boolean reduced = false;
            for (ControlFlowGraphReducer controlFlowGraphReducer : preferredReducers) {
                try {
                    if (!controlFlowGraphReducer.reduce(method)) continue;
                    if (comd.getStatements() instanceof Statements) {
                        Statements stmts = (Statements)comd.getStatements();
                        if (stmts.isEmpty()) {
                            comd.setStatements((BaseStatement)statementMaker.make(controlFlowGraphReducer.getControlFlowGraph(), stmts));
                        }
                    } else {
                        comd.setStatements((BaseStatement)statementMaker.make(controlFlowGraphReducer.getControlFlowGraph(), new Statements()));
                    }
                    reduced = true;
                    break;
                }
                catch (Exception | StackOverflowError e) {
                    assert (ExceptionUtil.printStackTrace((Throwable)e));
                }
            }
            if (!reduced) {
                System.err.println("Could not reduce control flow graph in method " + method.getName() + method.getSignature() + " from class " + classFile.getInternalTypeName());
                comd.setStatements((BaseStatement)new Statements(ByteCodeWriter.getLineNumberTableAsStatements(method)));
            }
            localVariableMaker.make(containsLineNumber, this.typeMaker);
        }
        comd.setFormalParameters(localVariableMaker.getFormalParameters());
        if (classFile.isInterface()) {
            comd.setFlags(comd.getFlags() & 0xFFFFFBFE);
        }
    }

    @Override
    public void visit(ClassDeclaration declaration) {
        this.safeAccept((Declaration)declaration.getBodyDeclaration());
    }

    @Override
    public void visit(EnumDeclaration declaration) {
        this.safeAccept((Declaration)declaration.getBodyDeclaration());
    }

    @Override
    public void visit(InterfaceDeclaration declaration) {
        this.safeAccept((Declaration)declaration.getBodyDeclaration());
    }
}

