/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.declaration.ArrayVariableInitializer;
import org.jd.core.v1.model.javasyntax.declaration.BaseMemberDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.BodyDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ClassDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ConstructorDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.Declaration;
import org.jd.core.v1.model.javasyntax.declaration.DeclarationVisitor;
import org.jd.core.v1.model.javasyntax.declaration.ExpressionVariableInitializer;
import org.jd.core.v1.model.javasyntax.declaration.FieldDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.FieldDeclarator;
import org.jd.core.v1.model.javasyntax.declaration.FormalParameter;
import org.jd.core.v1.model.javasyntax.declaration.LocalVariableDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.LocalVariableDeclarator;
import org.jd.core.v1.model.javasyntax.declaration.MethodDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.StaticInitializerDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.VariableInitializer;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.BinaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.CastExpression;
import org.jd.core.v1.model.javasyntax.expression.ConstructorInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.ConstructorReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.DoubleConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.EnumConstantReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor;
import org.jd.core.v1.model.javasyntax.expression.FieldReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.FloatConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.IntegerConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.LambdaIdentifiersExpression;
import org.jd.core.v1.model.javasyntax.expression.LocalVariableReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.LongConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.MethodInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.NewExpression;
import org.jd.core.v1.model.javasyntax.expression.NewInitializedArray;
import org.jd.core.v1.model.javasyntax.expression.NullExpression;
import org.jd.core.v1.model.javasyntax.expression.ObjectTypeReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.QualifiedSuperExpression;
import org.jd.core.v1.model.javasyntax.expression.SuperConstructorInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.SuperExpression;
import org.jd.core.v1.model.javasyntax.expression.TernaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.ThisExpression;
import org.jd.core.v1.model.javasyntax.expression.TypeReferenceDotClassExpression;
import org.jd.core.v1.model.javasyntax.statement.BaseStatement;
import org.jd.core.v1.model.javasyntax.statement.BreakStatement;
import org.jd.core.v1.model.javasyntax.statement.ContinueStatement;
import org.jd.core.v1.model.javasyntax.statement.LambdaExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.ReturnExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.StatementVisitor;
import org.jd.core.v1.model.javasyntax.statement.ThrowStatement;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.BaseTypeArgument;
import org.jd.core.v1.model.javasyntax.type.BaseTypeParameter;
import org.jd.core.v1.model.javasyntax.type.GenericType;
import org.jd.core.v1.model.javasyntax.type.InnerObjectType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeArgument;
import org.jd.core.v1.model.javasyntax.type.TypeArgumentVisitable;
import org.jd.core.v1.model.javasyntax.type.TypeArgumentVisitor;
import org.jd.core.v1.model.javasyntax.type.TypeArguments;
import org.jd.core.v1.model.javasyntax.type.TypeParameterVisitor;
import org.jd.core.v1.model.javasyntax.type.TypeParameterWithTypeBounds;
import org.jd.core.v1.model.javasyntax.type.Types;
import org.jd.core.v1.model.javasyntax.type.WildcardExtendsTypeArgument;
import org.jd.core.v1.model.javasyntax.type.WildcardSuperTypeArgument;
import org.jd.core.v1.model.javasyntax.type.WildcardTypeArgument;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileBodyDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileStaticInitializerDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileConstructorInvocationExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileMethodInvocationExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileNewExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileSuperConstructorInvocationExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.SearchFirstLineNumberVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.TypeWithBoundsToGenericVisitor;
import org.jd.core.v1.util.DefaultList;

public class AddCastExpressionVisitor
extends AbstractJavaSyntaxVisitor {
    private final SearchFirstLineNumberVisitor searchFirstLineNumberVisitor = new SearchFirstLineNumberVisitor();
    private final TypeMaker typeMaker;
    private Map<String, BaseType> typeBounds;
    private Type returnedType;
    private BaseType exceptionTypes;
    private Deque<TypeParameter> typeParameters = new ArrayDeque<TypeParameter>();
    private Map<String, BaseTypeArgument> parameterTypeArguments = new HashMap<String, BaseTypeArgument>();
    private Type type;
    private boolean visitingAnonymousClass;
    private boolean visitingLambda;
    private Set<String> fieldNamesInLambda = new HashSet<String>();
    private boolean staticContext;

    public AddCastExpressionVisitor(TypeMaker typeMaker) {
        this.typeMaker = typeMaker;
    }

    @Override
    public void visit(BodyDeclaration declaration) {
        if (!declaration.isAnonymous()) {
            this.visitBodyDeclaration(declaration);
        }
    }

    private void visitBodyDeclaration(BodyDeclaration declaration) {
        BaseMemberDeclaration memberDeclarations = declaration.getMemberDeclarations();
        if (memberDeclarations != null) {
            Map<String, BaseType> tb = this.typeBounds;
            this.typeBounds = ((ClassFileBodyDeclaration)declaration).getTypeBounds();
            memberDeclarations.accept((DeclarationVisitor)this);
            this.typeBounds = tb;
        }
    }

    @Override
    public void visit(FieldDeclaration declaration) {
        if ((declaration.getFlags() & 0x1000) == 0) {
            Type t = this.type;
            this.type = declaration.getType();
            declaration.getFieldDeclarators().accept((DeclarationVisitor)this);
            this.type = t;
        }
    }

    @Override
    public void visit(FieldDeclarator declarator) {
        VariableInitializer variableInitializer;
        if (declarator.getName() != null && this.visitingLambda) {
            this.fieldNamesInLambda.add(declarator.getName());
        }
        if ((variableInitializer = declarator.getVariableInitializer()) != null) {
            variableInitializer.accept((DeclarationVisitor)this);
        }
    }

    @Override
    public void visit(StaticInitializerDeclaration declaration) {
        BaseStatement statements = declaration.getStatements();
        if (statements != null) {
            Map<String, BaseType> tb = this.typeBounds;
            this.typeBounds = ((ClassFileStaticInitializerDeclaration)declaration).getTypeBounds();
            statements.accept((StatementVisitor)this);
            this.typeBounds = tb;
        }
    }

    @Override
    public void visit(ConstructorDeclaration declaration) {
        BaseStatement statements;
        if ((declaration.getFlags() & 0x1040) == 0 && (statements = declaration.getStatements()) != null) {
            Map<String, BaseType> tb = this.typeBounds;
            BaseType et = this.exceptionTypes;
            this.typeBounds = ((ClassFileConstructorDeclaration)declaration).getTypeBounds();
            this.exceptionTypes = declaration.getExceptionTypes();
            statements.accept((StatementVisitor)this);
            this.typeBounds = tb;
            this.exceptionTypes = et;
        }
    }

    @Override
    public void visit(MethodDeclaration declaration) {
        BaseStatement statements;
        if ((declaration.getFlags() & 0x1040) == 0 && (statements = declaration.getStatements()) != null) {
            Map<String, BaseType> tb = this.typeBounds;
            Type rt = this.returnedType;
            BaseType et = this.exceptionTypes;
            boolean sc = this.staticContext;
            this.typeBounds = ((ClassFileMethodDeclaration)declaration).getTypeBounds();
            this.returnedType = declaration.getReturnedType();
            this.exceptionTypes = declaration.getExceptionTypes();
            this.staticContext = declaration.isStatic();
            this.pushContext(declaration);
            this.safeAccept((Declaration)declaration.getFormalParameters());
            statements.accept((StatementVisitor)this);
            this.typeBounds = tb;
            this.returnedType = rt;
            this.exceptionTypes = et;
            this.staticContext = sc;
            this.popContext(declaration);
        }
    }

    @Override
    public void visit(ClassDeclaration declaration) {
        this.pushContext(declaration);
        super.visit(declaration);
        this.popContext(declaration);
    }

    @Override
    public void visit(FormalParameter declaration) {
        if (!this.visitingAnonymousClass && declaration.getType() instanceof ObjectType) {
            ObjectType ot = (ObjectType)declaration.getType();
            this.parameterTypeArguments.put(declaration.getName(), ot.getTypeArguments());
        }
    }

    public void pushContext(MethodDeclaration declaration) {
        if (declaration.getTypeParameters() != null) {
            this.typeParameters.push(new TypeParameter(declaration.isStatic(), declaration.getTypeParameters()));
        }
    }

    public void popContext(MethodDeclaration declaration) {
        if (declaration.getTypeParameters() != null) {
            this.typeParameters.pop();
        }
        if (!this.visitingAnonymousClass) {
            this.parameterTypeArguments.clear();
        }
    }

    public void pushContext(ClassDeclaration declaration) {
        if (declaration.getTypeParameters() != null) {
            this.typeParameters.push(new TypeParameter(declaration.isStatic(), declaration.getTypeParameters()));
        }
    }

    public void popContext(ClassDeclaration declaration) {
        if (declaration.getTypeParameters() != null) {
            this.typeParameters.pop();
        }
    }

    @Override
    public void visit(LambdaIdentifiersExpression expression) {
        this.visitingLambda = true;
        BaseStatement statements = expression.getStatements();
        if (statements != null) {
            Type rt = this.returnedType;
            this.returnedType = ObjectType.TYPE_OBJECT;
            statements.accept((StatementVisitor)this);
            this.returnedType = rt;
        }
        this.visitingLambda = false;
    }

    @Override
    public void visit(ReturnExpressionStatement statement) {
        statement.setExpression(this.updateStatementExpression(statement.getExpression()));
    }

    @Override
    public void visit(LambdaExpressionStatement statement) {
        statement.setExpression(this.updateStatementExpression(statement.getExpression()));
    }

    private Expression updateStatementExpression(Expression expression) {
        Map<String, TypeArgument> typeBindings = AddCastExpressionVisitor.getLocalTypeBindings(expression);
        Map<String, BaseType> localTypeBounds = this.getLocalTypeBounds(expression);
        return this.updateExpression(typeBindings, localTypeBounds, this.returnedType, null, expression, false, true, false);
    }

    @Override
    public void visit(ThrowStatement statement) {
        Type exceptionType;
        if (this.exceptionTypes != null && this.exceptionTypes.size() == 1 && (exceptionType = (Type)this.exceptionTypes.getFirst()).isGenericType() && !statement.getExpression().getType().equals(exceptionType)) {
            statement.setExpression(this.addCastExpression(exceptionType, statement.getExpression()));
        }
    }

    @Override
    public void visit(LocalVariableDeclaration declaration) {
        Type t = this.type;
        this.type = declaration.getType();
        declaration.getLocalVariableDeclarators().accept((DeclarationVisitor)this);
        this.type = t;
    }

    @Override
    public void visit(LocalVariableDeclarator declarator) {
        VariableInitializer variableInitializer = declarator.getVariableInitializer();
        if (variableInitializer != null) {
            int extraDimension = declarator.getDimension();
            if (extraDimension == 0) {
                variableInitializer.accept((DeclarationVisitor)this);
            } else {
                Type t = this.type;
                this.type = this.type.createType(this.type.getDimension() + extraDimension);
                variableInitializer.accept((DeclarationVisitor)this);
                this.type = t;
            }
        }
    }

    @Override
    public void visit(ArrayVariableInitializer declaration) {
        if (this.type.getDimension() == 0) {
            this.acceptListDeclaration((List<? extends Declaration>)declaration);
        } else {
            Type t = this.type;
            this.type = this.type.createType(Math.max(0, this.type.getDimension() - 1));
            this.acceptListDeclaration((List<? extends Declaration>)declaration);
            this.type = t;
        }
    }

    @Override
    public void visit(ExpressionVariableInitializer declaration) {
        Expression expression = declaration.getExpression();
        if (expression.isNewInitializedArray()) {
            NewInitializedArray nia = (NewInitializedArray)expression;
            Type t = this.type;
            this.type = nia.getType();
            nia.getArrayInitializer().accept((DeclarationVisitor)this);
            this.type = t;
        } else {
            declaration.setExpression(this.updateExpression(Collections.emptyMap(), this.typeBounds, this.type, null, expression, false, true, false));
        }
    }

    @Override
    public void visit(SuperConstructorInvocationExpression expression) {
        BaseExpression parameters = expression.getParameters();
        if (parameters != null && parameters.size() > 0) {
            boolean unique = this.typeMaker.matchCount(expression.getObjectType().getInternalName(), "<init>", parameters.size(), true) <= 1;
            boolean forceCast = !unique && this.typeMaker.matchCount(Collections.emptyMap(), this.typeBounds, expression.getObjectType().getInternalName(), "<init>", parameters, true) > 1;
            boolean rawCast = false;
            BaseType parameterTypes = ((ClassFileSuperConstructorInvocationExpression)expression).getParameterTypes();
            expression.setParameters(this.updateParameters(Collections.emptyMap(), this.typeBounds, parameterTypes, null, parameters, forceCast, unique, rawCast));
        }
    }

    @Override
    public void visit(ConstructorInvocationExpression expression) {
        BaseExpression parameters = expression.getParameters();
        if (parameters != null && parameters.size() > 0) {
            boolean unique = this.typeMaker.matchCount(expression.getObjectType().getInternalName(), "<init>", parameters.size(), true) <= 1;
            boolean forceCast = !unique && this.typeMaker.matchCount(Collections.emptyMap(), this.typeBounds, expression.getObjectType().getInternalName(), "<init>", parameters, true) > 1;
            boolean rawCast = false;
            BaseType parameterTypes = ((ClassFileConstructorInvocationExpression)expression).getParameterTypes();
            expression.setParameters(this.updateParameters(Collections.emptyMap(), this.typeBounds, parameterTypes, null, parameters, forceCast, unique, rawCast));
        }
    }

    private static Map<String, TypeArgument> getLocalTypeBindings(Expression exp) {
        if (exp instanceof MethodInvocationExpression) {
            MethodInvocationExpression mie = (MethodInvocationExpression)exp;
            return mie.getTypeBindings();
        }
        return Collections.emptyMap();
    }

    private Map<String, BaseType> getLocalTypeBounds(Expression exp) {
        MethodInvocationExpression mie;
        HashMap<String, BaseType> localTypeBounds = new HashMap<String, BaseType>(this.typeBounds);
        if (exp instanceof MethodInvocationExpression && (mie = (MethodInvocationExpression)exp).getTypeBounds() != null) {
            localTypeBounds.putAll(mie.getTypeBounds());
        }
        return localTypeBounds;
    }

    @Override
    public void visit(MethodInvocationExpression expression) {
        ObjectType ot;
        CastExpression ce;
        BaseExpression parameters = expression.getParameters();
        Map<String, TypeArgument> typeBindings = AddCastExpressionVisitor.getLocalTypeBindings((Expression)expression);
        Map<String, BaseType> localTypeBounds = this.getLocalTypeBounds((Expression)expression);
        if (parameters != null && parameters.size() > 0) {
            boolean unique = this.typeMaker.matchCount(expression.getInternalTypeName(), expression.getName(), parameters.size(), false) <= 1;
            boolean forceCast = !unique && this.typeMaker.matchCount(typeBindings, localTypeBounds, expression.getInternalTypeName(), expression.getName(), parameters, false) > 1;
            BaseType parameterTypes = ((ClassFileMethodInvocationExpression)expression).getParameterTypes();
            BaseType unboundParameterTypes = ((ClassFileMethodInvocationExpression)expression).getUnboundParameterTypes();
            boolean rawCast = false;
            expression.setParameters(this.updateParameters(typeBindings, localTypeBounds, parameterTypes, unboundParameterTypes, parameters, forceCast, unique, rawCast));
        }
        if (expression.getNonWildcardTypeArguments() != null) {
            if (this.hasKnownTypeParameters(expression.getNonWildcardTypeArguments())) {
                this.safeAccept((TypeArgumentVisitable)expression.getNonWildcardTypeArguments());
            } else {
                expression.setNonWildcardTypeArguments(null);
            }
        }
        if (expression.getExpression() instanceof CastExpression && (ce = (CastExpression)expression.getExpression()).isByteCodeCheckCast() && ce.getExpression() instanceof ClassFileMethodInvocationExpression && ce.getType() instanceof ObjectType && (ot = (ObjectType)ce.getType()) != null) {
            TypeMaker.TypeTypes typeTypes;
            if (this.isCastToBeRemoved(typeBindings, localTypeBounds, (Type)ot, ce, true)) {
                expression.setExpression(ce.getExpression());
            }
            if ((typeTypes = this.typeMaker.makeTypeTypes(ot.getInternalName())) != null && typeTypes.getTypeParameters() != null && ot.getTypeArguments() == null) {
                ClassFileMethodInvocationExpression mie = (ClassFileMethodInvocationExpression)ce.getExpression();
                if (mie.getUnboundType() instanceof ObjectType) {
                    TypeArguments typeArguments = new TypeArguments();
                    for (int i = 0; i < typeTypes.getTypeParameters().size(); ++i) {
                        typeArguments.add((Object)WildcardTypeArgument.WILDCARD_TYPE_ARGUMENT);
                    }
                    ce.setType((Type)ot.createType((BaseTypeArgument)typeArguments));
                }
            } else if (ot.getTypeArguments() != null && !this.hasKnownTypeParameters(ot.getTypeArguments())) {
                expression.setExpression(ce.getExpression());
            }
        }
        expression.getExpression().accept((ExpressionVisitor)this);
    }

    @Override
    public void visit(NewExpression expression) {
        BaseExpression parameters = expression.getParameters();
        if (parameters != null) {
            boolean rawCast;
            boolean unique = this.typeMaker.matchCount(expression.getObjectType().getInternalName(), "<init>", parameters.size(), true) <= 1;
            boolean forceCast = !unique && this.typeMaker.matchCount(Collections.emptyMap(), this.typeBounds, expression.getObjectType().getInternalName(), "<init>", parameters, true) > 1;
            Type currentType = this.type == null ? this.returnedType : this.type;
            boolean bl = rawCast = currentType instanceof ObjectType && expression.getType() instanceof ObjectType && this.typeMaker.isRawTypeAssignable((ObjectType)currentType, expression.getObjectType()) && !this.typeMaker.isAssignable(this.typeBounds, (ObjectType)currentType, expression.getObjectType());
            if (rawCast) {
                expression.setObjectType(expression.getObjectType().createType(((ObjectType)currentType).getTypeArguments()));
            }
            BaseType parameterTypes = ((ClassFileNewExpression)expression).getParameterTypes();
            expression.setParameters(this.updateParameters(Collections.emptyMap(), this.typeBounds, parameterTypes, null, parameters, forceCast, unique, rawCast));
        }
        if (expression.getBodyDeclaration() != null && expression.getBodyDeclaration().isAnonymous()) {
            this.visitingAnonymousClass = true;
            this.visitBodyDeclaration(expression.getBodyDeclaration());
            this.visitingAnonymousClass = false;
        }
        if (!this.hasKnownTypeParameters((BaseTypeArgument)expression.getObjectType())) {
            expression.setType(expression.getObjectType().createType((BaseTypeArgument)ObjectType.TYPE_UNDEFINED_OBJECT));
        }
    }

    @Override
    public void visit(NewInitializedArray expression) {
        ArrayVariableInitializer arrayInitializer = expression.getArrayInitializer();
        if (arrayInitializer != null) {
            Type t = this.type;
            this.type = expression.getType();
            arrayInitializer.accept((DeclarationVisitor)this);
            this.type = t;
        }
    }

    @Override
    public void visit(FieldReferenceExpression expression) {
        ObjectType localType;
        Expression exp = expression.getExpression();
        if (exp != null && !exp.isObjectTypeReferenceExpression() && (localType = this.typeMaker.makeFromInternalTypeName(expression.getInternalTypeName())).getName() != null) {
            expression.setExpression(this.updateExpression(Collections.emptyMap(), this.typeBounds, (Type)localType, null, exp, false, true, false));
        }
    }

    @Override
    public void visit(BinaryOperatorExpression expression) {
        expression.getLeftExpression().accept((ExpressionVisitor)this);
        Expression rightExpression = expression.getRightExpression();
        if ("=".equals(expression.getOperator())) {
            ClassFileMethodInvocationExpression mie;
            if (rightExpression.isMethodInvocationExpression() && (mie = (ClassFileMethodInvocationExpression)rightExpression).getTypeParameters() != null) {
                rightExpression.accept((ExpressionVisitor)this);
                return;
            }
            expression.setRightExpression(this.updateExpression(Collections.emptyMap(), this.typeBounds, expression.getLeftExpression().getType(), null, rightExpression, false, true, false));
            return;
        }
        rightExpression.accept((ExpressionVisitor)this);
    }

    @Override
    public void visit(TernaryOperatorExpression expression) {
        Type expressionType = expression.getType();
        expression.getCondition().accept((ExpressionVisitor)this);
        expression.setTrueExpression(this.updateExpression(Collections.emptyMap(), this.typeBounds, expressionType, null, expression.getTrueExpression(), false, true, false));
        expression.setFalseExpression(this.updateExpression(Collections.emptyMap(), this.typeBounds, expressionType, null, expression.getFalseExpression(), false, true, false));
    }

    public void visit(TypeArguments type) {
        TypeParameter baseTypeParameter = this.typeParameters.peek();
        TypeWithBoundsToGenericVisitor typeParameterVisitor = new TypeWithBoundsToGenericVisitor();
        if (baseTypeParameter != null) {
            baseTypeParameter.type().accept((TypeParameterVisitor)typeParameterVisitor);
            type.accept((TypeArgumentVisitor)typeParameterVisitor);
        }
    }

    protected BaseExpression updateParameters(Map<String, TypeArgument> typeBindings, Map<String, BaseType> localTypeBounds, BaseType types, BaseType unboundTypes, BaseExpression expressions, boolean forceCast, boolean unique, boolean rawCast) {
        if (expressions != null) {
            if (expressions.isList()) {
                DefaultList typeList = types.getList();
                DefaultList unboundTypeList = unboundTypes == null ? null : unboundTypes.getList();
                DefaultList expressionList = expressions.getList();
                for (int i = expressionList.size() - 1; i >= 0; --i) {
                    Type unboundType = unboundTypes == null ? null : (Type)unboundTypeList.get(i);
                    expressionList.set(i, (Object)this.updateParameter(typeBindings, localTypeBounds, (Type)typeList.get(i), unboundType, (Expression)expressionList.get(i), forceCast, unique, rawCast));
                }
            } else {
                Type unboundType = unboundTypes == null ? null : (Type)unboundTypes.getFirst();
                expressions = this.updateParameter(typeBindings, localTypeBounds, (Type)types.getFirst(), unboundType, (Expression)expressions.getFirst(), forceCast, unique, rawCast);
            }
        }
        return expressions;
    }

    private Expression updateParameter(Map<String, TypeArgument> typeBindings, Map<String, BaseType> localTypeBounds, Type type, Type unboundType, Expression expression, boolean forceCast, boolean unique, boolean rawCast) {
        if (this.visitingAnonymousClass && expression instanceof FieldReferenceExpression && expression.getType() instanceof ObjectType) {
            BaseTypeArgument parameterTypeArgument;
            FieldReferenceExpression fieldRef = (FieldReferenceExpression)expression;
            ObjectType ot = (ObjectType)expression.getType();
            if (ot.getTypeArguments() == null && (parameterTypeArgument = this.parameterTypeArguments.get(expression.getName())) != null) {
                fieldRef.setType((Type)ot.createType(parameterTypeArgument));
            }
        }
        expression = this.updateExpression(typeBindings, localTypeBounds, type, unboundType, expression, forceCast, unique, rawCast);
        if (type == PrimitiveType.TYPE_BYTE) {
            if (expression.isIntegerConstantExpression()) {
                expression = new CastExpression((Type)PrimitiveType.TYPE_BYTE, expression);
            } else if (expression.isTernaryOperatorExpression()) {
                Expression exp = expression.getTrueExpression();
                if (exp.isIntegerConstantExpression() || exp.isTernaryOperatorExpression()) {
                    expression = new CastExpression((Type)PrimitiveType.TYPE_BYTE, expression);
                } else {
                    exp = expression.getFalseExpression();
                    if (exp.isIntegerConstantExpression() || exp.isTernaryOperatorExpression()) {
                        expression = new CastExpression((Type)PrimitiveType.TYPE_BYTE, expression);
                    }
                }
            }
        }
        for (PrimitiveType primitiveType : Arrays.asList(PrimitiveType.TYPE_BYTE, PrimitiveType.TYPE_SHORT)) {
            if (!primitiveType.createType(type.getDimension()).equals(type) || !expression.isNewInitializedArray()) continue;
            NewInitializedArray newInitializedArray = (NewInitializedArray)expression;
            for (VariableInitializer variableInitializer : newInitializedArray.getArrayInitializer()) {
                if (!(variableInitializer instanceof ExpressionVariableInitializer)) continue;
                ExpressionVariableInitializer evi = (ExpressionVariableInitializer)variableInitializer;
                evi.setExpression((Expression)new CastExpression((Type)primitiveType, evi.getExpression()));
            }
        }
        return expression;
    }

    private Expression updateExpression(Map<String, TypeArgument> typeBindings, Map<String, BaseType> localTypeBounds, Type type, Type unboundType, Expression expression, boolean forceCast, boolean unique, boolean rawCast) {
        if (expression.isNullExpression()) {
            if (forceCast) {
                this.searchFirstLineNumberVisitor.init();
                expression.accept((ExpressionVisitor)this.searchFirstLineNumberVisitor);
                expression = new CastExpression(this.searchFirstLineNumberVisitor.getLineNumber(), type, expression);
            }
        } else {
            if ("java/util/stream/Collectors".equals(expression.getInternalTypeName()) && "toList".equals(expression.getName())) {
                return expression;
            }
            Type expressionType = expression.getType();
            if (!expressionType.equals(type)) {
                if (type.isObjectType()) {
                    if (expressionType.isObjectType()) {
                        ObjectType objectType = (ObjectType)type;
                        ObjectType expressionObjectType = (ObjectType)expressionType;
                        if (rawCast) {
                            expression = this.addCastExpression((Type)objectType.createType(null), expression);
                        } else if (forceCast && (!objectType.rawEquals((Object)expressionObjectType) || expression instanceof LambdaIdentifiersExpression)) {
                            if (expression.isNewExpression()) {
                                ClassFileNewExpression ne = (ClassFileNewExpression)expression;
                                ne.setObjectType(ne.getObjectType().createType(null));
                            }
                            expression = this.addCastExpression((Type)objectType, expression);
                        } else if (!ObjectType.TYPE_OBJECT.equals((Object)type) && !this.typeMaker.isAssignable(typeBindings, localTypeBounds, objectType, unboundType, expressionObjectType)) {
                            BaseTypeArgument ta1 = objectType.getTypeArguments();
                            BaseTypeArgument ta2 = expressionObjectType.getTypeArguments();
                            Type t = type;
                            if (ta1 != null && ta2 != null && !ta1.isTypeArgumentAssignableFrom(this.typeMaker, typeBindings, localTypeBounds, ta2)) {
                                t = objectType.createType((BaseTypeArgument)(ta1.isGenericTypeArgument() ? ta1 : null));
                            }
                            if (!expression.isNew() && this.hasKnownTypeParameters((BaseTypeArgument)t) && !(ta1 instanceof WildcardSuperTypeArgument)) {
                                expression = this.addCastExpression(t, expression);
                            }
                        }
                    } else if (expressionType.getDimension() == 0 && type.getDimension() == 0 && expressionType.isGenericType() && !ObjectType.TYPE_OBJECT.equals((Object)type)) {
                        ObjectType boundObjectType;
                        GenericType gt;
                        BaseType boundType;
                        boolean cast = true;
                        if (expressionType instanceof GenericType && (boundType = this.typeBounds.get((gt = (GenericType)expressionType).getName())) instanceof ObjectType && (boundObjectType = (ObjectType)boundType).equals((Object)type)) {
                            cast = false;
                        }
                        if (cast) {
                            expression = this.addCastExpression(type, expression);
                        }
                    }
                } else if (type.isGenericType() && this.hasKnownTypeParameters((BaseTypeArgument)type) && (expressionType.isObjectType() || expressionType.isGenericType())) {
                    expression = expression instanceof CastExpression && this.isCastToBeRemoved(typeBindings, localTypeBounds, type, (CastExpression)expression, unique) ? expression.getExpression() : this.addCastExpression(type, expression);
                }
            }
            if (expression instanceof CastExpression && this.isCastToBeRemoved(typeBindings, localTypeBounds, type, (CastExpression)expression, unique)) {
                expression = expression.getExpression();
            }
            expression.accept((ExpressionVisitor)this);
        }
        return expression;
    }

    private boolean isCastToBeRemoved(Map<String, TypeArgument> typeBindings, Map<String, BaseType> localTypeBounds, Type type, CastExpression expression, boolean unique) {
        ObjectType right;
        ObjectType left;
        FieldReferenceExpression fre;
        if (!this.hasKnownTypeParameters((BaseTypeArgument)expression.getType())) {
            return true;
        }
        Expression nestedExpression = expression.getExpression();
        if (nestedExpression.getExpression() instanceof FieldReferenceExpression && this.fieldNamesInLambda.contains((fre = (FieldReferenceExpression)nestedExpression.getExpression()).getName())) {
            return false;
        }
        Type nestedExpressionType = nestedExpression.getType();
        return type.isObjectType() && nestedExpressionType.isObjectType() && ((left = (ObjectType)type).equals((Object)(right = (ObjectType)nestedExpressionType)) || unique && this.typeMaker.isAssignable(typeBindings, localTypeBounds, left, right));
    }

    private boolean hasKnownTypeParameters(BaseTypeArgument type) {
        Set genericIdentifiersInType = type.findTypeParametersInType();
        Set<String> genericIdentifiersInScope = this.findKnownTypeParameters();
        return genericIdentifiersInScope.containsAll(genericIdentifiersInType);
    }

    private Set<String> findKnownTypeParameters() {
        HashSet<String> genericIdentifiers = new HashSet<String>();
        for (TypeParameter baseTypeParameters : this.typeParameters) {
            if (this.staticContext && !baseTypeParameters.staticContext()) continue;
            baseTypeParameters.type().forEach(typeParameter -> genericIdentifiers.add(typeParameter.getIdentifier()));
        }
        return genericIdentifiers;
    }

    private Expression addCastExpression(Type type, Expression expression) {
        if (!expression.isCastExpression()) {
            this.searchFirstLineNumberVisitor.init();
            expression.accept((ExpressionVisitor)this.searchFirstLineNumberVisitor);
            return new CastExpression(this.searchFirstLineNumberVisitor.getLineNumber(), type, expression);
        }
        if (type.equals(expression.getExpression().getType())) {
            return expression.getExpression();
        }
        CastExpression ce = (CastExpression)expression;
        ce.setType(type);
        return ce;
    }

    @Override
    public void visit(FloatConstantExpression expression) {
    }

    @Override
    public void visit(IntegerConstantExpression expression) {
    }

    @Override
    public void visit(ConstructorReferenceExpression expression) {
    }

    @Override
    public void visit(DoubleConstantExpression expression) {
    }

    @Override
    public void visit(EnumConstantReferenceExpression expression) {
    }

    @Override
    public void visit(LocalVariableReferenceExpression expression) {
    }

    @Override
    public void visit(LongConstantExpression expression) {
    }

    @Override
    public void visit(BreakStatement statement) {
    }

    @Override
    public void visit(ContinueStatement statement) {
    }

    @Override
    public void visit(NullExpression expression) {
    }

    @Override
    public void visit(ObjectTypeReferenceExpression expression) {
    }

    @Override
    public void visit(SuperExpression expression) {
    }

    @Override
    public void visit(QualifiedSuperExpression expression) {
    }

    @Override
    public void visit(ThisExpression expression) {
    }

    @Override
    public void visit(TypeReferenceDotClassExpression expression) {
    }

    public void visit(WildcardExtendsTypeArgument type) {
    }

    public void visit(ObjectType type) {
    }

    public void visit(InnerObjectType type) {
    }

    public void visit(WildcardSuperTypeArgument type) {
    }

    @Override
    public void visit(Types list) {
    }

    @Override
    public void visit(TypeParameterWithTypeBounds type) {
    }

    private record TypeParameter(boolean staticContext, BaseTypeParameter type) {
    }
}

