/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util.cfg;

import java.util.BitSet;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg.BasicBlock;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ByteCodeUtil;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ControlFlowGraphReducer;

public class MinDepthCFGReducer
extends ControlFlowGraphReducer {
    private boolean preReduce;

    public MinDepthCFGReducer(boolean preReduce) {
        this.preReduce = preReduce;
    }

    @Override
    protected boolean needToUpdateConditionTernaryOperator(BasicBlock basicBlock, BasicBlock nextNext) {
        return ByteCodeUtil.getMinDepth(nextNext) == -1;
    }

    @Override
    protected boolean needToUpdateCondition(BasicBlock basicBlock, BasicBlock nextNext) {
        BasicBlock nextNextNext = nextNext.getNext();
        BasicBlock nextNextBranch = nextNext.getBranch();
        return nextNextNext.getType() == 0x10000000 && nextNextNext.getPredecessors().size() == 1 && nextNextNext.getNext().matchType(294912) && nextNextBranch.matchType(0x10000004) && nextNextNext.getNext() == nextNextBranch.getNext() && nextNextBranch.getPredecessors().size() == 1 && nextNextNext.getNext().getPredecessors().size() == 2 && ByteCodeUtil.getMinDepth(nextNextNext.getNext()) == -2;
    }

    @Override
    protected boolean needToCreateIf(BasicBlock branch, BasicBlock nextNext, int maxOffset) {
        return nextNext.getFromOffset() < branch.getFromOffset() && nextNext.getPredecessors().size() == 1;
    }

    @Override
    protected boolean needToCreateIfElse(BasicBlock branch, BasicBlock nextNext, BasicBlock branchNext) {
        return nextNext.getFromOffset() > branch.getFromOffset() && branchNext.matchType(1266696506);
    }

    @Override
    protected boolean reduceTryDeclaration(BitSet visited, BasicBlock basicBlock, BitSet jsrTargets) {
        BasicBlock sub1;
        BasicBlock next = basicBlock.getNext();
        if (next != null && next.matchType(0x400000) && (sub1 = next.getSub1()) != null && sub1.matchType(7680)) {
            return false;
        }
        return super.reduceTryDeclaration(visited, basicBlock, jsrTargets);
    }

    @Override
    public boolean doPreReduce() {
        return this.preReduce;
    }

    @Override
    public String getLabel() {
        return "Show Minimum-Depth Control Flow Graph";
    }
}

