/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import java.util.Iterator;
import java.util.List;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.expression.BinaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.MethodInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.NullExpression;
import org.jd.core.v1.model.javasyntax.statement.BaseStatement;
import org.jd.core.v1.model.javasyntax.statement.ExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.IfStatement;
import org.jd.core.v1.model.javasyntax.statement.Statement;
import org.jd.core.v1.model.javasyntax.statement.StatementVisitor;
import org.jd.core.v1.model.javasyntax.statement.Statements;
import org.jd.core.v1.model.javasyntax.statement.ThrowStatement;
import org.jd.core.v1.model.javasyntax.statement.TryStatement;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileLocalVariableReferenceExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.statement.ClassFileTryStatement;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.AbstractLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.LocalVariableMaker;
import org.jd.core.v1.util.DefaultList;

public final class TryWithResourcesStatementMaker {
    private TryWithResourcesStatementMaker() {
    }

    public static Statement makeLegacy(LocalVariableMaker localVariableMaker, Statements statements, Statements tryStatements, DefaultList<TryStatement.CatchClause> catchClauses, Statements finallyStatements) {
        int size = statements.size();
        if (size < 2 || finallyStatements == null || finallyStatements.size() != 1 || !TryWithResourcesStatementMaker.checkThrowable(catchClauses)) {
            return null;
        }
        Statement statement = (Statement)statements.get(size - 2);
        if (!statement.isExpressionStatement()) {
            return null;
        }
        Expression expression = statement.getExpression();
        if (!expression.isBinaryOperatorExpression()) {
            return null;
        }
        Expression boe = expression;
        if (!(expression = boe.getLeftExpression()).isLocalVariableReferenceExpression()) {
            return null;
        }
        AbstractLocalVariable lv1 = ((ClassFileLocalVariableReferenceExpression)expression).getLocalVariable();
        statement = (Statement)statements.get(size - 1);
        if (!statement.isExpressionStatement()) {
            return null;
        }
        expression = statement.getExpression();
        if (!expression.isBinaryOperatorExpression()) {
            return null;
        }
        if (!(expression = expression.getLeftExpression()).isLocalVariableReferenceExpression()) {
            return null;
        }
        AbstractLocalVariable lv2 = ((ClassFileLocalVariableReferenceExpression)expression).getLocalVariable();
        statement = (Statement)finallyStatements.getFirst();
        if (statement.isIfStatement() && lv1 == TryWithResourcesStatementMaker.getLocalVariable(statement.getCondition())) {
            if ((statement = (Statement)statement.getStatements().getFirst()).isIfElseStatement()) {
                return TryWithResourcesStatementMaker.parsePatternAddSuppressed(localVariableMaker, statements, tryStatements, finallyStatements, boe, lv1, lv2, statement);
            }
            if (statement.isExpressionStatement()) {
                return TryWithResourcesStatementMaker.parsePatternCloseResource(localVariableMaker, statements, tryStatements, finallyStatements, boe, lv1, lv2, statement);
            }
        }
        if (statement.isExpressionStatement()) {
            return TryWithResourcesStatementMaker.parsePatternCloseResource(localVariableMaker, statements, tryStatements, finallyStatements, boe, lv1, lv2, statement);
        }
        return null;
    }

    public static Statement make(LocalVariableMaker localVariableMaker, Statements statements, Statements tryStatements, DefaultList<TryStatement.CatchClause> catchClauses, Statements finallyStatements) {
        int size = statements.size();
        if (size < 1 || !TryWithResourcesStatementMaker.checkThrowable(catchClauses)) {
            return null;
        }
        Statement statement = (Statement)statements.getLast();
        if (!statement.isExpressionStatement()) {
            return null;
        }
        Expression expression = statement.getExpression();
        if (!expression.isBinaryOperatorExpression()) {
            return null;
        }
        Expression boe = expression;
        if (!(expression = boe.getLeftExpression()).isLocalVariableReferenceExpression()) {
            return null;
        }
        AbstractLocalVariable lv1 = ((ClassFileLocalVariableReferenceExpression)expression).getLocalVariable();
        BaseStatement catchStatements = ((TryStatement.CatchClause)catchClauses.getFirst()).getStatements();
        if (catchStatements == null || catchStatements.size() != 2) {
            return null;
        }
        ClassFileTryStatement tryStatement = TryWithResourcesStatementMaker.getClassFileTryStatement(catchStatements, lv1);
        if (tryStatement == null || !((Statement)catchStatements.getLast()).isThrowStatement()) {
            return null;
        }
        ThrowStatement throwStatement = (ThrowStatement)catchStatements.getLast();
        expression = throwStatement.getExpression();
        if (!expression.isLocalVariableReferenceExpression()) {
            return null;
        }
        AbstractLocalVariable lv2 = ((ClassFileLocalVariableReferenceExpression)expression).getLocalVariable();
        if (tryStatement.getTryStatements() == null || tryStatement.getTryStatements().size() != 1) {
            return null;
        }
        if (!(tryStatement.getTryStatements().getFirst() instanceof ExpressionStatement)) {
            return null;
        }
        ExpressionStatement expressionStatement = (ExpressionStatement)tryStatement.getTryStatements().getFirst();
        if (!(expressionStatement.getExpression() instanceof MethodInvocationExpression)) {
            return null;
        }
        MethodInvocationExpression mie = (MethodInvocationExpression)expressionStatement.getExpression();
        if (!TryWithResourcesStatementMaker.checkCloseInvocation(mie, lv1)) {
            return null;
        }
        if (tryStatement.getCatchClauses() == null || tryStatement.getCatchClauses().size() != 1) {
            return null;
        }
        TryStatement.CatchClause catchClause = (TryStatement.CatchClause)tryStatement.getCatchClauses().getFirst();
        if (catchClause.getStatements() == null || catchClause.getStatements().size() != 1) {
            return null;
        }
        if (!(catchClause.getStatements().getFirst() instanceof ExpressionStatement)) {
            return null;
        }
        expressionStatement = (ExpressionStatement)catchClause.getStatements().getFirst();
        if (!(expressionStatement.getExpression() instanceof MethodInvocationExpression)) {
            return null;
        }
        mie = (MethodInvocationExpression)expressionStatement.getExpression();
        if (!"addSuppressed".equals(mie.getName()) || !"(Ljava/lang/Throwable;)V".equals(mie.getDescriptor())) {
            return null;
        }
        expression = mie.getExpression();
        if (!expression.isLocalVariableReferenceExpression()) {
            return null;
        }
        if (((ClassFileLocalVariableReferenceExpression)expression).getLocalVariable() != lv2) {
            return null;
        }
        return TryWithResourcesStatementMaker.newTryStatement(localVariableMaker, statements, tryStatements, finallyStatements, boe, lv1, lv2);
    }

    private static ClassFileTryStatement getClassFileTryStatement(BaseStatement catchStatements, AbstractLocalVariable lv1) {
        Statement firstStatement = (Statement)catchStatements.getFirst();
        if (firstStatement instanceof ClassFileTryStatement) {
            return (ClassFileTryStatement)firstStatement;
        }
        if (firstStatement instanceof IfStatement) {
            BinaryOperatorExpression boe;
            IfStatement ifStatement = (IfStatement)firstStatement;
            Expression condition = ifStatement.getCondition();
            BaseStatement thenStatements = ifStatement.getStatements();
            if (condition instanceof BinaryOperatorExpression && thenStatements.size() == 1 && "!=".equals((boe = (BinaryOperatorExpression)condition).getOperator()) && boe.getRightExpression() instanceof NullExpression && boe.getLeftExpression() instanceof ClassFileLocalVariableReferenceExpression && ((ClassFileLocalVariableReferenceExpression)boe.getLeftExpression()).getLocalVariable() == lv1 && thenStatements.getFirst() instanceof ClassFileTryStatement) {
                MethodInvocationExpression mie;
                ClassFileTryStatement tryStatement = (ClassFileTryStatement)((Object)thenStatements.getFirst());
                BaseStatement tryStatements = ((ClassFileTryStatement)((Object)thenStatements.getFirst())).getTryStatements();
                if (tryStatements.size() == 1 && tryStatements.getFirst() instanceof ExpressionStatement && TryWithResourcesStatementMaker.checkCloseInvocation(mie = (MethodInvocationExpression)((Statement)tryStatements.getFirst()).getExpression(), lv1)) {
                    return tryStatement;
                }
            }
        }
        return null;
    }

    private static Statement parsePatternAddSuppressed(LocalVariableMaker localVariableMaker, Statements statements, Statements tryStatements, Statements finallyStatements, Expression boe, AbstractLocalVariable lv1, AbstractLocalVariable lv2, Statement statement) {
        if (!statement.isIfElseStatement()) {
            return null;
        }
        Statement ies = statement;
        if (!(statement = (Statement)ies.getStatements().getFirst()).isTryStatement()) {
            return null;
        }
        Statement ts = statement;
        statement = (Statement)ies.getElseStatements().getFirst();
        if (!statement.isExpressionStatement()) {
            return null;
        }
        Expression expression = statement.getExpression();
        if (!expression.isMethodInvocationExpression()) {
            return null;
        }
        MethodInvocationExpression mie = (MethodInvocationExpression)expression;
        if (ts.getFinallyStatements() != null || lv2 != TryWithResourcesStatementMaker.getLocalVariable(ies.getCondition()) || !TryWithResourcesStatementMaker.checkThrowable((List<? extends TryStatement.CatchClause>)ts.getCatchClauses()) || !TryWithResourcesStatementMaker.checkCloseInvocation(mie, lv1)) {
            return null;
        }
        statement = (Statement)ts.getTryStatements().getFirst();
        if (!statement.isExpressionStatement()) {
            return null;
        }
        expression = statement.getExpression();
        if (!expression.isMethodInvocationExpression()) {
            return null;
        }
        mie = (MethodInvocationExpression)expression;
        if (!TryWithResourcesStatementMaker.checkCloseInvocation(mie, lv1)) {
            return null;
        }
        statement = (Statement)((TryStatement.CatchClause)ts.getCatchClauses().getFirst()).getStatements().getFirst();
        if (!statement.isExpressionStatement()) {
            return null;
        }
        expression = statement.getExpression();
        if (!expression.isMethodInvocationExpression()) {
            return null;
        }
        mie = (MethodInvocationExpression)expression;
        if (!"addSuppressed".equals(mie.getName()) || !"(Ljava/lang/Throwable;)V".equals(mie.getDescriptor())) {
            return null;
        }
        expression = mie.getExpression();
        if (!expression.isLocalVariableReferenceExpression()) {
            return null;
        }
        if (((ClassFileLocalVariableReferenceExpression)expression).getLocalVariable() != lv2) {
            return null;
        }
        return TryWithResourcesStatementMaker.newTryStatement(localVariableMaker, statements, tryStatements, finallyStatements, boe, lv1, lv2);
    }

    private static boolean checkThrowable(List<? extends TryStatement.CatchClause> catchClauses) {
        return catchClauses.size() == 1 && catchClauses.get(0).getType().equals((Object)ObjectType.TYPE_THROWABLE);
    }

    private static AbstractLocalVariable getLocalVariable(Expression condition) {
        if (!condition.isBinaryOperatorExpression()) {
            return null;
        }
        if (!("!=".equals(condition.getOperator()) && condition.getRightExpression().isNullExpression() && condition.getLeftExpression().isLocalVariableReferenceExpression())) {
            return null;
        }
        return ((ClassFileLocalVariableReferenceExpression)condition.getLeftExpression()).getLocalVariable();
    }

    private static boolean checkCloseInvocation(MethodInvocationExpression mie, AbstractLocalVariable lv) {
        Expression expression;
        if ("close".equals(mie.getName()) && "()V".equals(mie.getDescriptor()) && (expression = mie.getExpression()).isLocalVariableReferenceExpression()) {
            return ((ClassFileLocalVariableReferenceExpression)expression).getLocalVariable() == lv;
        }
        return false;
    }

    private static Statement parsePatternCloseResource(LocalVariableMaker localVariableMaker, Statements statements, Statements tryStatements, Statements finallyStatements, Expression boe, AbstractLocalVariable lv1, AbstractLocalVariable lv2, Statement statement) {
        Expression expression = statement.getExpression();
        if (!expression.isMethodInvocationExpression()) {
            return null;
        }
        MethodInvocationExpression mie = (MethodInvocationExpression)expression;
        if (!"$closeResource".equals(mie.getName()) || !"(Ljava/lang/Throwable;Ljava/lang/AutoCloseable;)V".equals(mie.getDescriptor())) {
            return null;
        }
        DefaultList parameters = mie.getParameters().getList();
        Expression parameter0 = (Expression)parameters.getFirst();
        if (!parameter0.isLocalVariableReferenceExpression()) {
            return null;
        }
        if (((ClassFileLocalVariableReferenceExpression)parameter0).getLocalVariable() != lv2) {
            return null;
        }
        Expression parameter1 = (Expression)parameters.get(1);
        if (!parameter1.isLocalVariableReferenceExpression()) {
            return null;
        }
        if (((ClassFileLocalVariableReferenceExpression)parameter1).getLocalVariable() != lv1) {
            return null;
        }
        return TryWithResourcesStatementMaker.newTryStatement(localVariableMaker, statements, tryStatements, finallyStatements, boe, lv1, lv2);
    }

    private static ClassFileTryStatement newTryStatement(LocalVariableMaker localVariableMaker, Statements statements, Statements tryStatements, Statements finallyStatements, Expression boe, final AbstractLocalVariable lv1, AbstractLocalVariable lv2) {
        if (TryWithResourcesStatementMaker.checkLocalVariable(statements, lv2)) {
            statements.removeLast();
        }
        if (TryWithResourcesStatementMaker.checkLocalVariable(statements, lv1)) {
            statements.removeLast();
        }
        lv1.setDeclared(true);
        localVariableMaker.removeLocalVariable(lv2);
        tryStatements.accept((StatementVisitor)new AbstractJavaSyntaxVisitor(){

            @Override
            public void visit(Statements statements) {
                if (statements.isList()) {
                    Iterator iterator = statements.getList().iterator();
                    while (iterator.hasNext()) {
                        MethodInvocationExpression mie;
                        Expression expression;
                        Statement statement = (Statement)iterator.next();
                        if (statement instanceof IfStatement) {
                            IfStatement ifStatement = (IfStatement)statement;
                            Expression condition = ifStatement.getCondition();
                            BaseStatement thenStatements = ifStatement.getStatements();
                            if (condition instanceof BinaryOperatorExpression && thenStatements.size() == 1) {
                                MethodInvocationExpression mie2;
                                Statement singleStatement = (Statement)thenStatements.getFirst();
                                BinaryOperatorExpression boe = (BinaryOperatorExpression)condition;
                                if ("!=".equals(boe.getOperator()) && boe.getRightExpression() instanceof NullExpression && boe.getLeftExpression() instanceof ClassFileLocalVariableReferenceExpression && ((ClassFileLocalVariableReferenceExpression)boe.getLeftExpression()).getLocalVariable() == lv1 && singleStatement.getExpression() instanceof MethodInvocationExpression && TryWithResourcesStatementMaker.checkCloseInvocation(mie2 = (MethodInvocationExpression)singleStatement.getExpression(), lv1)) {
                                    iterator.remove();
                                }
                            }
                        }
                        if (!((expression = statement.getExpression()) instanceof MethodInvocationExpression) || !TryWithResourcesStatementMaker.checkCloseInvocation(mie = (MethodInvocationExpression)expression, lv1)) continue;
                        iterator.remove();
                    }
                }
                super.visit(statements);
            }
        });
        DefaultList resources = new DefaultList();
        resources.add((Object)new TryStatement.Resource((ObjectType)lv1.getType(), lv1.getName(), boe.getRightExpression()));
        return new ClassFileTryStatement((DefaultList<TryStatement.Resource>)resources, (BaseStatement)tryStatements, null, (BaseStatement)finallyStatements, false, false);
    }

    private static boolean checkLocalVariable(Statements statements, AbstractLocalVariable lv) {
        BinaryOperatorExpression boe;
        Expression leftExpression;
        ExpressionStatement expressionStatement;
        Expression expression;
        Statement lastStatement;
        if (!statements.isEmpty() && (lastStatement = (Statement)statements.getLast()) instanceof ExpressionStatement && (expression = (expressionStatement = (ExpressionStatement)lastStatement).getExpression()) instanceof BinaryOperatorExpression && (leftExpression = (boe = (BinaryOperatorExpression)expression).getLeftExpression()) instanceof ClassFileLocalVariableReferenceExpression) {
            ClassFileLocalVariableReferenceExpression ref = (ClassFileLocalVariableReferenceExpression)leftExpression;
            return lv == ref.getLocalVariable();
        }
        return false;
    }
}

