/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import java.util.HashMap;
import java.util.Iterator;
import org.jd.core.v1.model.javasyntax.expression.EnumConstantReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.FieldReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.IntegerConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.MethodInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.StringConstantExpression;
import org.jd.core.v1.model.javasyntax.statement.BaseStatement;
import org.jd.core.v1.model.javasyntax.statement.Statement;
import org.jd.core.v1.model.javasyntax.statement.Statements;
import org.jd.core.v1.model.javasyntax.statement.SwitchStatement;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileBodyDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorOrMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileTypeDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileLocalVariableReferenceExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.AbstractLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.LocalVariableMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.CreateInstructionsVisitor;
import org.jd.core.v1.util.DefaultList;

public final class SwitchStatementMaker {
    private static final Integer MINUS_ONE = -1;

    private SwitchStatementMaker() {
    }

    public static void makeSwitchString(LocalVariableMaker localVariableMaker, Statements statements, SwitchStatement switchStatement) {
        Expression expression;
        int size = statements.size();
        SwitchStatement previousSwitchStatement = (SwitchStatement)statements.get(size - 2);
        if (previousSwitchStatement.getCondition().getLineNumber() == switchStatement.getCondition().getLineNumber() && previousSwitchStatement.getCondition().isMethodInvocationExpression() && (expression = previousSwitchStatement.getCondition()).isMethodInvocationExpression() && (expression = expression.getExpression()).isLocalVariableReferenceExpression()) {
            MethodInvocationExpression mie;
            AbstractLocalVariable syntheticLV2;
            Expression boe2;
            AbstractLocalVariable lv2;
            AbstractLocalVariable syntheticLV1 = ((ClassFileLocalVariableReferenceExpression)expression).getLocalVariable();
            expression = ((Statement)statements.get(size - 4)).getExpression().getLeftExpression();
            if (expression.isLocalVariableReferenceExpression() && syntheticLV1.equals(lv2 = ((ClassFileLocalVariableReferenceExpression)expression).getLocalVariable()) && (expression = ((Statement)statements.get(size - 3)).getExpression()).isBinaryOperatorExpression() && (expression = (boe2 = expression).getRightExpression()).isIntegerConstantExpression() && MINUS_ONE.equals(expression.getIntegerValue()) && (expression = switchStatement.getCondition()).isLocalVariableReferenceExpression() && (syntheticLV2 = ((ClassFileLocalVariableReferenceExpression)expression).getLocalVariable()).equals(((ClassFileLocalVariableReferenceExpression)boe2.getLeftExpression()).getLocalVariable()) && "hashCode".equals((mie = (MethodInvocationExpression)previousSwitchStatement.getCondition()).getName()) && "()I".equals(mie.getDescriptor())) {
                HashMap<Integer, String> map = new HashMap<Integer, String>();
                block0: for (SwitchStatement.Block block : previousSwitchStatement.getBlocks()) {
                    Statement stmt;
                    BaseStatement stmts = block.getStatements();
                    assert (stmts != null && stmts.isStatements() && stmts.size() > 0);
                    Iterator iterator = stmts.iterator();
                    while (iterator.hasNext() && (stmt = (Statement)iterator.next()).isIfStatement() && (expression = stmt.getCondition()).isMethodInvocationExpression() && (expression = (Expression)expression.getParameters().getFirst()).isStringConstantExpression()) {
                        String string = expression.getStringValue();
                        expression = ((Statement)stmt.getStatements().getFirst()).getExpression().getRightExpression();
                        if (!expression.isIntegerConstantExpression()) continue block0;
                        Integer index = expression.getIntegerValue();
                        map.put(index, string);
                    }
                }
                for (SwitchStatement.Block block : switchStatement.getBlocks()) {
                    if (block.isSwitchStatementLabelBlock()) {
                        SwitchStatement.LabelBlock lb = (SwitchStatement.LabelBlock)block;
                        if (lb.getLabel() == SwitchStatement.DEFAULT_LABEL) continue;
                        SwitchStatement.ExpressionLabel el = (SwitchStatement.ExpressionLabel)lb.getLabel();
                        IntegerConstantExpression nce = (IntegerConstantExpression)el.getExpression();
                        el.setExpression((Expression)new StringConstantExpression(nce.getLineNumber(), (String)map.get(nce.getIntegerValue())));
                        continue;
                    }
                    if (!block.isSwitchStatementMultiLabelsBlock()) continue;
                    SwitchStatement.MultiLabelsBlock lmb = (SwitchStatement.MultiLabelsBlock)block;
                    for (SwitchStatement.Label label : lmb.getLabels()) {
                        if (label == SwitchStatement.DEFAULT_LABEL) continue;
                        SwitchStatement.ExpressionLabel el = (SwitchStatement.ExpressionLabel)label;
                        IntegerConstantExpression nce = (IntegerConstantExpression)el.getExpression();
                        el.setExpression((Expression)new StringConstantExpression(nce.getLineNumber(), (String)map.get(nce.getIntegerValue())));
                    }
                }
                expression = ((Statement)statements.get(size - 4)).getExpression();
                if (expression.isBinaryOperatorExpression()) {
                    switchStatement.setCondition(expression.getRightExpression());
                    statements.subList(size - 4, size - 1).clear();
                    localVariableMaker.removeLocalVariable(syntheticLV1);
                    localVariableMaker.removeLocalVariable(syntheticLV2);
                }
            }
        }
    }

    public static void makeSwitchEnum(ClassFileBodyDeclaration bodyDeclaration, SwitchStatement switchStatement, TypeMaker typeMaker) {
        block5: {
            Expression expression;
            block4: {
                ClassFileTypeDeclaration syntheticClassDeclaration;
                expression = switchStatement.getCondition().getExpression();
                if (!expression.isFieldReferenceExpression()) break block4;
                FieldReferenceExpression fre = (FieldReferenceExpression)expression;
                if (!"[I".equals(fre.getDescriptor()) || !fre.getName().startsWith("$SwitchMap$") || (syntheticClassDeclaration = bodyDeclaration.getInnerTypeDeclaration(fre.getInternalTypeName())) == null) break block5;
                bodyDeclaration = (ClassFileBodyDeclaration)syntheticClassDeclaration.getBodyDeclaration();
                ClassFileConstructorOrMethodDeclaration methodDeclaration = bodyDeclaration.getMethodDeclarations().get(0);
                if (methodDeclaration.getStatements() == null) {
                    CreateInstructionsVisitor createInstructionsVisitor = new CreateInstructionsVisitor(typeMaker);
                    createInstructionsVisitor.createParametersVariablesAndStatements(methodDeclaration, false);
                }
                DefaultList statements = methodDeclaration.getStatements().getList();
                SwitchStatementMaker.updateSwitchStatement(switchStatement, SwitchStatementMaker.searchSwitchMap(fre, statements.iterator()));
                break block5;
            }
            if (expression.isMethodInvocationExpression()) {
                MethodInvocationExpression mie = (MethodInvocationExpression)expression;
                String methodName = mie.getName();
                if ("()[I".equals(mie.getDescriptor()) && methodName.startsWith("$SWITCH_TABLE$")) {
                    for (ClassFileConstructorOrMethodDeclaration declaration : bodyDeclaration.getMethodDeclarations()) {
                        if (!declaration.getMethod().getName().equals(methodName)) continue;
                        DefaultList statements = declaration.getStatements().getList();
                        SwitchStatementMaker.updateSwitchStatement(switchStatement, statements.listIterator(3));
                        break;
                    }
                }
            }
        }
    }

    private static Iterator<Statement> searchSwitchMap(FieldReferenceExpression fre, Iterator<Statement> iterator) {
        String name = fre.getName();
        while (iterator.hasNext()) {
            Expression expression = iterator.next().getExpression().getLeftExpression();
            if (!expression.isFieldReferenceExpression() || !name.equals(expression.getName())) continue;
            return iterator;
        }
        return iterator;
    }

    private static void updateSwitchStatement(SwitchStatement switchStatement, Iterator<Statement> iterator) {
        Expression boe;
        Expression expression;
        BaseStatement statements;
        Statement statement;
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        while (iterator.hasNext() && (statement = iterator.next()).isTryStatement() && (statements = statement.getTryStatements()).isList() && (expression = ((Statement)statements.getFirst()).getExpression()).isBinaryOperatorExpression() && (expression = (boe = expression).getRightExpression()).isIntegerConstantExpression()) {
            Integer index = expression.getIntegerValue();
            expression = boe.getLeftExpression();
            if (!expression.isArrayExpression() || !(expression = expression.getIndex()).isMethodInvocationExpression() || !(expression = expression.getExpression()).isFieldReferenceExpression()) break;
            String name = ((FieldReferenceExpression)expression).getName();
            map.put(index, name);
        }
        Expression expression2 = switchStatement.getCondition().getIndex().getExpression();
        ObjectType type = (ObjectType)expression2.getType();
        for (SwitchStatement.Block block : switchStatement.getBlocks()) {
            if (block.isSwitchStatementLabelBlock()) {
                SwitchStatement.LabelBlock lb = (SwitchStatement.LabelBlock)block;
                if (lb.getLabel() == SwitchStatement.DEFAULT_LABEL) continue;
                SwitchStatement.ExpressionLabel el = (SwitchStatement.ExpressionLabel)lb.getLabel();
                IntegerConstantExpression nce = (IntegerConstantExpression)el.getExpression();
                el.setExpression((Expression)new EnumConstantReferenceExpression(nce.getLineNumber(), type, (String)map.get(nce.getIntegerValue())));
                continue;
            }
            if (!block.isSwitchStatementMultiLabelsBlock()) continue;
            SwitchStatement.MultiLabelsBlock lmb = (SwitchStatement.MultiLabelsBlock)block;
            for (SwitchStatement.Label label : lmb.getLabels()) {
                if (label == SwitchStatement.DEFAULT_LABEL) continue;
                SwitchStatement.ExpressionLabel el = (SwitchStatement.ExpressionLabel)label;
                IntegerConstantExpression nce = (IntegerConstantExpression)el.getExpression();
                el.setExpression((Expression)new EnumConstantReferenceExpression(nce.getLineNumber(), type, (String)map.get(nce.getIntegerValue())));
            }
        }
        switchStatement.setCondition(expression2);
    }
}

