/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import java.util.Iterator;
import java.util.StringTokenizer;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.BinaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.MethodInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.StringConstantExpression;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileMethodInvocationExpression;
import org.jd.core.v1.util.DefaultList;

public final class StringConcatenationUtil {
    private StringConcatenationUtil() {
    }

    public static Expression create(Expression expression, int lineNumber, String typeName) {
        MethodInvocationExpression mie;
        if (expression.isMethodInvocationExpression() && (mie = (MethodInvocationExpression)expression).getParameters() != null && !mie.getParameters().isList() && "append".equals(mie.getName())) {
            String internalTypeName;
            Expression concatenatedStringExpression = (Expression)mie.getParameters().getFirst();
            Expression expr = mie.getExpression();
            boolean firstParameterHaveGenericType = false;
            while (expr.isMethodInvocationExpression() && (mie = (MethodInvocationExpression)expr).getParameters() != null && !mie.getParameters().isList() && "append".equals(mie.getName())) {
                firstParameterHaveGenericType = ((Expression)mie.getParameters().getFirst()).getType().isGenericType();
                concatenatedStringExpression = new BinaryOperatorExpression(mie.getLineNumber(), (Type)ObjectType.TYPE_STRING, (Expression)mie.getParameters(), "+", concatenatedStringExpression, 4);
                expr = mie.getExpression();
            }
            if (expr.isNewExpression() && ("Ljava/lang/StringBuilder;".equals(internalTypeName = expr.getType().getDescriptor()) || "Ljava/lang/StringBuffer;".equals(internalTypeName))) {
                if (expr.getParameters() == null) {
                    if (!firstParameterHaveGenericType) {
                        return concatenatedStringExpression;
                    }
                } else if (!expr.getParameters().isList() && ObjectType.TYPE_STRING.equals((Object)(expr = (Expression)expr.getParameters().getFirst()).getType())) {
                    return new BinaryOperatorExpression(expr.getLineNumber(), (Type)ObjectType.TYPE_STRING, expr, "+", concatenatedStringExpression, 4);
                }
            }
        }
        return new ClassFileMethodInvocationExpression(lineNumber, (Type)ObjectType.TYPE_STRING, expression, typeName, "toString", "()Ljava/lang/String;", null, null);
    }

    public static Expression create(String recipe, BaseExpression parameters) {
        StringTokenizer st = new StringTokenizer(recipe, "\u0001", true);
        if (st.hasMoreTokens()) {
            StringConstantExpression expression;
            String token = st.nextToken();
            Object object = expression = "\u0001".equals(token) ? StringConcatenationUtil.createFirstStringConcatenationItem((Expression)parameters.getFirst()) : new StringConstantExpression(token);
            if (parameters.isList()) {
                DefaultList list = parameters.getList();
                int index = 0;
                while (st.hasMoreTokens()) {
                    token = st.nextToken();
                    StringConstantExpression e = "\u0001".equals(token) ? (Expression)list.get(index++) : new StringConstantExpression(token);
                    expression = new BinaryOperatorExpression(expression.getLineNumber(), (Type)ObjectType.TYPE_STRING, (Expression)expression, "+", (Expression)e, 6);
                }
            } else {
                while (st.hasMoreTokens()) {
                    token = st.nextToken();
                    StringConstantExpression e = "\u0001".equals(token) ? (Expression)parameters.getFirst() : new StringConstantExpression(token);
                    expression = new BinaryOperatorExpression(expression.getLineNumber(), (Type)ObjectType.TYPE_STRING, (Expression)expression, "+", (Expression)e, 6);
                }
            }
            return expression;
        }
        return StringConstantExpression.EMPTY_STRING;
    }

    public static Expression create(BaseExpression parameters) {
        switch (parameters.size()) {
            case 0: {
                return StringConstantExpression.EMPTY_STRING;
            }
            case 1: {
                return StringConcatenationUtil.createFirstStringConcatenationItem((Expression)parameters.getFirst());
            }
        }
        Iterator iterator = parameters.iterator();
        Expression expression = StringConcatenationUtil.createFirstStringConcatenationItem((Expression)iterator.next());
        while (iterator.hasNext()) {
            expression = new BinaryOperatorExpression(expression.getLineNumber(), (Type)ObjectType.TYPE_STRING, expression, "+", (Expression)iterator.next(), 6);
        }
        return expression;
    }

    private static Expression createFirstStringConcatenationItem(Expression expression) {
        if (!expression.getType().equals(ObjectType.TYPE_STRING)) {
            expression = new BinaryOperatorExpression(expression.getLineNumber(), (Type)ObjectType.TYPE_STRING, (Expression)StringConstantExpression.EMPTY_STRING, "+", expression, 6);
        }
        return expression;
    }
}

