/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.apache.bcel.classfile.Method;
import org.jd.core.v1.model.classfile.ClassFile;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.declaration.DeclarationVisitor;
import org.jd.core.v1.model.javasyntax.declaration.FieldDeclarator;
import org.jd.core.v1.model.javasyntax.declaration.MethodDeclaration;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.BinaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.BooleanExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.FieldReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.IntegerConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.MethodInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.NoExpression;
import org.jd.core.v1.model.javasyntax.expression.NullExpression;
import org.jd.core.v1.model.javasyntax.expression.PostOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.StringConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.TernaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.TypeReferenceDotClassExpression;
import org.jd.core.v1.model.javasyntax.statement.AssertStatement;
import org.jd.core.v1.model.javasyntax.statement.BaseStatement;
import org.jd.core.v1.model.javasyntax.statement.BreakStatement;
import org.jd.core.v1.model.javasyntax.statement.CommentStatement;
import org.jd.core.v1.model.javasyntax.statement.ContinueStatement;
import org.jd.core.v1.model.javasyntax.statement.ExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.IfElseStatement;
import org.jd.core.v1.model.javasyntax.statement.IfStatement;
import org.jd.core.v1.model.javasyntax.statement.ReturnExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.ReturnStatement;
import org.jd.core.v1.model.javasyntax.statement.Statement;
import org.jd.core.v1.model.javasyntax.statement.StatementVisitor;
import org.jd.core.v1.model.javasyntax.statement.Statements;
import org.jd.core.v1.model.javasyntax.statement.SwitchStatement;
import org.jd.core.v1.model.javasyntax.statement.TryStatement;
import org.jd.core.v1.model.javasyntax.statement.WhileStatement;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.BaseTypeArgument;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg.BasicBlock;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg.ControlFlowGraph;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileBodyDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorOrMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileFieldDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileLocalVariableReferenceExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.statement.ClassFileBreakContinueStatement;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.statement.ClassFileTryStatement;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.AbstractLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ByteCodeParser;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.LocalVariableMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.LoopStatementMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.NewArrayMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.SwitchStatementMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.SynchronizedStatementMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TryWithResourcesStatementMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.WatchDog;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.MergeTryWithResourcesStatementVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.RemoveBinaryOpReturnStatementsVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.RemoveFinallyStatementsVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.SearchFirstLineNumberVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.UpdateIntegerConstantTypeVisitor;
import org.jd.core.v1.util.DefaultList;
import org.jd.core.v1.util.DefaultStack;

public class StatementMaker {
    protected static final SwitchCaseComparator SWITCH_CASE_COMPARATOR = new SwitchCaseComparator();
    protected static final NullExpression FINALLY_EXCEPTION_EXPRESSION = new NullExpression((Type)new ObjectType("java/lang/Exception", "java.lang.Exception", "Exception"));
    protected static final MergeTryWithResourcesStatementVisitor MERGE_TRY_WITH_RESOURCES_STATEMENT_VISITOR = new MergeTryWithResourcesStatementVisitor();
    private final TypeMaker typeMaker;
    private final Map<String, BaseType> typeBounds;
    private final LocalVariableMaker localVariableMaker;
    private final ByteCodeParser byteCodeParser;
    private final int majorVersion;
    private final String internalTypeName;
    private final ClassFileBodyDeclaration bodyDeclaration;
    private final DefaultStack<Expression> stack = new DefaultStack();
    private final Deque<Expression> enclosingInstances = new ArrayDeque<Expression>();
    private final RemoveFinallyStatementsVisitor removeFinallyStatementsVisitor;
    private final RemoveBinaryOpReturnStatementsVisitor removeBinaryOpReturnStatementsVisitor;
    private final UpdateIntegerConstantTypeVisitor updateIntegerConstantTypeVisitor;
    private final SearchFirstLineNumberVisitor searchFirstLineNumberVisitor = new SearchFirstLineNumberVisitor();
    private final MemberVisitor memberVisitor = new MemberVisitor();
    private boolean removeFinallyStatementsFlag;
    private boolean mergeTryWithResourcesStatementFlag;

    public StatementMaker(TypeMaker typeMaker, LocalVariableMaker localVariableMaker, ClassFileConstructorOrMethodDeclaration comd) {
        ClassFile classFile = comd.getClassFile();
        this.typeMaker = typeMaker;
        this.typeBounds = comd.getTypeBounds();
        this.localVariableMaker = localVariableMaker;
        this.majorVersion = classFile.getMajorVersion();
        this.internalTypeName = classFile.getInternalTypeName();
        this.bodyDeclaration = comd.getBodyDeclaration();
        this.byteCodeParser = new ByteCodeParser(typeMaker, localVariableMaker, classFile, this.bodyDeclaration, comd);
        this.removeFinallyStatementsVisitor = new RemoveFinallyStatementsVisitor();
        this.removeBinaryOpReturnStatementsVisitor = new RemoveBinaryOpReturnStatementsVisitor(localVariableMaker);
        this.updateIntegerConstantTypeVisitor = new UpdateIntegerConstantTypeVisitor(comd.getReturnedType());
    }

    public Statements make(ControlFlowGraph cfg, Statements statements) {
        Statements jumps = new Statements();
        WatchDog watchdog = new WatchDog();
        this.localVariableMaker.pushFrame(statements);
        this.makeStatements(watchdog, cfg.getStart(), statements, jumps);
        if (this.removeFinallyStatementsFlag) {
            this.removeFinallyStatementsVisitor.init();
            statements.accept((StatementVisitor)this.removeFinallyStatementsVisitor);
        }
        if (this.mergeTryWithResourcesStatementFlag) {
            statements.accept((StatementVisitor)MERGE_TRY_WITH_RESOURCES_STATEMENT_VISITOR);
        }
        statements.accept((StatementVisitor)this.removeBinaryOpReturnStatementsVisitor);
        if (!statements.isEmpty() && ((Statement)statements.getLast()).isReturnStatement()) {
            statements.removeLast();
        }
        this.localVariableMaker.popFrame();
        statements.accept((StatementVisitor)this.updateIntegerConstantTypeVisitor);
        this.replacePreOperatorWithPostOperator(statements);
        boolean breakToReturn = this.breakToReturn(cfg, statements, jumps);
        if (!breakToReturn && !jumps.isEmpty()) {
            this.updateJumpStatements(jumps, cfg);
        }
        return statements;
    }

    protected boolean breakToReturn(ControlFlowGraph cfg, Statements statements, Statements jumps) {
        boolean breakToReturn = false;
        if (jumps.size() == 1) {
            ClassFileBreakContinueStatement jumpStatement = (ClassFileBreakContinueStatement)jumps.get(0);
            for (Statement stmt : statements) {
                if (!stmt.isReturnExpressionStatement() || stmt.getLineNumber() != cfg.getLineNumber(jumpStatement.getTargetOffset())) continue;
                int lineNumber = cfg.getLineNumber(jumpStatement.getOffset()) + 1;
                jumpStatement.setStatement((Statement)new ReturnExpressionStatement(lineNumber, stmt.getExpression().copyTo(lineNumber)));
                breakToReturn = true;
            }
        }
        return breakToReturn;
    }

    protected void makeStatements(WatchDog watchdog, BasicBlock basicBlock, Statements statements, Statements jumps) {
        switch (basicBlock.getType()) {
            case 1: {
                watchdog.check(basicBlock, basicBlock.getNext());
                this.makeStatements(watchdog, basicBlock.getNext(), statements, jumps);
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                watchdog.check(basicBlock, basicBlock.getNext());
            }
            case 8: {
                if (basicBlock.isByteCodeParsed()) break;
                this.parseByteCode(basicBlock, statements);
                this.makeStatements(watchdog, basicBlock.getNext(), statements, jumps);
                basicBlock.setByteCodeParsed(true);
                break;
            }
            case 16: {
                Method method = basicBlock.getControlFlowGraph().getMethod();
                if (method.isSynthetic() && method.getName().contains("lambda$")) {
                    this.parseByteCode(basicBlock, statements);
                    break;
                }
                statements.add((Object)ReturnStatement.RETURN);
                break;
            }
            case 32: 
            case 16384: 
            case 0x10000000: {
                this.parseByteCode(basicBlock, statements);
                break;
            }
            case 128: {
                this.parseSwitch(watchdog, basicBlock, statements, jumps);
                break;
            }
            case 256: 
            case 0x2000000: {
                statements.add((Object)BreakStatement.BREAK);
                break;
            }
            case 1024: {
                this.parseTry(watchdog, basicBlock, statements, jumps, false, false);
                break;
            }
            case 2048: {
                this.parseTry(watchdog, basicBlock, statements, jumps, true, false);
                break;
            }
            case 4096: {
                this.parseTry(watchdog, basicBlock, statements, jumps, false, true);
                break;
            }
            case 8192: {
                this.parseJSR(watchdog, basicBlock, statements, jumps);
                break;
            }
            case 65536: {
                this.parseIf(watchdog, basicBlock, statements, jumps);
                break;
            }
            case 131072: {
                watchdog.check(basicBlock, basicBlock.getCondition());
                this.makeStatements(watchdog, basicBlock.getCondition(), statements, jumps);
                Expression condition = (Expression)this.stack.pop();
                DefaultStack backup = new DefaultStack(this.stack);
                watchdog.check(basicBlock, basicBlock.getSub1());
                Statements subStatements = this.makeSubStatements(watchdog, basicBlock.getSub1(), statements, jumps);
                if (!basicBlock.getSub2().matchType(0x3800000) && this.stack.size() != backup.size()) {
                    this.stack.copy(backup);
                }
                watchdog.check(basicBlock, basicBlock.getSub2());
                Statements elseStatements = this.makeSubStatements(watchdog, basicBlock.getSub2(), statements, jumps);
                statements.add((Object)new IfElseStatement(condition, (BaseStatement)subStatements, (BaseStatement)elseStatements));
                watchdog.check(basicBlock, basicBlock.getNext());
                this.makeStatements(watchdog, basicBlock.getNext(), statements, jumps);
                break;
            }
            case 262144: {
                if (basicBlock.getSub1() != BasicBlock.END) {
                    this.stack.push((Object)this.makeExpression(watchdog, basicBlock.getSub1(), statements, jumps));
                }
                if (basicBlock.getSub2() != BasicBlock.END) {
                    this.stack.push((Object)this.makeExpression(watchdog, basicBlock.getSub2(), statements, jumps));
                }
                this.parseByteCode(basicBlock, statements);
                break;
            }
            case 524288: {
                watchdog.check(basicBlock, basicBlock.getSub1());
                Expression exp1 = this.makeExpression(watchdog, basicBlock.getSub1(), statements, jumps);
                watchdog.check(basicBlock, basicBlock.getSub2());
                Expression exp2 = this.makeExpression(watchdog, basicBlock.getSub2(), statements, jumps);
                this.stack.push((Object)new BinaryOperatorExpression(basicBlock.getFirstLineNumber(), (Type)PrimitiveType.TYPE_BOOLEAN, exp1, "||", exp2, 14));
                break;
            }
            case 0x100000: {
                watchdog.check(basicBlock, basicBlock.getSub1());
                Expression exp1 = this.makeExpression(watchdog, basicBlock.getSub1(), statements, jumps);
                watchdog.check(basicBlock, basicBlock.getSub2());
                Expression exp2 = this.makeExpression(watchdog, basicBlock.getSub2(), statements, jumps);
                this.stack.push((Object)new BinaryOperatorExpression(basicBlock.getFirstLineNumber(), (Type)PrimitiveType.TYPE_BOOLEAN, exp1, "&&", exp2, 13));
                break;
            }
            case 0x200000: {
                watchdog.check(basicBlock, basicBlock.getCondition());
                this.makeStatements(watchdog, basicBlock.getCondition(), statements, jumps);
                Expression condition = (Expression)this.stack.pop();
                DefaultStack backup = new DefaultStack(this.stack);
                watchdog.check(basicBlock, basicBlock.getSub1());
                Expression exp1 = this.makeExpression(watchdog, basicBlock.getSub1(), statements, jumps);
                if (this.stack.size() != backup.size()) {
                    this.stack.copy(backup);
                }
                watchdog.check(basicBlock, basicBlock.getSub2());
                Expression exp2 = this.makeExpression(watchdog, basicBlock.getSub2(), statements, jumps);
                this.stack.push((Object)this.parseTernaryOperator(basicBlock.getFirstLineNumber(), condition, exp1, exp2));
                this.parseByteCode(basicBlock, statements);
                break;
            }
            case 0x20000000: {
                watchdog.check(basicBlock, basicBlock.getCondition());
                this.makeStatements(watchdog, basicBlock.getCondition(), statements, jumps);
                Expression condition = (Expression)this.stack.pop();
                DefaultStack backup = new DefaultStack(this.stack);
                watchdog.check(basicBlock, basicBlock.getSub1());
                Expression exp1 = this.makeExpression(watchdog, basicBlock.getSub1(), statements, jumps);
                if (this.stack.size() != backup.size()) {
                    this.stack.copy(backup);
                }
                watchdog.check(basicBlock, basicBlock.getSub2());
                Expression exp2 = this.makeExpression(watchdog, basicBlock.getSub2(), statements, jumps);
                this.stack.push((Object)this.parseTernaryOperator(basicBlock.getFirstLineNumber(), condition, exp1, exp2));
                watchdog.check(basicBlock, basicBlock.getNext());
                this.makeStatements(watchdog, basicBlock.getNext(), statements, jumps);
                break;
            }
            case 0x400000: {
                this.parseLoop(watchdog, basicBlock, statements, jumps);
                break;
            }
            case 0x800000: 
            case 0x1000000: {
                statements.add((Object)ContinueStatement.CONTINUE);
                break;
            }
            case 0x40000000: {
                ClassFileBreakContinueStatement jump = new ClassFileBreakContinueStatement(basicBlock.getFromOffset(), basicBlock.getToOffset());
                statements.add((Object)jump);
                jumps.add((Object)jump);
                break;
            }
            case 0x8000000: {
                statements.add((Object)new WhileStatement((Expression)BooleanExpression.TRUE, null));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected basic block: " + basicBlock.getTypeName() + ":" + basicBlock.getIndex());
            }
        }
    }

    protected Statements makeSubStatements(WatchDog watchdog, BasicBlock basicBlock, Statements statements, Statements jumps, BasicBlock updateBasicBlock) {
        Statements subStatements = this.makeSubStatements(watchdog, basicBlock, statements, jumps);
        if (updateBasicBlock != null) {
            subStatements.addAll((Collection)this.makeSubStatements(watchdog, updateBasicBlock, statements, jumps));
        }
        return subStatements;
    }

    protected Statements makeSubStatements(WatchDog watchdog, BasicBlock basicBlock, Statements statements, Statements jumps) {
        Statements subStatements = new Statements();
        if (!statements.isEmpty() && ((Statement)statements.getLast()).isMonitorEnterStatement()) {
            subStatements.add((Object)((Statement)statements.removeLast()));
        }
        this.localVariableMaker.pushFrame(subStatements);
        this.makeStatements(watchdog, basicBlock, subStatements, jumps);
        this.localVariableMaker.popFrame();
        this.replacePreOperatorWithPostOperator(subStatements);
        if (!subStatements.isEmpty() && ((Statement)subStatements.getFirst()).isMonitorEnterStatement()) {
            statements.add((Object)((Statement)subStatements.removeFirst()));
        }
        return subStatements;
    }

    protected Expression makeExpression(WatchDog watchdog, BasicBlock basicBlock, Statements statements, Statements jumps) {
        Expression boe;
        int initialStatementCount = statements.size();
        this.makeStatements(watchdog, basicBlock, statements, jumps);
        if (this.stack.isEmpty()) {
            return new StringConstantExpression("JD-Core does not support Kotlin");
        }
        Expression expression = (Expression)this.stack.pop();
        if (statements.size() > initialStatementCount && (boe = ((Statement)statements.getLast()).getExpression()) != NoExpression.NO_EXPRESSION) {
            if (boe.getRightExpression() == expression) {
                statements.removeLast();
                expression = boe;
            } else if (expression.isNewArray()) {
                expression = NewArrayMaker.make(statements, expression);
            }
        }
        return expression;
    }

    protected void parseSwitch(WatchDog watchdog, BasicBlock basicBlock, Statements statements, Statements jumps) {
        this.parseByteCode(basicBlock, statements);
        DefaultList<BasicBlock.SwitchCase> switchCases = basicBlock.getSwitchCases();
        SwitchStatement switchStatement = (SwitchStatement)statements.getLast();
        Expression condition = switchStatement.getCondition();
        Type conditionType = condition.getType();
        List blocks = switchStatement.getBlocks();
        DefaultStack localStack = new DefaultStack(this.stack);
        switchCases.sort(SWITCH_CASE_COMPARATOR);
        int len = switchCases.size();
        for (int i = 0; i < len; ++i) {
            int j;
            BasicBlock.SwitchCase sc = (BasicBlock.SwitchCase)switchCases.get(i);
            BasicBlock bb = sc.getBasicBlock();
            for (j = i + 1; j < len && bb == ((BasicBlock.SwitchCase)switchCases.get(j)).getBasicBlock(); ++j) {
            }
            Statements subStatements = new Statements();
            this.stack.copy(localStack);
            this.makeStatements(watchdog, bb, subStatements, jumps);
            this.replacePreOperatorWithPostOperator(subStatements);
            if (sc.isDefaultCase()) {
                blocks.add(new SwitchStatement.LabelBlock((SwitchStatement.Label)SwitchStatement.DEFAULT_LABEL, (BaseStatement)subStatements));
                continue;
            }
            if (j == i + 1) {
                SwitchStatement.ExpressionLabel label = new SwitchStatement.ExpressionLabel((Expression)new IntegerConstantExpression(conditionType, sc.getValue()));
                blocks.add(new SwitchStatement.LabelBlock((SwitchStatement.Label)label, (BaseStatement)subStatements));
                continue;
            }
            DefaultList labels = new DefaultList(j - i);
            while (i < j) {
                labels.add((Object)new SwitchStatement.ExpressionLabel((Expression)new IntegerConstantExpression(conditionType, ((BasicBlock.SwitchCase)switchCases.get(i)).getValue())));
                ++i;
            }
            blocks.add(new SwitchStatement.MultiLabelsBlock((List)labels, (BaseStatement)subStatements));
            --i;
        }
        int size = statements.size();
        if (size > 3 && condition.isLocalVariableReferenceExpression() && ((Statement)statements.get(size - 2)).isSwitchStatement()) {
            SwitchStatementMaker.makeSwitchString(this.localVariableMaker, statements, switchStatement);
        } else if (condition.isArrayExpression()) {
            SwitchStatementMaker.makeSwitchEnum(this.bodyDeclaration, switchStatement, this.typeMaker);
        }
        this.makeStatements(watchdog, basicBlock.getNext(), statements, jumps);
    }

    protected void parseTry(WatchDog watchdog, BasicBlock basicBlock, Statements statements, Statements jumps, boolean jsr, boolean eclipse) {
        DefaultList catchClauses = new DefaultList();
        Statements finallyStatements = null;
        Statements tryStatements = this.makeSubStatements(watchdog, basicBlock.getSub1(), statements, jumps);
        if (basicBlock.getNext().getType() == 0x1000000) {
            tryStatements.add((Object)ContinueStatement.CONTINUE);
            basicBlock.setNext(BasicBlock.END);
        }
        for (BasicBlock.ExceptionHandler exceptionHandler : basicBlock.getExceptionHandlers()) {
            if (exceptionHandler.getInternalThrowableName() == null) {
                Expression expression;
                Statement statement;
                this.stack.push((Object)FINALLY_EXCEPTION_EXPRESSION);
                finallyStatements = this.makeSubStatements(watchdog, exceptionHandler.getBasicBlock(), statements, jumps);
                if (((Statement)finallyStatements.getFirst()).isMonitorEnterStatement()) continue;
                this.removeFinallyStatementsFlag |= !jsr;
                Expression leftExpression = ((Statement)finallyStatements.getFirst()).getExpression().getLeftExpression();
                if (leftExpression.isLocalVariableReferenceExpression() && (statement = (Statement)finallyStatements.getLast()).isThrowStatement() && (expression = statement.getExpression()).isLocalVariableReferenceExpression()) {
                    ClassFileLocalVariableReferenceExpression vre1 = (ClassFileLocalVariableReferenceExpression)expression;
                    ClassFileLocalVariableReferenceExpression vre2 = (ClassFileLocalVariableReferenceExpression)leftExpression;
                    if (vre1.getLocalVariable() == vre2.getLocalVariable()) {
                        this.localVariableMaker.removeLocalVariable(vre2.getLocalVariable());
                        finallyStatements.removeFirst();
                    }
                }
                finallyStatements.removeLast();
                continue;
            }
            this.stack.push((Object)new NullExpression((Type)this.typeMaker.makeFromInternalTypeName(exceptionHandler.getInternalThrowableName())));
            Statements catchStatements = new Statements();
            this.localVariableMaker.pushFrame(catchStatements);
            BasicBlock bb = exceptionHandler.getBasicBlock();
            int lineNumber = bb.getControlFlowGraph().getLineNumber(bb.getFromOffset());
            int index = ByteCodeParser.getExceptionLocalVariableIndex(bb);
            ObjectType ot = this.typeMaker.makeFromInternalTypeName(exceptionHandler.getInternalThrowableName());
            int offset = bb.getFromOffset();
            byte[] code = bb.getControlFlowGraph().getMethod().getCode().getCode();
            offset = code[offset] == 58 ? (offset += 2) : ++offset;
            AbstractLocalVariable exception = this.localVariableMaker.getExceptionLocalVariable(index, offset, ot);
            if (bb != null && bb.getNext().getPredecessors().size() > 1) {
                bb.getNext().getPredecessors().remove(bb);
                bb.setNext(BasicBlock.END);
            }
            this.makeStatements(watchdog, bb, catchStatements, jumps);
            this.localVariableMaker.popFrame();
            this.removeExceptionReference(catchStatements);
            if (lineNumber != 0) {
                this.searchFirstLineNumberVisitor.init();
                this.searchFirstLineNumberVisitor.visit(catchStatements);
                if (this.searchFirstLineNumberVisitor.getLineNumber() == lineNumber) {
                    lineNumber = 0;
                }
            }
            this.replacePreOperatorWithPostOperator(catchStatements);
            ClassFileTryStatement.CatchClause cc = new ClassFileTryStatement.CatchClause(lineNumber, ot, exception, (BaseStatement)catchStatements);
            if (exceptionHandler.getOtherInternalThrowableNames() != null) {
                for (String name : exceptionHandler.getOtherInternalThrowableNames()) {
                    cc.addType(this.typeMaker.makeFromInternalTypeName(name));
                }
            }
            catchClauses.add((Object)cc);
        }
        Object statement = null;
        if (finallyStatements != null && !finallyStatements.isEmpty() && ((Statement)finallyStatements.getFirst()).isMonitorExitStatement()) {
            statement = SynchronizedStatementMaker.make(this.localVariableMaker, statements, tryStatements);
        } else {
            if (this.majorVersion > 52) {
                statement = TryWithResourcesStatementMaker.make(this.localVariableMaker, statements, tryStatements, (DefaultList<TryStatement.CatchClause>)catchClauses, finallyStatements);
            } else if (this.majorVersion >= 51 && (statement = TryWithResourcesStatementMaker.makeLegacy(this.localVariableMaker, statements, tryStatements, (DefaultList<TryStatement.CatchClause>)catchClauses, finallyStatements)) == null) {
                statement = TryWithResourcesStatementMaker.make(this.localVariableMaker, statements, tryStatements, (DefaultList<TryStatement.CatchClause>)catchClauses, finallyStatements);
            }
            if (statement == null) {
                statement = new ClassFileTryStatement((BaseStatement)tryStatements, (DefaultList<TryStatement.CatchClause>)catchClauses, (BaseStatement)finallyStatements, jsr, eclipse);
            } else {
                this.mergeTryWithResourcesStatementFlag = true;
            }
        }
        statements.add(statement);
        this.makeStatements(watchdog, basicBlock.getNext(), statements, jumps);
    }

    protected void removeExceptionReference(Statements catchStatements) {
        if (!catchStatements.isEmpty() && ((Statement)catchStatements.getFirst()).isExpressionStatement()) {
            Expression exp = ((Statement)catchStatements.getFirst()).getExpression();
            if (exp.isBinaryOperatorExpression()) {
                if (exp.getLeftExpression().isLocalVariableReferenceExpression() && exp.getRightExpression().isNullExpression()) {
                    catchStatements.removeFirst();
                }
            } else if (exp.isNullExpression()) {
                catchStatements.removeFirst();
            }
        }
    }

    protected void parseJSR(WatchDog watchdog, BasicBlock basicBlock, Statements statements, Statements jumps) {
        int statementCount = statements.size();
        this.parseByteCode(basicBlock, statements);
        this.makeStatements(watchdog, basicBlock.getBranch(), statements, jumps);
        this.makeStatements(watchdog, basicBlock.getNext(), statements, jumps);
        ExpressionStatement es = (ExpressionStatement)statements.get(statementCount);
        BinaryOperatorExpression boe = (BinaryOperatorExpression)es.getExpression();
        ClassFileLocalVariableReferenceExpression vre = (ClassFileLocalVariableReferenceExpression)boe.getLeftExpression();
        this.localVariableMaker.removeLocalVariable(vre.getLocalVariable());
        statements.remove(statementCount);
    }

    protected void parseIf(WatchDog watchdog, BasicBlock basicBlock, Statements statements, Statements jumps) {
        BasicBlock condition = basicBlock.getCondition();
        if (condition.getType() == 0x100000) {
            condition = condition.getSub1();
        }
        if (ByteCodeParser.isAssertCondition(this.internalTypeName, condition)) {
            BaseExpression parameters;
            Expression e;
            BooleanExpression cond;
            if (condition == basicBlock.getCondition()) {
                cond = new BooleanExpression(condition.getFirstLineNumber(), false);
            } else {
                condition = basicBlock.getCondition().getSub2();
                condition.inverseCondition();
                this.makeStatements(watchdog, condition, statements, jumps);
                cond = (Expression)this.stack.pop();
            }
            Statements subStatements = this.makeSubStatements(watchdog, basicBlock.getSub1(), statements, jumps);
            Expression message = null;
            if (((Statement)subStatements.getFirst()).isThrowStatement() && (e = ((Statement)subStatements.getFirst()).getExpression()).isNewExpression() && (parameters = e.getParameters()) != null && !parameters.isList()) {
                message = (Expression)parameters.getFirst();
            }
            statements.add((Object)new AssertStatement((Expression)cond, message));
            this.makeStatements(watchdog, basicBlock.getNext(), statements, jumps);
        } else {
            ReturnExpressionStatement returnExp;
            Statement thenStatement;
            IfStatement ifStatement;
            BaseStatement thenStatements;
            this.makeStatements(watchdog, basicBlock.getCondition(), statements, jumps);
            Expression cond = (Expression)this.stack.pop();
            DefaultStack backup = new DefaultStack(this.stack);
            Statements subStatements = this.makeSubStatements(watchdog, basicBlock.getSub1(), statements, jumps);
            if (this.stack.size() != backup.size()) {
                this.stack.copy(backup);
            }
            statements.add((Object)new IfStatement(cond, (BaseStatement)subStatements));
            int index = statements.size();
            this.makeStatements(watchdog, basicBlock.getNext(), statements, jumps);
            if (this.stack.size() == 1 && basicBlock.getNext().matchType(0x10000000) && !statements.isEmpty() && statements.getLast() instanceof IfStatement && (thenStatements = (ifStatement = (IfStatement)statements.getLast()).getStatements()).size() == 1 && (thenStatement = (Statement)thenStatements.getFirst()) instanceof ReturnExpressionStatement && (returnExp = (ReturnExpressionStatement)thenStatement).getExpression().getType().equals(((Expression)this.stack.peek()).getType())) {
                Expression exp = (Expression)this.stack.pop();
                statements.add((Object)new ReturnExpressionStatement(exp.getLineNumber(), exp));
            }
            if (subStatements.size() == 1 && index + 1 == statements.size() && ((Statement)subStatements.getFirst()).isReturnExpressionStatement() && ((Statement)statements.get(index)).isReturnExpressionStatement()) {
                Statement cfres1 = (Statement)subStatements.getFirst();
                if (cond.getLineNumber() >= cfres1.getLineNumber()) {
                    Statement cfres2 = (Statement)statements.get(index);
                    if (cfres1.getLineNumber() == cfres2.getLineNumber()) {
                        statements.subList(index - 1, statements.size()).clear();
                        statements.add((Object)new ReturnExpressionStatement((Expression)this.newTernaryOperatorExpression(cfres1.getLineNumber(), cond, cfres1.getExpression(), cfres2.getExpression())));
                    }
                }
            }
        }
    }

    protected void parseLoop(WatchDog watchdog, BasicBlock basicBlock, Statements statements, Statements jumps) {
        BasicBlock sub1 = basicBlock.getSub1();
        BasicBlock updateBasicBlock = null;
        if (sub1.getType() == 65536 && sub1.getCondition() == BasicBlock.END) {
            updateBasicBlock = sub1.getNext();
            sub1 = sub1.getSub1();
        }
        if (sub1.getType() == 65536 || sub1.getType() == 131072 && sub1.getSub2() == BasicBlock.LOOP_END) {
            BasicBlock ifBB = sub1;
            if (ifBB.getNext() == BasicBlock.LOOP_END || ifBB.getSub2() == BasicBlock.LOOP_END) {
                this.makeStatements(watchdog, ifBB.getCondition(), statements, jumps);
                statements.add((Object)LoopStatementMaker.makeLoop(this.majorVersion, this.typeBounds, this.localVariableMaker, basicBlock, statements, (Expression)this.stack.pop(), this.makeSubStatements(watchdog, ifBB.getSub1(), statements, jumps, updateBasicBlock), jumps));
                this.makeStatements(watchdog, basicBlock.getNext(), statements, jumps);
                return;
            }
            if (ifBB.getSub1() == BasicBlock.LOOP_END) {
                if (ifBB.getNext() == BasicBlock.LOOP_START) {
                    ifBB.getCondition().inverseCondition();
                    Statements subStatements = new Statements();
                    this.makeStatements(watchdog, ifBB.getCondition(), subStatements, jumps);
                    this.replacePreOperatorWithPostOperator(subStatements);
                    statements.add((Object)LoopStatementMaker.makeDoWhileLoop(basicBlock, (Expression)this.stack.pop(), subStatements, jumps));
                } else {
                    ifBB.getCondition().inverseCondition();
                    this.makeStatements(watchdog, ifBB.getCondition(), statements, jumps);
                    statements.add((Object)LoopStatementMaker.makeLoop(this.majorVersion, this.typeBounds, this.localVariableMaker, basicBlock, statements, (Expression)this.stack.pop(), this.makeSubStatements(watchdog, ifBB.getNext(), statements, jumps, updateBasicBlock), jumps));
                }
                this.makeStatements(watchdog, basicBlock.getNext(), statements, jumps);
                return;
            }
        }
        BasicBlock next = sub1.getNext();
        BasicBlock last = sub1;
        while (next.matchType(876822149) && next.getPredecessors().size() == 1) {
            last = next;
            next = next.getNext();
        }
        if (next == BasicBlock.LOOP_START && last.getType() == 65536 && last.getSub1() == BasicBlock.LOOP_END && this.countStartLoop(sub1) == 1) {
            Statements subStatements;
            last.getCondition().inverseCondition();
            last.setType(2);
            if (sub1.getType() == 0x400000 && sub1.getNext() == last && this.countStartLoop(sub1.getSub1()) == 0) {
                StatementMaker.changeEndLoopToStartLoop(new BitSet(), sub1.getSub1());
                subStatements = this.makeSubStatements(watchdog, sub1.getSub1(), statements, jumps, updateBasicBlock);
                if (subStatements.getLast() != ContinueStatement.CONTINUE) {
                    throw new IllegalStateException("StatementMaker.parseLoop(...) : unexpected basic block for create a do-while loop");
                }
                subStatements.removeLast();
            } else {
                this.createDoWhileContinue(last);
                subStatements = this.makeSubStatements(watchdog, sub1, statements, jumps, updateBasicBlock);
            }
            this.makeStatements(watchdog, last.getCondition(), subStatements, jumps);
            statements.add((Object)LoopStatementMaker.makeDoWhileLoop(basicBlock, (Expression)this.stack.pop(), subStatements, jumps));
        } else {
            statements.add((Object)LoopStatementMaker.makeLoop(this.localVariableMaker, basicBlock, statements, this.makeSubStatements(watchdog, sub1, statements, jumps, updateBasicBlock), jumps));
        }
        this.makeStatements(watchdog, basicBlock.getNext(), statements, jumps);
    }

    protected int countStartLoop(BasicBlock bb) {
        int count = 0;
        while (bb.matchType(876822149)) {
            switch (bb.getType()) {
                case 128: {
                    for (BasicBlock.SwitchCase switchCase : bb.getSwitchCases()) {
                        count += this.countStartLoop(switchCase.getBasicBlock());
                    }
                    break;
                }
                case 1024: 
                case 2048: 
                case 4096: {
                    count += this.countStartLoop(bb.getSub1());
                    for (BasicBlock.ExceptionHandler exceptionHandler : bb.getExceptionHandlers()) {
                        count += this.countStartLoop(exceptionHandler.getBasicBlock());
                    }
                    break;
                }
                case 131072: 
                case 0x20000000: {
                    count += this.countStartLoop(bb.getSub2());
                }
                case 65536: {
                    count += this.countStartLoop(bb.getSub1());
                }
            }
            bb = bb.getNext();
        }
        if (bb.getType() == 0x800000) {
            ++count;
        }
        return count;
    }

    protected void createDoWhileContinue(BasicBlock last) {
        boolean change;
        do {
            change = false;
            for (BasicBlock predecessor : last.getPredecessors()) {
                BasicBlock l;
                if (predecessor.getType() != 65536 || !(l = predecessor.getSub1()).matchType(876822149)) continue;
                BasicBlock n = l.getNext();
                while (n.matchType(876822149)) {
                    l = n;
                    n = n.getNext();
                }
                if (n != BasicBlock.END) continue;
                predecessor.getCondition().inverseCondition();
                predecessor.setNext(predecessor.getSub1());
                last.getPredecessors().remove(predecessor);
                last.getPredecessors().add(l);
                l.setNext(last);
                predecessor.setSub1(BasicBlock.LOOP_START);
                change = true;
            }
        } while (change);
    }

    protected static void changeEndLoopToStartLoop(BitSet visited, BasicBlock basicBlock) {
        if (!basicBlock.matchType(1266696506) && !visited.get(basicBlock.getIndex())) {
            visited.set(basicBlock.getIndex());
            switch (basicBlock.getType()) {
                case 8192: 
                case 32768: 
                case 262144: {
                    if (basicBlock.getBranch() == BasicBlock.LOOP_END) {
                        basicBlock.setBranch(BasicBlock.LOOP_START);
                    } else {
                        StatementMaker.changeEndLoopToStartLoop(visited, basicBlock.getBranch());
                    }
                }
                case 1: 
                case 4: 
                case 0x400000: 
                case 0x4000000: 
                case 0x10000000: {
                    if (basicBlock.getNext() == BasicBlock.LOOP_END) {
                        basicBlock.setNext(BasicBlock.LOOP_START);
                        break;
                    }
                    StatementMaker.changeEndLoopToStartLoop(visited, basicBlock.getNext());
                    break;
                }
                case 512: 
                case 1024: 
                case 2048: 
                case 4096: {
                    for (BasicBlock.ExceptionHandler exceptionHandler : basicBlock.getExceptionHandlers()) {
                        if (exceptionHandler.getBasicBlock() == BasicBlock.LOOP_END) {
                            exceptionHandler.setBasicBlock(BasicBlock.LOOP_START);
                            continue;
                        }
                        StatementMaker.changeEndLoopToStartLoop(visited, exceptionHandler.getBasicBlock());
                    }
                    break;
                }
                case 131072: 
                case 0x20000000: {
                    if (basicBlock.getSub2() == BasicBlock.LOOP_END) {
                        basicBlock.setSub2(BasicBlock.LOOP_START);
                    } else {
                        StatementMaker.changeEndLoopToStartLoop(visited, basicBlock.getSub2());
                    }
                }
                case 65536: {
                    if (basicBlock.getSub1() == BasicBlock.LOOP_END) {
                        basicBlock.setSub1(BasicBlock.LOOP_START);
                    } else {
                        StatementMaker.changeEndLoopToStartLoop(visited, basicBlock.getSub1());
                    }
                    if (basicBlock.getNext() == BasicBlock.LOOP_END) {
                        basicBlock.setNext(BasicBlock.LOOP_START);
                        break;
                    }
                    StatementMaker.changeEndLoopToStartLoop(visited, basicBlock.getNext());
                    break;
                }
                case 64: 
                case 128: {
                    for (BasicBlock.SwitchCase switchCase : basicBlock.getSwitchCases()) {
                        if (switchCase.getBasicBlock() == BasicBlock.LOOP_END) {
                            switchCase.setBasicBlock(BasicBlock.LOOP_START);
                            continue;
                        }
                        StatementMaker.changeEndLoopToStartLoop(visited, switchCase.getBasicBlock());
                    }
                    break;
                }
            }
        }
    }

    protected Expression parseTernaryOperator(int lineNumber, Expression condition, Expression exp1, Expression exp2) {
        String fieldName;
        FieldReferenceExpression freCond;
        if (ObjectType.TYPE_CLASS.equals((Object)exp1.getType()) && ObjectType.TYPE_CLASS.equals((Object)exp2.getType()) && condition.isBinaryOperatorExpression() && condition.getLeftExpression().isFieldReferenceExpression() && condition.getRightExpression().isNullExpression() && (freCond = (FieldReferenceExpression)condition.getLeftExpression()).getInternalTypeName().equals(this.internalTypeName) && (fieldName = freCond.getName()).startsWith("class$")) {
            MethodInvocationExpression mie;
            if ("==".equals(condition.getOperator()) && exp1.isBinaryOperatorExpression() && this.checkFieldReference(fieldName, exp2)) {
                MethodInvocationExpression mie2;
                if (exp1.getRightExpression().isMethodInvocationExpression() && this.checkFieldReference(fieldName, exp1.getLeftExpression()) && (mie2 = (MethodInvocationExpression)exp1.getRightExpression()).getParameters().isStringConstantExpression() && "class$".equals(mie2.getName()) && mie2.getInternalTypeName().equals(this.internalTypeName)) {
                    return this.createObjectTypeReferenceDotClassExpression(lineNumber, fieldName, mie2);
                }
            } else if ("!=".equals(condition.getOperator()) && exp2.isBinaryOperatorExpression() && this.checkFieldReference(fieldName, exp1) && exp2.getRightExpression().isMethodInvocationExpression() && this.checkFieldReference(fieldName, exp2.getLeftExpression()) && (mie = (MethodInvocationExpression)exp2.getRightExpression()).getParameters().isStringConstantExpression() && "class$".equals(mie.getName()) && mie.getInternalTypeName().equals(this.internalTypeName)) {
                return this.createObjectTypeReferenceDotClassExpression(lineNumber, fieldName, mie);
            }
        }
        return this.newTernaryOperatorExpression(lineNumber, condition, exp1, exp2);
    }

    protected TernaryOperatorExpression newTernaryOperatorExpression(int lineNumber, Expression condition, Expression expressionTrue, Expression expressionFalse) {
        int flags;
        Type expressionTrueType = expressionTrue.getType();
        Type expressionFalseType = expressionFalse.getType();
        Object type = expressionTrue.isNullExpression() ? expressionFalseType : (expressionFalse.isNullExpression() || expressionTrueType.equals(expressionFalseType) ? expressionTrueType : (expressionTrueType.isPrimitiveType() && expressionFalseType.isPrimitiveType() ? (((flags = ((PrimitiveType)expressionTrueType).getFlags() | ((PrimitiveType)expressionFalseType).getFlags()) & 8) != 0 ? PrimitiveType.TYPE_DOUBLE : ((flags & 4) != 0 ? PrimitiveType.TYPE_FLOAT : ((flags & 0x80) != 0 ? PrimitiveType.TYPE_LONG : (((flags = ((PrimitiveType)expressionTrueType).getFlags() & ((PrimitiveType)expressionFalseType).getFlags()) & 0x40) != 0 ? PrimitiveType.TYPE_INT : ((flags & 0x20) != 0 ? PrimitiveType.TYPE_SHORT : ((flags & 2) != 0 ? PrimitiveType.TYPE_CHAR : ((flags & 0x10) != 0 ? PrimitiveType.TYPE_BYTE : PrimitiveType.MAYBE_BOOLEAN_TYPE))))))) : (expressionTrueType.isObjectType() && expressionFalseType.isObjectType() ? (this.typeMaker.isAssignable(this.typeBounds, (ObjectType)expressionTrueType, (ObjectType)expressionFalseType) ? this.getTernaryOperatorExpressionType((ObjectType)expressionTrueType, (ObjectType)expressionFalseType) : (this.typeMaker.isAssignable(this.typeBounds, (ObjectType)expressionFalseType, (ObjectType)expressionTrueType) ? this.getTernaryOperatorExpressionType((ObjectType)expressionFalseType, (ObjectType)expressionTrueType) : ObjectType.TYPE_UNDEFINED_OBJECT)) : ObjectType.TYPE_UNDEFINED_OBJECT)));
        return new TernaryOperatorExpression(lineNumber, type, condition, expressionTrue, expressionFalse);
    }

    protected Type getTernaryOperatorExpressionType(ObjectType ot1, ObjectType ot2) {
        if (ot1.getTypeArguments() != null) {
            if (ot2.getTypeArguments() == null) {
                return ot1.createType(null);
            }
            if (!ot1.isTypeArgumentAssignableFrom(this.typeMaker, Collections.emptyMap(), this.typeBounds, (BaseTypeArgument)ot2)) {
                if (ot2.isTypeArgumentAssignableFrom(this.typeMaker, Collections.emptyMap(), this.typeBounds, (BaseTypeArgument)ot1)) {
                    return ot1.createType(ot2.getTypeArguments());
                }
                return ot1.createType(null);
            }
        }
        return ot1;
    }

    protected boolean checkFieldReference(String fieldName, Expression expression) {
        if (expression.isFieldReferenceExpression()) {
            FieldReferenceExpression fre = (FieldReferenceExpression)expression;
            return fre.getName().equals(fieldName) && fre.getInternalTypeName().equals(this.internalTypeName);
        }
        return false;
    }

    protected Expression createObjectTypeReferenceDotClassExpression(int lineNumber, String fieldName, MethodInvocationExpression mie) {
        this.memberVisitor.init(fieldName);
        for (ClassFileFieldDeclaration field : this.bodyDeclaration.getFieldDeclarations()) {
            field.getFieldDeclarators().accept((DeclarationVisitor)this.memberVisitor);
            if (!this.memberVisitor.found()) continue;
            field.setFlags(field.getFlags() | 0x1000);
            break;
        }
        this.memberVisitor.init("class$");
        for (ClassFileConstructorOrMethodDeclaration member : this.bodyDeclaration.getMethodDeclarations()) {
            member.accept(this.memberVisitor);
            if (!this.memberVisitor.found()) continue;
            member.setFlags(member.getFlags() | 0x1000);
            break;
        }
        String typeName = mie.getParameters().getStringValue();
        ObjectType ot = this.typeMaker.makeFromInternalTypeName(typeName.replace('.', '/'));
        return new TypeReferenceDotClassExpression(lineNumber, (Type)ot);
    }

    protected void parseByteCode(BasicBlock basicBlock, Statements statements) {
        this.byteCodeParser.parse(basicBlock, statements, this.stack, this.enclosingInstances);
    }

    protected void replacePreOperatorWithPostOperator(Statements statements) {
        for (Statement statement : statements) {
            Expression poe;
            String operator;
            if (!statement.getExpression().isPreOperatorExpression() || !"++".equals(operator = (poe = statement.getExpression()).getOperator()) && !"--".equals(operator)) continue;
            if (statement.isExpressionStatement()) {
                ExpressionStatement es = (ExpressionStatement)statement;
                es.setExpression((Expression)new PostOperatorExpression(poe.getLineNumber(), poe.getExpression(), operator));
                continue;
            }
            if (!statement.isReturnExpressionStatement()) continue;
            ReturnExpressionStatement res = (ReturnExpressionStatement)statement;
            res.setExpression((Expression)new PostOperatorExpression(poe.getLineNumber(), poe.getExpression(), operator));
        }
    }

    protected void updateJumpStatements(Statements jumps, ControlFlowGraph cfg) {
        for (ClassFileBreakContinueStatement statement : jumps) {
            CommentStatement commentStatement = new CommentStatement();
            commentStatement.setText("// goto line number " + cfg.getLineNumber(statement.getTargetOffset()));
            statement.setStatement((Statement)commentStatement);
        }
    }

    protected static class MemberVisitor
    extends AbstractJavaSyntaxVisitor {
        private String name;
        private boolean found;

        protected MemberVisitor() {
        }

        public void init(String name) {
            this.name = name;
            this.found = false;
        }

        public boolean found() {
            return this.found;
        }

        @Override
        public void visit(FieldDeclarator declaration) {
            this.found |= declaration.getName().equals(this.name);
        }

        @Override
        public void visit(MethodDeclaration declaration) {
            this.found |= declaration.getName().equals(this.name);
        }
    }

    protected static class SwitchCaseComparator
    implements Serializable,
    Comparator<BasicBlock.SwitchCase> {
        private static final long serialVersionUID = 1L;

        protected SwitchCaseComparator() {
        }

        @Override
        public int compare(BasicBlock.SwitchCase sc1, BasicBlock.SwitchCase sc2) {
            int diff = sc1.getOffset() - sc2.getOffset();
            if (diff != 0) {
                return diff;
            }
            return sc1.getValue() - sc2.getValue();
        }
    }
}

