/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import java.util.Collections;
import java.util.ListIterator;
import org.jd.core.v1.model.javasyntax.declaration.ArrayVariableInitializer;
import org.jd.core.v1.model.javasyntax.declaration.ExpressionVariableInitializer;
import org.jd.core.v1.model.javasyntax.declaration.VariableInitializer;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.IntegerConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.NewInitializedArray;
import org.jd.core.v1.model.javasyntax.expression.NullExpression;
import org.jd.core.v1.model.javasyntax.statement.Statement;
import org.jd.core.v1.model.javasyntax.statement.Statements;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;

public final class NewArrayMaker {
    private static final ArrayVariableInitializer EMPTY_ARRAY = new ArrayVariableInitializer((Type)PrimitiveType.TYPE_VOID);

    private NewArrayMaker() {
    }

    public static Expression make(Statements statements, Expression newArray) {
        Expression ae;
        if (!statements.isEmpty() && (ae = ((Statement)statements.getLast()).getExpression().getLeftExpression()).getExpression() == newArray && ae.getIndex().isIntegerConstantExpression()) {
            return new NewInitializedArray(newArray.getLineNumber(), newArray.getType(), NewArrayMaker.createVariableInitializer(statements.listIterator(statements.size()), newArray));
        }
        return newArray;
    }

    private static ArrayVariableInitializer createVariableInitializer(ListIterator<Statement> li, Expression newArray) {
        Statement statement = li.previous();
        li.remove();
        Type type = newArray.getType();
        Expression boe = statement.getExpression();
        ArrayVariableInitializer array = new ArrayVariableInitializer(type.createType(type.getDimension() - 1));
        int index = boe.getLeftExpression().getIndex().getIntegerValue();
        array.add((Object)new ExpressionVariableInitializer(boe.getRightExpression()));
        while (li.hasPrevious()) {
            Expression ae;
            boe = li.previous().getExpression();
            if (boe.getLeftExpression().isArrayExpression() && (ae = boe.getLeftExpression()).getIndex().isIntegerConstantExpression()) {
                Expression lastE;
                if (ae.getExpression() == newArray) {
                    index = ae.getIndex().getIntegerValue();
                    array.add((Object)new ExpressionVariableInitializer(boe.getRightExpression()));
                    li.remove();
                    continue;
                }
                if (ae.getExpression().isNewArray() && (lastE = ((VariableInitializer)array.getLast()).getExpression()).isNewArray() && ae.getExpression() == lastE) {
                    array.removeLast();
                    li.next();
                    array.add((Object)NewArrayMaker.createVariableInitializer(li, lastE));
                    continue;
                }
            }
            li.next();
            break;
        }
        ListIterator vii = array.listIterator();
        while (vii.hasNext()) {
            BaseExpression del;
            Expression expression = ((VariableInitializer)vii.next()).getExpression();
            if (!expression.isNewArray() || !(del = expression.getDimensionExpressionList()).isIntegerConstantExpression() || del.getIntegerValue() != 0) continue;
            Type t = expression.getType();
            if (type.getDimension() != t.getDimension() + 1 || type.getDescriptor().length() != t.getDescriptor().length() + 1 || !type.getDescriptor().endsWith(t.getDescriptor())) continue;
            vii.set(EMPTY_ARRAY);
        }
        if (index > 0) {
            ExpressionVariableInitializer evi = (type = type.createType(type.getDimension() - 1)).getDimension() == 0 && type.isPrimitiveType() ? new ExpressionVariableInitializer((Expression)new IntegerConstantExpression(type, 0)) : new ExpressionVariableInitializer((Expression)new NullExpression(type));
            while (index-- > 0) {
                array.add((Object)evi);
            }
        }
        Collections.reverse(array);
        return array;
    }
}

