/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jd.core.v1.model.javasyntax.declaration.MemberDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.MemberDeclarations;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileMemberDeclaration;

public final class MergeMembersUtil {
    private static final MemberDeclarationComparator MEMBER_DECLARATION_COMPARATOR = new MemberDeclarationComparator();

    private MergeMembersUtil() {
    }

    public static MemberDeclarations merge(List<? extends ClassFileMemberDeclaration> fields, List<? extends ClassFileMemberDeclaration> methods, List<? extends ClassFileMemberDeclaration> innerTypes) {
        int size = fields != null ? fields.size() : 0;
        if (methods != null) {
            size += methods.size();
        }
        if (innerTypes != null) {
            size += innerTypes.size();
        }
        MemberDeclarations result = new MemberDeclarations(size);
        MergeMembersUtil.merge((List<MemberDeclaration>)result, fields);
        MergeMembersUtil.merge((List<MemberDeclaration>)result, methods);
        MergeMembersUtil.merge((List<MemberDeclaration>)result, innerTypes);
        return result;
    }

    private static void merge(List<MemberDeclaration> result, List<? extends ClassFileMemberDeclaration> members) {
        if (members != null && !members.isEmpty()) {
            MergeMembersUtil.sort(members);
            if (result.isEmpty()) {
                result.addAll(members);
            } else {
                int resultIndex = 0;
                int resultLength = result.size();
                int listStartIndex = 0;
                int listEndIndex = 0;
                int listLength = members.size();
                int listLineNumber = 0;
                while (listEndIndex < listLength) {
                    ClassFileMemberDeclaration member;
                    int resultLineNumber;
                    while (listEndIndex < listLength) {
                        listLineNumber = members.get(listEndIndex).getFirstLineNumber();
                        ++listEndIndex;
                        if (listLineNumber <= 0) continue;
                    }
                    if (listLineNumber == 0) {
                        result.addAll(members.subList(listStartIndex, listEndIndex));
                        continue;
                    }
                    while (resultIndex < resultLength && (resultLineNumber = (member = (ClassFileMemberDeclaration)result.get(resultIndex)).getFirstLineNumber()) <= listLineNumber) {
                        ++resultIndex;
                    }
                    result.addAll(resultIndex, members.subList(listStartIndex, listEndIndex));
                    int subListLength = listEndIndex - listStartIndex;
                    resultIndex += subListLength;
                    resultLength += subListLength;
                    listStartIndex = listEndIndex;
                }
            }
        }
    }

    private static void sort(List<? extends ClassFileMemberDeclaration> members) {
        int order = 0;
        int lastLineNumber = 0;
        for (ClassFileMemberDeclaration classFileMemberDeclaration : members) {
            int lineNumber = classFileMemberDeclaration.getFirstLineNumber();
            if (lineNumber <= 0 || lineNumber == lastLineNumber) continue;
            if (lastLineNumber > 0) {
                if (order == 0) {
                    order = lineNumber > lastLineNumber ? 1 : 2;
                } else if (order == 1) {
                    if (lineNumber < lastLineNumber) {
                        order = 3;
                        break;
                    }
                } else if (order == 2 && lineNumber > lastLineNumber) {
                    order = 3;
                    break;
                }
            }
            lastLineNumber = lineNumber;
        }
        if (order == 2) {
            Collections.reverse(members);
        } else if (order == 3) {
            members.sort(MEMBER_DECLARATION_COMPARATOR);
        }
    }

    protected static class MemberDeclarationComparator
    implements Serializable,
    Comparator<ClassFileMemberDeclaration> {
        private static final long serialVersionUID = 1L;

        protected MemberDeclarationComparator() {
        }

        @Override
        public int compare(ClassFileMemberDeclaration md1, ClassFileMemberDeclaration md2) {
            int lineNumber1 = md1.getFirstLineNumber();
            int lineNumber2 = md2.getFirstLineNumber();
            if (lineNumber1 == 0) {
                lineNumber1 = Integer.MAX_VALUE;
            }
            if (lineNumber2 == 0) {
                lineNumber2 = Integer.MAX_VALUE;
            }
            return lineNumber1 - lineNumber2;
        }
    }
}

