/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.expression.ArrayExpression;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.BooleanExpression;
import org.jd.core.v1.model.javasyntax.expression.CastExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor;
import org.jd.core.v1.model.javasyntax.expression.Expressions;
import org.jd.core.v1.model.javasyntax.expression.MethodInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.PostOperatorExpression;
import org.jd.core.v1.model.javasyntax.statement.BaseStatement;
import org.jd.core.v1.model.javasyntax.statement.BreakStatement;
import org.jd.core.v1.model.javasyntax.statement.ContinueStatement;
import org.jd.core.v1.model.javasyntax.statement.DoWhileStatement;
import org.jd.core.v1.model.javasyntax.statement.LabelStatement;
import org.jd.core.v1.model.javasyntax.statement.Statement;
import org.jd.core.v1.model.javasyntax.statement.StatementVisitor;
import org.jd.core.v1.model.javasyntax.statement.Statements;
import org.jd.core.v1.model.javasyntax.statement.WhileStatement;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.BaseTypeArgument;
import org.jd.core.v1.model.javasyntax.type.GenericType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeArgumentVisitor;
import org.jd.core.v1.model.javasyntax.type.WildcardExtendsTypeArgument;
import org.jd.core.v1.model.javasyntax.type.WildcardSuperTypeArgument;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg.BasicBlock;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileLocalVariableReferenceExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileNewExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.statement.ClassFileBreakContinueStatement;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.statement.ClassFileForEachStatement;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.statement.ClassFileForStatement;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.AbstractLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.GenericLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.ObjectLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.LocalVariableMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.ChangeFrameOfLocalVariablesVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.CreateTypeFromTypeArgumentVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.RemoveLastContinueStatementVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.SearchFirstLineNumberVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.SearchFromOffsetVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.SearchLocalVariableReferenceVisitor;

public final class LoopStatementMaker {
    private static final RemoveLastContinueStatementVisitor REMOVE_LAST_CONTINUE_STATEMENT_VISITOR = new RemoveLastContinueStatementVisitor();

    private LoopStatementMaker() {
    }

    public static Statement makeLoop(int majorVersion, Map<String, BaseType> typeBounds, LocalVariableMaker localVariableMaker, BasicBlock loopBasicBlock, Statements statements, Expression condition, Statements subStatements, Statements jumps) {
        Statement loop = LoopStatementMaker.makeLoop(majorVersion, typeBounds, localVariableMaker, loopBasicBlock, statements, condition, subStatements);
        int continueOffset = loopBasicBlock.getSub1().getFromOffset();
        int breakOffset = loopBasicBlock.getNext().getFromOffset();
        if (breakOffset <= 0) {
            breakOffset = loopBasicBlock.getToOffset();
        }
        return LoopStatementMaker.makeLabels(loopBasicBlock.getIndex(), continueOffset, breakOffset, loop, jumps);
    }

    private static Statement makeLoop(int majorVersion, Map<String, BaseType> typeBounds, LocalVariableMaker localVariableMaker, BasicBlock loopBasicBlock, Statements statements, Expression condition, Statements subStatements) {
        boolean forEachSupported = majorVersion >= 49;
        subStatements.accept((StatementVisitor)REMOVE_LAST_CONTINUE_STATEMENT_VISITOR);
        if (forEachSupported) {
            Statement statement = LoopStatementMaker.makeForEachArray(typeBounds, localVariableMaker, statements, condition, subStatements);
            if (statement != null) {
                return statement;
            }
            statement = LoopStatementMaker.makeForEachList(typeBounds, localVariableMaker, statements, condition, subStatements);
            if (statement != null) {
                return statement;
            }
        }
        int lineNumber = condition == null ? 0 : condition.getLineNumber();
        int subStatementsSize = subStatements.size();
        switch (subStatementsSize) {
            case 0: {
                BaseExpression init;
                if (lineNumber <= 0 || (init = LoopStatementMaker.extractInit(statements, lineNumber)) == null) break;
                return LoopStatementMaker.newClassFileForStatement(localVariableMaker, loopBasicBlock.getFromOffset(), loopBasicBlock.getToOffset(), init, condition, null, null);
            }
            case 1: {
                if (lineNumber > 0) {
                    Statement subStatement = (Statement)subStatements.getFirst();
                    BaseExpression init = LoopStatementMaker.extractInit(statements, lineNumber);
                    if (subStatement.isExpressionStatement()) {
                        Expression subExpression = subStatement.getExpression();
                        if (subExpression.getLineNumber() == lineNumber) {
                            return LoopStatementMaker.newClassFileForStatement(localVariableMaker, loopBasicBlock.getFromOffset(), loopBasicBlock.getToOffset(), init, condition, (BaseExpression)subExpression, null);
                        }
                        if (init == null) break;
                        return LoopStatementMaker.newClassFileForStatement(localVariableMaker, loopBasicBlock.getFromOffset(), loopBasicBlock.getToOffset(), init, condition, null, (BaseStatement)subStatement);
                    }
                    if (init == null) break;
                    return LoopStatementMaker.newClassFileForStatement(localVariableMaker, loopBasicBlock.getFromOffset(), loopBasicBlock.getToOffset(), init, condition, null, (BaseStatement)subStatement);
                }
                return LoopStatementMaker.createForStatementWithoutLineNumber(localVariableMaker, loopBasicBlock, statements, condition, subStatements);
            }
            default: {
                if (lineNumber <= 0) {
                    return LoopStatementMaker.createForStatementWithoutLineNumber(localVariableMaker, loopBasicBlock, statements, condition, subStatements);
                }
                SearchFirstLineNumberVisitor visitor = new SearchFirstLineNumberVisitor();
                ((Statement)subStatements.getFirst()).accept((StatementVisitor)visitor);
                int firstLineNumber = visitor.getLineNumber();
                Expressions update = LoopStatementMaker.extractUpdate(subStatements, firstLineNumber);
                BaseExpression init = LoopStatementMaker.extractInit(statements, lineNumber);
                if (init == null && update.isEmpty()) break;
                return LoopStatementMaker.newClassFileForStatement(localVariableMaker, loopBasicBlock.getFromOffset(), loopBasicBlock.getToOffset(), init, condition, (BaseExpression)update, (BaseStatement)subStatements);
            }
        }
        return new WhileStatement(condition, (BaseStatement)subStatements);
    }

    public static Statement makeLoop(LocalVariableMaker localVariableMaker, BasicBlock loopBasicBlock, Statements statements, Statements subStatements, Statements jumps) {
        subStatements.accept((StatementVisitor)REMOVE_LAST_CONTINUE_STATEMENT_VISITOR);
        Statement loop = LoopStatementMaker.makeLoop(localVariableMaker, loopBasicBlock, statements, subStatements);
        int continueOffset = loopBasicBlock.getSub1().getFromOffset();
        int breakOffset = loopBasicBlock.getNext().getFromOffset();
        if (breakOffset <= 0) {
            breakOffset = loopBasicBlock.getToOffset();
        }
        return LoopStatementMaker.makeLabels(loopBasicBlock.getIndex(), continueOffset, breakOffset, loop, jumps);
    }

    private static Statement makeLoop(LocalVariableMaker localVariableMaker, BasicBlock loopBasicBlock, Statements statements, Statements subStatements) {
        int subStatementsSize = subStatements.size();
        if (subStatementsSize > 0 && subStatements.getLast() == ContinueStatement.CONTINUE) {
            subStatements.removeLast();
            --subStatementsSize;
        }
        switch (subStatementsSize) {
            case 0: {
                break;
            }
            case 1: {
                BaseExpression init;
                Expression subExpression;
                int lineNumber;
                Statement subStatement = (Statement)subStatements.getFirst();
                if (!subStatement.isExpressionStatement() || (lineNumber = (subExpression = subStatement.getExpression()).getLineNumber()) <= 0 || (init = LoopStatementMaker.extractInit(statements, lineNumber)) == null) break;
                return LoopStatementMaker.newClassFileForStatement(localVariableMaker, loopBasicBlock.getFromOffset(), loopBasicBlock.getToOffset(), init, null, (BaseExpression)subExpression, null);
            }
            default: {
                SearchFirstLineNumberVisitor visitor = new SearchFirstLineNumberVisitor();
                ((Statement)subStatements.get(0)).accept((StatementVisitor)visitor);
                int firstLineNumber = visitor.getLineNumber();
                if (firstLineNumber <= 0) {
                    return LoopStatementMaker.createForStatementWithoutLineNumber(localVariableMaker, loopBasicBlock, statements, (Expression)BooleanExpression.TRUE, subStatements);
                }
                Expressions update = LoopStatementMaker.extractUpdate(subStatements, firstLineNumber);
                if (update.isEmpty()) break;
                BaseExpression init = LoopStatementMaker.extractInit(statements, ((Expression)update.getFirst()).getLineNumber());
                return LoopStatementMaker.newClassFileForStatement(localVariableMaker, loopBasicBlock.getFromOffset(), loopBasicBlock.getToOffset(), init, null, (BaseExpression)update, (BaseStatement)subStatements);
            }
        }
        return new WhileStatement((Expression)BooleanExpression.TRUE, (BaseStatement)subStatements);
    }

    public static Statement makeDoWhileLoop(BasicBlock loopBasicBlock, Expression condition, Statements subStatements, Statements jumps) {
        subStatements.accept((StatementVisitor)REMOVE_LAST_CONTINUE_STATEMENT_VISITOR);
        DoWhileStatement loop = new DoWhileStatement(condition, (BaseStatement)subStatements);
        int continueOffset = loopBasicBlock.getSub1().getFromOffset();
        int breakOffset = loopBasicBlock.getNext().getFromOffset();
        if (breakOffset <= 0) {
            breakOffset = loopBasicBlock.getToOffset();
        }
        return LoopStatementMaker.makeLabels(loopBasicBlock.getIndex(), continueOffset, breakOffset, (Statement)loop, jumps);
    }

    private static BaseExpression extractInit(Statements statements, int lineNumber) {
        if (lineNumber > 0) {
            switch (statements.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    Expression expression;
                    Statement statement = (Statement)statements.getFirst();
                    if (!statement.isExpressionStatement() || (expression = statement.getExpression()).getLineNumber() != lineNumber || !expression.isBinaryOperatorExpression() || expression.getRightExpression().getLineNumber() == 0) break;
                    statements.clear();
                    return expression;
                }
                default: {
                    Expression expression;
                    Statement statement;
                    Expressions init = new Expressions();
                    ListIterator iterator = statements.listIterator(statements.size());
                    while (iterator.hasPrevious() && (statement = (Statement)iterator.previous()).isExpressionStatement() && (expression = statement.getExpression()).getLineNumber() == lineNumber && expression.isBinaryOperatorExpression() && expression.getRightExpression().getLineNumber() != 0) {
                        init.add((Object)expression);
                        iterator.remove();
                    }
                    if (init.isEmpty()) break;
                    if (init.size() > 1) {
                        Collections.reverse(init);
                    }
                    return init;
                }
            }
        }
        return null;
    }

    private static Expressions extractUpdate(Statements statements, int firstLineNumber) {
        Expression expression;
        Statement statement;
        Expressions update = new Expressions();
        ListIterator iterator = statements.listIterator(statements.size());
        while (iterator.hasPrevious() && (statement = (Statement)iterator.previous()).isExpressionStatement() && (expression = statement.getExpression()).getLineNumber() < firstLineNumber) {
            iterator.remove();
            update.add((Object)expression);
        }
        if (update.size() > 1) {
            Collections.reverse(update);
        }
        return update;
    }

    private static Statement createForStatementWithoutLineNumber(LocalVariableMaker localVariableMaker, BasicBlock basicBlock, Statements statements, Expression condition, Statements subStatements) {
        Expression init;
        if (!statements.isEmpty() && (init = ((Statement)statements.getLast()).getExpression()).getLeftExpression().isLocalVariableReferenceExpression()) {
            Expression expression;
            AbstractLocalVariable localVariable = ((ClassFileLocalVariableReferenceExpression)init.getLeftExpression()).getLocalVariable();
            Expression update = ((Statement)subStatements.getLast()).getExpression();
            if (update.isBinaryOperatorExpression()) {
                expression = update.getLeftExpression();
            } else if (update.isPreOperatorExpression()) {
                expression = update.getExpression();
                update = new PostOperatorExpression(update.getLineNumber(), expression, update.getOperator());
            } else if (update.isPostOperatorExpression()) {
                expression = update.getExpression();
            } else {
                return new WhileStatement(condition, (BaseStatement)subStatements);
            }
            if (expression.isLocalVariableReferenceExpression() && ((ClassFileLocalVariableReferenceExpression)expression).getLocalVariable() == localVariable) {
                statements.removeLast();
                subStatements.removeLast();
                if (condition == BooleanExpression.TRUE) {
                    condition = null;
                }
                return LoopStatementMaker.newClassFileForStatement(localVariableMaker, basicBlock.getFromOffset(), basicBlock.getToOffset(), (BaseExpression)init, condition, (BaseExpression)update, (BaseStatement)subStatements);
            }
        }
        return new WhileStatement(condition, (BaseStatement)subStatements);
    }

    private static Statement makeForEachArray(Map<String, BaseType> typeBounds, LocalVariableMaker localVariableMaker, Statements statements, Expression condition, Statements subStatements) {
        if (condition == null) {
            return null;
        }
        int statementsSize = statements.size();
        if (statementsSize < 3 || subStatements.size() < 2) {
            return null;
        }
        Statement statement = (Statement)statements.get(statementsSize - 2);
        if (!statement.isExpressionStatement()) {
            return null;
        }
        int lineNumber = condition.getLineNumber();
        Expression expression = statement.getExpression();
        if (expression.getLineNumber() != lineNumber || !expression.isBinaryOperatorExpression()) {
            return null;
        }
        if (!expression.getRightExpression().isLengthExpression() || !expression.getLeftExpression().isLocalVariableReferenceExpression()) {
            return null;
        }
        Expression boe = expression;
        if (!(expression = boe.getRightExpression().getExpression()).isLocalVariableReferenceExpression()) {
            return null;
        }
        AbstractLocalVariable syntheticArray = ((ClassFileLocalVariableReferenceExpression)expression).getLocalVariable();
        AbstractLocalVariable syntheticLength = ((ClassFileLocalVariableReferenceExpression)boe.getLeftExpression()).getLocalVariable();
        if (syntheticArray.getName() != null && syntheticArray.getName().indexOf(36) == -1) {
            return null;
        }
        expression = ((Statement)subStatements.getFirst()).getExpression();
        if (!expression.getRightExpression().isArrayExpression() || !expression.getLeftExpression().isLocalVariableReferenceExpression() || expression.getLineNumber() != condition.getLineNumber()) {
            return null;
        }
        ArrayExpression arrayExpression = (ArrayExpression)expression.getRightExpression();
        if (!arrayExpression.getExpression().isLocalVariableReferenceExpression() || !arrayExpression.getIndex().isLocalVariableReferenceExpression()) {
            return null;
        }
        if (((ClassFileLocalVariableReferenceExpression)arrayExpression.getExpression()).getLocalVariable() != syntheticArray) {
            return null;
        }
        AbstractLocalVariable syntheticIndex = ((ClassFileLocalVariableReferenceExpression)arrayExpression.getIndex()).getLocalVariable();
        AbstractLocalVariable item = ((ClassFileLocalVariableReferenceExpression)expression.getLeftExpression()).getLocalVariable();
        if (syntheticIndex.getName() != null && syntheticIndex.getName().indexOf(36) == -1) {
            return null;
        }
        expression = ((Statement)statements.get(statementsSize - 3)).getExpression();
        if (!expression.getLeftExpression().isLocalVariableReferenceExpression()) {
            return null;
        }
        if (((ClassFileLocalVariableReferenceExpression)expression.getLeftExpression()).getLocalVariable() != syntheticArray) {
            return null;
        }
        Type arrayType = expression.getRightExpression().getType();
        Expression array = expression.getRightExpression();
        expression = ((Statement)statements.get(statementsSize - 1)).getExpression();
        if (expression.getLineNumber() != lineNumber || !expression.getLeftExpression().isLocalVariableReferenceExpression() || !expression.getRightExpression().isIntegerConstantExpression()) {
            return null;
        }
        if (expression.getRightExpression().getIntegerValue() != 0 || ((ClassFileLocalVariableReferenceExpression)expression.getLeftExpression()).getLocalVariable() != syntheticIndex) {
            return null;
        }
        if (!condition.getLeftExpression().isLocalVariableReferenceExpression() || !condition.getRightExpression().isLocalVariableReferenceExpression()) {
            return null;
        }
        if (((ClassFileLocalVariableReferenceExpression)condition.getLeftExpression()).getLocalVariable() != syntheticIndex || ((ClassFileLocalVariableReferenceExpression)condition.getRightExpression()).getLocalVariable() != syntheticLength) {
            return null;
        }
        expression = ((Statement)subStatements.getLast()).getExpression();
        if (expression.getLineNumber() != lineNumber || !expression.isPostOperatorExpression()) {
            return null;
        }
        statements.removeLast();
        statements.removeLast();
        statements.removeLast();
        subStatements.removeFirst();
        subStatements.removeLast();
        item.setDeclared(true);
        Type type = arrayType.createType(arrayType.getDimension() - 1);
        if (ObjectType.TYPE_OBJECT.equals((Object)item.getType())) {
            ((ObjectLocalVariable)item).setType(typeBounds, type);
        } else if (item.getType().isGenericType() && type.isGenericType()) {
            ((GenericLocalVariable)item).setType((GenericType)type);
        } else {
            item.typeOnRight(typeBounds, type);
        }
        localVariableMaker.removeLocalVariable(syntheticArray);
        localVariableMaker.removeLocalVariable(syntheticIndex);
        localVariableMaker.removeLocalVariable(syntheticLength);
        if (array instanceof CastExpression) {
            Type rightArrayType;
            CastExpression castExpression = (CastExpression)array;
            Type leftArrayType = item.getType().createType(item.getType().getDimension() + 1);
            if (leftArrayType.equals(rightArrayType = castExpression.getExpression().getType())) {
                return new ClassFileForEachStatement(item, castExpression.getExpression(), (BaseStatement)subStatements);
            }
        }
        return new ClassFileForEachStatement(item, array, (BaseStatement)subStatements);
    }

    private static Statement makeForEachList(Map<String, BaseType> typeBounds, LocalVariableMaker localVariableMaker, Statements statements, Expression condition, Statements subStatements) {
        Type type;
        if (condition == null) {
            return null;
        }
        if (statements.isEmpty() || subStatements.isEmpty()) {
            return null;
        }
        if (!condition.isMethodInvocationExpression()) {
            return null;
        }
        MethodInvocationExpression mie = (MethodInvocationExpression)condition;
        if (!("hasNext".equals(mie.getName()) && "java/util/Iterator".equals(mie.getInternalTypeName()) && mie.getExpression().isLocalVariableReferenceExpression())) {
            return null;
        }
        AbstractLocalVariable syntheticIterator = ((ClassFileLocalVariableReferenceExpression)mie.getExpression()).getLocalVariable();
        Expression boe = ((Statement)statements.getLast()).getExpression();
        if (boe == null || !boe.getLeftExpression().isLocalVariableReferenceExpression() || !boe.getRightExpression().isMethodInvocationExpression() || boe.getLineNumber() != condition.getLineNumber()) {
            return null;
        }
        mie = (MethodInvocationExpression)boe.getRightExpression();
        if (!"iterator".equals(mie.getName()) || !"()Ljava/util/Iterator;".equals(mie.getDescriptor())) {
            return null;
        }
        if (((ClassFileLocalVariableReferenceExpression)boe.getLeftExpression()).getLocalVariable() != syntheticIterator) {
            return null;
        }
        Expression list = mie.getExpression();
        if (list.isCastExpression()) {
            list = list.getExpression();
        }
        if (!(boe = ((Statement)subStatements.getFirst()).getExpression()).getLeftExpression().isLocalVariableReferenceExpression()) {
            return null;
        }
        Expression expression = boe.getRightExpression();
        if (boe.getRightExpression().isCastExpression()) {
            expression = expression.getExpression();
        }
        if (!expression.isMethodInvocationExpression()) {
            return null;
        }
        mie = (MethodInvocationExpression)expression;
        if (!("next".equals(mie.getName()) && "java/util/Iterator".equals(mie.getInternalTypeName()) && mie.getExpression().isLocalVariableReferenceExpression())) {
            return null;
        }
        if (((ClassFileLocalVariableReferenceExpression)mie.getExpression()).getLocalVariable() != syntheticIterator) {
            return null;
        }
        SearchLocalVariableReferenceVisitor visitor1 = new SearchLocalVariableReferenceVisitor();
        visitor1.init(syntheticIterator);
        int len = subStatements.size();
        for (int i = 1; i < len; ++i) {
            ((Statement)subStatements.get(i)).accept((StatementVisitor)visitor1);
        }
        if (visitor1.containsReference()) {
            return null;
        }
        AbstractLocalVariable item = ((ClassFileLocalVariableReferenceExpression)boe.getLeftExpression()).getLocalVariable();
        statements.removeLast();
        subStatements.remove(0);
        item.setDeclared(true);
        if (syntheticIterator.getReferences().size() == 3) {
            localVariableMaker.removeLocalVariable(syntheticIterator);
        }
        if ((type = list.getType()).isObjectType()) {
            ObjectType listType = (ObjectType)type;
            if (listType.getTypeArguments() == null || listType.getTypeArguments().isWildcardTypeArgument() || listType.getTypeArguments().isGenericTypeArgument()) {
                if (list.isNewExpression()) {
                    ClassFileNewExpression ne = (ClassFileNewExpression)list;
                    ne.setType(listType.createType((BaseTypeArgument)item.getType()));
                } else {
                    list = new CastExpression((Type)ObjectType.TYPE_ITERABLE.createType((BaseTypeArgument)item.getType()), list);
                }
            } else {
                CreateTypeFromTypeArgumentVisitor visitor2 = new CreateTypeFromTypeArgumentVisitor();
                listType.getTypeArguments().accept((TypeArgumentVisitor)visitor2);
                type = visitor2.getType();
                if (type != null) {
                    if (ObjectType.TYPE_OBJECT.equals((Object)item.getType())) {
                        if (item instanceof ObjectLocalVariable) {
                            ObjectLocalVariable olv = (ObjectLocalVariable)item;
                            olv.setType(typeBounds, type);
                        }
                    } else if (item.getType().isGenericType()) {
                        if (item instanceof GenericLocalVariable) {
                            GenericLocalVariable glv = (GenericLocalVariable)item;
                            if (type instanceof GenericType) {
                                glv.setType((GenericType)type);
                            }
                        }
                    } else {
                        item.typeOnRight(typeBounds, type);
                    }
                }
            }
        }
        if (list instanceof MethodInvocationExpression && item.getType() instanceof ObjectType) {
            MethodInvocationExpression exp = (MethodInvocationExpression)list;
            ObjectType ot = (ObjectType)item.getType();
            if (ot.getTypeArguments() instanceof WildcardExtendsTypeArgument || ot.getTypeArguments() instanceof WildcardSuperTypeArgument) {
                exp.setNonWildcardTypeArguments(null);
            }
        }
        return new ClassFileForEachStatement(item, list, (BaseStatement)subStatements);
    }

    private static Statement makeLabels(int loopIndex, int continueOffset, int breakOffset, Statement loop, Statements jumps) {
        if (!jumps.isEmpty()) {
            Iterator iterator = jumps.iterator();
            String label = "label" + loopIndex;
            boolean createLabel = false;
            while (iterator.hasNext()) {
                ClassFileBreakContinueStatement statement = (ClassFileBreakContinueStatement)iterator.next();
                int offset = statement.getOffset();
                int targetOffset = statement.getTargetOffset();
                if (targetOffset == continueOffset) {
                    statement.setStatement((Statement)new ContinueStatement(label));
                    createLabel = true;
                    iterator.remove();
                    continue;
                }
                if (targetOffset == breakOffset) {
                    statement.setStatement((Statement)new BreakStatement(label));
                    createLabel = true;
                    iterator.remove();
                    continue;
                }
                if (continueOffset > offset || offset >= breakOffset) continue;
                if (continueOffset <= targetOffset && targetOffset < breakOffset) {
                    if (statement.isContinueLabel()) {
                        statement.setStatement((Statement)new ContinueStatement(label));
                        createLabel = true;
                    } else {
                        statement.setStatement((Statement)ContinueStatement.CONTINUE);
                    }
                    iterator.remove();
                    continue;
                }
                statement.setContinueLabel(true);
            }
            if (createLabel) {
                return new LabelStatement(label, loop);
            }
        }
        return loop;
    }

    private static ClassFileForStatement newClassFileForStatement(LocalVariableMaker localVariableMaker, int fromOffset, int toOffset, BaseExpression init, Expression condition, BaseExpression update, BaseStatement statements) {
        AbstractJavaSyntaxVisitor visitor;
        if (init != null) {
            visitor = new SearchFromOffsetVisitor();
            init.accept((ExpressionVisitor)visitor);
            int offset = ((SearchFromOffsetVisitor)visitor).getOffset();
            if (fromOffset > offset) {
                fromOffset = offset;
            }
        }
        visitor = new ChangeFrameOfLocalVariablesVisitor(localVariableMaker);
        if (condition != null) {
            condition.accept((ExpressionVisitor)visitor);
        }
        if (update != null) {
            update.accept((ExpressionVisitor)visitor);
        }
        return new ClassFileForStatement(fromOffset, toOffset, init, condition, update, statements);
    }
}

