/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.LocalVariableTypeTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.ParameterAnnotationEntry;
import org.apache.bcel.classfile.RuntimeInvisibleParameterAnnotations;
import org.apache.bcel.classfile.RuntimeVisibleParameterAnnotations;
import org.jd.core.v1.model.classfile.ClassFile;
import org.jd.core.v1.model.javasyntax.declaration.BaseFormalParameter;
import org.jd.core.v1.model.javasyntax.declaration.FormalParameters;
import org.jd.core.v1.model.javasyntax.reference.BaseAnnotationReference;
import org.jd.core.v1.model.javasyntax.statement.Statements;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.BaseTypeArgument;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeArgumentVisitor;
import org.jd.core.v1.model.javasyntax.type.WildcardTypeArgument;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorOrMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileFormalParameter;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.AbstractLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.Frame;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.LocalVariableSet;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.ObjectLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.PrimitiveLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.RootFrame;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.AnnotationConverter;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.CreateLocalVariableVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.CreateParameterVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.GenerateParameterSuffixNameVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.PopulateBlackListNamesVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.SearchInTypeArgumentVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.UpdateTypeVisitor;
import org.jd.core.v1.util.DefaultList;

public class LocalVariableMaker {
    private final LocalVariableSet localVariableSet = new LocalVariableSet();
    private final Set<String> names = new HashSet<String>();
    private final Set<String> blackListNames = new HashSet<String>();
    private Frame currentFrame = new RootFrame();
    private AbstractLocalVariable[] localVariableCache;
    private final TypeMaker typeMaker;
    private final Map<String, BaseType> typeBounds;
    private final FormalParameters formalParameters;
    private final PopulateBlackListNamesVisitor populateBlackListNamesVisitor = new PopulateBlackListNamesVisitor(this.blackListNames);
    private final SearchInTypeArgumentVisitor searchInTypeArgumentVisitor = new SearchInTypeArgumentVisitor();
    private final CreateParameterVisitor createParameterVisitor;
    private final CreateLocalVariableVisitor createLocalVariableVisitor;

    public LocalVariableMaker(TypeMaker typeMaker, ClassFileConstructorOrMethodDeclaration comd, boolean constructor) {
        ClassFile classFile = comd.getClassFile();
        Method method = comd.getMethod();
        BaseType parameterTypes = comd.getParameterTypes();
        this.typeMaker = typeMaker;
        this.typeBounds = comd.getTypeBounds();
        this.createParameterVisitor = new CreateParameterVisitor(typeMaker);
        this.createLocalVariableVisitor = new CreateLocalVariableVisitor(typeMaker);
        for (Field field : classFile.getFields()) {
            String descriptor = field.getSignature();
            if (descriptor.charAt(descriptor.length() - 1) != ';') continue;
            typeMaker.makeFromDescriptor(descriptor).accept((TypeArgumentVisitor)this.populateBlackListNamesVisitor);
        }
        typeMaker.makeFromInternalTypeName(classFile.getInternalTypeName()).accept((TypeArgumentVisitor)this.populateBlackListNamesVisitor);
        if (classFile.getSuperTypeName() != null) {
            typeMaker.makeFromInternalTypeName(classFile.getSuperTypeName()).accept((TypeArgumentVisitor)this.populateBlackListNamesVisitor);
        }
        for (Field field : classFile.getInterfaceTypeNames()) {
            typeMaker.makeFromInternalTypeName((String)field).accept((TypeArgumentVisitor)this.populateBlackListNamesVisitor);
        }
        if (parameterTypes != null) {
            if (parameterTypes.isList()) {
                for (Type type : parameterTypes) {
                    type.accept((TypeArgumentVisitor)this.populateBlackListNamesVisitor);
                }
            } else {
                ((Type)parameterTypes.getFirst()).accept((TypeArgumentVisitor)this.populateBlackListNamesVisitor);
            }
        }
        this.initLocalVariablesFromAttributes(method);
        int firstVariableIndex = 0;
        if ((method.getAccessFlags() & 8) == 0) {
            if (this.localVariableSet.root(0) == null) {
                this.localVariableSet.add(0, new ObjectLocalVariable(typeMaker, 0, 0, (Type)typeMaker.makeFromInternalTypeName(classFile.getInternalTypeName()), "this"));
            }
            firstVariableIndex = 1;
        }
        if (constructor) {
            if (classFile.isEnum()) {
                if (this.localVariableSet.root(1) == null) {
                    this.localVariableSet.add(1, new ObjectLocalVariable(typeMaker, 1, 0, (Type)ObjectType.TYPE_STRING, "this$enum$name"));
                }
                if (this.localVariableSet.root(2) == null) {
                    this.localVariableSet.add(2, new PrimitiveLocalVariable(2, 0, PrimitiveType.TYPE_INT, "this$enum$index"));
                }
            } else if (classFile.getOuterClassFile() != null && !classFile.isStatic() && this.localVariableSet.root(1) == null) {
                this.localVariableSet.add(1, new ObjectLocalVariable(typeMaker, 1, 0, (Type)typeMaker.makeFromInternalTypeName(classFile.getOuterClassFile().getInternalTypeName()), "this$0"));
            }
        }
        FormalParameters fp = null;
        if (parameterTypes != null) {
            int lastParameterIndex = parameterTypes.size() - 1;
            boolean bl = (method.getAccessFlags() & 0x80) != 0;
            this.initLocalVariablesFromParameterTypes(classFile, parameterTypes, bl, firstVariableIndex, lastParameterIndex);
            fp = new FormalParameters();
            RuntimeVisibleParameterAnnotations rvpa = Stream.of(method.getAttributes()).filter(RuntimeVisibleParameterAnnotations.class::isInstance).findAny().orElse(null);
            RuntimeInvisibleParameterAnnotations ripa = Stream.of(method.getAttributes()).filter(RuntimeInvisibleParameterAnnotations.class::isInstance).findAny().orElse(null);
            if (rvpa == null && ripa == null) {
                int parameterIndex = 0;
                int variableIndex = firstVariableIndex;
                while (parameterIndex <= lastParameterIndex) {
                    AbstractLocalVariable lv = this.localVariableSet.root(variableIndex);
                    if (lv != null) {
                        fp.add((Object)new ClassFileFormalParameter(lv, bl && parameterIndex == lastParameterIndex));
                        if (PrimitiveType.TYPE_LONG.equals((Object)lv.getType()) || PrimitiveType.TYPE_DOUBLE.equals((Object)lv.getType())) {
                            ++variableIndex;
                        }
                    }
                    ++parameterIndex;
                    ++variableIndex;
                }
            } else {
                ParameterAnnotationEntry[] visiblesArray = rvpa == null ? null : rvpa.getParameterAnnotationEntries();
                ParameterAnnotationEntry[] invisiblesArray = ripa == null ? null : ripa.getParameterAnnotationEntries();
                AnnotationConverter annotationConverter = new AnnotationConverter(typeMaker);
                int parameterIndex = 0;
                int variableIndex = firstVariableIndex;
                while (parameterIndex <= lastParameterIndex) {
                    AbstractLocalVariable lv = this.localVariableSet.root(variableIndex);
                    ParameterAnnotationEntry visibles = visiblesArray == null || visiblesArray.length <= parameterIndex ? null : visiblesArray[parameterIndex];
                    ParameterAnnotationEntry invisibles = invisiblesArray == null || invisiblesArray.length <= parameterIndex ? null : invisiblesArray[parameterIndex];
                    AnnotationEntry[] visibleEntries = visibles == null ? null : visibles.getAnnotationEntries();
                    AnnotationEntry[] invisibleEntries = invisibles == null ? null : invisibles.getAnnotationEntries();
                    BaseAnnotationReference annotationReferences = annotationConverter.convert(visibleEntries, invisibleEntries);
                    fp.add((Object)new ClassFileFormalParameter(annotationReferences, lv, bl && parameterIndex == lastParameterIndex));
                    if (PrimitiveType.TYPE_LONG.equals((Object)lv.getType()) || PrimitiveType.TYPE_DOUBLE.equals((Object)lv.getType())) {
                        ++variableIndex;
                    }
                    ++parameterIndex;
                    ++variableIndex;
                }
            }
        }
        this.formalParameters = fp;
        this.localVariableCache = this.localVariableSet.initialize(this.currentFrame);
    }

    protected void initLocalVariablesFromAttributes(Method method) {
        Code code = method.getCode();
        if (code != null) {
            LocalVariableTypeTable localVariableTypeTable;
            LocalVariableTable localVariableTable = code.getLocalVariableTable();
            if (localVariableTable != null) {
                boolean staticFlag = (method.getAccessFlags() & 8) != 0;
                for (LocalVariable localVariable : localVariableTable.getLocalVariableTable()) {
                    int dimension;
                    int index = localVariable.getIndex();
                    int startPc = !staticFlag && index == 0 ? 0 : localVariable.getStartPC();
                    String descriptor = localVariable.getSignature();
                    String name = localVariable.getName();
                    Object lv = descriptor.charAt(descriptor.length() - 1) == ';' ? new ObjectLocalVariable(this.typeMaker, index, startPc, (Type)this.typeMaker.makeFromDescriptor(descriptor), name) : ((dimension = TypeMaker.countDimension((String)descriptor)) == 0 ? new PrimitiveLocalVariable(index, startPc, PrimitiveType.getPrimitiveType((char)descriptor.charAt(0)), name) : new ObjectLocalVariable(this.typeMaker, index, startPc, this.typeMaker.makeFromSignature(descriptor.substring(dimension)).createType(dimension), name));
                    this.localVariableSet.add(index, (AbstractLocalVariable)lv);
                    this.names.add(name);
                }
            }
            if ((localVariableTypeTable = (LocalVariableTypeTable)Stream.of(code.getAttributes()).filter(LocalVariableTypeTable.class::isInstance).findAny().orElse(null)) != null) {
                UpdateTypeVisitor updateTypeVisitor = new UpdateTypeVisitor(this.localVariableSet);
                for (Object lv : localVariableTypeTable.getLocalVariableTypeTable()) {
                    updateTypeVisitor.setLocalVariableType((LocalVariable)lv);
                    this.typeMaker.makeFromSignature(lv.getSignature()).accept((TypeArgumentVisitor)updateTypeVisitor);
                }
            }
        }
    }

    protected void initLocalVariablesFromParameterTypes(ClassFile classFile, BaseType parameterTypes, boolean varargs, int firstVariableIndex, int lastParameterIndex) {
        HashMap<Type, Boolean> typeMap = new HashMap<Type, Boolean>();
        DefaultList t = parameterTypes.getList();
        for (int parameterIndex = 0; parameterIndex <= lastParameterIndex; ++parameterIndex) {
            Type type = (Type)t.get(parameterIndex);
            typeMap.put(type, typeMap.containsKey(type));
        }
        Object parameterNamePrefix = "param";
        if (classFile.getOuterClassFile() != null) {
            int innerTypeDepth = 1;
            for (ObjectType type = this.typeMaker.makeFromInternalTypeName(classFile.getOuterClassFile().getInternalTypeName()); type != null && type.isInnerObjectType(); type = type.getOuterType()) {
                ++innerTypeDepth;
            }
            parameterNamePrefix = (String)parameterNamePrefix + innerTypeDepth;
        }
        StringBuilder sb = new StringBuilder();
        GenerateParameterSuffixNameVisitor generateParameterSuffixNameVisitor = new GenerateParameterSuffixNameVisitor();
        int parameterIndex = 0;
        int variableIndex = firstVariableIndex;
        while (parameterIndex <= lastParameterIndex) {
            Type type = (Type)t.get(parameterIndex);
            AbstractLocalVariable lv = this.localVariableSet.root(variableIndex);
            if (lv == null) {
                sb.setLength(0);
                sb.append((String)parameterNamePrefix);
                if (parameterIndex == lastParameterIndex && varargs) {
                    sb.append("VarArgs");
                } else {
                    if (type.getDimension() > 0) {
                        sb.append("ArrayOf");
                    }
                    type.accept((TypeArgumentVisitor)generateParameterSuffixNameVisitor);
                    sb.append(generateParameterSuffixNameVisitor.getSuffix());
                }
                int length = sb.length();
                int counter = 1;
                if (Boolean.TRUE.equals(typeMap.get(type))) {
                    sb.append(counter);
                    ++counter;
                }
                String name = sb.toString();
                while (this.names.contains(name)) {
                    sb.setLength(length);
                    sb.append(counter);
                    ++counter;
                    name = sb.toString();
                }
                this.names.add(name);
                this.createParameterVisitor.init(variableIndex, name);
                type.accept((TypeArgumentVisitor)this.createParameterVisitor);
                AbstractLocalVariable alv = this.createParameterVisitor.getLocalVariable();
                alv.setDeclared(true);
                this.localVariableSet.add(variableIndex, alv);
            }
            if (PrimitiveType.TYPE_LONG.equals((Object)type) || PrimitiveType.TYPE_DOUBLE.equals((Object)type)) {
                ++variableIndex;
            }
            ++parameterIndex;
            ++variableIndex;
        }
    }

    public AbstractLocalVariable getLocalVariable(int index, int offset) {
        Frame frame;
        AbstractLocalVariable lv = this.localVariableCache[index];
        if (lv == null) {
            lv = this.currentFrame.getLocalVariable(index);
            if (lv == null) {
                lv = new ObjectLocalVariable(this.typeMaker, index, offset, (Type)ObjectType.TYPE_OBJECT, "SYNTHETIC_LOCAL_VARIABLE_" + index, true);
            }
        } else if (lv.getFrame() != this.currentFrame && (frame = LocalVariableMaker.searchCommonParentFrame(lv.getFrame(), this.currentFrame)) != null) {
            frame.mergeLocalVariable(this.typeBounds, this, lv);
            if (lv.getFrame() != frame) {
                lv.getFrame().removeLocalVariable(lv);
                frame.addLocalVariable(lv);
            }
        }
        lv.setFromToOffset(offset);
        return lv;
    }

    protected AbstractLocalVariable searchLocalVariable(int index, int offset) {
        AbstractLocalVariable lv = this.localVariableSet.get(index, offset);
        if (lv == null) {
            lv = this.currentFrame.getLocalVariable(index);
        } else {
            AbstractLocalVariable lv2 = this.currentFrame.getLocalVariable(index);
            if (lv2 != null && (lv.getName() == null ? lv2.getName() == null : lv.getName().equals(lv2.getName())) && lv.getType().equals(lv2.getType())) {
                lv = lv2;
            }
            this.localVariableSet.remove(index, offset);
        }
        return lv;
    }

    public boolean isCompatible(AbstractLocalVariable lv, Type valueType) {
        if (valueType == ObjectType.TYPE_UNDEFINED_OBJECT) {
            return true;
        }
        if (valueType.isObjectType() && lv.getType().getDimension() == valueType.getDimension()) {
            ObjectType valueObjectType = (ObjectType)valueType;
            if (lv.getType().isObjectType()) {
                ObjectType lvObjectType = (ObjectType)lv.getType();
                BaseTypeArgument lvTypeArguments = lvObjectType.getTypeArguments();
                BaseTypeArgument valueTypeArguments = valueObjectType.getTypeArguments();
                if (lvTypeArguments == null || valueTypeArguments == null || valueTypeArguments == WildcardTypeArgument.WILDCARD_TYPE_ARGUMENT) {
                    return this.typeMaker.isRawTypeAssignable(lvObjectType, valueObjectType);
                }
                this.searchInTypeArgumentVisitor.init();
                lvTypeArguments.accept((TypeArgumentVisitor)this.searchInTypeArgumentVisitor);
                if (!this.searchInTypeArgumentVisitor.containsGeneric()) {
                    this.searchInTypeArgumentVisitor.init();
                    valueTypeArguments.accept((TypeArgumentVisitor)this.searchInTypeArgumentVisitor);
                    if (this.searchInTypeArgumentVisitor.containsGeneric()) {
                        return this.typeMaker.isRawTypeAssignable(lvObjectType, valueObjectType);
                    }
                }
            } else if (lv.getType().isGenericType() && valueObjectType.getInternalName().equals(ObjectType.TYPE_OBJECT.getInternalName())) {
                return true;
            }
        }
        return false;
    }

    public AbstractLocalVariable getLocalVariableInAssignment(Map<String, BaseType> typeBounds, int index, int offset, Type valueType) {
        AbstractLocalVariable lv = this.searchLocalVariable(index, offset);
        if (lv != null && (lv.isAssignableFrom(typeBounds, valueType) || this.isCompatible(lv, valueType))) {
            lv.typeOnRight(typeBounds, valueType);
        } else if (lv == null || !lv.getType().isGenericType() || ObjectType.TYPE_OBJECT != valueType) {
            lv = this.createNewLocalVariable(index, offset, valueType);
        }
        lv.setFromToOffset(offset);
        this.store(lv);
        return lv;
    }

    public AbstractLocalVariable getLocalVariableInNullAssignment(int index, int offset, Type valueType) {
        AbstractLocalVariable lv = this.searchLocalVariable(index, offset);
        if (lv == null || lv.getType().getDimension() == 0 && lv.getType().isPrimitiveType()) {
            lv = this.createNewLocalVariable(index, offset, valueType);
        }
        lv.setFromToOffset(offset);
        this.store(lv);
        return lv;
    }

    public AbstractLocalVariable getLocalVariableInAssignment(Map<String, BaseType> typeBounds, int index, int offset, AbstractLocalVariable valueLocalVariable) {
        AbstractLocalVariable lv = this.searchLocalVariable(index, offset);
        if (!(lv != null && (lv.isAssignableFrom(typeBounds, valueLocalVariable) || this.isCompatible(lv, valueLocalVariable.getType()) || lv.getType().isGenericType() && ObjectType.TYPE_OBJECT == valueLocalVariable.getType()))) {
            lv = this.createNewLocalVariable(index, offset, valueLocalVariable);
        }
        lv.variableOnRight(typeBounds, valueLocalVariable);
        lv.setFromToOffset(offset);
        this.store(lv);
        return lv;
    }

    protected AbstractLocalVariable createNewLocalVariable(int index, int offset, Type valueType) {
        this.createLocalVariableVisitor.init(index, offset);
        valueType.accept((TypeArgumentVisitor)this.createLocalVariableVisitor);
        return this.createLocalVariableVisitor.getLocalVariable();
    }

    protected AbstractLocalVariable createNewLocalVariable(int index, int offset, AbstractLocalVariable valueLocalVariable) {
        this.createLocalVariableVisitor.init(index, offset);
        valueLocalVariable.accept(this.createLocalVariableVisitor);
        return this.createLocalVariableVisitor.getLocalVariable();
    }

    public AbstractLocalVariable getExceptionLocalVariable(int index, int offset, ObjectType type) {
        AbstractLocalVariable lv;
        if (index == -1) {
            lv = new ObjectLocalVariable(this.typeMaker, index, offset, (Type)type, null, true);
            this.currentFrame.setExceptionLocalVariable(lv);
        } else {
            lv = this.localVariableSet.remove(index, offset);
            if (lv == null) {
                lv = new ObjectLocalVariable(this.typeMaker, index, offset, (Type)type, "e", true);
            } else {
                lv.setDeclared(true);
            }
            this.currentFrame.addLocalVariable(lv);
        }
        return lv;
    }

    public void removeLocalVariable(AbstractLocalVariable lv) {
        if (lv != null && lv.getIndex() < this.localVariableCache.length) {
            this.localVariableCache[lv.getIndex()] = null;
            this.currentFrame.removeLocalVariable(lv);
        }
    }

    protected void store(AbstractLocalVariable lv) {
        int index = lv.getIndex();
        if (index >= this.localVariableCache.length) {
            AbstractLocalVariable[] tmp = this.localVariableCache;
            this.localVariableCache = new AbstractLocalVariable[index * 2];
            System.arraycopy(tmp, 0, this.localVariableCache, 0, tmp.length);
        }
        this.localVariableCache[index] = lv;
        if (lv.getFrame() == null) {
            this.currentFrame.addLocalVariable(lv);
        }
    }

    public boolean containsName(String name) {
        return this.names.contains(name);
    }

    public void make(boolean containsLineNumber, TypeMaker typeMaker) {
        this.currentFrame.updateLocalVariableInForStatements(typeMaker);
        this.currentFrame.createNames(this.blackListNames);
        this.currentFrame.createDeclarations(containsLineNumber);
    }

    public BaseFormalParameter getFormalParameters() {
        return this.formalParameters;
    }

    public void pushFrame(Statements statements) {
        Frame parent = this.currentFrame;
        this.currentFrame = new Frame(this.currentFrame, statements);
        parent.addChild(this.currentFrame);
    }

    public void popFrame() {
        this.currentFrame = this.currentFrame.getParent();
    }

    protected static Frame searchCommonParentFrame(Frame frame1, Frame frame2) {
        if (frame1 == frame2 || frame2.getParent() == frame1) {
            return frame1;
        }
        if (frame1.getParent() == frame2) {
            return frame2;
        }
        HashSet<Frame> set = new HashSet<Frame>();
        while (frame1 != null) {
            set.add(frame1);
            frame1 = frame1.getParent();
        }
        while (frame2 != null) {
            if (set.contains(frame2)) {
                return frame2;
            }
            frame2 = frame2.getParent();
        }
        return null;
    }

    public void changeFrame(AbstractLocalVariable localVariable) {
        Frame frame = LocalVariableMaker.searchCommonParentFrame(localVariable.getFrame(), this.currentFrame);
        if (frame != null && localVariable.getFrame() != frame) {
            localVariable.getFrame().removeLocalVariable(localVariable);
            frame.addLocalVariable(localVariable);
        }
    }
}

