/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;
import org.apache.bcel.classfile.Method;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg.BasicBlock;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg.ControlFlowGraph;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg.Loop;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ByteCodeUtil;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ControlFlowGraphGotoReducer;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ControlFlowGraphLoopReducer;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ControlFlowGraphMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ControlFlowGraphPreReducer;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.WatchDog;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.cfg.CmpDepthCFGReducer;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.cfg.MinDepthCFGReducer;
import org.jd.core.v1.util.DefaultList;

public abstract class ControlFlowGraphReducer {
    private ControlFlowGraph controlFlowGraph;

    public boolean reduce(Method method) {
        this.reduceGotoLoop(method, false);
        if (this.controlFlowGraph.contains(0x40000000)) {
            this.reduceGotoLoop(method, true);
        }
        if (this.doPreReduce()) {
            ControlFlowGraphPreReducer.reduce(this.controlFlowGraph);
        }
        BasicBlock start = this.controlFlowGraph.getStart();
        BitSet jsrTargets = new BitSet();
        BitSet visited = new BitSet(this.controlFlowGraph.getBasicBlocks().size());
        return this.reduce(visited, start, jsrTargets);
    }

    private void reduceGotoLoop(Method method, boolean splitReturns) {
        this.controlFlowGraph = new ControlFlowGraphMaker().make(method);
        ControlFlowGraphGotoReducer.reduce(this.controlFlowGraph, splitReturns);
        ControlFlowGraphLoopReducer.reduce(this.controlFlowGraph);
    }

    public boolean reduce(BitSet visited, BasicBlock basicBlock, BitSet jsrTargets) {
        if (!basicBlock.matchType(1266696506) && !visited.get(basicBlock.getIndex())) {
            visited.set(basicBlock.getIndex());
            return switch (basicBlock.getType()) {
                case 1, 4, 128, 1024, 2048, 4096, 65536, 131072, 0x10000000 -> this.reduce(visited, basicBlock.getNext(), jsrTargets);
                case 32768, 262144, 524288, 0x100000, 0x200000 -> this.reduceConditionalBranch(visited, basicBlock, jsrTargets);
                case 64 -> this.reduceSwitchDeclaration(visited, basicBlock, jsrTargets);
                case 512 -> this.reduceTryDeclaration(visited, basicBlock, jsrTargets);
                case 8192 -> this.reduceJsr(visited, basicBlock, jsrTargets);
                case 0x400000 -> this.reduceLoop(visited, basicBlock, jsrTargets);
                default -> true;
            };
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reduceConditionalBranch(BitSet visited, BasicBlock basicBlock, BitSet jsrTargets) {
        while (this.aggregateConditionalBranches(basicBlock)) {
        }
        assert (basicBlock.matchType(0x3C0000));
        boolean reduced = true;
        reduced &= this.reduce(visited, basicBlock.getNext(), jsrTargets);
        reduced &= this.reduce(visited, basicBlock.getBranch(), jsrTargets);
        try {
            boolean bl = reduced && this.reduceConditionalBranch(basicBlock);
            return bl;
        }
        finally {
            ControlFlowGraphReducer.mergeTernaryOperators(basicBlock, BasicBlock::getCondition, BasicBlock::setCondition);
        }
    }

    private static void mergeTernaryOperators(BasicBlock basicBlock, UnaryOperator<BasicBlock> getter, BiConsumer<BasicBlock, BasicBlock> setter) {
        if (basicBlock == null) {
            return;
        }
        BasicBlock linkedBlock = (BasicBlock)getter.apply(basicBlock);
        if (linkedBlock != null && linkedBlock.getSub1() != null && linkedBlock.getSub2() != null && linkedBlock.getType() == 0x200000 && linkedBlock.getSub1().getType() == 0x200000 && linkedBlock.getSub2().getIndex() == linkedBlock.getSub1().getSub2().getIndex()) {
            BasicBlock subCondition1 = linkedBlock.getCondition();
            BasicBlock subCondition2 = linkedBlock.getSub1().getCondition();
            ControlFlowGraph cfg = basicBlock.getControlFlowGraph();
            BasicBlock mergedCondition = cfg.newBasicBlock(0x100000, subCondition1.getFromOffset(), subCondition2.getToOffset());
            mergedCondition.setSub1(subCondition1);
            mergedCondition.setSub2(subCondition2);
            BasicBlock mergedTernaryOp = cfg.newBasicBlock(0x200000, linkedBlock.getFromOffset(), linkedBlock.getToOffset());
            setter.accept(basicBlock, mergedTernaryOp);
            mergedTernaryOp.setSub1(linkedBlock.getSub1().getSub1());
            mergedTernaryOp.setSub2(linkedBlock.getSub1().getSub2());
            mergedTernaryOp.getSub1().inverseCondition();
            mergedTernaryOp.setCondition(mergedCondition);
        }
        ControlFlowGraphReducer.mergeTernaryOperators(linkedBlock, BasicBlock::getSub1, BasicBlock::setSub1);
        ControlFlowGraphReducer.mergeTernaryOperators(linkedBlock, BasicBlock::getSub2, BasicBlock::setSub2);
    }

    private boolean reduceConditionalBranch(BasicBlock basicBlock) {
        BasicBlock nextNext;
        BasicBlock nextLast;
        BasicBlock next = basicBlock.getNext();
        BasicBlock branch = basicBlock.getBranch();
        WatchDog watchdog = new WatchDog();
        if (next == branch) {
            ControlFlowGraphReducer.createIf(basicBlock, BasicBlock.END, BasicBlock.END, branch);
            return true;
        }
        if (next.matchType(1266696506) && next.getPredecessors().size() <= 1) {
            ControlFlowGraphReducer.createIf(basicBlock, next, next, branch);
            return true;
        }
        if (next.matchType(876822205) && next.getPredecessors().size() == 1) {
            nextLast = next;
            nextNext = next.getNext();
            ControlFlowGraph cfg = next.getControlFlowGraph();
            int lineNumber = cfg.getLineNumber(basicBlock.getFromOffset());
            int maxOffset = branch.getFromOffset();
            if (maxOffset == 0 || next.getFromOffset() > branch.getFromOffset()) {
                maxOffset = Integer.MAX_VALUE;
            }
            while (nextLast != nextNext && nextNext.matchType(876822149) && nextNext.getPredecessors().size() == 1 && cfg.getLineNumber(nextNext.getFromOffset()) >= lineNumber && nextNext.getFromOffset() < maxOffset) {
                watchdog.check(nextNext, nextNext.getNext());
                nextLast = nextNext;
                nextNext = nextNext.getNext();
            }
            if (nextNext == branch) {
                ControlFlowGraphReducer.createIf(basicBlock, next, nextLast, branch);
                return true;
            }
            if (nextNext.matchType(1266696506) && nextNext.getFromOffset() < maxOffset) {
                BasicBlock branchNext = branch.getNext();
                if (nextNext.matchType(256) && branchNext.matchType(256) && next.matchType(4) && branch.matchType(4)) {
                    ControlFlowGraphReducer.createIfElse(131072, basicBlock, next, nextLast, branch, branch, nextNext);
                } else {
                    ControlFlowGraphReducer.createIf(basicBlock, next, nextNext, branch);
                }
                return true;
            }
            if (branch.matchType(1266696506)) {
                if (nextNext.getFromOffset() < maxOffset && nextNext.getPredecessors().size() == 1) {
                    ControlFlowGraphReducer.createIf(basicBlock, next, nextNext, branch);
                } else {
                    ControlFlowGraphReducer.createIfElse(131072, basicBlock, next, nextLast, branch, branch, nextNext);
                }
                return true;
            }
            if (branch.matchType(876822149) && branch.getPredecessors().size() == 1) {
                BasicBlock branchNext;
                BasicBlock branchLast = branch;
                watchdog.clear();
                for (branchNext = branch.getNext(); branchLast != branchNext && branchNext.matchType(876822149) && branchNext.getPredecessors().size() == 1 && cfg.getLineNumber(branchNext.getFromOffset()) >= lineNumber; branchNext = branchNext.getNext()) {
                    watchdog.check(branchNext, branchNext.getNext());
                    branchLast = branchNext;
                }
                if (nextNext == branchNext) {
                    if (nextLast.matchType(0x30000000)) {
                        ControlFlowGraphReducer.createIfElse(0x20000000, basicBlock, next, nextLast, branch, branchLast, nextNext);
                    } else {
                        ControlFlowGraphReducer.createIfElse(131072, basicBlock, next, nextLast, branch, branchLast, nextNext);
                    }
                    return true;
                }
                if (this.needToCreateIf(branch, nextNext, maxOffset)) {
                    ControlFlowGraphReducer.createIf(basicBlock, next, nextNext, branch);
                    return true;
                }
                if (this.needToCreateIfElse(branch, nextNext, branchNext)) {
                    ControlFlowGraphReducer.createIfElse(131072, basicBlock, next, nextLast, branch, branchNext, nextNext);
                    return true;
                }
            }
        }
        if (branch.matchType(876822205) && branch.getPredecessors().size() == 1) {
            BasicBlock branchNext;
            BasicBlock branchLast = branch;
            watchdog.clear();
            for (branchNext = branch.getNext(); branchLast != branchNext && branchNext.matchType(876822149) && branchNext.getPredecessors().size() == 1; branchNext = branchNext.getNext()) {
                watchdog.check(branchNext, branchNext.getNext());
                branchLast = branchNext;
            }
            if (branchNext == next) {
                basicBlock.inverseCondition();
                ControlFlowGraphReducer.createIf(basicBlock, branch, branchLast, next);
                return true;
            }
            if (branchNext.matchType(1266696506) && branchNext.getPredecessors().size() <= 1) {
                basicBlock.inverseCondition();
                ControlFlowGraphReducer.createIf(basicBlock, branch, branchNext, next);
                return true;
            }
        }
        if (next.matchType(56)) {
            next = ControlFlowGraphReducer.clone(basicBlock, next);
            ControlFlowGraphReducer.createIf(basicBlock, next, next, branch);
            return true;
        }
        if (next.matchType(876822149)) {
            nextLast = next;
            watchdog.clear();
            for (nextNext = next.getNext(); nextLast != nextNext && nextNext.matchType(876822149) && nextNext.getPredecessors().size() == 1; nextNext = nextNext.getNext()) {
                watchdog.check(nextNext, nextNext.getNext());
                nextLast = nextNext;
            }
            if (nextNext.matchType(56)) {
                ControlFlowGraphReducer.createIf(basicBlock, next, nextNext, branch);
                return true;
            }
        }
        return false;
    }

    private static void createIf(BasicBlock basicBlock, BasicBlock sub, BasicBlock last, BasicBlock next) {
        BasicBlock condition = basicBlock.getControlFlowGraph().newBasicBlock(basicBlock);
        condition.endCondition();
        int toOffset = last.getToOffset();
        if (toOffset == 0) {
            toOffset = basicBlock.getToOffset();
        }
        last.setNext(BasicBlock.END);
        next.getPredecessors().remove(last);
        basicBlock.setType(65536);
        basicBlock.setToOffset(toOffset);
        basicBlock.setCondition(condition);
        basicBlock.setSub1(sub);
        basicBlock.setSub2(null);
        basicBlock.setNext(next);
    }

    private static void createIfElse(int type, BasicBlock basicBlock, BasicBlock sub1, BasicBlock last1, BasicBlock sub2, BasicBlock last2, BasicBlock next) {
        Loop loop;
        BasicBlock condition = basicBlock.getControlFlowGraph().newBasicBlock(basicBlock);
        condition.endCondition();
        int toOffset = last2.getToOffset();
        if (toOffset == 0 && (toOffset = last1.getToOffset()) == 0) {
            toOffset = basicBlock.getToOffset();
        }
        if (!basicBlock.isLoopExitCondition(loop = basicBlock.getEnclosingLoop())) {
            last1.setNext(BasicBlock.END);
            next.getPredecessors().remove(last1);
            last2.setNext(BasicBlock.END);
            next.getPredecessors().remove(last2);
        }
        basicBlock.setType(type);
        basicBlock.setToOffset(toOffset);
        basicBlock.setCondition(condition);
        basicBlock.setSub1(sub1);
        basicBlock.setSub2(sub2);
        BasicBlock tryBlock = next.getSinglePredecessor(512);
        if (tryBlock != null) {
            tryBlock.getPredecessors().add(basicBlock);
            basicBlock.setNext(tryBlock);
        } else if (next.isOutsideLoop(loop) || basicBlock.isLoopExitCondition(loop)) {
            basicBlock.setNext(BasicBlock.END);
        } else {
            next.getPredecessors().add(basicBlock);
            basicBlock.setNext(next);
        }
    }

    public abstract String getLabel();

    public abstract boolean doPreReduce();

    protected abstract boolean needToUpdateConditionTernaryOperator(BasicBlock var1, BasicBlock var2);

    protected abstract boolean needToUpdateCondition(BasicBlock var1, BasicBlock var2);

    protected abstract boolean needToCreateIf(BasicBlock var1, BasicBlock var2, int var3);

    protected abstract boolean needToCreateIfElse(BasicBlock var1, BasicBlock var2, BasicBlock var3);

    private boolean aggregateConditionalBranches(BasicBlock basicBlock) {
        int lineNumber2;
        BasicBlock nextNext;
        boolean change = false;
        BasicBlock next = basicBlock.getNext();
        BasicBlock branch = basicBlock.getBranch();
        if (next.getType() == 0x10000000 && next.getPredecessors().size() == 1 && (nextNext = next.getNext()).matchType(294912)) {
            if (branch.matchType(0x10000004) && nextNext == branch.getNext() && branch.getPredecessors().size() == 1 && nextNext.getPredecessors().size() == 2) {
                if (this.needToUpdateConditionTernaryOperator(basicBlock, nextNext)) {
                    ControlFlowGraphReducer.updateConditionTernaryOperator(basicBlock, nextNext);
                    return true;
                }
                if (this.needToUpdateCondition(basicBlock, nextNext)) {
                    ControlFlowGraphReducer.updateCondition(basicBlock, nextNext, nextNext.getNext().getNext());
                    return true;
                }
            }
            if (nextNext.getNext() == branch && ControlFlowGraphReducer.checkJdk118TernaryOperatorPattern(next, nextNext, 153) || nextNext.getBranch() == branch && ControlFlowGraphReducer.checkJdk118TernaryOperatorPattern(next, nextNext, 154)) {
                ControlFlowGraphReducer.convertConditionalBranchToGotoInTernaryOperator(basicBlock, next, nextNext);
                return true;
            }
            if (nextNext.getPredecessors().size() == 1) {
                ControlFlowGraphReducer.convertGotoInTernaryOperatorToCondition(next, nextNext);
                return true;
            }
        }
        if (next.matchType(3964928)) {
            int lineNumber1 = basicBlock.getLastLineNumber();
            lineNumber2 = next.getFirstLineNumber();
            if (lineNumber2 - lineNumber1 <= 1) {
                change = this.aggregateConditionalBranches(next);
                if (next.matchType(3964928) && next.getPredecessors().size() == 1) {
                    if (next.getNext() == branch) {
                        ControlFlowGraphReducer.updateConditionalBranches(basicBlock, ControlFlowGraphReducer.createLeftCondition(basicBlock), 524288, next);
                        return true;
                    }
                    if (next.getBranch() == branch) {
                        ControlFlowGraphReducer.updateConditionalBranches(basicBlock, ControlFlowGraphReducer.createLeftInverseCondition(basicBlock), 0x100000, next);
                        return true;
                    }
                    if (branch.matchType(3964928)) {
                        change = this.aggregateConditionalBranches(branch);
                        if (branch.matchType(3964928)) {
                            if (next.getNext() == branch.getNext() && next.getBranch() == branch.getBranch()) {
                                ControlFlowGraphReducer.updateConditionTernaryOperator2(basicBlock);
                                return true;
                            }
                            if (next.getBranch() == branch.getNext() && next.getNext() == branch.getBranch()) {
                                ControlFlowGraphReducer.updateConditionTernaryOperator2(basicBlock);
                                branch.inverseCondition();
                                return true;
                            }
                        }
                    }
                }
            }
        }
        if (branch.matchType(3964928)) {
            int lineNumber1 = basicBlock.getLastLineNumber();
            lineNumber2 = branch.getFirstLineNumber();
            if (lineNumber2 - lineNumber1 <= 1) {
                change = this.aggregateConditionalBranches(branch);
                if (branch.matchType(3964928) && branch.getPredecessors().size() == 1) {
                    if (branch.getBranch() == next) {
                        ControlFlowGraphReducer.updateConditionalBranches(basicBlock, ControlFlowGraphReducer.createLeftCondition(basicBlock), 0x100000, branch);
                        return true;
                    }
                    if (branch.getNext() == next) {
                        ControlFlowGraphReducer.updateConditionalBranches(basicBlock, ControlFlowGraphReducer.createLeftInverseCondition(basicBlock), 524288, branch);
                        return true;
                    }
                }
            }
        }
        if (basicBlock.getType() == 32768) {
            basicBlock.setType(262144);
            return true;
        }
        return change;
    }

    private static BasicBlock createLeftCondition(BasicBlock basicBlock) {
        if (basicBlock.getType() == 32768) {
            return basicBlock.getControlFlowGraph().newBasicBlock(262144, basicBlock.getFromOffset(), basicBlock.getToOffset(), false);
        }
        BasicBlock left = basicBlock.getControlFlowGraph().newBasicBlock(basicBlock);
        left.inverseCondition();
        return left;
    }

    private static BasicBlock createLeftInverseCondition(BasicBlock basicBlock) {
        if (basicBlock.getType() == 32768) {
            return basicBlock.getControlFlowGraph().newBasicBlock(262144, basicBlock.getFromOffset(), basicBlock.getToOffset());
        }
        return basicBlock.getControlFlowGraph().newBasicBlock(basicBlock);
    }

    private static void updateConditionalBranches(BasicBlock basicBlock, BasicBlock leftBasicBlock, int operator, BasicBlock subBasicBlock) {
        basicBlock.setType(operator);
        basicBlock.setToOffset(subBasicBlock.getToOffset());
        basicBlock.setNext(subBasicBlock.getNext());
        basicBlock.setBranch(subBasicBlock.getBranch());
        basicBlock.setCondition(BasicBlock.END);
        basicBlock.setSub1(leftBasicBlock);
        basicBlock.setSub2(subBasicBlock);
        subBasicBlock.getNext().replace(subBasicBlock, basicBlock);
        subBasicBlock.getBranch().replace(subBasicBlock, basicBlock);
    }

    private static void updateConditionTernaryOperator(BasicBlock basicBlock, BasicBlock nextNext) {
        int fromOffset = nextNext.getFromOffset();
        int toOffset = nextNext.getToOffset();
        BasicBlock next = nextNext.getNext();
        BasicBlock branch = nextNext.getBranch();
        if (basicBlock.getType() == 32768) {
            basicBlock.setType(262144);
        }
        if (nextNext.getType() == 262144 && !nextNext.mustInverseCondition()) {
            basicBlock.inverseCondition();
        }
        BasicBlock condition = nextNext;
        condition.setType(basicBlock.getType());
        condition.setFromOffset(basicBlock.getFromOffset());
        condition.setToOffset(basicBlock.getToOffset());
        condition.endCondition();
        condition.setCondition(basicBlock.getCondition());
        condition.setSub1(basicBlock.getSub1());
        condition.setSub2(basicBlock.getSub2());
        condition.getPredecessors().clear();
        basicBlock.setType(0x200000);
        basicBlock.setFromOffset(fromOffset);
        basicBlock.setToOffset(toOffset);
        basicBlock.setCondition(condition);
        basicBlock.setSub1(basicBlock.getNext());
        basicBlock.setSub2(basicBlock.getBranch());
        basicBlock.setNext(next);
        basicBlock.setBranch(branch);
        basicBlock.getSub1().setNext(BasicBlock.END);
        basicBlock.getSub2().setNext(BasicBlock.END);
        next.replace(nextNext, basicBlock);
        branch.replace(nextNext, basicBlock);
        basicBlock.getSub1().getPredecessors().clear();
        basicBlock.getSub2().getPredecessors().clear();
    }

    private static void updateCondition(BasicBlock basicBlock, BasicBlock nextNext, BasicBlock nextNextNextNext) {
        int fromOffset = nextNextNextNext.getFromOffset();
        int toOffset = nextNextNextNext.getToOffset();
        BasicBlock next = nextNextNextNext.getNext();
        BasicBlock branch = nextNextNextNext.getBranch();
        BasicBlock condition = basicBlock.getControlFlowGraph().newBasicBlock(basicBlock);
        condition.setType(262144);
        basicBlock.getNext().setNext(BasicBlock.END);
        basicBlock.getNext().getPredecessors().clear();
        basicBlock.getBranch().setNext(BasicBlock.END);
        basicBlock.getBranch().getPredecessors().clear();
        nextNextNextNext.setType(0x200000);
        nextNextNextNext.setFromOffset(condition.getToOffset());
        nextNextNextNext.setToOffset(condition.getToOffset());
        nextNextNextNext.setCondition(condition);
        nextNextNextNext.setSub1(basicBlock.getNext());
        nextNextNextNext.setSub2(basicBlock.getBranch());
        nextNextNextNext.endCondition();
        condition.endCondition();
        condition = nextNext.getControlFlowGraph().newBasicBlock(nextNext);
        condition.setType(262144);
        nextNext.getNext().setNext(BasicBlock.END);
        nextNext.getNext().getPredecessors().clear();
        nextNext.getBranch().setNext(BasicBlock.END);
        nextNext.getBranch().getPredecessors().clear();
        nextNext.setType(0x200000);
        nextNext.setFromOffset(condition.getToOffset());
        nextNext.setToOffset(condition.getToOffset());
        nextNext.setCondition(condition);
        nextNext.setSub1(nextNext.getNext());
        nextNext.setSub2(nextNext.getBranch());
        nextNext.endCondition();
        condition.endCondition();
        basicBlock.setType(262144);
        basicBlock.setFromOffset(fromOffset);
        basicBlock.setToOffset(toOffset);
        basicBlock.setSub1(nextNextNextNext);
        basicBlock.setSub2(nextNext);
        basicBlock.setNext(next);
        basicBlock.setBranch(branch);
        next.replace(nextNextNextNext, basicBlock);
        branch.replace(nextNextNextNext, basicBlock);
    }

    private static void updateConditionTernaryOperator2(BasicBlock basicBlock) {
        BasicBlock next = basicBlock.getNext();
        BasicBlock branch = basicBlock.getBranch();
        ControlFlowGraph cfg = basicBlock.getControlFlowGraph();
        BasicBlock condition = cfg.newBasicBlock(262144, basicBlock.getFromOffset(), basicBlock.getToOffset());
        condition.endCondition();
        basicBlock.setType(0x200000);
        basicBlock.setToOffset(basicBlock.getFromOffset());
        basicBlock.setCondition(condition);
        basicBlock.setSub1(next);
        basicBlock.setSub2(branch);
        basicBlock.setNext(next.getNext());
        basicBlock.setBranch(next.getBranch());
        next.getNext().replace(next, basicBlock);
        next.getBranch().replace(next, basicBlock);
        branch.getNext().replace(branch, basicBlock);
        branch.getBranch().replace(branch, basicBlock);
        next.getPredecessors().clear();
        branch.getPredecessors().clear();
    }

    private static void convertGotoInTernaryOperatorToCondition(BasicBlock basicBlock, BasicBlock next) {
        basicBlock.setType(262144);
        basicBlock.setNext(next.getNext());
        basicBlock.setBranch(next.getBranch());
        next.getNext().replace(next, basicBlock);
        next.getBranch().replace(next, basicBlock);
        next.setType(0);
    }

    private static void convertConditionalBranchToGotoInTernaryOperator(BasicBlock basicBlock, BasicBlock next, BasicBlock nextNext) {
        basicBlock.setType(0x10000000);
        basicBlock.setNext(nextNext);
        basicBlock.getBranch().getPredecessors().remove(basicBlock);
        basicBlock.setBranch(BasicBlock.END);
        basicBlock.setInverseCondition(false);
        nextNext.replace(next, basicBlock);
        next.setType(0);
    }

    private static boolean checkJdk118TernaryOperatorPattern(BasicBlock next, BasicBlock nextNext, int ifByteCode) {
        if (nextNext.getToOffset() - nextNext.getFromOffset() == 3) {
            byte[] code = next.getControlFlowGraph().getMethod().getCode().getCode();
            int nextFromOffset = next.getFromOffset();
            int nextNextFromOffset = nextNext.getFromOffset();
            return code[nextFromOffset] == 3 && ((code[nextFromOffset + 1] & 0xFF) == 167 || (code[nextFromOffset + 1] & 0xFF) == 200) && (code[nextNextFromOffset] & 0xFF) == ifByteCode && nextNextFromOffset + 3 == nextNext.getToOffset();
        }
        return false;
    }

    private boolean reduceSwitchDeclaration(BitSet visited, BasicBlock basicBlock, BitSet jsrTargets) {
        BasicBlock.SwitchCase defaultSC = null;
        BasicBlock.SwitchCase lastSC = null;
        int maxOffset = -1;
        for (BasicBlock.SwitchCase switchCase : basicBlock.getSwitchCases()) {
            if (maxOffset < switchCase.getOffset()) {
                maxOffset = switchCase.getOffset();
            }
            if (switchCase.isDefaultCase()) {
                defaultSC = switchCase;
                continue;
            }
            lastSC = switchCase;
        }
        if (lastSC == null) {
            lastSC = defaultSC;
        }
        BasicBlock lastSwitchCaseBasicBlock = null;
        BitSet v = new BitSet();
        HashSet<BasicBlock> ends = new HashSet<BasicBlock>();
        for (Object switchCase : basicBlock.getSwitchCases()) {
            BasicBlock bb = ((BasicBlock.SwitchCase)switchCase).getBasicBlock();
            if (((BasicBlock.SwitchCase)switchCase).getOffset() == maxOffset) {
                lastSwitchCaseBasicBlock = bb;
                continue;
            }
            ControlFlowGraphReducer.visit(v, bb, maxOffset, ends);
        }
        BasicBlock end = BasicBlock.END;
        for (BasicBlock bb : ends) {
            if (end != BasicBlock.END && end.getFromOffset() >= bb.getFromOffset()) continue;
            end = bb;
        }
        if (end == BasicBlock.END) {
            end = lastSwitchCaseBasicBlock;
        } else {
            ControlFlowGraphReducer.visit(v, lastSwitchCaseBasicBlock, end.getFromOffset(), ends);
        }
        Set<Object> endPredecessors = end == null ? new HashSet() : end.getPredecessors();
        Iterator<Object> endPredecessorIterator = endPredecessors.iterator();
        while (endPredecessorIterator.hasNext()) {
            BasicBlock endPredecessor = (BasicBlock)endPredecessorIterator.next();
            if (!v.get(endPredecessor.getIndex())) continue;
            endPredecessor.replace(end, BasicBlock.SWITCH_BREAK);
            endPredecessorIterator.remove();
        }
        if (defaultSC != null && defaultSC.getBasicBlock() == end) {
            Iterator iterator = basicBlock.getSwitchCases().iterator();
            while (iterator.hasNext()) {
                if (((BasicBlock.SwitchCase)iterator.next()).getBasicBlock() != end) continue;
                iterator.remove();
            }
        } else {
            for (Object switchCase : basicBlock.getSwitchCases()) {
                if (((BasicBlock.SwitchCase)switchCase).getBasicBlock() != end) continue;
                ((BasicBlock.SwitchCase)switchCase).setBasicBlock(BasicBlock.SWITCH_BREAK);
            }
        }
        boolean reduced = true;
        for (BasicBlock.SwitchCase switchCase : basicBlock.getSwitchCases()) {
            reduced &= this.reduce(visited, switchCase.getBasicBlock(), jsrTargets);
        }
        for (BasicBlock.SwitchCase switchCase : basicBlock.getSwitchCases()) {
            BasicBlock bb = switchCase.getBasicBlock();
            if (bb == end) {
                throw new IllegalStateException("bb == end");
            }
            Set<BasicBlock> predecessors = bb.getPredecessors();
            if (predecessors.size() <= 1) continue;
            Iterator<BasicBlock> predecessorIterator = predecessors.iterator();
            while (predecessorIterator.hasNext()) {
                BasicBlock predecessor = predecessorIterator.next();
                if (predecessor == basicBlock) continue;
                predecessor.replace(bb, BasicBlock.END);
                predecessorIterator.remove();
            }
        }
        basicBlock.setType(128);
        basicBlock.setNext(end);
        endPredecessors.add(basicBlock);
        return reduced &= this.reduce(visited, basicBlock.getNext(), jsrTargets);
    }

    protected boolean reduceTryDeclaration(BitSet visited, BasicBlock basicBlock, BitSet jsrTargets) {
        Set<BasicBlock> predecessors;
        BasicBlock bb;
        boolean reduced = true;
        BasicBlock finallyBB = null;
        for (BasicBlock.ExceptionHandler exceptionHandler : basicBlock.getExceptionHandlers()) {
            if (exceptionHandler.getInternalThrowableName() != null) continue;
            reduced = this.reduce(visited, exceptionHandler.getBasicBlock(), jsrTargets);
            finallyBB = exceptionHandler.getBasicBlock();
            break;
        }
        BasicBlock jsrTarget = ControlFlowGraphReducer.searchJsrTarget(basicBlock, jsrTargets);
        reduced &= this.reduce(visited, basicBlock.getNext(), jsrTargets);
        BasicBlock tryBB = basicBlock.getNext();
        if (tryBB.matchType(1140900419)) {
            return false;
        }
        int maxOffset = basicBlock.getFromOffset();
        boolean tryWithResourcesFlag = true;
        BasicBlock tryWithResourcesBB = null;
        block1: for (BasicBlock.ExceptionHandler exceptionHandler : basicBlock.getExceptionHandlers()) {
            if (exceptionHandler.getInternalThrowableName() != null) {
                reduced &= this.reduce(visited, exceptionHandler.getBasicBlock(), jsrTargets);
            }
            if ((bb = exceptionHandler.getBasicBlock()).matchType(1140900419)) {
                return false;
            }
            if (maxOffset < bb.getFromOffset()) {
                maxOffset = bb.getFromOffset();
            }
            if (!tryWithResourcesFlag) continue;
            predecessors = bb.getPredecessors();
            if (predecessors.size() == 1) {
                tryWithResourcesFlag = false;
                continue;
            }
            if (predecessors.size() != 2) continue;
            if (tryWithResourcesBB == null) {
                for (BasicBlock predecessor : predecessors) {
                    if (predecessor == basicBlock) continue;
                    assert (predecessor.getType() == 512);
                    tryWithResourcesBB = predecessor;
                    continue block1;
                }
                continue;
            }
            if (predecessors.contains(tryWithResourcesBB)) continue;
            tryWithResourcesFlag = false;
        }
        if (tryWithResourcesFlag) {
            for (BasicBlock.ExceptionHandler exceptionHandler : basicBlock.getExceptionHandlers()) {
                exceptionHandler.getBasicBlock().getPredecessors().remove(basicBlock);
            }
            for (Object predecessor : basicBlock.getPredecessors()) {
                ((BasicBlock)predecessor).replace(basicBlock, tryBB);
                tryBB.replace(basicBlock, (BasicBlock)predecessor);
            }
            basicBlock.setType(0);
        } else if (reduced) {
            BasicBlock end = ControlFlowGraphReducer.searchEndBlock(basicBlock, maxOffset);
            ControlFlowGraphReducer.updateBlock(tryBB, end, maxOffset);
            if (finallyBB != null && basicBlock.getExceptionHandlers().size() == 1 && tryBB.getType() == 1024 && tryBB.getNext() == BasicBlock.END && basicBlock.getFromOffset() == tryBB.getFromOffset() && !ControlFlowGraphReducer.containsFinally(tryBB)) {
                basicBlock.getExceptionHandlers().addAll(0, tryBB.getExceptionHandlers());
                for (BasicBlock.ExceptionHandler exceptionHandler : tryBB.getExceptionHandlers()) {
                    predecessors = exceptionHandler.getBasicBlock().getPredecessors();
                    predecessors.clear();
                    predecessors.add(basicBlock);
                }
                tryBB.setType(0);
                tryBB = tryBB.getSub1();
                Set<BasicBlock> predecessors2 = tryBB.getPredecessors();
                predecessors2.clear();
                predecessors2.add(basicBlock);
            }
            int toOffset = maxOffset;
            for (BasicBlock.ExceptionHandler exceptionHandler : basicBlock.getExceptionHandlers()) {
                BasicBlock last;
                int offset;
                bb = exceptionHandler.getBasicBlock();
                if (bb == end) {
                    exceptionHandler.setBasicBlock(BasicBlock.END);
                    continue;
                }
                int n = offset = bb.getFromOffset() == maxOffset ? end.getFromOffset() : maxOffset;
                if (offset == 0) {
                    offset = Integer.MAX_VALUE;
                }
                if (toOffset >= (last = ControlFlowGraphReducer.updateBlock(bb, end, offset)).getToOffset()) continue;
                toOffset = last.getToOffset();
            }
            basicBlock.setSub1(tryBB);
            basicBlock.setNext(end);
            end.getPredecessors().add(basicBlock);
            if (jsrTarget == null) {
                if (finallyBB != null && ControlFlowGraphReducer.checkEclipseFinallyPattern(basicBlock, finallyBB, maxOffset)) {
                    basicBlock.setType(4096);
                } else {
                    basicBlock.setType(1024);
                }
            } else {
                basicBlock.setType(2048);
                ControlFlowGraphReducer.removeJsrAndMergeSubTry(basicBlock);
            }
            basicBlock.setToOffset(toOffset);
        }
        return reduced;
    }

    private static boolean containsFinally(BasicBlock basicBlock) {
        for (BasicBlock.ExceptionHandler exceptionHandler : basicBlock.getExceptionHandlers()) {
            if (exceptionHandler.getInternalThrowableName() != null) continue;
            return true;
        }
        return false;
    }

    private static boolean checkEclipseFinallyPattern(BasicBlock basicBlock, BasicBlock finallyBB, int maxOffset) {
        int nextOpcode = ByteCodeUtil.searchNextOpcode(basicBlock, maxOffset);
        if (nextOpcode == 0 || nextOpcode == 167 || nextOpcode == 200) {
            return true;
        }
        BasicBlock next = basicBlock.getNext();
        if (!next.matchType(1266696506) && finallyBB.getFromOffset() < next.getFromOffset()) {
            ControlFlowGraph cfg = finallyBB.getControlFlowGraph();
            int toLineNumber = cfg.getLineNumber(finallyBB.getToOffset() - 1);
            int fromLineNumber = cfg.getLineNumber(next.getFromOffset());
            if (fromLineNumber < toLineNumber) {
                return true;
            }
        }
        return false;
    }

    private static BasicBlock searchJsrTarget(BasicBlock basicBlock, BitSet jsrTargets) {
        for (BasicBlock.ExceptionHandler exceptionHandler : basicBlock.getExceptionHandlers()) {
            BasicBlock bb;
            if (exceptionHandler.getInternalThrowableName() != null || (bb = exceptionHandler.getBasicBlock()).getType() != 4 || (bb = bb.getNext()).getType() != 8192 || bb.getNext().getType() != 8) continue;
            BasicBlock jsrTarget = bb.getBranch();
            jsrTargets.set(jsrTarget.getIndex());
            return jsrTarget;
        }
        return null;
    }

    private static BasicBlock searchEndBlock(BasicBlock basicBlock, int maxOffset) {
        BasicBlock end = null;
        BasicBlock last = ControlFlowGraphReducer.splitSequence(basicBlock.getNext(), maxOffset);
        if (!last.matchType(1266696506)) {
            BasicBlock next = last.getNext();
            if (next.getFromOffset() >= maxOffset || !next.matchType(58720530) && next.getToOffset() < basicBlock.getFromOffset()) {
                return next;
            }
            end = next;
        }
        for (BasicBlock.ExceptionHandler exceptionHandler : basicBlock.getExceptionHandlers()) {
            BasicBlock next;
            BasicBlock bb = exceptionHandler.getBasicBlock();
            if (bb.getFromOffset() < maxOffset) {
                last = ControlFlowGraphReducer.splitSequence(bb, maxOffset);
                if (last.matchType(1266696506)) continue;
                BasicBlock next2 = last.getNext();
                if (next2.getFromOffset() >= maxOffset || !next2.matchType(58720530) && next2.getToOffset() < basicBlock.getFromOffset()) {
                    return next2;
                }
                if (end == null) {
                    end = next2;
                    continue;
                }
                if (end == next2) continue;
                end = BasicBlock.END;
                continue;
            }
            ControlFlowGraph cfg = bb.getControlFlowGraph();
            int lineNumber = cfg.getLineNumber(bb.getFromOffset());
            WatchDog watchdog = new WatchDog();
            last = bb;
            for (next = bb.getNext(); last != next && last.matchType(876822149) && next.getPredecessors().size() == 1 && lineNumber <= cfg.getLineNumber(next.getFromOffset()); next = next.getNext()) {
                watchdog.check(next, next.getNext());
                last = next;
            }
            if (last.matchType(1266696506)) continue;
            if (!(last == next || next.getPredecessors().size() <= 1 && next.matchType(1266696506))) {
                return next;
            }
            if (end == next || exceptionHandler.getInternalThrowableName() == null) continue;
            end = BasicBlock.END;
        }
        if (end != null && end.matchType(58720512)) {
            return end;
        }
        return BasicBlock.END;
    }

    private static BasicBlock splitSequence(BasicBlock basicBlock, int maxOffset) {
        BasicBlock next = basicBlock.getNext();
        WatchDog watchdog = new WatchDog();
        while (next.getFromOffset() < maxOffset && next.matchType(876822149)) {
            watchdog.check(next, next.getNext());
            basicBlock = next;
            next = next.getNext();
        }
        if (basicBlock.getToOffset() > maxOffset && basicBlock.getType() == 1024) {
            DefaultList<BasicBlock.ExceptionHandler> exceptionHandlers = basicBlock.getExceptionHandlers();
            BasicBlock bb = ((BasicBlock.ExceptionHandler)exceptionHandlers.get(exceptionHandlers.size() - 1)).getBasicBlock();
            BasicBlock last = ControlFlowGraphReducer.splitSequence(bb, maxOffset);
            next = last.getNext();
            last.setNext(BasicBlock.END);
            basicBlock.setToOffset(last.getToOffset());
            basicBlock.setNext(next);
            next.getPredecessors().remove(last);
            next.getPredecessors().add(basicBlock);
        }
        return basicBlock;
    }

    private static BasicBlock updateBlock(BasicBlock basicBlock, BasicBlock end, int maxOffset) {
        WatchDog watchdog = new WatchDog();
        while (basicBlock.matchType(876822149)) {
            watchdog.check(basicBlock, basicBlock.getNext());
            BasicBlock next = basicBlock.getNext();
            if (next == end || next.getFromOffset() > maxOffset) {
                next.getPredecessors().remove(basicBlock);
                basicBlock.setNext(BasicBlock.END);
                break;
            }
            basicBlock = next;
        }
        return basicBlock;
    }

    private static void removeJsrAndMergeSubTry(BasicBlock basicBlock) {
        BasicBlock subTry;
        if (basicBlock.getExceptionHandlers().size() == 1 && (subTry = basicBlock.getSub1()).matchType(7168)) {
            for (BasicBlock.ExceptionHandler exceptionHandler : subTry.getExceptionHandlers()) {
                if (exceptionHandler.getInternalThrowableName() != null) continue;
                return;
            }
            for (BasicBlock.ExceptionHandler exceptionHandler : subTry.getExceptionHandlers()) {
                BasicBlock bb = exceptionHandler.getBasicBlock();
                basicBlock.addExceptionHandler(exceptionHandler.getInternalThrowableName(), bb);
                bb.replace(subTry, basicBlock);
            }
            basicBlock.setSub1(subTry.getSub1());
            subTry.getSub1().replace(subTry, basicBlock);
        }
    }

    private boolean reduceJsr(BitSet visited, BasicBlock basicBlock, BitSet jsrTargets) {
        BasicBlock branch = basicBlock.getBranch();
        boolean reduced = true;
        reduced &= this.reduce(visited, basicBlock.getNext(), jsrTargets);
        reduced &= this.reduce(visited, branch, jsrTargets);
        if (branch.getIndex() >= 0 && jsrTargets.get(branch.getIndex())) {
            int delta = basicBlock.getToOffset() - basicBlock.getFromOffset();
            if (delta > 3) {
                int opcode = ByteCodeUtil.getLastOpcode(basicBlock);
                if (opcode == 168) {
                    basicBlock.setType(4);
                    basicBlock.setToOffset(basicBlock.getToOffset() - 3);
                    branch.getPredecessors().remove(basicBlock);
                    return true;
                }
                if (delta > 201) {
                    basicBlock.setType(4);
                    basicBlock.setToOffset(basicBlock.getToOffset() - 5);
                    branch.getPredecessors().remove(basicBlock);
                    return true;
                }
            }
            basicBlock.setType(0);
            branch.getPredecessors().remove(basicBlock);
            Set<BasicBlock> nextPredecessors = basicBlock.getNext().getPredecessors();
            nextPredecessors.remove(basicBlock);
            for (BasicBlock predecessor : basicBlock.getPredecessors()) {
                predecessor.replace(basicBlock, basicBlock.getNext());
                nextPredecessors.add(predecessor);
            }
            return true;
        }
        if (basicBlock.getBranch().getPredecessors().size() > 1) {
            BasicBlock next = basicBlock.getNext();
            Iterator<BasicBlock> iterator = basicBlock.getBranch().getPredecessors().iterator();
            while (iterator.hasNext()) {
                BasicBlock predecessor = iterator.next();
                if (predecessor == basicBlock || predecessor.getType() != 8192 || predecessor.getNext() != next) continue;
                for (BasicBlock predecessorPredecessor : predecessor.getPredecessors()) {
                    predecessorPredecessor.replace(predecessor, basicBlock);
                    basicBlock.getPredecessors().add(predecessorPredecessor);
                }
                next.getPredecessors().remove(predecessor);
                iterator.remove();
                reduced = true;
            }
        }
        return reduced;
    }

    private boolean reduceLoop(BitSet visited, BasicBlock basicBlock, BitSet jsrTargets) {
        Object clone = visited.clone();
        boolean reduced = this.reduce(visited, basicBlock.getSub1(), jsrTargets);
        if (!reduced) {
            BitSet visitedMembers = new BitSet();
            BasicBlock updateBasicBlock = this.searchUpdateBlockAndCreateContinueLoop(visitedMembers, basicBlock.getSub1());
            visited = (BitSet)((BitSet)clone).clone();
            reduced = this.reduce(visited, basicBlock.getSub1(), jsrTargets);
            if (updateBasicBlock != null) {
                ControlFlowGraphReducer.removeLastContinueLoop(basicBlock.getSub1().getSub1());
                BasicBlock ifBasicBlock = basicBlock.getControlFlowGraph().newBasicBlock(65536, basicBlock.getSub1().getFromOffset(), basicBlock.getToOffset());
                ifBasicBlock.setCondition(BasicBlock.END);
                ifBasicBlock.setSub1(basicBlock.getSub1());
                ifBasicBlock.setNext(updateBasicBlock);
                updateBasicBlock.getPredecessors().add(ifBasicBlock);
                basicBlock.setSub1(ifBasicBlock);
            }
            if (!reduced) {
                visitedMembers.clear();
                BasicBlock conditionalBranch = ControlFlowGraphReducer.getLastConditionalBranch(visitedMembers, basicBlock.getSub1());
                if (conditionalBranch != null && conditionalBranch.getNext() == BasicBlock.LOOP_START) {
                    visitedMembers.clear();
                    visitedMembers.set(conditionalBranch.getIndex());
                    ControlFlowGraphReducer.changeEndLoopToJump(visitedMembers, basicBlock.getNext(), basicBlock.getSub1());
                    BasicBlock newLoopBB = basicBlock.getControlFlowGraph().newBasicBlock(basicBlock);
                    Set<BasicBlock> predecessors = conditionalBranch.getPredecessors();
                    for (BasicBlock predecessor : predecessors) {
                        predecessor.replace(conditionalBranch, BasicBlock.LOOP_END);
                    }
                    newLoopBB.setNext(conditionalBranch);
                    predecessors.clear();
                    predecessors.add(newLoopBB);
                    basicBlock.setSub1(newLoopBB);
                    visitedMembers.clear();
                    reduced = this.reduce(visitedMembers, newLoopBB, jsrTargets);
                }
            }
        }
        return reduced &= this.reduce(visited, basicBlock.getNext(), jsrTargets);
    }

    private static void removeLastContinueLoop(BasicBlock basicBlock) {
        BitSet visited = new BitSet();
        BasicBlock next = basicBlock.getNext();
        if (next == null) {
            return;
        }
        while (!next.matchType(1266696506) && !visited.get(next.getIndex())) {
            visited.set(next.getIndex());
            basicBlock = next;
            next = basicBlock.getNext();
        }
        if (next == BasicBlock.LOOP_CONTINUE) {
            basicBlock.setNext(BasicBlock.END);
        }
    }

    private static BasicBlock getLastConditionalBranch(BitSet visited, BasicBlock basicBlock) {
        if (!basicBlock.matchType(1266696506) && !visited.get(basicBlock.getIndex())) {
            visited.set(basicBlock.getIndex());
            int basicBlockType = basicBlock.getType();
            if (basicBlockType == 1 || basicBlockType == 4 || basicBlockType == 64 || basicBlockType == 512 || basicBlockType == 8192 || basicBlockType == 0x400000 || basicBlockType == 131072 || basicBlockType == 128 || basicBlockType == 1024 || basicBlockType == 2048 || basicBlockType == 4096) {
                return ControlFlowGraphReducer.getLastConditionalBranch(visited, basicBlock.getNext());
            }
            if (basicBlockType == 65536 || basicBlockType == 32768 || basicBlockType == 262144 || basicBlockType == 524288 || basicBlockType == 0x100000) {
                BasicBlock bb = ControlFlowGraphReducer.getLastConditionalBranch(visited, basicBlock.getBranch());
                if (bb != null) {
                    return bb;
                }
                bb = ControlFlowGraphReducer.getLastConditionalBranch(visited, basicBlock.getNext());
                if (bb != null) {
                    return bb;
                }
                return basicBlock;
            }
        }
        return null;
    }

    private static void visit(BitSet visited, BasicBlock basicBlock, int maxOffset, Set<BasicBlock> ends) {
        if (basicBlock.getFromOffset() >= maxOffset) {
            ends.add(basicBlock);
        } else if (basicBlock.getIndex() >= 0 && !visited.get(basicBlock.getIndex())) {
            visited.set(basicBlock.getIndex());
            switch (basicBlock.getType()) {
                case 8192: 
                case 32768: 
                case 262144: {
                    ControlFlowGraphReducer.visit(visited, basicBlock.getBranch(), maxOffset, ends);
                }
                case 1: 
                case 4: 
                case 0x400000: 
                case 0x4000000: 
                case 0x10000000: {
                    ControlFlowGraphReducer.visit(visited, basicBlock.getNext(), maxOffset, ends);
                    break;
                }
                case 1024: 
                case 2048: 
                case 4096: {
                    ControlFlowGraphReducer.visit(visited, basicBlock.getSub1(), maxOffset, ends);
                }
                case 512: {
                    for (BasicBlock.ExceptionHandler exceptionHandler : basicBlock.getExceptionHandlers()) {
                        ControlFlowGraphReducer.visit(visited, exceptionHandler.getBasicBlock(), maxOffset, ends);
                    }
                    ControlFlowGraphReducer.visit(visited, basicBlock.getNext(), maxOffset, ends);
                    break;
                }
                case 131072: 
                case 0x20000000: {
                    ControlFlowGraphReducer.visit(visited, basicBlock.getSub2(), maxOffset, ends);
                }
                case 65536: {
                    ControlFlowGraphReducer.visit(visited, basicBlock.getSub1(), maxOffset, ends);
                    ControlFlowGraphReducer.visit(visited, basicBlock.getNext(), maxOffset, ends);
                    break;
                }
                case 524288: 
                case 0x100000: {
                    ControlFlowGraphReducer.visit(visited, basicBlock.getSub1(), maxOffset, ends);
                    ControlFlowGraphReducer.visit(visited, basicBlock.getSub2(), maxOffset, ends);
                    break;
                }
                case 128: {
                    ControlFlowGraphReducer.visit(visited, basicBlock.getNext(), maxOffset, ends);
                }
                case 64: {
                    for (BasicBlock.SwitchCase switchCase : basicBlock.getSwitchCases()) {
                        ControlFlowGraphReducer.visit(visited, switchCase.getBasicBlock(), maxOffset, ends);
                    }
                    break;
                }
            }
        }
    }

    private BasicBlock searchUpdateBlockAndCreateContinueLoop(BitSet visited, BasicBlock basicBlock) {
        BasicBlock updateBasicBlock = null;
        if (!basicBlock.matchType(1266696506) && !visited.get(basicBlock.getIndex())) {
            visited.set(basicBlock.getIndex());
            switch (basicBlock.getType()) {
                case 8192: 
                case 32768: 
                case 262144: 
                case 0x200000: {
                    updateBasicBlock = this.searchUpdateBlockAndCreateContinueLoop(visited, basicBlock, basicBlock.getBranch());
                }
                case 1: 
                case 4: 
                case 0x400000: 
                case 0x4000000: 
                case 0x10000000: {
                    if (updateBasicBlock != null) break;
                    updateBasicBlock = this.searchUpdateBlockAndCreateContinueLoop(visited, basicBlock, basicBlock.getNext());
                    break;
                }
                case 1024: 
                case 2048: 
                case 4096: {
                    updateBasicBlock = this.searchUpdateBlockAndCreateContinueLoop(visited, basicBlock, basicBlock.getSub1());
                }
                case 512: {
                    for (BasicBlock.ExceptionHandler exceptionHandler : basicBlock.getExceptionHandlers()) {
                        if (updateBasicBlock != null) continue;
                        updateBasicBlock = this.searchUpdateBlockAndCreateContinueLoop(visited, basicBlock, exceptionHandler.getBasicBlock());
                    }
                    if (updateBasicBlock != null) break;
                    updateBasicBlock = this.searchUpdateBlockAndCreateContinueLoop(visited, basicBlock, basicBlock.getNext());
                    break;
                }
                case 131072: 
                case 0x20000000: {
                    updateBasicBlock = this.searchUpdateBlockAndCreateContinueLoop(visited, basicBlock, basicBlock.getSub2());
                }
                case 65536: {
                    if (updateBasicBlock == null) {
                        updateBasicBlock = this.searchUpdateBlockAndCreateContinueLoop(visited, basicBlock, basicBlock.getSub1());
                    }
                    if (updateBasicBlock != null) break;
                    updateBasicBlock = this.searchUpdateBlockAndCreateContinueLoop(visited, basicBlock, basicBlock.getNext());
                    break;
                }
                case 524288: 
                case 0x100000: {
                    updateBasicBlock = this.searchUpdateBlockAndCreateContinueLoop(visited, basicBlock, basicBlock.getSub1());
                    if (updateBasicBlock != null) break;
                    updateBasicBlock = this.searchUpdateBlockAndCreateContinueLoop(visited, basicBlock, basicBlock.getSub2());
                    break;
                }
                case 128: {
                    updateBasicBlock = this.searchUpdateBlockAndCreateContinueLoop(visited, basicBlock, basicBlock.getNext());
                }
                case 64: {
                    for (BasicBlock.SwitchCase switchCase : basicBlock.getSwitchCases()) {
                        if (updateBasicBlock != null) continue;
                        updateBasicBlock = this.searchUpdateBlockAndCreateContinueLoop(visited, basicBlock, switchCase.getBasicBlock());
                    }
                    break;
                }
            }
        }
        return updateBasicBlock;
    }

    private BasicBlock searchUpdateBlockAndCreateContinueLoop(BitSet visited, BasicBlock basicBlock, BasicBlock subBasicBlock) {
        if (subBasicBlock != null) {
            if (basicBlock.getFromOffset() < subBasicBlock.getFromOffset()) {
                if (basicBlock.getFirstLineNumber() == 0) {
                    if (subBasicBlock.matchType(876822149) && subBasicBlock.getNext().getType() == 0x800000) {
                        Set<BasicBlock> predecessors;
                        for (int stackDepth = ByteCodeUtil.evalStackDepth(subBasicBlock); stackDepth != 0 && (predecessors = subBasicBlock.getPredecessors()).size() == 1; stackDepth += ByteCodeUtil.evalStackDepth(subBasicBlock)) {
                            subBasicBlock = predecessors.iterator().next();
                        }
                        ControlFlowGraphReducer.removePredecessors(subBasicBlock);
                        return subBasicBlock;
                    }
                } else if (basicBlock.getFirstLineNumber() > subBasicBlock.getFirstLineNumber()) {
                    ControlFlowGraphReducer.removePredecessors(subBasicBlock);
                    return subBasicBlock;
                }
            }
            return this.searchUpdateBlockAndCreateContinueLoop(visited, subBasicBlock);
        }
        return null;
    }

    private static void removePredecessors(BasicBlock basicBlock) {
        Set<BasicBlock> predecessors = basicBlock.getPredecessors();
        Iterator<BasicBlock> iterator = predecessors.iterator();
        while (iterator.hasNext()) {
            iterator.next().replace(basicBlock, BasicBlock.LOOP_CONTINUE);
        }
        predecessors.clear();
    }

    private static void changeEndLoopToJump(BitSet visited, BasicBlock target, BasicBlock bb) {
        if (!bb.matchType(1266696506) && !visited.get(bb.getIndex())) {
            visited.set(bb.getIndex());
            switch (bb.getType()) {
                case 8192: 
                case 32768: 
                case 262144: {
                    if (bb.getBranch() == BasicBlock.LOOP_END) {
                        bb.setBranch(bb.getControlFlowGraph().newJumpBasicBlock(bb, target));
                    } else {
                        ControlFlowGraphReducer.changeEndLoopToJump(visited, target, bb.getBranch());
                    }
                }
                case 1: 
                case 4: 
                case 0x400000: 
                case 0x4000000: 
                case 0x10000000: {
                    if (bb.getNext() == BasicBlock.LOOP_END) {
                        bb.setNext(bb.getControlFlowGraph().newJumpBasicBlock(bb, target));
                        break;
                    }
                    ControlFlowGraphReducer.changeEndLoopToJump(visited, target, bb.getNext());
                    break;
                }
                case 1024: 
                case 2048: 
                case 4096: {
                    if (bb.getSub1() == BasicBlock.LOOP_END) {
                        bb.setSub1(bb.getControlFlowGraph().newJumpBasicBlock(bb, target));
                    } else {
                        ControlFlowGraphReducer.changeEndLoopToJump(visited, target, bb.getSub1());
                    }
                }
                case 512: {
                    for (BasicBlock.ExceptionHandler exceptionHandler : bb.getExceptionHandlers()) {
                        if (exceptionHandler.getBasicBlock() == BasicBlock.LOOP_END) {
                            exceptionHandler.setBasicBlock(bb.getControlFlowGraph().newJumpBasicBlock(bb, target));
                            continue;
                        }
                        ControlFlowGraphReducer.changeEndLoopToJump(visited, target, exceptionHandler.getBasicBlock());
                    }
                    break;
                }
                case 131072: 
                case 0x20000000: {
                    if (bb.getSub2() == BasicBlock.LOOP_END) {
                        bb.setSub2(bb.getControlFlowGraph().newJumpBasicBlock(bb, target));
                    } else {
                        ControlFlowGraphReducer.changeEndLoopToJump(visited, target, bb.getSub2());
                    }
                }
                case 65536: {
                    if (bb.getSub1() == BasicBlock.LOOP_END) {
                        bb.setSub1(bb.getControlFlowGraph().newJumpBasicBlock(bb, target));
                    } else {
                        ControlFlowGraphReducer.changeEndLoopToJump(visited, target, bb.getSub1());
                    }
                    if (bb.getNext() == BasicBlock.LOOP_END) {
                        bb.setNext(bb.getControlFlowGraph().newJumpBasicBlock(bb, target));
                        break;
                    }
                    ControlFlowGraphReducer.changeEndLoopToJump(visited, target, bb.getNext());
                    break;
                }
                case 524288: 
                case 0x100000: {
                    if (bb.getSub1() == BasicBlock.LOOP_END) {
                        bb.setSub1(bb.getControlFlowGraph().newJumpBasicBlock(bb, target));
                    } else {
                        ControlFlowGraphReducer.changeEndLoopToJump(visited, target, bb.getSub1());
                    }
                    if (bb.getSub2() == BasicBlock.LOOP_END) {
                        bb.setSub2(bb.getControlFlowGraph().newJumpBasicBlock(bb, target));
                        break;
                    }
                    ControlFlowGraphReducer.changeEndLoopToJump(visited, target, bb.getSub2());
                    break;
                }
                case 128: {
                    if (bb.getNext() == BasicBlock.LOOP_END) {
                        bb.setNext(bb.getControlFlowGraph().newJumpBasicBlock(bb, target));
                    } else {
                        ControlFlowGraphReducer.changeEndLoopToJump(visited, target, bb.getNext());
                    }
                }
                case 64: {
                    for (BasicBlock.SwitchCase switchCase : bb.getSwitchCases()) {
                        if (switchCase.getBasicBlock() == BasicBlock.LOOP_END) {
                            switchCase.setBasicBlock(bb.getControlFlowGraph().newJumpBasicBlock(bb, target));
                            continue;
                        }
                        ControlFlowGraphReducer.changeEndLoopToJump(visited, target, switchCase.getBasicBlock());
                    }
                    break;
                }
            }
        }
    }

    private static BasicBlock clone(BasicBlock bb, BasicBlock next) {
        BasicBlock clone = next.getControlFlowGraph().newBasicBlock(next.getType(), next.getFromOffset(), next.getToOffset());
        clone.setNext(BasicBlock.END);
        clone.getPredecessors().add(bb);
        next.getPredecessors().remove(bb);
        bb.setNext(clone);
        return clone;
    }

    public ControlFlowGraph getControlFlowGraph() {
        return this.controlFlowGraph;
    }

    public static List<ControlFlowGraphReducer> getPreferredReducers() {
        ArrayList<ControlFlowGraphReducer> preferredReducers = new ArrayList<ControlFlowGraphReducer>();
        preferredReducers.add(new MinDepthCFGReducer(false));
        preferredReducers.add(new MinDepthCFGReducer(true));
        preferredReducers.add(new CmpDepthCFGReducer());
        return preferredReducers;
    }
}

