/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import java.util.Set;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg.BasicBlock;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg.ControlFlowGraph;

public final class ControlFlowGraphGotoReducer {
    private ControlFlowGraphGotoReducer() {
    }

    public static void reduce(ControlFlowGraph cfg, boolean splitReturns) {
        for (BasicBlock basicBlock : cfg.getBasicBlocks()) {
            if (basicBlock.getType() != 0x4000000) continue;
            BasicBlock successor = basicBlock.getNext();
            if (basicBlock == successor) {
                basicBlock.getPredecessors().remove(basicBlock);
                basicBlock.setType(0x8000000);
                continue;
            }
            if (splitReturns && successor.getType() == 16 && !"<clinit>".equals(cfg.getMethod().getName())) {
                basicBlock.setType(16);
                basicBlock.setNext(BasicBlock.END);
                successor.getPredecessors().remove(basicBlock);
                continue;
            }
            Set<BasicBlock> successorPredecessors = successor.getPredecessors();
            successorPredecessors.remove(basicBlock);
            for (BasicBlock predecessor : basicBlock.getPredecessors()) {
                predecessor.replace(basicBlock, successor);
                successorPredecessors.add(predecessor);
            }
            basicBlock.setType(0);
        }
    }

    public static void reduce(ControlFlowGraph cfg) {
        ControlFlowGraphGotoReducer.reduce(cfg, false);
    }
}

