/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.bcel.classfile.BootstrapMethod;
import org.apache.bcel.classfile.BootstrapMethods;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantMethodHandle;
import org.apache.bcel.classfile.ConstantMethodType;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Method;
import org.jd.core.v1.model.classfile.ClassFile;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.declaration.AbstractNopDeclarationVisitor;
import org.jd.core.v1.model.javasyntax.declaration.BaseFormalParameter;
import org.jd.core.v1.model.javasyntax.declaration.BodyDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.DeclarationVisitor;
import org.jd.core.v1.model.javasyntax.declaration.FieldDeclarator;
import org.jd.core.v1.model.javasyntax.declaration.FormalParameter;
import org.jd.core.v1.model.javasyntax.declaration.FormalParameters;
import org.jd.core.v1.model.javasyntax.declaration.MethodDeclaration;
import org.jd.core.v1.model.javasyntax.expression.ArrayExpression;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.BinaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.CastExpression;
import org.jd.core.v1.model.javasyntax.expression.ConstructorReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.DoubleConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor;
import org.jd.core.v1.model.javasyntax.expression.Expressions;
import org.jd.core.v1.model.javasyntax.expression.FieldReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.FloatConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.InstanceOfExpression;
import org.jd.core.v1.model.javasyntax.expression.IntegerConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.LambdaIdentifiersExpression;
import org.jd.core.v1.model.javasyntax.expression.LengthExpression;
import org.jd.core.v1.model.javasyntax.expression.LongConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.MethodInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.MethodReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.NewArray;
import org.jd.core.v1.model.javasyntax.expression.NewExpression;
import org.jd.core.v1.model.javasyntax.expression.NullExpression;
import org.jd.core.v1.model.javasyntax.expression.ObjectTypeReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.PostOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.PreOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.QualifiedSuperExpression;
import org.jd.core.v1.model.javasyntax.expression.StringConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.SuperExpression;
import org.jd.core.v1.model.javasyntax.expression.ThisExpression;
import org.jd.core.v1.model.javasyntax.expression.TypeReferenceDotClassExpression;
import org.jd.core.v1.model.javasyntax.statement.BaseStatement;
import org.jd.core.v1.model.javasyntax.statement.ExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.LambdaExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.ReturnExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.ReturnStatement;
import org.jd.core.v1.model.javasyntax.statement.Statement;
import org.jd.core.v1.model.javasyntax.statement.StatementVisitor;
import org.jd.core.v1.model.javasyntax.statement.Statements;
import org.jd.core.v1.model.javasyntax.statement.SwitchStatement;
import org.jd.core.v1.model.javasyntax.statement.ThrowStatement;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.BaseTypeArgument;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeParameterWithTypeBounds;
import org.jd.core.v1.model.javasyntax.type.TypeVisitor;
import org.jd.core.v1.model.javasyntax.type.WildcardTypeArgument;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg.BasicBlock;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg.ControlFlowGraph;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileBodyDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileClassDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorOrMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileFieldDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileFormalParameter;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileTypeDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileCmpExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileLocalVariableReferenceExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileNewExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.statement.ClassFileMonitorEnterStatement;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.statement.ClassFileMonitorExitStatement;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.AbstractLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.AbstractTypeParametersToTypeArgumentsBinder;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.Java5TypeParametersToTypeArgumentsBinder;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.JavaTypeParametersToTypeArgumentsBinder;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.LocalVariableMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.NewArrayMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.PrimitiveTypeUtil;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.StringConcatenationUtil;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.CreateInstructionsVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.EraseTypeArgumentVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.RenameLocalVariablesVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.SearchFirstLineNumberVisitor;
import org.jd.core.v1.util.DefaultList;
import org.jd.core.v1.util.DefaultStack;

public class ByteCodeParser {
    private static final JsrReturnAddressExpression JSR_RETURN_ADDRESS_EXPRESSION = new JsrReturnAddressExpression();
    private final MemberVisitor memberVisitor = new MemberVisitor();
    private final SearchFirstLineNumberVisitor searchFirstLineNumberVisitor = new SearchFirstLineNumberVisitor();
    private final EraseTypeArgumentVisitor eraseTypeArgumentVisitor = new EraseTypeArgumentVisitor();
    private final LambdaParameterNamesVisitor lambdaParameterNamesVisitor = new LambdaParameterNamesVisitor();
    private final RenameLocalVariablesVisitor renameLocalVariablesVisitor = new RenameLocalVariablesVisitor();
    private final TypeMaker typeMaker;
    private final LocalVariableMaker localVariableMaker;
    private final boolean diamondSupported;
    private final boolean genericTypesSupported;
    private final int majorVersion;
    private final String internalTypeName;
    private final AbstractTypeParametersToTypeArgumentsBinder typeParametersToTypeArgumentsBinder;
    private final BootstrapMethods attributeBootstrapMethods;
    private final ClassFileBodyDeclaration bodyDeclaration;
    private final Map<String, BaseType> typeBounds;
    private Type returnedType;
    private BaseType exceptionTypes;

    public ByteCodeParser(TypeMaker typeMaker, LocalVariableMaker localVariableMaker, ClassFile classFile, ClassFileBodyDeclaration bodyDeclaration, ClassFileConstructorOrMethodDeclaration comd) {
        this.typeMaker = typeMaker;
        this.localVariableMaker = localVariableMaker;
        this.majorVersion = classFile.getMajorVersion();
        this.diamondSupported = this.majorVersion >= 51;
        this.genericTypesSupported = this.majorVersion >= 49;
        this.internalTypeName = classFile.getInternalTypeName();
        this.attributeBootstrapMethods = (BootstrapMethods)classFile.getAttribute((byte)20);
        this.bodyDeclaration = bodyDeclaration;
        this.returnedType = comd.getReturnedType();
        this.exceptionTypes = comd.getExceptionTypes();
        this.typeBounds = comd.getTypeBounds();
        this.typeParametersToTypeArgumentsBinder = this.genericTypesSupported ? new Java5TypeParametersToTypeArgumentsBinder(typeMaker, this.internalTypeName, comd) : new JavaTypeParametersToTypeArgumentsBinder();
    }

    public void parse(BasicBlock basicBlock, Statements statements, DefaultStack<Expression> stack, Deque<Expression> enclosingInstances) {
        ControlFlowGraph cfg = basicBlock.getControlFlowGraph();
        int fromOffset = basicBlock.getFromOffset();
        int toOffset = basicBlock.getToOffset();
        Method method = cfg.getMethod();
        ConstantPool constants = method.getConstantPool();
        byte[] code = method.getCode().getCode();
        block134: for (int offset = fromOffset; offset < toOffset; ++offset) {
            int opcode = code[offset] & 0xFF;
            int lineNumber = cfg.getLineNumber(offset);
            switch (opcode) {
                case 0: {
                    continue block134;
                }
                case 1: {
                    stack.push((Object)new NullExpression(lineNumber, (Type)ObjectType.TYPE_UNDEFINED_OBJECT));
                    continue block134;
                }
                case 2: {
                    stack.push((Object)new IntegerConstantExpression(lineNumber, (Type)PrimitiveType.MAYBE_NEGATIVE_BYTE_TYPE, -1));
                    continue block134;
                }
                case 3: 
                case 4: {
                    stack.push((Object)new IntegerConstantExpression(lineNumber, (Type)PrimitiveType.MAYBE_BOOLEAN_TYPE, opcode - 3));
                    continue block134;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    stack.push((Object)new IntegerConstantExpression(lineNumber, (Type)PrimitiveType.MAYBE_BYTE_TYPE, opcode - 3));
                    continue block134;
                }
                case 9: 
                case 10: {
                    stack.push((Object)new LongConstantExpression(lineNumber, (long)opcode - 9L));
                    continue block134;
                }
                case 11: 
                case 12: 
                case 13: {
                    stack.push((Object)new FloatConstantExpression(lineNumber, (float)opcode - 11.0f));
                    continue block134;
                }
                case 14: 
                case 15: {
                    stack.push((Object)new DoubleConstantExpression(lineNumber, (double)opcode - 14.0));
                    continue block134;
                }
                case 16: {
                    short value = (short)(code[++offset] & 0xFF);
                    stack.push((Object)new IntegerConstantExpression(lineNumber, (Type)PrimitiveTypeUtil.getPrimitiveTypeFromValue((int)value), (int)value));
                    continue block134;
                }
                case 17: {
                    short value = (short)((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    stack.push((Object)new IntegerConstantExpression(lineNumber, (Type)PrimitiveTypeUtil.getPrimitiveTypeFromValue((int)value), (int)value));
                    continue block134;
                }
                case 18: {
                    this.parseLDC(stack, constants, lineNumber, constants.getConstant(code[++offset] & 0xFF));
                    continue block134;
                }
                case 19: 
                case 20: {
                    this.parseLDC(stack, constants, lineNumber, constants.getConstant((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF));
                    continue block134;
                }
                case 21: {
                    AbstractLocalVariable localVariable = this.localVariableMaker.getLocalVariable(code[++offset] & 0xFF, offset);
                    ByteCodeParser.parseILOAD(statements, stack, lineNumber, offset, localVariable);
                    continue block134;
                }
                case 22: 
                case 23: 
                case 24: {
                    AbstractLocalVariable localVariable = this.localVariableMaker.getLocalVariable(code[++offset] & 0xFF, offset);
                    stack.push((Object)new ClassFileLocalVariableReferenceExpression(lineNumber, offset, localVariable));
                    continue block134;
                }
                case 25: {
                    int i = code[++offset] & 0xFF;
                    AbstractLocalVariable localVariable = this.localVariableMaker.getLocalVariable(i, offset);
                    if (i == 0 && (method.getAccessFlags() & 8) == 0) {
                        stack.push((Object)new ThisExpression(lineNumber, localVariable.getType()));
                        continue block134;
                    }
                    stack.push((Object)new ClassFileLocalVariableReferenceExpression(lineNumber, offset, localVariable));
                    continue block134;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    AbstractLocalVariable localVariable = this.localVariableMaker.getLocalVariable(opcode - 26, offset);
                    ByteCodeParser.parseILOAD(statements, stack, lineNumber, offset, localVariable);
                    continue block134;
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    AbstractLocalVariable localVariable = this.localVariableMaker.getLocalVariable(opcode - 30, offset);
                    stack.push((Object)new ClassFileLocalVariableReferenceExpression(lineNumber, offset, localVariable));
                    continue block134;
                }
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    AbstractLocalVariable localVariable = this.localVariableMaker.getLocalVariable(opcode - 34, offset);
                    stack.push((Object)new ClassFileLocalVariableReferenceExpression(lineNumber, offset, localVariable));
                    continue block134;
                }
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    AbstractLocalVariable localVariable = this.localVariableMaker.getLocalVariable(opcode - 38, offset);
                    stack.push((Object)new ClassFileLocalVariableReferenceExpression(lineNumber, offset, localVariable));
                    continue block134;
                }
                case 42: {
                    AbstractLocalVariable localVariable = this.localVariableMaker.getLocalVariable(0, offset);
                    if ((method.getAccessFlags() & 8) == 0) {
                        stack.push((Object)new ThisExpression(lineNumber, localVariable.getType()));
                        continue block134;
                    }
                    stack.push((Object)new ClassFileLocalVariableReferenceExpression(lineNumber, offset, localVariable));
                    continue block134;
                }
                case 43: 
                case 44: 
                case 45: {
                    AbstractLocalVariable localVariable = this.localVariableMaker.getLocalVariable(opcode - 42, offset);
                    stack.push((Object)new ClassFileLocalVariableReferenceExpression(lineNumber, offset, localVariable));
                    continue block134;
                }
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    Expression indexRef = (Expression)stack.pop();
                    Expression arrayRef = (Expression)stack.pop();
                    stack.push((Object)new ArrayExpression(lineNumber, arrayRef, indexRef));
                    continue block134;
                }
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    Expression valueRef = (Expression)stack.pop();
                    AbstractLocalVariable localVariable = this.getLocalVariableInAssignment(code[++offset] & 0xFF, offset + 2, valueRef);
                    localVariable.setAssigned(true);
                    this.parseSTORE(statements, stack, lineNumber, offset, localVariable, valueRef);
                    continue block134;
                }
                case 58: {
                    Expression valueRef = (Expression)stack.pop();
                    AbstractLocalVariable localVariable = this.getLocalVariableInAssignment(code[++offset] & 0xFF, offset + 1, valueRef);
                    this.parseASTORE(statements, stack, lineNumber, offset, localVariable, valueRef);
                    continue block134;
                }
                case 59: 
                case 60: 
                case 61: 
                case 62: {
                    Expression valueRef = (Expression)stack.pop();
                    AbstractLocalVariable localVariable = this.getLocalVariableInAssignment(opcode - 59, offset + 1, valueRef);
                    this.parseSTORE(statements, stack, lineNumber, offset, localVariable, valueRef);
                    continue block134;
                }
                case 63: 
                case 64: 
                case 65: 
                case 66: {
                    Expression valueRef = (Expression)stack.pop();
                    AbstractLocalVariable localVariable = this.getLocalVariableInAssignment(opcode - 63, offset + 1, valueRef);
                    this.parseSTORE(statements, stack, lineNumber, offset, localVariable, valueRef);
                    continue block134;
                }
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    Expression valueRef = (Expression)stack.pop();
                    AbstractLocalVariable localVariable = this.getLocalVariableInAssignment(opcode - 67, offset + 1, valueRef);
                    this.parseSTORE(statements, stack, lineNumber, offset, localVariable, valueRef);
                    continue block134;
                }
                case 71: 
                case 72: 
                case 73: 
                case 74: {
                    Expression valueRef = (Expression)stack.pop();
                    AbstractLocalVariable localVariable = this.getLocalVariableInAssignment(opcode - 71, offset + 1, valueRef);
                    this.parseSTORE(statements, stack, lineNumber, offset, localVariable, valueRef);
                    continue block134;
                }
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    Expression valueRef = (Expression)stack.pop();
                    AbstractLocalVariable localVariable = this.getLocalVariableInAssignment(opcode - 75, offset + 1, valueRef);
                    this.parseASTORE(statements, stack, lineNumber, offset, localVariable, valueRef);
                    continue block134;
                }
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 84: 
                case 85: 
                case 86: {
                    Expression valueRef = (Expression)stack.pop();
                    Expression indexRef = (Expression)stack.pop();
                    Expression arrayRef = (Expression)stack.pop();
                    Type type1 = arrayRef.getType();
                    statements.add((Object)new ExpressionStatement((Expression)new BinaryOperatorExpression(lineNumber, type1.createType(type1.getDimension() - 1), (Expression)new ArrayExpression(lineNumber, arrayRef, indexRef), "=", valueRef, 16)));
                    continue block134;
                }
                case 83: {
                    Expression valueRef = (Expression)stack.pop();
                    Expression indexRef = (Expression)stack.pop();
                    Expression arrayRef = (Expression)stack.pop();
                    Type type1 = arrayRef.getType();
                    Type type2 = type1.createType(type1.getDimension() > 0 ? type1.getDimension() - 1 : 0);
                    this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes(type2, valueRef);
                    this.parseAASTORE(statements, stack, lineNumber, (Expression)new ArrayExpression(lineNumber, arrayRef, indexRef), valueRef);
                    continue block134;
                }
                case 87: 
                case 88: {
                    Object expression1 = (Expression)stack.pop();
                    if (expression1.isMethodInvocationExpression() && expression1.getExpression().getType().isInnerObjectType() && "getClass".equals(expression1.getName())) {
                        enclosingInstances.push(expression1.getExpression());
                        continue block134;
                    }
                    if (expression1.isLocalVariableReferenceExpression() || expression1.isFieldReferenceExpression() || expression1.isThisExpression()) continue block134;
                    this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes((Type)ObjectType.TYPE_OBJECT, (Expression)expression1);
                    statements.add((Object)new ExpressionStatement(expression1.isCastExpression() ? expression1.getExpression() : expression1));
                    continue block134;
                }
                case 89: {
                    Object expression1 = (Expression)stack.pop();
                    stack.push(expression1);
                    stack.push(expression1);
                    continue block134;
                }
                case 90: {
                    Object expression1 = (Expression)stack.pop();
                    Expression expression2 = (Expression)stack.pop();
                    stack.push(expression1);
                    stack.push((Object)expression2);
                    stack.push(expression1);
                    continue block134;
                }
                case 91: {
                    Expression expression3;
                    Object expression1 = (Expression)stack.pop();
                    Expression expression2 = (Expression)stack.pop();
                    Type type2 = expression2.getType();
                    if (PrimitiveType.TYPE_LONG.equals((Object)type2) || PrimitiveType.TYPE_DOUBLE.equals((Object)type2)) {
                        stack.push(expression1);
                    } else {
                        expression3 = (Expression)stack.pop();
                        stack.push(expression1);
                        stack.push((Object)expression3);
                    }
                    stack.push((Object)expression2);
                    stack.push(expression1);
                    continue block134;
                }
                case 92: {
                    Expression expression2;
                    Object expression1 = (Expression)stack.pop();
                    Type type1 = expression1.getType();
                    if (PrimitiveType.TYPE_LONG.equals((Object)type1) || PrimitiveType.TYPE_DOUBLE.equals((Object)type1)) {
                        stack.push(expression1);
                    } else {
                        expression2 = (Expression)stack.pop();
                        stack.push((Object)expression2);
                        stack.push(expression1);
                        stack.push((Object)expression2);
                    }
                    stack.push(expression1);
                    continue block134;
                }
                case 93: {
                    Expression expression3;
                    Object expression1 = (Expression)stack.pop();
                    Expression expression2 = (Expression)stack.pop();
                    Type type1 = expression1.getType();
                    if (PrimitiveType.TYPE_LONG.equals((Object)type1) || PrimitiveType.TYPE_DOUBLE.equals((Object)type1)) {
                        stack.push(expression1);
                    } else {
                        expression3 = (Expression)stack.pop();
                        stack.push((Object)expression2);
                        stack.push(expression1);
                        stack.push((Object)expression3);
                    }
                    stack.push((Object)expression2);
                    stack.push(expression1);
                    continue block134;
                }
                case 94: {
                    Expression expression3;
                    Type type2;
                    Object expression1 = (Expression)stack.pop();
                    Expression expression2 = (Expression)stack.pop();
                    Type type1 = expression1.getType();
                    if (PrimitiveType.TYPE_LONG.equals((Object)type1) || PrimitiveType.TYPE_DOUBLE.equals((Object)type1)) {
                        type2 = expression2.getType();
                        if (PrimitiveType.TYPE_LONG.equals((Object)type2) || PrimitiveType.TYPE_DOUBLE.equals((Object)type2)) {
                            stack.push(expression1);
                        } else {
                            expression3 = (Expression)stack.pop();
                            stack.push(expression1);
                            stack.push((Object)expression3);
                        }
                    } else {
                        expression3 = (Expression)stack.pop();
                        Type type3 = expression3.getType();
                        if (PrimitiveType.TYPE_LONG.equals((Object)type3) || PrimitiveType.TYPE_DOUBLE.equals((Object)type3)) {
                            stack.push((Object)expression2);
                            stack.push(expression1);
                        } else {
                            Expression expression4 = (Expression)stack.pop();
                            stack.push((Object)expression2);
                            stack.push(expression1);
                            stack.push((Object)expression4);
                        }
                        stack.push((Object)expression3);
                    }
                    stack.push((Object)expression2);
                    stack.push(expression1);
                    continue block134;
                }
                case 95: {
                    Object expression1 = (Expression)stack.pop();
                    Expression expression2 = (Expression)stack.pop();
                    stack.push(expression1);
                    stack.push((Object)expression2);
                    continue block134;
                }
                case 96: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)this.newIntegerBinaryOperatorExpression(lineNumber, (Expression)expression1, "+", expression2, 6));
                    continue block134;
                }
                case 97: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_LONG, expression1, "+", expression2, 6));
                    continue block134;
                }
                case 98: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_FLOAT, expression1, "+", expression2, 6));
                    continue block134;
                }
                case 99: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_DOUBLE, expression1, "+", expression2, 6));
                    continue block134;
                }
                case 100: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)this.newIntegerBinaryOperatorExpression(lineNumber, (Expression)expression1, "-", expression2, 6));
                    continue block134;
                }
                case 101: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_LONG, expression1, "-", expression2, 6));
                    continue block134;
                }
                case 102: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_FLOAT, expression1, "-", expression2, 6));
                    continue block134;
                }
                case 103: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_DOUBLE, expression1, "-", expression2, 6));
                    continue block134;
                }
                case 104: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)this.newIntegerBinaryOperatorExpression(lineNumber, (Expression)expression1, "*", expression2, 5));
                    continue block134;
                }
                case 105: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_LONG, expression1, "*", expression2, 5));
                    continue block134;
                }
                case 106: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_FLOAT, expression1, "*", expression2, 5));
                    continue block134;
                }
                case 107: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_DOUBLE, expression1, "*", expression2, 5));
                    continue block134;
                }
                case 108: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)this.newIntegerBinaryOperatorExpression(lineNumber, (Expression)expression1, "/", expression2, 5));
                    continue block134;
                }
                case 109: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_LONG, expression1, "/", expression2, 5));
                    continue block134;
                }
                case 110: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_FLOAT, expression1, "/", expression2, 5));
                    continue block134;
                }
                case 111: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_DOUBLE, expression1, "/", expression2, 5));
                    continue block134;
                }
                case 112: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)this.newIntegerBinaryOperatorExpression(lineNumber, (Expression)expression1, "%", expression2, 5));
                    continue block134;
                }
                case 113: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_LONG, expression1, "%", expression2, 5));
                    continue block134;
                }
                case 114: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_FLOAT, expression1, "%", expression2, 5));
                    continue block134;
                }
                case 115: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_DOUBLE, expression1, "%", expression2, 5));
                    continue block134;
                }
                case 116: 
                case 117: 
                case 118: 
                case 119: {
                    stack.push((Object)this.newPreArithmeticOperatorExpression(lineNumber, "-", (Expression)stack.pop()));
                    continue block134;
                }
                case 120: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)this.newIntegerBinaryOperatorExpression(lineNumber, (Expression)expression1, "<<", expression2, 7));
                    continue block134;
                }
                case 121: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_LONG, expression1, "<<", expression2, 7));
                    continue block134;
                }
                case 122: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_INT, expression1, ">>", expression2, 7));
                    continue block134;
                }
                case 123: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_LONG, expression1, ">>", expression2, 7));
                    continue block134;
                }
                case 124: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)this.newIntegerBinaryOperatorExpression(lineNumber, (Expression)expression1, ">>>", expression2, 7));
                    continue block134;
                }
                case 125: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_LONG, expression1, ">>>", expression2, 7));
                    continue block134;
                }
                case 126: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)this.newIntegerOrBooleanBinaryOperatorExpression(lineNumber, (Expression)expression1, "&", expression2, 10));
                    continue block134;
                }
                case 127: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_LONG, expression1, "&", expression2, 10));
                    continue block134;
                }
                case 128: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)this.newIntegerOrBooleanBinaryOperatorExpression(lineNumber, (Expression)expression1, "|", expression2, 12));
                    continue block134;
                }
                case 129: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_LONG, expression1, "|", expression2, 12));
                    continue block134;
                }
                case 130: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)this.newIntegerOrBooleanBinaryOperatorExpression(lineNumber, (Expression)expression1, "^", expression2, 11));
                    continue block134;
                }
                case 131: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_LONG, expression1, "^", expression2, 11));
                    continue block134;
                }
                case 132: {
                    AbstractLocalVariable localVariable = this.localVariableMaker.getLocalVariable(code[++offset] & 0xFF, offset);
                    this.parseIINC(statements, stack, lineNumber, offset++, localVariable, (byte)(code[offset] & 0xFF));
                    continue block134;
                }
                case 133: {
                    stack.push((Object)new CastExpression(lineNumber, (Type)PrimitiveType.TYPE_LONG, (Expression)stack.pop(), false));
                    continue block134;
                }
                case 134: {
                    stack.push((Object)new CastExpression(lineNumber, (Type)PrimitiveType.TYPE_FLOAT, (Expression)stack.pop(), false));
                    continue block134;
                }
                case 135: 
                case 138: 
                case 141: {
                    stack.push((Object)new CastExpression(lineNumber, (Type)PrimitiveType.TYPE_DOUBLE, (Expression)stack.pop(), false));
                    continue block134;
                }
                case 136: 
                case 139: 
                case 142: {
                    stack.push((Object)new CastExpression(lineNumber, (Type)PrimitiveType.TYPE_INT, ByteCodeParser.forceExplicitCastExpression((Expression)stack.pop())));
                    continue block134;
                }
                case 137: 
                case 144: {
                    stack.push((Object)new CastExpression(lineNumber, (Type)PrimitiveType.TYPE_FLOAT, ByteCodeParser.forceExplicitCastExpression((Expression)stack.pop())));
                    continue block134;
                }
                case 140: 
                case 143: {
                    stack.push((Object)new CastExpression(lineNumber, (Type)PrimitiveType.TYPE_LONG, ByteCodeParser.forceExplicitCastExpression((Expression)stack.pop())));
                    continue block134;
                }
                case 145: {
                    stack.push((Object)new CastExpression(lineNumber, (Type)PrimitiveType.TYPE_BYTE, ByteCodeParser.forceExplicitCastExpression((Expression)stack.pop())));
                    continue block134;
                }
                case 146: {
                    stack.push((Object)new CastExpression(lineNumber, (Type)PrimitiveType.TYPE_CHAR, ByteCodeParser.forceExplicitCastExpression((Expression)stack.pop())));
                    continue block134;
                }
                case 147: {
                    stack.push((Object)new CastExpression(lineNumber, (Type)PrimitiveType.TYPE_SHORT, ByteCodeParser.forceExplicitCastExpression((Expression)stack.pop())));
                    continue block134;
                }
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)new ClassFileCmpExpression(lineNumber, (Expression)expression1, expression2));
                    continue block134;
                }
                case 153: {
                    this.parseIF(stack, lineNumber, basicBlock, "!=", "==", 8);
                    offset += 2;
                    continue block134;
                }
                case 154: {
                    this.parseIF(stack, lineNumber, basicBlock, "==", "!=", 8);
                    offset += 2;
                    continue block134;
                }
                case 155: {
                    this.parseIF(stack, lineNumber, basicBlock, ">=", "<", 7);
                    offset += 2;
                    continue block134;
                }
                case 156: {
                    this.parseIF(stack, lineNumber, basicBlock, "<", ">=", 7);
                    offset += 2;
                    continue block134;
                }
                case 157: {
                    this.parseIF(stack, lineNumber, basicBlock, "<=", ">", 7);
                    offset += 2;
                    continue block134;
                }
                case 158: {
                    this.parseIF(stack, lineNumber, basicBlock, ">", "<=", 7);
                    offset += 2;
                    continue block134;
                }
                case 159: 
                case 165: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)this.newIntegerOrBooleanComparisonOperatorExpression(lineNumber, (Expression)expression1, basicBlock.mustInverseCondition() ? "!=" : "==", expression2, 9));
                    offset += 2;
                    continue block134;
                }
                case 160: 
                case 166: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)this.newIntegerOrBooleanComparisonOperatorExpression(lineNumber, (Expression)expression1, basicBlock.mustInverseCondition() ? "==" : "!=", expression2, 9));
                    offset += 2;
                    continue block134;
                }
                case 161: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)this.newIntegerComparisonOperatorExpression(lineNumber, (Expression)expression1, basicBlock.mustInverseCondition() ? ">=" : "<", expression2, 8));
                    offset += 2;
                    continue block134;
                }
                case 162: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)this.newIntegerComparisonOperatorExpression(lineNumber, (Expression)expression1, basicBlock.mustInverseCondition() ? "<" : ">=", expression2, 8));
                    offset += 2;
                    continue block134;
                }
                case 163: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)this.newIntegerComparisonOperatorExpression(lineNumber, (Expression)expression1, basicBlock.mustInverseCondition() ? "<=" : ">", expression2, 8));
                    offset += 2;
                    continue block134;
                }
                case 164: {
                    Expression expression2 = (Expression)stack.pop();
                    Object expression1 = (Expression)stack.pop();
                    stack.push((Object)this.newIntegerComparisonOperatorExpression(lineNumber, (Expression)expression1, basicBlock.mustInverseCondition() ? ">" : "<=", expression2, 8));
                    offset += 2;
                    continue block134;
                }
                case 168: {
                    stack.push((Object)JSR_RETURN_ADDRESS_EXPRESSION);
                }
                case 167: {
                    offset += 2;
                    continue block134;
                }
                case 169: {
                    ++offset;
                    continue block134;
                }
                case 170: {
                    offset = offset + 4 & 0xFFFC;
                    offset += 4;
                    int low = (code[offset++] & 0xFF) << 24 | (code[offset++] & 0xFF) << 16 | (code[offset++] & 0xFF) << 8 | code[offset++] & 0xFF;
                    int high = (code[offset++] & 0xFF) << 24 | (code[offset++] & 0xFF) << 16 | (code[offset++] & 0xFF) << 8 | code[offset++] & 0xFF;
                    offset += 4 * (high - low + 1) - 1;
                    statements.add((Object)new SwitchStatement((Expression)stack.pop(), (List)new DefaultList(high - low + 2)));
                    continue block134;
                }
                case 171: {
                    offset = offset + 4 & 0xFFFC;
                    offset += 4;
                    int count = (code[offset++] & 0xFF) << 24 | (code[offset++] & 0xFF) << 16 | (code[offset++] & 0xFF) << 8 | code[offset++] & 0xFF;
                    offset += 8 * count - 1;
                    statements.add((Object)new SwitchStatement((Expression)stack.pop(), (List)new DefaultList(count + 1)));
                    continue block134;
                }
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: {
                    this.parseXRETURN(statements, stack, lineNumber);
                    continue block134;
                }
                case 177: {
                    if (method.isSynthetic() && method.getName().contains("lambda$") && !stack.isEmpty()) {
                        statements.add((Object)new ExpressionStatement((Expression)stack.pop()));
                        continue block134;
                    }
                    statements.add((Object)ReturnStatement.RETURN);
                    continue block134;
                }
                case 178: {
                    this.parseGetStatic(stack, constants, lineNumber, (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    continue block134;
                }
                case 179: {
                    this.parsePutStatic(statements, stack, constants, lineNumber, (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    continue block134;
                }
                case 180: {
                    this.parseGetField(stack, constants, lineNumber, (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    continue block134;
                }
                case 181: {
                    this.parsePutField(statements, stack, constants, lineNumber, (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    continue block134;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    Object expression1;
                    ConstantCP constantMemberRef = (ConstantCP)constants.getConstant((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    String typeName = constants.getConstantString(constantMemberRef.getClassIndex(), (byte)7);
                    ObjectType ot = this.typeMaker.makeFromDescriptorOrInternalTypeName(typeName);
                    ConstantNameAndType constantNameAndType = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
                    String name = constants.getConstantString(constantNameAndType.getNameIndex(), (byte)1);
                    String descriptor = constants.getConstantString(constantNameAndType.getSignatureIndex(), (byte)1);
                    TypeMaker.MethodTypes methodTypes = this.makeMethodTypes(ot.getInternalName(), name, descriptor);
                    methodTypes.handlePolymorphicSignature(typeName, name);
                    BaseExpression parameters = ByteCodeParser.extractParametersFromStack(statements, stack, methodTypes.getParameterTypes());
                    if (opcode == 184) {
                        expression1 = this.typeParametersToTypeArgumentsBinder.newMethodInvocationExpression(lineNumber, (Expression)new ObjectTypeReferenceExpression(lineNumber, ot), ot, name, descriptor, methodTypes, parameters);
                        if (PrimitiveType.TYPE_VOID.equals((Object)methodTypes.getReturnedType())) {
                            this.typeParametersToTypeArgumentsBinder.setExceptionTypes(this.exceptionTypes);
                            this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes((Type)ObjectType.TYPE_OBJECT, (Expression)expression1);
                            statements.add((Object)new ExpressionStatement(expression1));
                            continue block134;
                        }
                        stack.push(expression1);
                        continue block134;
                    }
                    expression1 = (Expression)stack.pop();
                    if (expression1 instanceof NewExpression && expression1.getType().isInnerObjectType() && !enclosingInstances.isEmpty()) {
                        ((NewExpression)expression1).setQualifier(enclosingInstances.pop());
                    }
                    if (expression1.isLocalVariableReferenceExpression()) {
                        ((ClassFileLocalVariableReferenceExpression)expression1).getLocalVariable().typeOnLeft(this.typeBounds, (Type)ot);
                    }
                    if (opcode == 185) {
                        offset += 2;
                    }
                    if (PrimitiveType.TYPE_VOID.equals((Object)methodTypes.getReturnedType())) {
                        if (opcode == 183 && "<init>".equals(name)) {
                            if (expression1.isNewExpression()) {
                                this.typeParametersToTypeArgumentsBinder.updateNewExpression((ClassFileNewExpression)((Object)expression1), descriptor, methodTypes, parameters);
                                continue block134;
                            }
                            if (ot.getDescriptor().equals(expression1.getType().getDescriptor())) {
                                statements.add((Object)new ExpressionStatement((Expression)this.typeParametersToTypeArgumentsBinder.newConstructorInvocationExpression(lineNumber, ot, descriptor, methodTypes, parameters)));
                                continue block134;
                            }
                            statements.add((Object)new ExpressionStatement((Expression)this.typeParametersToTypeArgumentsBinder.newSuperConstructorInvocationExpression(lineNumber, ot, descriptor, methodTypes, parameters)));
                            continue block134;
                        }
                        expression1 = this.typeParametersToTypeArgumentsBinder.newMethodInvocationExpression(lineNumber, this.getMethodInstanceReference((Expression)expression1, ot, name, descriptor), ot, name, descriptor, methodTypes, parameters);
                        this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes((Type)ObjectType.TYPE_OBJECT, (Expression)expression1);
                        statements.add((Object)new ExpressionStatement(expression1));
                        continue block134;
                    }
                    if (opcode == 182 && "toString".equals(name) && "()Ljava/lang/String;".equals(descriptor) && ("java/lang/StringBuilder".equals(typeName = constants.getConstantString(constantMemberRef.getClassIndex(), (byte)7)) || "java/lang/StringBuffer".equals(typeName))) {
                        stack.push((Object)StringConcatenationUtil.create(expression1, lineNumber, typeName));
                        continue block134;
                    }
                    stack.push((Object)this.typeParametersToTypeArgumentsBinder.newMethodInvocationExpression(lineNumber, this.getMethodInstanceReference((Expression)expression1, ot, name, descriptor), ot, name, descriptor, methodTypes, parameters));
                    continue block134;
                }
                case 186: {
                    this.parseInvokeDynamic(statements, stack, constants, lineNumber, (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    offset += 2;
                    continue block134;
                }
                case 187: {
                    String typeName = constants.getConstantString((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF, (byte)7);
                    stack.push((Object)this.newNewExpression(lineNumber, typeName));
                    continue block134;
                }
                case 188: {
                    Type type1 = PrimitiveTypeUtil.getPrimitiveTypeFromTag((int)(code[++offset] & 0xFF)).createType(1);
                    stack.push((Object)new NewArray(lineNumber, type1, (BaseExpression)stack.pop()));
                    continue block134;
                }
                case 189: {
                    ObjectType ot;
                    Type type1;
                    String typeName = constants.getConstantString((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF, (byte)7);
                    if (typeName.charAt(0) == '[') {
                        type1 = this.typeMaker.makeFromDescriptor(typeName);
                        type1 = type1.createType(type1.getDimension() + 1);
                    } else {
                        type1 = this.typeMaker.makeFromInternalTypeName(typeName).createType(1);
                    }
                    if (typeName.endsWith(ObjectType.TYPE_CLASS.getInternalName()) && (ot = (ObjectType)type1).getTypeArguments() == null) {
                        type1 = ot.createType((BaseTypeArgument)WildcardTypeArgument.WILDCARD_TYPE_ARGUMENT);
                    }
                    stack.push((Object)new NewArray(lineNumber, type1, (BaseExpression)stack.pop()));
                    continue block134;
                }
                case 190: {
                    stack.push((Object)new LengthExpression(lineNumber, (Expression)stack.pop()));
                    continue block134;
                }
                case 191: {
                    statements.add((Object)new ThrowStatement((Expression)stack.pop()));
                    continue block134;
                }
                case 192: {
                    TypeParameterWithTypeBounds typeParameterWithTypeBounds;
                    String identifier;
                    TypeMaker.TypeTypes typeTypes;
                    String typeName = constants.getConstantString((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF, (byte)7);
                    Type type1 = this.typeMaker.makeFromDescriptorOrInternalTypeName(typeName);
                    Object expression1 = (Expression)stack.peek();
                    if (type1.isObjectType() && expression1.getType().isObjectType() && this.typeMaker.isRawTypeAssignable((ObjectType)type1, (ObjectType)expression1.getType())) continue block134;
                    if (expression1.isCastExpression()) {
                        ((CastExpression)expression1).setType(type1);
                        continue block134;
                    }
                    boolean castNeeded = true;
                    if (expression1.getType().isGenericType() && (typeTypes = this.typeMaker.makeTypeTypes(typeName)) != null && typeTypes.getTypeParameters() instanceof TypeParameterWithTypeBounds && (identifier = (typeParameterWithTypeBounds = (TypeParameterWithTypeBounds)typeTypes.getTypeParameters()).getIdentifier()).equals(expression1.getType().getName()) && type1 instanceof ObjectType && typeParameterWithTypeBounds.getTypeBounds() instanceof ObjectType && this.typeMaker.isRawTypeAssignable((ObjectType)type1, (ObjectType)typeParameterWithTypeBounds.getTypeBounds())) {
                        castNeeded = false;
                    }
                    if (!castNeeded) continue block134;
                    this.searchFirstLineNumberVisitor.init();
                    expression1.accept((ExpressionVisitor)this.searchFirstLineNumberVisitor);
                    CastExpression castExpression = new CastExpression(this.searchFirstLineNumberVisitor.getLineNumber(), type1, ByteCodeParser.forceExplicitCastExpression((Expression)stack.pop()), true, true);
                    stack.push((Object)castExpression);
                    continue block134;
                }
                case 193: {
                    String typeName = constants.getConstantString((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF, (byte)7);
                    Type type1 = this.typeMaker.makeFromDescriptorOrInternalTypeName(typeName);
                    if (type1 == null) {
                        type1 = PrimitiveTypeUtil.getPrimitiveTypeFromDescriptor((String)typeName);
                    }
                    stack.push((Object)new InstanceOfExpression(lineNumber, (Expression)stack.pop(), type1));
                    continue block134;
                }
                case 194: {
                    statements.add((Object)new ClassFileMonitorEnterStatement((Expression)stack.pop()));
                    continue block134;
                }
                case 195: {
                    statements.add((Object)new ClassFileMonitorExitStatement((Expression)stack.pop()));
                    continue block134;
                }
                case 196: {
                    int count;
                    Expression valueRef;
                    AbstractLocalVariable localVariable;
                    opcode = code[++offset] & 0xFF;
                    int i = (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF;
                    if (opcode == 132) {
                        count = (short)((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                        this.parseIINC(statements, stack, lineNumber, offset, this.localVariableMaker.getLocalVariable(i, offset), count);
                        continue block134;
                    }
                    switch (opcode) {
                        case 21: {
                            localVariable = this.localVariableMaker.getLocalVariable(i, offset + 4);
                            ByteCodeParser.parseILOAD(statements, stack, lineNumber, offset, localVariable);
                            continue block134;
                        }
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: {
                            stack.push((Object)new ClassFileLocalVariableReferenceExpression(lineNumber, offset, this.localVariableMaker.getLocalVariable(i, offset)));
                            continue block134;
                        }
                        case 54: {
                            valueRef = (Expression)stack.pop();
                            localVariable = this.getLocalVariableInAssignment(i, offset + 4, valueRef);
                            statements.add((Object)new ExpressionStatement((Expression)new BinaryOperatorExpression(lineNumber, localVariable.getType(), (Expression)new ClassFileLocalVariableReferenceExpression(lineNumber, offset, localVariable), "=", valueRef, 16)));
                            continue block134;
                        }
                        case 55: {
                            valueRef = (Expression)stack.pop();
                            localVariable = this.getLocalVariableInAssignment(i, offset + 4, valueRef);
                            statements.add((Object)new ExpressionStatement((Expression)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_LONG, (Expression)new ClassFileLocalVariableReferenceExpression(lineNumber, offset, localVariable), "=", valueRef, 16)));
                            continue block134;
                        }
                        case 56: {
                            valueRef = (Expression)stack.pop();
                            localVariable = this.getLocalVariableInAssignment(i, offset + 4, valueRef);
                            statements.add((Object)new ExpressionStatement((Expression)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_FLOAT, (Expression)new ClassFileLocalVariableReferenceExpression(lineNumber, offset, localVariable), "=", valueRef, 16)));
                            continue block134;
                        }
                        case 57: {
                            valueRef = (Expression)stack.pop();
                            localVariable = this.getLocalVariableInAssignment(i, offset + 4, valueRef);
                            statements.add((Object)new ExpressionStatement((Expression)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_DOUBLE, (Expression)new ClassFileLocalVariableReferenceExpression(lineNumber, offset, localVariable), "=", valueRef, 16)));
                            continue block134;
                        }
                        case 58: {
                            valueRef = (Expression)stack.pop();
                            localVariable = this.getLocalVariableInAssignment(i, offset + 4, valueRef);
                            this.parseASTORE(statements, stack, lineNumber, offset, localVariable, valueRef);
                            continue block134;
                        }
                    }
                    continue block134;
                }
                case 197: {
                    String typeName = constants.getConstantString((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF, (byte)7);
                    Type type1 = this.typeMaker.makeFromDescriptor(typeName);
                    int i = code[++offset] & 0xFF;
                    Expressions dimensions = new Expressions(i);
                    while (i-- > 0) {
                        dimensions.add((Object)((Expression)stack.pop()));
                    }
                    Collections.reverse(dimensions);
                    stack.push((Object)new NewArray(lineNumber, type1, (BaseExpression)dimensions));
                    continue block134;
                }
                case 198: {
                    Object expression1 = (Expression)stack.pop();
                    this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes((Type)ObjectType.TYPE_OBJECT, (Expression)expression1);
                    stack.push((Object)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_BOOLEAN, expression1, basicBlock.mustInverseCondition() ? "!=" : "==", (Expression)new NullExpression(expression1.getLineNumber(), expression1.getType()), 9));
                    ByteCodeParser.checkStack(stack, code, offset += 2);
                    continue block134;
                }
                case 199: {
                    Object expression1 = (Expression)stack.pop();
                    this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes((Type)ObjectType.TYPE_OBJECT, (Expression)expression1);
                    stack.push((Object)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_BOOLEAN, expression1, basicBlock.mustInverseCondition() ? "==" : "!=", (Expression)new NullExpression(expression1.getLineNumber(), expression1.getType()), 9));
                    ByteCodeParser.checkStack(stack, code, offset += 2);
                    continue block134;
                }
                case 201: {
                    stack.push((Object)JSR_RETURN_ADDRESS_EXPRESSION);
                }
                case 200: {
                    offset += 4;
                }
            }
        }
    }

    private static BaseExpression extractParametersFromStack(Statements statements, DefaultStack<Expression> stack, BaseType parameterTypes) {
        int count;
        if (parameterTypes == null) {
            return null;
        }
        switch (parameterTypes.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Expression parameter = (Expression)stack.pop();
                if (parameter.isNewArray()) {
                    parameter = NewArrayMaker.make(statements, parameter);
                }
                return ByteCodeParser.checkIfLastStatementIsAMultiAssignment(statements, parameter);
            }
        }
        Expressions parameters = new Expressions(parameterTypes.size());
        for (int i = count = parameterTypes.size() - 1; i >= 0; --i) {
            if (stack.isEmpty()) continue;
            Expression parameter = (Expression)stack.pop();
            if (parameter.isNewArray()) {
                parameter = NewArrayMaker.make(statements, parameter);
            }
            parameters.add((Object)ByteCodeParser.checkIfLastStatementIsAMultiAssignment(statements, parameter));
        }
        Collections.reverse(parameters);
        return parameters;
    }

    private static Expression checkIfLastStatementIsAMultiAssignment(Statements statements, Expression parameter) {
        Expression expression;
        if (!statements.isEmpty() && (expression = ((Statement)statements.getLast()).getExpression()).isBinaryOperatorExpression() && ByteCodeParser.getLastRightExpression(expression) == parameter) {
            statements.removeLast();
            return expression;
        }
        return parameter;
    }

    private AbstractLocalVariable getLocalVariableInAssignment(int index, int offset, Expression value) {
        Type valueType = value.getType();
        if (value.isNullExpression()) {
            return this.localVariableMaker.getLocalVariableInNullAssignment(index, offset, valueType);
        }
        if (value.isLocalVariableReferenceExpression()) {
            AbstractLocalVariable valueLocalVariable = ((ClassFileLocalVariableReferenceExpression)value).getLocalVariable();
            AbstractLocalVariable lv = this.localVariableMaker.getLocalVariableInAssignment(this.typeBounds, index, offset, valueLocalVariable);
            valueLocalVariable.variableOnLeft(this.typeBounds, lv);
            return lv;
        }
        if (value.isMethodInvocationExpression()) {
            if (valueType.isObjectType()) {
                valueType = ((ObjectType)valueType).createType(null);
            } else if (valueType.isGenericType()) {
                valueType = ObjectType.TYPE_UNDEFINED_OBJECT;
            }
        }
        return this.localVariableMaker.getLocalVariableInAssignment(this.typeBounds, index, offset, valueType);
    }

    private void parseLDC(DefaultStack<Expression> stack, ConstantPool constants, int lineNumber, Constant constant) {
        switch (constant.getTag()) {
            case 3: {
                int i = ((ConstantInteger)constant).getBytes();
                stack.push((Object)new IntegerConstantExpression(lineNumber, (Type)PrimitiveTypeUtil.getPrimitiveTypeFromValue((int)i), i));
                break;
            }
            case 4: {
                float f = ((ConstantFloat)constant).getBytes();
                if (Float.compare(f, Float.MIN_VALUE) == 0) {
                    stack.push((Object)new FieldReferenceExpression(lineNumber, (Type)PrimitiveType.TYPE_FLOAT, (Expression)new ObjectTypeReferenceExpression(lineNumber, ObjectType.TYPE_FLOAT), "java/lang/Float", "MIN_VALUE", "F"));
                    break;
                }
                if (Float.compare(f, Float.MAX_VALUE) == 0) {
                    stack.push((Object)new FieldReferenceExpression(lineNumber, (Type)PrimitiveType.TYPE_FLOAT, (Expression)new ObjectTypeReferenceExpression(lineNumber, ObjectType.TYPE_FLOAT), "java/lang/Float", "MAX_VALUE", "F"));
                    break;
                }
                if (Float.compare(f, Float.NEGATIVE_INFINITY) == 0) {
                    stack.push((Object)new FieldReferenceExpression(lineNumber, (Type)PrimitiveType.TYPE_FLOAT, (Expression)new ObjectTypeReferenceExpression(lineNumber, ObjectType.TYPE_FLOAT), "java/lang/Float", "NEGATIVE_INFINITY", "F"));
                    break;
                }
                if (Float.compare(f, Float.POSITIVE_INFINITY) == 0) {
                    stack.push((Object)new FieldReferenceExpression(lineNumber, (Type)PrimitiveType.TYPE_FLOAT, (Expression)new ObjectTypeReferenceExpression(lineNumber, ObjectType.TYPE_FLOAT), "java/lang/Float", "POSITIVE_INFINITY", "F"));
                    break;
                }
                if (Float.isNaN(f)) {
                    stack.push((Object)new FieldReferenceExpression(lineNumber, (Type)PrimitiveType.TYPE_FLOAT, (Expression)new ObjectTypeReferenceExpression(lineNumber, ObjectType.TYPE_FLOAT), "java/lang/Float", "NaN", "F"));
                    break;
                }
                stack.push((Object)new FloatConstantExpression(lineNumber, f));
                break;
            }
            case 7: {
                int typeNameIndex = ((ConstantClass)constant).getNameIndex();
                String typeName = ((ConstantUtf8)constants.getConstant(typeNameIndex)).getBytes();
                ObjectType type = this.typeMaker.makeFromDescriptorOrInternalTypeName(typeName);
                if (type == null) {
                    type = PrimitiveTypeUtil.getPrimitiveTypeFromDescriptor((String)typeName);
                }
                stack.push((Object)new TypeReferenceDotClassExpression(lineNumber, (Type)type));
                break;
            }
            case 5: {
                long l = ((ConstantLong)constant).getBytes();
                if (l == Long.MIN_VALUE) {
                    stack.push((Object)new FieldReferenceExpression(lineNumber, (Type)PrimitiveType.TYPE_LONG, (Expression)new ObjectTypeReferenceExpression(lineNumber, ObjectType.TYPE_LONG), "java/lang/Long", "MIN_VALUE", "J"));
                    break;
                }
                if (l == Long.MAX_VALUE) {
                    stack.push((Object)new FieldReferenceExpression(lineNumber, (Type)PrimitiveType.TYPE_LONG, (Expression)new ObjectTypeReferenceExpression(lineNumber, ObjectType.TYPE_LONG), "java/lang/Long", "MAX_VALUE", "J"));
                    break;
                }
                stack.push((Object)new LongConstantExpression(lineNumber, l));
                break;
            }
            case 6: {
                double d = ((ConstantDouble)constant).getBytes();
                if (Double.compare(d, Double.MIN_VALUE) == 0) {
                    stack.push((Object)new FieldReferenceExpression(lineNumber, (Type)PrimitiveType.TYPE_DOUBLE, (Expression)new ObjectTypeReferenceExpression(lineNumber, ObjectType.TYPE_DOUBLE), "java/lang/Double", "MIN_VALUE", "D"));
                    break;
                }
                if (Double.compare(d, Double.MAX_VALUE) == 0) {
                    stack.push((Object)new FieldReferenceExpression(lineNumber, (Type)PrimitiveType.TYPE_DOUBLE, (Expression)new ObjectTypeReferenceExpression(lineNumber, ObjectType.TYPE_DOUBLE), "java/lang/Double", "MAX_VALUE", "D"));
                    break;
                }
                if (Double.compare(d, Double.NEGATIVE_INFINITY) == 0) {
                    stack.push((Object)new FieldReferenceExpression(lineNumber, (Type)PrimitiveType.TYPE_DOUBLE, (Expression)new ObjectTypeReferenceExpression(lineNumber, ObjectType.TYPE_DOUBLE), "java/lang/Double", "NEGATIVE_INFINITY", "D"));
                    break;
                }
                if (Double.compare(d, Double.POSITIVE_INFINITY) == 0) {
                    stack.push((Object)new FieldReferenceExpression(lineNumber, (Type)PrimitiveType.TYPE_DOUBLE, (Expression)new ObjectTypeReferenceExpression(lineNumber, ObjectType.TYPE_DOUBLE), "java/lang/Double", "POSITIVE_INFINITY", "D"));
                    break;
                }
                if (Double.isNaN(d)) {
                    stack.push((Object)new FieldReferenceExpression(lineNumber, (Type)PrimitiveType.TYPE_DOUBLE, (Expression)new ObjectTypeReferenceExpression(lineNumber, ObjectType.TYPE_DOUBLE), "java/lang/Double", "NaN", "D"));
                    break;
                }
                if (Double.compare(d, Math.E) == 0) {
                    stack.push((Object)new FieldReferenceExpression(lineNumber, (Type)PrimitiveType.TYPE_DOUBLE, (Expression)new ObjectTypeReferenceExpression(lineNumber, ObjectType.TYPE_MATH), "java/lang/Math", "E", "D"));
                    break;
                }
                if (Double.compare(d, Math.PI) == 0) {
                    stack.push((Object)new FieldReferenceExpression(lineNumber, (Type)PrimitiveType.TYPE_DOUBLE, (Expression)new ObjectTypeReferenceExpression(lineNumber, ObjectType.TYPE_MATH), "java/lang/Math", "PI", "D"));
                    break;
                }
                stack.push((Object)new DoubleConstantExpression(lineNumber, d));
                break;
            }
            case 8: {
                int stringIndex = ((ConstantString)constant).getStringIndex();
                stack.push((Object)new StringConstantExpression(lineNumber, constants.getConstantString(stringIndex, (byte)1)));
            }
        }
    }

    private static void parseILOAD(Statements statements, DefaultStack<Expression> stack, int lineNumber, int offset, AbstractLocalVariable localVariable) {
        ClassFileLocalVariableReferenceExpression cflvre;
        Expression expression;
        if (!statements.isEmpty() && (expression = ((Statement)statements.getLast()).getExpression()).getLineNumber() == lineNumber && expression.isPreOperatorExpression() && expression.getExpression().isLocalVariableReferenceExpression() && (cflvre = (ClassFileLocalVariableReferenceExpression)expression.getExpression()).getLocalVariable() == localVariable) {
            statements.removeLast();
            stack.push((Object)expression);
            return;
        }
        if (!localVariable.isAssigned() && localVariable.getNext() != null && localVariable.getNext().isAssigned()) {
            stack.push((Object)new ClassFileLocalVariableReferenceExpression(lineNumber, offset, localVariable.getNext()));
        } else {
            stack.push((Object)new ClassFileLocalVariableReferenceExpression(lineNumber, offset, localVariable));
        }
    }

    private void parseSTORE(Statements statements, DefaultStack<Expression> stack, int lineNumber, int offset, AbstractLocalVariable localVariable, Expression valueRef) {
        ClassFileLocalVariableReferenceExpression lvr;
        ClassFileLocalVariableReferenceExpression vre = new ClassFileLocalVariableReferenceExpression(lineNumber, offset, localVariable);
        this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes(vre.getType(), valueRef);
        if (valueRef.getLineNumber() == lineNumber && valueRef.isBinaryOperatorExpression() && valueRef.getLeftExpression().isLocalVariableReferenceExpression() && (lvr = (ClassFileLocalVariableReferenceExpression)valueRef.getLeftExpression()).getLocalVariable() == localVariable) {
            BinaryOperatorExpression boe = (BinaryOperatorExpression)valueRef;
            BinaryOperatorExpression expression = switch (boe.getOperator()) {
                case "*" -> ByteCodeParser.createAssignment(boe, "*=");
                case "/" -> ByteCodeParser.createAssignment(boe, "/=");
                case "%" -> ByteCodeParser.createAssignment(boe, "%=");
                case "<<" -> ByteCodeParser.createAssignment(boe, "<<=");
                case ">>" -> ByteCodeParser.createAssignment(boe, ">>=");
                case ">>>" -> ByteCodeParser.createAssignment(boe, ">>>=");
                case "&" -> ByteCodeParser.createAssignment(boe, "&=");
                case "^" -> ByteCodeParser.createAssignment(boe, "^=");
                case "|" -> ByteCodeParser.createAssignment(boe, "|=");
                case "=" -> boe;
                case "+" -> {
                    if (ByteCodeParser.isPositiveOne(boe.getRightExpression())) {
                        if (ByteCodeParser.stackContainsLocalVariableReference(stack, localVariable)) {
                            stack.pop();
                            stack.push((Object)valueRef);
                            yield this.newPostArithmeticOperatorExpression(boe.getLineNumber(), boe.getLeftExpression(), "++");
                        }
                        yield this.newPreArithmeticOperatorExpression(boe.getLineNumber(), "++", boe.getLeftExpression());
                    }
                    if (ByteCodeParser.isNegativeOne(boe.getRightExpression())) {
                        if (ByteCodeParser.stackContainsLocalVariableReference(stack, localVariable)) {
                            stack.pop();
                            stack.push((Object)valueRef);
                            yield this.newPostArithmeticOperatorExpression(boe.getLineNumber(), boe.getLeftExpression(), "--");
                        }
                        yield this.newPreArithmeticOperatorExpression(boe.getLineNumber(), "--", boe.getLeftExpression());
                    }
                    yield ByteCodeParser.createAssignment(boe, "+=");
                }
                case "-" -> {
                    if (ByteCodeParser.isPositiveOne(boe.getRightExpression())) {
                        if (ByteCodeParser.stackContainsLocalVariableReference(stack, localVariable)) {
                            stack.pop();
                            stack.push((Object)valueRef);
                            yield this.newPostArithmeticOperatorExpression(boe.getLineNumber(), boe.getLeftExpression(), "--");
                        }
                        yield this.newPreArithmeticOperatorExpression(boe.getLineNumber(), "--", boe.getLeftExpression());
                    }
                    if (ByteCodeParser.isNegativeOne(boe.getRightExpression())) {
                        if (ByteCodeParser.stackContainsLocalVariableReference(stack, localVariable)) {
                            stack.pop();
                            stack.push((Object)valueRef);
                            yield this.newPostArithmeticOperatorExpression(boe.getLineNumber(), boe.getLeftExpression(), "++");
                        }
                        yield this.newPreArithmeticOperatorExpression(boe.getLineNumber(), "++", boe.getLeftExpression());
                    }
                    yield ByteCodeParser.createAssignment(boe, "-=");
                }
                default -> throw new IllegalStateException("Unexpected value expression");
            };
            if (!stack.isEmpty() && stack.peek() == valueRef) {
                stack.replace((Object)valueRef, (Object)expression);
            } else {
                statements.add((Object)new ExpressionStatement((Expression)expression));
            }
            return;
        }
        this.createAssignment(statements, stack, lineNumber, (Expression)vre, valueRef);
    }

    private static boolean stackContainsLocalVariableReference(DefaultStack<Expression> stack, AbstractLocalVariable localVariable) {
        Expression expression;
        if (!stack.isEmpty() && (expression = (Expression)stack.peek()).isLocalVariableReferenceExpression()) {
            ClassFileLocalVariableReferenceExpression lvr = (ClassFileLocalVariableReferenceExpression)expression;
            return lvr.getLocalVariable() == localVariable;
        }
        return false;
    }

    private void parsePUT(Statements statements, DefaultStack<Expression> stack, int lineNumber, FieldReferenceExpression fr, Expression valueRef) {
        FieldReferenceExpression boefr;
        if (valueRef.isNewArray()) {
            valueRef = NewArrayMaker.make(statements, valueRef);
        }
        this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes(fr.getType(), valueRef);
        if (valueRef.getLineNumber() == lineNumber && valueRef.isBinaryOperatorExpression() && valueRef.getLeftExpression().isFieldReferenceExpression() && (boefr = (FieldReferenceExpression)valueRef.getLeftExpression()).getName().equals(fr.getName()) && boefr.getExpression().getType().equals(fr.getExpression().getType()) && boefr.getExpression().getIndex().getIntegerValue() == fr.getExpression().getIndex().getIntegerValue()) {
            BinaryOperatorExpression boe = (BinaryOperatorExpression)valueRef;
            BinaryOperatorExpression expression = switch (boe.getOperator()) {
                case "*" -> ByteCodeParser.createAssignment(boe, "*=");
                case "/" -> ByteCodeParser.createAssignment(boe, "/=");
                case "%" -> ByteCodeParser.createAssignment(boe, "%=");
                case "<<" -> ByteCodeParser.createAssignment(boe, "<<=");
                case ">>" -> ByteCodeParser.createAssignment(boe, ">>=");
                case ">>>" -> ByteCodeParser.createAssignment(boe, ">>>=");
                case "&" -> ByteCodeParser.createAssignment(boe, "&=");
                case "^" -> ByteCodeParser.createAssignment(boe, "^=");
                case "|" -> ByteCodeParser.createAssignment(boe, "|=");
                case "=" -> boe;
                case "+" -> {
                    if (ByteCodeParser.isPositiveOne(boe.getRightExpression())) {
                        if (ByteCodeParser.stackContainsFieldReference(stack, fr)) {
                            stack.pop();
                            stack.push((Object)valueRef);
                            yield this.newPostArithmeticOperatorExpression(boe.getLineNumber(), boe.getLeftExpression(), "++");
                        }
                        yield this.newPreArithmeticOperatorExpression(boe.getLineNumber(), "++", boe.getLeftExpression());
                    }
                    if (ByteCodeParser.isNegativeOne(boe.getRightExpression())) {
                        if (ByteCodeParser.stackContainsFieldReference(stack, fr)) {
                            stack.pop();
                            stack.push((Object)valueRef);
                            yield this.newPostArithmeticOperatorExpression(boe.getLineNumber(), boe.getLeftExpression(), "--");
                        }
                        yield this.newPreArithmeticOperatorExpression(boe.getLineNumber(), "--", boe.getLeftExpression());
                    }
                    yield ByteCodeParser.createAssignment(boe, "+=");
                }
                case "-" -> {
                    if (ByteCodeParser.isPositiveOne(boe.getRightExpression())) {
                        if (ByteCodeParser.stackContainsFieldReference(stack, fr)) {
                            stack.pop();
                            stack.push((Object)valueRef);
                            yield this.newPostArithmeticOperatorExpression(boe.getLineNumber(), boe.getLeftExpression(), "--");
                        }
                        yield this.newPreArithmeticOperatorExpression(boe.getLineNumber(), "--", boe.getLeftExpression());
                    }
                    if (ByteCodeParser.isNegativeOne(boe.getRightExpression())) {
                        if (ByteCodeParser.stackContainsFieldReference(stack, fr)) {
                            stack.pop();
                            stack.push((Object)valueRef);
                            yield this.newPostArithmeticOperatorExpression(boe.getLineNumber(), boe.getLeftExpression(), "++");
                        }
                        yield this.newPreArithmeticOperatorExpression(boe.getLineNumber(), "++", boe.getLeftExpression());
                    }
                    yield ByteCodeParser.createAssignment(boe, "-=");
                }
                default -> throw new IllegalStateException("Unexpected value expression");
            };
            if (!stack.isEmpty() && stack.peek() == valueRef) {
                stack.replace((Object)valueRef, (Object)expression);
            } else {
                statements.add((Object)new ExpressionStatement((Expression)expression));
            }
            return;
        }
        this.createAssignment(statements, stack, lineNumber, (Expression)fr, valueRef);
    }

    private void parseInvokeDynamic(Statements statements, DefaultStack<Expression> stack, ConstantPool constants, int lineNumber, int index) {
        MethodInvocationExpression mie;
        Expression expression;
        if (!statements.isEmpty() && (expression = ((Statement)statements.getLast()).getExpression()).isMethodInvocationExpression() && "getClass".equals((mie = (MethodInvocationExpression)expression).getName()) && "()Ljava/lang/Class;".equals(mie.getDescriptor()) && "java/lang/Object".equals(mie.getInternalTypeName())) {
            statements.removeLast();
        }
        ConstantCP constantMemberRef = (ConstantCP)constants.getConstant(index);
        ConstantNameAndType indyCnat = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
        String indyMethodName = constants.getConstantString(indyCnat.getNameIndex(), (byte)1);
        String indyDescriptor = constants.getConstantString(indyCnat.getSignatureIndex(), (byte)1);
        TypeMaker.MethodTypes indyMethodTypes = this.typeMaker.makeMethodTypes(this.internalTypeName, indyMethodName, indyDescriptor);
        BaseExpression indyParameters = ByteCodeParser.extractParametersFromStack(statements, stack, indyMethodTypes.getParameterTypes());
        BootstrapMethod bootstrapMethod = this.attributeBootstrapMethods.getBootstrapMethods()[constantMemberRef.getClassIndex()];
        int[] bootstrapArguments = bootstrapMethod.getBootstrapArguments();
        if ("makeConcatWithConstants".equals(indyMethodName)) {
            String recipe = constants.getConstantString(bootstrapArguments[0], (byte)8);
            stack.push((Object)StringConcatenationUtil.create(recipe, indyParameters));
            return;
        }
        if ("makeConcat".equals(indyMethodName)) {
            stack.push((Object)StringConcatenationUtil.create(indyParameters));
            return;
        }
        ConstantMethodType cmt0 = (ConstantMethodType)constants.getConstant(bootstrapArguments[0]);
        String descriptor0 = constants.getConstantString(cmt0.getDescriptorIndex(), (byte)1);
        TypeMaker.MethodTypes methodTypes0 = this.typeMaker.makeMethodTypes(this.internalTypeName, null, descriptor0);
        int parameterCount = methodTypes0.getParameterTypes() == null ? 0 : methodTypes0.getParameterTypes().size();
        ConstantMethodHandle constantMethodHandle1 = (ConstantMethodHandle)constants.getConstant(bootstrapArguments[1]);
        ConstantCP cmr1 = (ConstantCP)constants.getConstant(constantMethodHandle1.getReferenceIndex());
        String typeName = constants.getConstantString(cmr1.getClassIndex(), (byte)7);
        ConstantNameAndType cnat1 = (ConstantNameAndType)constants.getConstant(cmr1.getNameAndTypeIndex());
        String name1 = constants.getConstantString(cnat1.getNameIndex(), (byte)1);
        String descriptor1 = constants.getConstantString(cnat1.getSignatureIndex(), (byte)1);
        if (typeName.equals(this.internalTypeName)) {
            for (ClassFileConstructorOrMethodDeclaration methodDeclaration : this.bodyDeclaration.getMethodDeclarations()) {
                if ((methodDeclaration.getFlags() & 0x1002) != 4098 || !methodDeclaration.getMethod().getName().equals(name1) || !methodDeclaration.getMethod().getSignature().equals(descriptor1)) continue;
                ClassFileMethodDeclaration cfmd = (ClassFileMethodDeclaration)methodDeclaration;
                if (cfmd.getStatements() == null) {
                    CreateInstructionsVisitor createInstructionsVisitor = new CreateInstructionsVisitor(this.typeMaker);
                    createInstructionsVisitor.createParametersVariablesAndStatements(cfmd, false);
                }
                stack.push((Object)new LambdaIdentifiersExpression(lineNumber, indyMethodTypes.getReturnedType(), indyMethodTypes.getReturnedType(), this.prepareLambdaParameterNames(cfmd.getFormalParameters(), parameterCount), this.prepareLambdaStatements(cfmd.getFormalParameters(), indyParameters, cfmd.getStatements())));
                return;
            }
        }
        if (indyParameters == null) {
            ObjectType ot = this.typeMaker.makeFromInternalTypeName(typeName);
            if ("<init>".equals(name1)) {
                stack.push((Object)new ConstructorReferenceExpression(lineNumber, indyMethodTypes.getReturnedType(), ot, descriptor1));
            } else {
                stack.push((Object)new MethodReferenceExpression(lineNumber, indyMethodTypes.getReturnedType(), (Expression)new ObjectTypeReferenceExpression(lineNumber, ot), typeName, name1, descriptor1));
            }
            return;
        }
        if (indyParameters instanceof Expression) {
            stack.push((Object)new MethodReferenceExpression(lineNumber, indyMethodTypes.getReturnedType(), (Expression)indyParameters, typeName, name1, descriptor1));
        }
        if (indyParameters instanceof Expressions) {
            stack.push((Object)new MethodReferenceExpression(lineNumber, indyMethodTypes.getReturnedType(), (Expression)((Expressions)indyParameters).getFirst(), typeName, name1, descriptor1));
        }
    }

    private List<String> prepareLambdaParameterNames(BaseFormalParameter formalParameters, int parameterCount) {
        if (formalParameters == null || parameterCount == 0) {
            return null;
        }
        this.lambdaParameterNamesVisitor.init();
        formalParameters.accept((DeclarationVisitor)this.lambdaParameterNamesVisitor);
        List<String> names = this.lambdaParameterNamesVisitor.getNames();
        assert (names.size() >= parameterCount);
        if (names.size() == parameterCount) {
            return names;
        }
        return names.subList(names.size() - parameterCount, names.size());
    }

    private BaseStatement prepareLambdaStatements(BaseFormalParameter formalParameters, BaseExpression indyParameters, BaseStatement baseStatement) {
        if (baseStatement != null) {
            Statement statement;
            int size;
            if (formalParameters != null && indyParameters != null && (size = indyParameters.size()) > 0 && size <= formalParameters.size()) {
                String newName;
                String name;
                HashMap<String, String> mapping = new HashMap<String, String>();
                Expression expression = (Expression)indyParameters.getFirst();
                if (expression.isLocalVariableReferenceExpression() && !(name = ((FormalParameter)formalParameters.getFirst()).getName()).equals(newName = expression.getName())) {
                    mapping.put(name, newName);
                }
                if (size > 1) {
                    DefaultList formalParameterList = formalParameters.getList();
                    DefaultList list = indyParameters.getList();
                    for (int i = 1; i < size; ++i) {
                        ClassFileFormalParameter classFileFormalParameter;
                        AbstractLocalVariable localVariable;
                        FormalParameter formalParameter;
                        expression = (Expression)list.get(i);
                        if (expression.isLocalVariableReferenceExpression() && (formalParameter = (FormalParameter)formalParameterList.get(i)) instanceof ClassFileFormalParameter && (localVariable = (classFileFormalParameter = (ClassFileFormalParameter)formalParameter).getLocalVariable()).isAssignableFrom(this.typeBounds, expression.getType())) continue;
                    }
                }
                if (!mapping.isEmpty()) {
                    this.renameLocalVariablesVisitor.init(mapping, true);
                    baseStatement.accept((StatementVisitor)this.renameLocalVariablesVisitor);
                }
            }
            if (baseStatement.size() == 1 && ((statement = (Statement)baseStatement.getFirst()).isReturnExpressionStatement() || statement.isExpressionStatement())) {
                return new LambdaExpressionStatement(statement.getExpression());
            }
        }
        return baseStatement;
    }

    private static boolean stackContainsFieldReference(DefaultStack<Expression> stack, FieldReferenceExpression fr) {
        Expression expression;
        if (!stack.isEmpty() && (expression = (Expression)stack.peek()).isFieldReferenceExpression()) {
            return expression.getName().equals(fr.getName()) && expression.getExpression().getType().equals(fr.getExpression().getType());
        }
        return false;
    }

    private static Expression createAssignment(BinaryOperatorExpression boe, String operator) {
        boe.setOperator(operator);
        boe.setPriority(16);
        return boe;
    }

    private static boolean isPositiveOne(Expression expression) {
        return expression.isIntegerConstantExpression() && expression.getIntegerValue() == 1 || expression.isLongConstantExpression() && expression.getLongValue() == 1L || expression.isFloatConstantExpression() && Float.compare(expression.getFloatValue(), 1.0f) == 0 || expression.isDoubleConstantExpression() && Double.compare(expression.getDoubleValue(), 1.0) == 0;
    }

    private static boolean isNegativeOne(Expression expression) {
        return expression.isIntegerConstantExpression() && expression.getIntegerValue() == -1 || expression.isLongConstantExpression() && expression.getLongValue() == -1L || expression.isFloatConstantExpression() && Float.compare(expression.getFloatValue(), -1.0f) == 0 || expression.isDoubleConstantExpression() && Double.compare(expression.getDoubleValue(), -1.0) == 0;
    }

    private void parseASTORE(Statements statements, DefaultStack<Expression> stack, int lineNumber, int offset, AbstractLocalVariable localVariable, Expression valueRef) {
        this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes(localVariable.getType(), valueRef);
        if (!ObjectType.TYPE_OBJECT.equals((Object)localVariable.getType())) {
            localVariable.typeOnRight(this.typeBounds, valueRef.getType());
        }
        ClassFileLocalVariableReferenceExpression vre = new ClassFileLocalVariableReferenceExpression(lineNumber, offset, localVariable);
        Expression oldValueRef = valueRef;
        if (valueRef.isNewArray()) {
            valueRef = NewArrayMaker.make(statements, valueRef);
        }
        if (oldValueRef != valueRef) {
            stack.replace((Object)oldValueRef, (Object)valueRef);
        }
        this.createAssignment(statements, stack, lineNumber, (Expression)vre, valueRef);
    }

    private void parseAASTORE(Statements statements, DefaultStack<Expression> stack, int lineNumber, Expression leftExpression, Expression valueRef) {
        Expression oldValueRef = valueRef;
        if (valueRef.isNewArray()) {
            valueRef = NewArrayMaker.make(statements, valueRef);
        }
        if (oldValueRef != valueRef) {
            stack.replace((Object)oldValueRef, (Object)valueRef);
        }
        this.createAssignment(statements, stack, lineNumber, leftExpression, valueRef);
    }

    private void createAssignment(Statements statements, DefaultStack<Expression> stack, int lineNumber, Expression leftExpression, Expression rightExpression) {
        Statement lastStatement;
        if (!stack.isEmpty() && stack.peek() == rightExpression) {
            stack.push((Object)new BinaryOperatorExpression(lineNumber, leftExpression.getType(), leftExpression, "=", (Expression)stack.pop(), 16));
            return;
        }
        if (!statements.isEmpty() && (lastStatement = (Statement)statements.getLast()).isExpressionStatement()) {
            PostOperatorExpression poe;
            ExpressionStatement lastES = (ExpressionStatement)lastStatement;
            Expression lastExpression = lastStatement.getExpression();
            if (lastExpression.isBinaryOperatorExpression()) {
                if (ByteCodeParser.getLastRightExpression(lastExpression) == rightExpression) {
                    lastES.setExpression((Expression)new BinaryOperatorExpression(lineNumber, leftExpression.getType(), leftExpression, "=", lastExpression, 16));
                    return;
                }
                if (lineNumber > 0 && lastExpression.getLineNumber() == lineNumber && lastExpression.getLeftExpression().getClass() == rightExpression.getClass()) {
                    if (rightExpression.isLocalVariableReferenceExpression()) {
                        ClassFileLocalVariableReferenceExpression lvr1 = (ClassFileLocalVariableReferenceExpression)lastExpression.getLeftExpression();
                        ClassFileLocalVariableReferenceExpression lvr2 = (ClassFileLocalVariableReferenceExpression)rightExpression;
                        if (lvr1.getLocalVariable() == lvr2.getLocalVariable()) {
                            lastES.setExpression((Expression)new BinaryOperatorExpression(lineNumber, leftExpression.getType(), leftExpression, "=", lastExpression, 16));
                            return;
                        }
                    } else if (rightExpression.isFieldReferenceExpression()) {
                        FieldReferenceExpression fr1 = (FieldReferenceExpression)lastExpression.getLeftExpression();
                        FieldReferenceExpression fr2 = (FieldReferenceExpression)rightExpression;
                        if (fr1.getName().equals(fr2.getName()) && fr1.getExpression().getType().equals(fr2.getExpression().getType())) {
                            lastES.setExpression((Expression)new BinaryOperatorExpression(lineNumber, leftExpression.getType(), leftExpression, "=", lastExpression, 16));
                            return;
                        }
                    }
                }
            } else if (lastExpression.isPreOperatorExpression()) {
                if (lastExpression.getExpression().getClass() == rightExpression.getClass()) {
                    if (rightExpression.isLocalVariableReferenceExpression()) {
                        ClassFileLocalVariableReferenceExpression lvr1 = (ClassFileLocalVariableReferenceExpression)lastExpression.getExpression();
                        ClassFileLocalVariableReferenceExpression lvr2 = (ClassFileLocalVariableReferenceExpression)rightExpression;
                        if (lvr1.getLocalVariable() == lvr2.getLocalVariable()) {
                            rightExpression = this.newPreArithmeticOperatorExpression(lastExpression.getLineNumber(), lastExpression.getOperator(), lastExpression.getExpression());
                            statements.removeLast();
                        }
                    } else if (rightExpression.isFieldReferenceExpression()) {
                        FieldReferenceExpression fr1 = (FieldReferenceExpression)lastExpression.getExpression();
                        FieldReferenceExpression fr2 = (FieldReferenceExpression)rightExpression;
                        if (fr1.getName().equals(fr2.getName()) && fr1.getExpression().getType().equals(fr2.getExpression().getType())) {
                            rightExpression = this.newPreArithmeticOperatorExpression(lastExpression.getLineNumber(), lastExpression.getOperator(), lastExpression.getExpression());
                            statements.removeLast();
                        }
                    }
                }
            } else if (lastExpression.isPostOperatorExpression() && (poe = (PostOperatorExpression)lastExpression).getExpression() == rightExpression) {
                rightExpression = poe;
                statements.removeLast();
            }
        }
        statements.add((Object)new ExpressionStatement((Expression)new BinaryOperatorExpression(lineNumber, leftExpression.getType(), leftExpression, "=", rightExpression, 16)));
    }

    private void parseIINC(Statements statements, DefaultStack<Expression> stack, int lineNumber, int offset, AbstractLocalVariable localVariable, int count) {
        ClassFileLocalVariableReferenceExpression exp;
        Object expression;
        if (!stack.isEmpty() && (expression = (Expression)stack.peek()).getLineNumber() == lineNumber && expression.isLocalVariableReferenceExpression() && (exp = (ClassFileLocalVariableReferenceExpression)expression).getLocalVariable() == localVariable) {
            stack.pop();
            if (count == 1) {
                stack.push((Object)this.newPostArithmeticOperatorExpression(lineNumber, (Expression)expression, "++"));
            } else if (count == -1) {
                stack.push((Object)this.newPostArithmeticOperatorExpression(lineNumber, (Expression)expression, "--"));
            } else {
                throw new IllegalStateException();
            }
            return;
        }
        expression = new ClassFileLocalVariableReferenceExpression(lineNumber, offset, localVariable);
        expression = count == 1 ? this.newPreArithmeticOperatorExpression(lineNumber, "++", (Expression)expression) : (count == -1 ? this.newPreArithmeticOperatorExpression(lineNumber, "--", (Expression)expression) : (count >= 0 ? new BinaryOperatorExpression(lineNumber, expression.getType(), expression, "+=", (Expression)new IntegerConstantExpression(lineNumber, expression.getType(), count), 16) : new BinaryOperatorExpression(lineNumber, expression.getType(), expression, "-=", (Expression)new IntegerConstantExpression(lineNumber, expression.getType(), -count), 16)));
        statements.add((Object)new ExpressionStatement(expression));
    }

    private void parseIF(DefaultStack<Expression> stack, int lineNumber, BasicBlock basicBlock, String operator1, String operator2, int priority) {
        Expression expression = (Expression)stack.pop();
        if (expression instanceof ClassFileCmpExpression) {
            ClassFileCmpExpression cmp = (ClassFileCmpExpression)expression;
            this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes(cmp.getLeftExpression().getType(), cmp.getLeftExpression());
            this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes(cmp.getRightExpression().getType(), cmp.getRightExpression());
            stack.push((Object)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_BOOLEAN, cmp.getLeftExpression(), basicBlock.mustInverseCondition() ? operator1 : operator2, cmp.getRightExpression(), priority));
        } else if (expression.getType().isPrimitiveType()) {
            PrimitiveType pt = (PrimitiveType)expression.getType();
            this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes((Type)pt, expression, true);
            switch (pt.getJavaPrimitiveFlags()) {
                case 1: {
                    if (basicBlock.mustInverseCondition() ^ "==".equals(operator1)) {
                        stack.push((Object)expression);
                        break;
                    }
                    stack.push((Object)new PreOperatorExpression(lineNumber, "!", expression));
                    break;
                }
                case 4: {
                    stack.push((Object)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_BOOLEAN, expression, basicBlock.mustInverseCondition() ? operator1 : operator2, (Expression)new FloatConstantExpression(lineNumber, 0.0f), 9));
                    break;
                }
                case 8: {
                    stack.push((Object)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_BOOLEAN, expression, basicBlock.mustInverseCondition() ? operator1 : operator2, (Expression)new DoubleConstantExpression(lineNumber, 0.0), 9));
                    break;
                }
                case 128: {
                    stack.push((Object)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_BOOLEAN, expression, basicBlock.mustInverseCondition() ? operator1 : operator2, (Expression)new LongConstantExpression(lineNumber, 0L), 9));
                    break;
                }
                default: {
                    stack.push((Object)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_BOOLEAN, expression, basicBlock.mustInverseCondition() ? operator1 : operator2, (Expression)new IntegerConstantExpression(lineNumber, (Type)pt, 0), 9));
                    break;
                }
            }
        } else {
            stack.push((Object)new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_BOOLEAN, expression, basicBlock.mustInverseCondition() ? operator1 : operator2, (Expression)new NullExpression(lineNumber, expression.getType()), 9));
        }
    }

    private void parseXRETURN(Statements statements, DefaultStack<Expression> stack, int lineNumber) {
        Expression expression;
        Statement lastStatement;
        Expression valueRef = (Expression)stack.pop();
        if (valueRef.isNewArray()) {
            valueRef = NewArrayMaker.make(statements, valueRef);
        }
        this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes(this.returnedType, valueRef);
        if (lineNumber > valueRef.getLineNumber()) {
            lineNumber = valueRef.getLineNumber();
        }
        if (!statements.isEmpty() && valueRef.isLocalVariableReferenceExpression() && (lastStatement = (Statement)statements.getLast()).isExpressionStatement() && lineNumber <= (expression = ((Statement)statements.getLast()).getExpression()).getLineNumber() && expression.isBinaryOperatorExpression() && "=".equals(expression.getOperator()) && expression.getLeftExpression().isLocalVariableReferenceExpression()) {
            ClassFileLocalVariableReferenceExpression vre1 = (ClassFileLocalVariableReferenceExpression)expression.getLeftExpression();
            ClassFileLocalVariableReferenceExpression vre2 = (ClassFileLocalVariableReferenceExpression)valueRef;
            if (vre1.getLocalVariable() == vre2.getLocalVariable()) {
                this.localVariableMaker.removeLocalVariable(vre1.getLocalVariable());
                statements.removeLast();
                statements.add((Object)new ReturnExpressionStatement(lineNumber, expression.getRightExpression()));
                return;
            }
        }
        statements.add((Object)new ReturnExpressionStatement(lineNumber, valueRef));
    }

    private void parseGetStatic(DefaultStack<Expression> stack, ConstantPool constants, int lineNumber, int index) {
        ConstantCP constantMemberRef = (ConstantCP)constants.getConstant(index);
        String typeName = constants.getConstantString(constantMemberRef.getClassIndex(), (byte)7);
        ConstantNameAndType constantNameAndType = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
        String name = constants.getConstantString(constantNameAndType.getNameIndex(), (byte)1);
        if ("TYPE".equals(name) && typeName.startsWith("java/lang/")) {
            switch (typeName) {
                case "java/lang/Boolean": {
                    stack.push((Object)new TypeReferenceDotClassExpression(lineNumber, (Type)PrimitiveType.TYPE_BOOLEAN));
                    return;
                }
                case "java/lang/Character": {
                    stack.push((Object)new TypeReferenceDotClassExpression(lineNumber, (Type)PrimitiveType.TYPE_CHAR));
                    return;
                }
                case "java/lang/Float": {
                    stack.push((Object)new TypeReferenceDotClassExpression(lineNumber, (Type)PrimitiveType.TYPE_FLOAT));
                    return;
                }
                case "java/lang/Double": {
                    stack.push((Object)new TypeReferenceDotClassExpression(lineNumber, (Type)PrimitiveType.TYPE_DOUBLE));
                    return;
                }
                case "java/lang/Byte": {
                    stack.push((Object)new TypeReferenceDotClassExpression(lineNumber, (Type)PrimitiveType.TYPE_BYTE));
                    return;
                }
                case "java/lang/Short": {
                    stack.push((Object)new TypeReferenceDotClassExpression(lineNumber, (Type)PrimitiveType.TYPE_SHORT));
                    return;
                }
                case "java/lang/Integer": {
                    stack.push((Object)new TypeReferenceDotClassExpression(lineNumber, (Type)PrimitiveType.TYPE_INT));
                    return;
                }
                case "java/lang/Long": {
                    stack.push((Object)new TypeReferenceDotClassExpression(lineNumber, (Type)PrimitiveType.TYPE_LONG));
                    return;
                }
                case "java/lang/Void": {
                    stack.push((Object)new TypeReferenceDotClassExpression(lineNumber, (Type)PrimitiveType.TYPE_VOID));
                    return;
                }
            }
        }
        ObjectType ot = this.typeMaker.makeFromInternalTypeName(typeName);
        String descriptor = constants.getConstantString(constantNameAndType.getSignatureIndex(), (byte)1);
        Type type = this.makeFieldType(ot.getInternalName(), name, descriptor);
        ObjectTypeReferenceExpression objectRef = new ObjectTypeReferenceExpression(lineNumber, ot, !this.internalTypeName.equals(typeName) || this.localVariableMaker.containsName(name));
        stack.push((Object)this.typeParametersToTypeArgumentsBinder.newFieldReferenceExpression(lineNumber, type, (Expression)objectRef, ot, name, descriptor));
    }

    private void parsePutStatic(Statements statements, DefaultStack<Expression> stack, ConstantPool constants, int lineNumber, int index) {
        ConstantCP constantMemberRef = (ConstantCP)constants.getConstant(index);
        String typeName = constants.getConstantString(constantMemberRef.getClassIndex(), (byte)7);
        ObjectType ot = this.typeMaker.makeFromInternalTypeName(typeName);
        ConstantNameAndType constantNameAndType = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
        String name = constants.getConstantString(constantNameAndType.getNameIndex(), (byte)1);
        String descriptor = constants.getConstantString(constantNameAndType.getSignatureIndex(), (byte)1);
        Type type = this.makeFieldType(ot.getInternalName(), name, descriptor);
        Expression valueRef = (Expression)stack.pop();
        ObjectTypeReferenceExpression objectRef = new ObjectTypeReferenceExpression(lineNumber, ot, !this.internalTypeName.equals(typeName) || this.localVariableMaker.containsName(name));
        FieldReferenceExpression fieldRef = this.typeParametersToTypeArgumentsBinder.newFieldReferenceExpression(lineNumber, type, (Expression)objectRef, ot, name, descriptor);
        this.parsePUT(statements, stack, lineNumber, fieldRef, valueRef);
    }

    private void parseGetField(DefaultStack<Expression> stack, ConstantPool constants, int lineNumber, int index) {
        ConstantCP constantMemberRef = (ConstantCP)constants.getConstant(index);
        String typeName = constants.getConstantString(constantMemberRef.getClassIndex(), (byte)7);
        ObjectType ot = this.typeMaker.makeFromInternalTypeName(typeName);
        ConstantNameAndType constantNameAndType = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
        String name = constants.getConstantString(constantNameAndType.getNameIndex(), (byte)1);
        String descriptor = constants.getConstantString(constantNameAndType.getSignatureIndex(), (byte)1);
        Type type = this.makeFieldType(ot.getInternalName(), name, descriptor);
        Expression objectRef = (Expression)stack.pop();
        stack.push((Object)this.typeParametersToTypeArgumentsBinder.newFieldReferenceExpression(lineNumber, type, this.getFieldInstanceReference(objectRef, ot, name), ot, name, descriptor));
    }

    private void parsePutField(Statements statements, DefaultStack<Expression> stack, ConstantPool constants, int lineNumber, int index) {
        ConstantCP constantMemberRef = (ConstantCP)constants.getConstant(index);
        String typeName = constants.getConstantString(constantMemberRef.getClassIndex(), (byte)7);
        ObjectType ot = this.typeMaker.makeFromInternalTypeName(typeName);
        ConstantNameAndType constantNameAndType = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
        String name = constants.getConstantString(constantNameAndType.getNameIndex(), (byte)1);
        String descriptor = constants.getConstantString(constantNameAndType.getSignatureIndex(), (byte)1);
        Type type = this.makeFieldType(ot.getInternalName(), name, descriptor);
        Expression valueRef = (Expression)stack.pop();
        Expression objectRef = (Expression)stack.pop();
        FieldReferenceExpression fieldRef = this.typeParametersToTypeArgumentsBinder.newFieldReferenceExpression(lineNumber, type, this.getFieldInstanceReference(objectRef, ot, name), ot, name, descriptor);
        this.parsePUT(statements, stack, lineNumber, fieldRef, valueRef);
    }

    private static Expression getLastRightExpression(Expression boe) {
        while ("=".equals(boe.getOperator())) {
            if (!boe.getRightExpression().isBinaryOperatorExpression()) {
                return boe.getRightExpression();
            }
            boe = boe.getRightExpression();
        }
        return boe;
    }

    private Expression newNewExpression(int lineNumber, String internalTypeName) {
        ObjectType objectType = this.typeMaker.makeFromInternalTypeName(internalTypeName);
        if (objectType.getQualifiedName() == null && objectType.getName() == null) {
            ClassFileTypeDeclaration typeDeclaration = this.bodyDeclaration.getInnerTypeDeclaration(internalTypeName);
            if (typeDeclaration == null) {
                return new ClassFileNewExpression(lineNumber, ObjectType.TYPE_OBJECT, false, this.diamondSupported);
            }
            if (typeDeclaration.isClassDeclaration()) {
                boolean diamondPossible;
                ClassFileClassDeclaration declaration = (ClassFileClassDeclaration)typeDeclaration;
                BodyDeclaration localBodyDeclaration = this.internalTypeName.equals(internalTypeName) ? null : declaration.getBodyDeclaration();
                boolean bl = diamondPossible = this.majorVersion > 52 || localBodyDeclaration == null && this.majorVersion >= 51;
                if (declaration.getInterfaces() != null && declaration.getInterfaces().size() > 0) {
                    return new ClassFileNewExpression(lineNumber, (ObjectType)declaration.getInterfaces(), localBodyDeclaration, true, false, diamondPossible);
                }
                if (declaration.getSuperType() != null) {
                    return new ClassFileNewExpression(lineNumber, declaration.getSuperType(), localBodyDeclaration, true, false, diamondPossible);
                }
                return new ClassFileNewExpression(lineNumber, ObjectType.TYPE_OBJECT, localBodyDeclaration, true, false, diamondPossible);
            }
        }
        return new ClassFileNewExpression(lineNumber, objectType, false, this.diamondSupported);
    }

    private Expression newIntegerBinaryOperatorExpression(int lineNumber, Expression leftExpression, String operator, Expression rightExpression, int priority) {
        if (leftExpression.isLocalVariableReferenceExpression()) {
            AbstractLocalVariable leftVariable = ((ClassFileLocalVariableReferenceExpression)leftExpression).getLocalVariable();
            leftVariable.typeOnLeft(this.typeBounds, (Type)PrimitiveType.MAYBE_BYTE_TYPE);
        }
        if (rightExpression.isLocalVariableReferenceExpression()) {
            AbstractLocalVariable rightVariable = ((ClassFileLocalVariableReferenceExpression)rightExpression).getLocalVariable();
            rightVariable.typeOnLeft(this.typeBounds, (Type)PrimitiveType.MAYBE_BYTE_TYPE);
        }
        return new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_INT, leftExpression, operator, rightExpression, priority);
    }

    private Expression newIntegerOrBooleanBinaryOperatorExpression(int lineNumber, Expression leftExpression, String operator, Expression rightExpression, int priority) {
        PrimitiveType type = PrimitiveType.TYPE_INT;
        if (leftExpression.isLocalVariableReferenceExpression()) {
            AbstractLocalVariable leftVariable = ((ClassFileLocalVariableReferenceExpression)leftExpression).getLocalVariable();
            if (rightExpression.isLocalVariableReferenceExpression()) {
                AbstractLocalVariable rightVariable = ((ClassFileLocalVariableReferenceExpression)rightExpression).getLocalVariable();
                if (leftVariable.isAssignableFrom(this.typeBounds, (Type)PrimitiveType.TYPE_BOOLEAN) || rightVariable.isAssignableFrom(this.typeBounds, (Type)PrimitiveType.TYPE_BOOLEAN)) {
                    leftVariable.variableOnRight(this.typeBounds, rightVariable);
                    rightVariable.variableOnLeft(this.typeBounds, leftVariable);
                    if (leftVariable.getType() == PrimitiveType.TYPE_BOOLEAN || rightVariable.getType() == PrimitiveType.TYPE_BOOLEAN) {
                        type = PrimitiveType.TYPE_BOOLEAN;
                    }
                }
            } else if (rightExpression.getType() == PrimitiveType.TYPE_BOOLEAN) {
                type = PrimitiveType.TYPE_BOOLEAN;
                leftVariable.typeOnRight(this.typeBounds, (Type)type);
            }
        } else if (rightExpression.isLocalVariableReferenceExpression() && leftExpression.getType() == PrimitiveType.TYPE_BOOLEAN) {
            AbstractLocalVariable rightVariable = ((ClassFileLocalVariableReferenceExpression)rightExpression).getLocalVariable();
            type = PrimitiveType.TYPE_BOOLEAN;
            rightVariable.typeOnRight(this.typeBounds, (Type)type);
        }
        if (type == PrimitiveType.TYPE_INT && leftExpression.getType().isPrimitiveType() && rightExpression.getType().isPrimitiveType()) {
            int leftFlags = ((PrimitiveType)leftExpression.getType()).getFlags();
            int rightFlags = ((PrimitiveType)rightExpression.getType()).getFlags();
            boolean leftBoolean = (leftFlags & 1) != 0;
            boolean rightBoolean = (rightFlags & 1) != 0;
            int commonflags = leftFlags | rightFlags;
            if (!leftBoolean || !rightBoolean) {
                commonflags &= 0xFFFFFFFE;
            }
            if ((type = PrimitiveTypeUtil.getPrimitiveTypeFromFlags((int)commonflags)) == null) {
                type = PrimitiveType.TYPE_INT;
            }
        }
        this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes(leftExpression.getType(), rightExpression);
        this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes(rightExpression.getType(), leftExpression);
        return new BinaryOperatorExpression(lineNumber, (Type)type, leftExpression, operator, rightExpression, priority);
    }

    private Expression newIntegerOrBooleanComparisonOperatorExpression(int lineNumber, Expression leftExpression, String operator, Expression rightExpression, int priority) {
        if (leftExpression.isLocalVariableReferenceExpression()) {
            AbstractLocalVariable leftVariable = ((ClassFileLocalVariableReferenceExpression)leftExpression).getLocalVariable();
            if (rightExpression.isLocalVariableReferenceExpression()) {
                AbstractLocalVariable rightVariable = ((ClassFileLocalVariableReferenceExpression)rightExpression).getLocalVariable();
                if (leftVariable.isAssignableFrom(this.typeBounds, (Type)PrimitiveType.TYPE_BOOLEAN) || rightVariable.isAssignableFrom(this.typeBounds, (Type)PrimitiveType.TYPE_BOOLEAN)) {
                    leftVariable.variableOnRight(this.typeBounds, rightVariable);
                    rightVariable.variableOnLeft(this.typeBounds, leftVariable);
                }
            } else if (rightExpression.getType() == PrimitiveType.TYPE_BOOLEAN) {
                leftVariable.typeOnRight(this.typeBounds, (Type)PrimitiveType.TYPE_BOOLEAN);
            }
        } else if (rightExpression.isLocalVariableReferenceExpression() && leftExpression.getType() == PrimitiveType.TYPE_BOOLEAN) {
            AbstractLocalVariable rightVariable = ((ClassFileLocalVariableReferenceExpression)rightExpression).getLocalVariable();
            rightVariable.typeOnRight(this.typeBounds, (Type)PrimitiveType.TYPE_BOOLEAN);
        }
        this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes(leftExpression.getType(), rightExpression);
        this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes(rightExpression.getType(), leftExpression);
        return new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_BOOLEAN, leftExpression, operator, rightExpression, priority);
    }

    private Expression newIntegerComparisonOperatorExpression(int lineNumber, Expression leftExpression, String operator, Expression rightExpression, int priority) {
        if (leftExpression.isLocalVariableReferenceExpression()) {
            AbstractLocalVariable leftVariable = ((ClassFileLocalVariableReferenceExpression)leftExpression).getLocalVariable();
            leftVariable.typeOnLeft(this.typeBounds, (Type)PrimitiveType.MAYBE_BYTE_TYPE);
        }
        if (rightExpression.isLocalVariableReferenceExpression()) {
            AbstractLocalVariable rightVariable = ((ClassFileLocalVariableReferenceExpression)rightExpression).getLocalVariable();
            rightVariable.typeOnLeft(this.typeBounds, (Type)PrimitiveType.MAYBE_BYTE_TYPE);
        }
        this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes(leftExpression.getType(), rightExpression);
        this.typeParametersToTypeArgumentsBinder.bindParameterTypesWithArgumentTypes(rightExpression.getType(), leftExpression);
        return new BinaryOperatorExpression(lineNumber, (Type)PrimitiveType.TYPE_BOOLEAN, leftExpression, operator, rightExpression, priority);
    }

    private Expression newPreArithmeticOperatorExpression(int lineNumber, String operator, Expression expression) {
        this.reduceIntegerLocalVariableType(expression);
        return new PreOperatorExpression(lineNumber, operator, expression);
    }

    private Expression newPostArithmeticOperatorExpression(int lineNumber, Expression expression, String operator) {
        this.reduceIntegerLocalVariableType(expression);
        return new PostOperatorExpression(lineNumber, expression, operator);
    }

    private void reduceIntegerLocalVariableType(Expression expression) {
        AbstractLocalVariable plv;
        ClassFileLocalVariableReferenceExpression lvre;
        if (expression.isLocalVariableReferenceExpression() && (lvre = (ClassFileLocalVariableReferenceExpression)expression).getLocalVariable().isPrimitiveLocalVariable() && (plv = lvre.getLocalVariable()).isAssignableFrom(this.typeBounds, (Type)PrimitiveType.MAYBE_BOOLEAN_TYPE)) {
            plv.typeOnRight(this.typeBounds, (Type)PrimitiveType.MAYBE_BYTE_TYPE);
        }
    }

    private Expression getFieldInstanceReference(Expression expression, ObjectType ot, String name) {
        if (expression.isThisExpression()) {
            String internalName = expression.getType().getInternalName();
            if (!ot.getInternalName().equals(internalName)) {
                this.memberVisitor.init(name, null);
                for (ClassFileFieldDeclaration field : this.bodyDeclaration.getFieldDeclarations()) {
                    field.getFieldDeclarators().accept((DeclarationVisitor)this.memberVisitor);
                    if (!this.memberVisitor.found()) continue;
                    return new SuperExpression(expression.getLineNumber(), expression.getType());
                }
            }
        }
        return expression;
    }

    private Expression getMethodInstanceReference(Expression expression, ObjectType ot, String name, String descriptor) {
        if (this.bodyDeclaration.getMethodDeclarations() != null && expression.isThisExpression()) {
            String internalName = expression.getType().getInternalName();
            if (!ot.getInternalName().equals(internalName)) {
                this.memberVisitor.init(name, descriptor);
                for (ClassFileConstructorOrMethodDeclaration member : this.bodyDeclaration.getMethodDeclarations()) {
                    member.accept(this.memberVisitor);
                    if (!this.memberVisitor.found()) continue;
                    String[] interfaceTypeNames = member.getClassFile().getInterfaceTypeNames();
                    if (Arrays.asList(interfaceTypeNames).contains(ot.getInternalName())) {
                        return new QualifiedSuperExpression(expression.getLineNumber(), ot);
                    }
                    return new SuperExpression(expression.getLineNumber(), expression.getType());
                }
            }
        }
        return expression;
    }

    private static void checkStack(DefaultStack<Expression> stack, byte[] code, int offset) {
        int opcode;
        if (stack.size() > 1 && offset < code.length && ((opcode = code[offset + 1] & 0xFF) == 176 || opcode == 87)) {
            Expression condition = (Expression)stack.pop();
            stack.push((Object)((Expression)stack.peek()));
            stack.push((Object)condition);
        }
    }

    public static boolean isAssertCondition(String internalTypeName, BasicBlock basicBlock) {
        ConstantCP constantMemberRef;
        ConstantNameAndType constantNameAndType;
        int toOffset;
        ControlFlowGraph cfg = basicBlock.getControlFlowGraph();
        int offset = basicBlock.getFromOffset();
        if (offset + 3 > (toOffset = basicBlock.getToOffset())) {
            return false;
        }
        Method method = cfg.getMethod();
        byte[] code = method.getCode().getCode();
        int opcode = code[offset] & 0xFF;
        if (opcode != 178) {
            return false;
        }
        ConstantPool constants = method.getConstantPool();
        String name = constants.getConstantString((constantNameAndType = (ConstantNameAndType)constants.getConstant((constantMemberRef = (ConstantCP)constants.getConstant((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF)).getNameAndTypeIndex())).getNameIndex(), (byte)1);
        if (!"$assertionsDisabled".equals(name)) {
            return false;
        }
        String descriptor = constants.getConstantString(constantNameAndType.getSignatureIndex(), (byte)1);
        if (!"Z".equals(descriptor)) {
            return false;
        }
        String typeName = constants.getConstantString(constantMemberRef.getClassIndex(), (byte)7);
        return internalTypeName.equals(typeName);
    }

    public static int getExceptionLocalVariableIndex(BasicBlock basicBlock) {
        int toOffset;
        ControlFlowGraph cfg = basicBlock.getControlFlowGraph();
        int offset = basicBlock.getFromOffset();
        if (offset + 1 > (toOffset = basicBlock.getToOffset())) {
            throw new IllegalStateException();
        }
        Method method = cfg.getMethod();
        byte[] code = method.getCode().getCode();
        int opcode = code[offset] & 0xFF;
        return switch (opcode) {
            case 58 -> code[++offset] & 0xFF;
            case 75, 76, 77, 78 -> opcode - 75;
            case 87, 88 -> -1;
            default -> throw new IllegalStateException();
        };
    }

    private Type makeFieldType(String internalTypeName, String fieldName, String descriptor) {
        Type type = this.typeMaker.makeFieldType(internalTypeName, fieldName, descriptor);
        if (!this.genericTypesSupported) {
            this.eraseTypeArgumentVisitor.init();
            type.accept((TypeVisitor)this.eraseTypeArgumentVisitor);
            type = (Type)this.eraseTypeArgumentVisitor.getBaseType();
        }
        return type;
    }

    private TypeMaker.MethodTypes makeMethodTypes(String internalTypeName, String methodName, String descriptor) {
        TypeMaker.MethodTypes methodTypes = this.typeMaker.makeMethodTypes(internalTypeName, methodName, descriptor);
        if (!this.genericTypesSupported) {
            TypeMaker.MethodTypes mt = new TypeMaker.MethodTypes();
            if (methodTypes.getParameterTypes() != null) {
                this.eraseTypeArgumentVisitor.init();
                methodTypes.getParameterTypes().accept((TypeVisitor)this.eraseTypeArgumentVisitor);
                mt.setParameterTypes(this.eraseTypeArgumentVisitor.getBaseType());
            }
            this.eraseTypeArgumentVisitor.init();
            methodTypes.getReturnedType().accept((TypeVisitor)this.eraseTypeArgumentVisitor);
            mt.setReturnedType((Type)this.eraseTypeArgumentVisitor.getBaseType());
            if (methodTypes.getExceptionTypes() != null) {
                this.eraseTypeArgumentVisitor.init();
                methodTypes.getExceptionTypes().accept((TypeVisitor)this.eraseTypeArgumentVisitor);
                mt.setExceptionTypes(this.eraseTypeArgumentVisitor.getBaseType());
            }
            methodTypes = mt;
        }
        return methodTypes;
    }

    protected static Expression forceExplicitCastExpression(Expression expression) {
        Expression exp = expression;
        while (exp.isCastExpression()) {
            CastExpression ce = (CastExpression)exp;
            ce.setExplicit(true);
            exp = ce.getExpression();
        }
        return expression;
    }

    private static class MemberVisitor
    extends AbstractJavaSyntaxVisitor {
        protected String name;
        protected String descriptor;
        protected boolean found;

        private MemberVisitor() {
        }

        public void init(String name, String descriptor) {
            this.name = name;
            this.descriptor = descriptor;
            this.found = false;
        }

        public boolean found() {
            return this.found;
        }

        @Override
        public void visit(FieldDeclarator declaration) {
            this.found |= declaration.getName().equals(this.name);
        }

        @Override
        public void visit(MethodDeclaration declaration) {
            this.found |= declaration.getName().equals(this.name) && declaration.getDescriptor().equals(this.descriptor);
        }
    }

    private static class LambdaParameterNamesVisitor
    extends AbstractNopDeclarationVisitor {
        protected DefaultList<String> names;

        private LambdaParameterNamesVisitor() {
        }

        public void init() {
            this.names = new DefaultList();
        }

        public List<String> getNames() {
            return this.names;
        }

        public void visit(FormalParameter declaration) {
            this.names.add((Object)declaration.getName());
        }

        public void visit(FormalParameters declarations) {
            Iterator iterator = declarations.iterator();
            while (iterator.hasNext()) {
                ((FormalParameter)iterator.next()).accept((DeclarationVisitor)this);
            }
        }
    }

    private static class JsrReturnAddressExpression
    extends NullExpression {
        public JsrReturnAddressExpression() {
            super((Type)PrimitiveType.TYPE_VOID);
        }

        public String toString() {
            return "JsrReturnAddressExpression{}";
        }
    }
}

