/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.ArrayElementValue;
import org.apache.bcel.classfile.ClassElementValue;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.EnumElementValue;
import org.apache.bcel.classfile.SimpleElementValue;
import org.jd.core.v1.model.classfile.attribute.ElementValueVisitor;
import org.jd.core.v1.model.javasyntax.expression.DoubleConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.FieldReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.FloatConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.IntegerConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.LongConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.ObjectTypeReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.StringConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.TypeReferenceDotClassExpression;
import org.jd.core.v1.model.javasyntax.reference.AnnotationElementValue;
import org.jd.core.v1.model.javasyntax.reference.AnnotationReference;
import org.jd.core.v1.model.javasyntax.reference.AnnotationReferences;
import org.jd.core.v1.model.javasyntax.reference.BaseAnnotationReference;
import org.jd.core.v1.model.javasyntax.reference.BaseElementValue;
import org.jd.core.v1.model.javasyntax.reference.BaseElementValuePair;
import org.jd.core.v1.model.javasyntax.reference.ElementValueArrayInitializerElementValue;
import org.jd.core.v1.model.javasyntax.reference.ElementValuePair;
import org.jd.core.v1.model.javasyntax.reference.ElementValuePairs;
import org.jd.core.v1.model.javasyntax.reference.ElementValues;
import org.jd.core.v1.model.javasyntax.reference.ExpressionElementValue;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;

public class AnnotationConverter
implements ElementValueVisitor {
    private final TypeMaker typeMaker;
    private BaseElementValue elementValue;

    public AnnotationConverter(TypeMaker typeMaker) {
        this.typeMaker = typeMaker;
    }

    public BaseAnnotationReference convert(AnnotationEntry[] visibles, AnnotationEntry[] invisibles) {
        if (visibles == null) {
            if (invisibles == null) {
                return null;
            }
            return this.convert(invisibles);
        }
        if (invisibles == null) {
            return this.convert(visibles);
        }
        AnnotationReferences aral = new AnnotationReferences();
        for (AnnotationEntry a : visibles) {
            aral.add((Object)this.convert(a));
        }
        for (AnnotationEntry a : invisibles) {
            aral.add((Object)this.convert(a));
        }
        return aral;
    }

    protected BaseAnnotationReference convert(AnnotationEntry[] as) {
        if (as.length == 1) {
            return this.convert(as[0]);
        }
        AnnotationReferences aral = new AnnotationReferences(as.length);
        for (AnnotationEntry a : as) {
            aral.add((Object)this.convert(a));
        }
        return aral;
    }

    protected AnnotationReference convert(AnnotationEntry annotation) {
        String descriptor = annotation.getAnnotationType();
        assert (descriptor != null && descriptor.length() > 2 && descriptor.charAt(0) == 'L' && descriptor.charAt(descriptor.length() - 1) == ';');
        ObjectType ot = this.typeMaker.makeFromDescriptor(descriptor);
        org.apache.bcel.classfile.ElementValuePair[] elementValuePairs = annotation.getElementValuePairs();
        if (elementValuePairs.length == 1) {
            org.apache.bcel.classfile.ElementValuePair elementValuePair = elementValuePairs[0];
            String elementName = elementValuePair.getNameString();
            ElementValue elemValue = elementValuePair.getValue();
            if ("value".equals(elementName)) {
                return new AnnotationReference(ot, this.convert(elemValue));
            }
            return new AnnotationReference(ot, (BaseElementValuePair)new ElementValuePair(elementName, this.convert(elemValue)));
        }
        ElementValuePairs list = new ElementValuePairs(elementValuePairs.length);
        for (org.apache.bcel.classfile.ElementValuePair elementValuePair : elementValuePairs) {
            String elementName = elementValuePair.getNameString();
            ElementValue elemValue = elementValuePair.getValue();
            list.add((Object)new ElementValuePair(elementName, this.convert(elemValue)));
        }
        return new AnnotationReference(ot, (BaseElementValuePair)list);
    }

    public BaseElementValue convert(ElementValue ev) {
        this.visit(ev);
        return this.elementValue;
    }

    public void visit(ElementValue ev) {
        if (ev instanceof SimpleElementValue) {
            this.visit((SimpleElementValue)ev);
        }
        if (ev instanceof ClassElementValue) {
            this.visit((ClassElementValue)ev);
        }
        if (ev instanceof org.apache.bcel.classfile.AnnotationElementValue) {
            this.visit((org.apache.bcel.classfile.AnnotationElementValue)ev);
        }
        if (ev instanceof EnumElementValue) {
            this.visit((EnumElementValue)ev);
        }
        if (ev instanceof ArrayElementValue) {
            this.visit((ArrayElementValue)ev);
        }
    }

    public void visit(SimpleElementValue elementValuePrimitiveType) {
        this.elementValue = switch (elementValuePrimitiveType.getElementValueType()) {
            case 66 -> new ExpressionElementValue((Expression)new IntegerConstantExpression((Type)PrimitiveType.TYPE_BYTE, (int)elementValuePrimitiveType.getValueByte()));
            case 68 -> new ExpressionElementValue((Expression)new DoubleConstantExpression(elementValuePrimitiveType.getValueDouble()));
            case 70 -> new ExpressionElementValue((Expression)new FloatConstantExpression(elementValuePrimitiveType.getValueFloat()));
            case 73 -> new ExpressionElementValue((Expression)new IntegerConstantExpression((Type)PrimitiveType.TYPE_INT, elementValuePrimitiveType.getValueInt()));
            case 74 -> new ExpressionElementValue((Expression)new LongConstantExpression(elementValuePrimitiveType.getValueLong()));
            case 83 -> new ExpressionElementValue((Expression)new IntegerConstantExpression((Type)PrimitiveType.TYPE_SHORT, (int)elementValuePrimitiveType.getValueShort()));
            case 90 -> new ExpressionElementValue((Expression)new IntegerConstantExpression((Type)PrimitiveType.TYPE_BOOLEAN, elementValuePrimitiveType.getValueBoolean() ? 1 : 0));
            case 67 -> new ExpressionElementValue((Expression)new IntegerConstantExpression((Type)PrimitiveType.TYPE_CHAR, (int)elementValuePrimitiveType.getValueChar()));
            case 115 -> new ExpressionElementValue((Expression)new StringConstantExpression(elementValuePrimitiveType.getValueString()));
            default -> this.elementValue;
        };
    }

    public void visit(ClassElementValue elementValueClassInfo) {
        String classInfo = elementValueClassInfo.getClassString();
        ObjectType ot = this.typeMaker.makeFromDescriptor(classInfo);
        this.elementValue = new ExpressionElementValue((Expression)new TypeReferenceDotClassExpression((Type)ot));
    }

    public void visit(org.apache.bcel.classfile.AnnotationElementValue elementValueAnnotationValue) {
        AnnotationEntry annotationValue = elementValueAnnotationValue.getAnnotationEntry();
        AnnotationReference annotationReference = this.convert(annotationValue);
        this.elementValue = new AnnotationElementValue(annotationReference);
    }

    public void visit(EnumElementValue elementValueEnumConstValue) {
        String descriptor = elementValueEnumConstValue.getEnumTypeString();
        if (descriptor == null || descriptor.length() <= 2 || descriptor.charAt(0) != 'L' || descriptor.charAt(descriptor.length() - 1) != ';') {
            throw new IllegalArgumentException("AnnotationConverter.visit(elementValueEnumConstValue)");
        }
        ObjectType ot = this.typeMaker.makeFromDescriptor(descriptor);
        String constName = elementValueEnumConstValue.getEnumValueString();
        String internalTypeName = descriptor.substring(1, descriptor.length() - 1);
        this.elementValue = new ExpressionElementValue((Expression)new FieldReferenceExpression((Type)ot, (Expression)new ObjectTypeReferenceExpression(ot), internalTypeName, constName, descriptor));
    }

    public void visit(ArrayElementValue elementValueArrayValue) {
        ElementValue[] values = elementValueArrayValue.getElementValuesArray();
        if (values.length == 1) {
            this.visit(values[0]);
            this.elementValue = new ElementValueArrayInitializerElementValue(this.elementValue);
        } else {
            ElementValues list = new ElementValues(values.length);
            for (ElementValue value : values) {
                this.visit(value);
                list.add((Object)this.elementValue);
            }
            this.elementValue = new ElementValueArrayInitializerElementValue((BaseElementValue)list);
        }
    }
}

