/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import java.util.Collection;
import java.util.List;
import org.jd.core.v1.model.javasyntax.declaration.BaseFieldDeclarator;
import org.jd.core.v1.model.javasyntax.declaration.FieldDeclarator;
import org.jd.core.v1.model.javasyntax.declaration.FieldDeclarators;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileFieldDeclaration;

public final class AggregateFieldsUtil {
    private AggregateFieldsUtil() {
    }

    public static void aggregate(List<ClassFileFieldDeclaration> fields) {
        int size = fields.size();
        if (size > 1) {
            int firstIndex = 0;
            int lastIndex = 0;
            ClassFileFieldDeclaration firstField = fields.get(0);
            for (int index = 1; index < size; ++index) {
                ClassFileFieldDeclaration field = fields.get(index);
                if (firstField.getFirstLineNumber() == 0 || firstField.getFlags() != field.getFlags() || !firstField.getType().equals(field.getType())) {
                    firstField = field;
                    firstIndex = lastIndex = index;
                    continue;
                }
                int lineNumber = field.getFirstLineNumber();
                if (lineNumber <= 0) continue;
                if (lineNumber == firstField.getFirstLineNumber()) {
                    lastIndex = index;
                    continue;
                }
                AggregateFieldsUtil.aggregate(fields, firstField, firstIndex, lastIndex);
                int length = lastIndex - firstIndex;
                size -= length;
                firstField = field;
                firstIndex = lastIndex = (index -= length);
            }
            AggregateFieldsUtil.aggregate(fields, firstField, firstIndex, lastIndex);
        }
    }

    private static void aggregate(List<ClassFileFieldDeclaration> fields, ClassFileFieldDeclaration firstField, int firstIndex, int lastIndex) {
        if (firstIndex < lastIndex) {
            List<ClassFileFieldDeclaration> sublist = fields.subList(firstIndex + 1, lastIndex + 1);
            int length = lastIndex - firstIndex;
            FieldDeclarators declarators = new FieldDeclarators(length);
            BaseFieldDeclarator bfd = firstField.getFieldDeclarators();
            if (bfd.isList()) {
                declarators.addAll((Collection)bfd.getList());
            } else {
                declarators.add((Object)((FieldDeclarator)bfd.getFirst()));
            }
            for (ClassFileFieldDeclaration f : sublist) {
                bfd = f.getFieldDeclarators();
                if (bfd.isList()) {
                    declarators.addAll((Collection)bfd.getList());
                    continue;
                }
                declarators.add((Object)((FieldDeclarator)bfd.getFirst()));
            }
            firstField.setFieldDeclarators((BaseFieldDeclarator)declarators);
            sublist.clear();
        }
    }
}

