/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.processor.block.impl;

import java.util.Set;
import java.util.function.UnaryOperator;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg.BasicBlock;
import org.jd.core.v1.service.converter.classfiletojavasyntax.processor.block.api.BlockProcessor;

public class InLoopConditionalBranchProcessor
implements BlockProcessor {
    @Override
    public boolean accept(BasicBlock bb) {
        return bb.getEnclosingLoop() != null && bb.getType() == 32768 && (this.hasIsolatedSuccessor(bb, BasicBlock::getNext, BasicBlock::getBranch) || this.hasIsolatedSuccessor(bb, BasicBlock::getBranch, BasicBlock::getNext));
    }

    @Override
    public void process(BasicBlock bb) {
        bb.flip();
    }

    public boolean hasIsolatedSuccessor(BasicBlock bb, UnaryOperator<BasicBlock> leftSuccessorFunction, UnaryOperator<BasicBlock> rightSuccessorFunction) {
        BasicBlock successor = (BasicBlock)leftSuccessorFunction.apply(bb);
        Set<BasicBlock> sucessorPredecessors = successor.getPredecessors();
        return successor.getType() == 32768 && sucessorPredecessors.size() >= 5 && sucessorPredecessors.stream().filter(b -> b.getIndex() != bb.getIndex()).allMatch(b -> ((BasicBlock)rightSuccessorFunction.apply((BasicBlock)b)).getIndex() == successor.getIndex());
    }
}

