/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.processor;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.bcel.classfile.AnnotationDefault;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Annotations;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Module;
import org.apache.bcel.classfile.ModuleExports;
import org.apache.bcel.classfile.ModuleOpens;
import org.apache.bcel.classfile.ModuleProvides;
import org.apache.bcel.classfile.ModuleRequires;
import org.apache.bcel.classfile.RuntimeInvisibleAnnotations;
import org.apache.bcel.classfile.RuntimeVisibleAnnotations;
import org.jd.core.v1.model.classfile.ClassFile;
import org.jd.core.v1.model.javasyntax.CompilationUnit;
import org.jd.core.v1.model.javasyntax.declaration.BaseFieldDeclarator;
import org.jd.core.v1.model.javasyntax.declaration.BaseTypeDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ExpressionVariableInitializer;
import org.jd.core.v1.model.javasyntax.declaration.FieldDeclarator;
import org.jd.core.v1.model.javasyntax.declaration.ModuleDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.VariableInitializer;
import org.jd.core.v1.model.javasyntax.expression.DoubleConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.FloatConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.IntegerConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.LongConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.StringConstantExpression;
import org.jd.core.v1.model.javasyntax.reference.BaseAnnotationReference;
import org.jd.core.v1.model.javasyntax.reference.BaseElementValue;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.BaseTypeParameter;
import org.jd.core.v1.model.javasyntax.type.GenericType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeArgument;
import org.jd.core.v1.model.javasyntax.type.TypeParameter;
import org.jd.core.v1.model.javasyntax.type.TypeParameterVisitor;
import org.jd.core.v1.model.javasyntax.type.TypeParameterWithTypeBounds;
import org.jd.core.v1.model.message.DecompileContext;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileAnnotationDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileBodyDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileClassDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorOrMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileEnumDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileFieldDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileInterfaceDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileStaticInitializerDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileTypeDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.processor.ConvertClassFileException;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.AnnotationConverter;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.PopulateBindingsWithTypeParameterVisitor;
import org.jd.core.v1.util.DefaultList;

public class ConvertClassFileProcessor {
    private final PopulateBindingsWithTypeParameterVisitor populateBindingsWithTypeParameterVisitor = new PopulateBindingsWithTypeParameterVisitor(){

        @Override
        public void visit(TypeParameter parameter) {
            this.bindings.put(parameter.getIdentifier(), new GenericType(parameter.getIdentifier()));
        }

        @Override
        public void visit(TypeParameterWithTypeBounds parameter) {
            this.bindings.put(parameter.getIdentifier(), new GenericType(parameter.getIdentifier()));
            this.typeBounds.put(parameter.getIdentifier(), parameter.getTypeBounds());
        }
    };

    public CompilationUnit process(ClassFile classFile, TypeMaker typeMaker, DecompileContext decompileContext) {
        AnnotationConverter annotationConverter = new AnnotationConverter(typeMaker);
        Object typeDeclaration = classFile.isEnum() ? this.convertEnumDeclaration(typeMaker, annotationConverter, classFile, null) : (classFile.isAnnotation() ? this.convertAnnotationDeclaration(typeMaker, annotationConverter, classFile, null) : (classFile.isModule() ? this.convertModuleDeclaration(classFile) : (classFile.isInterface() ? this.convertInterfaceDeclaration(typeMaker, annotationConverter, classFile, null) : this.convertClassDeclaration(typeMaker, annotationConverter, classFile, null))));
        decompileContext.setMajorVersion(classFile.getMajorVersion());
        decompileContext.setMinorVersion(classFile.getMinorVersion());
        return new CompilationUnit((BaseTypeDeclaration)typeDeclaration);
    }

    protected ClassFileInterfaceDeclaration convertInterfaceDeclaration(TypeMaker parser, AnnotationConverter converter, ClassFile classFile, ClassFileBodyDeclaration outerClassFileBodyDeclaration) {
        BaseAnnotationReference annotationReferences = this.convertAnnotationReferences(converter, classFile);
        TypeMaker.TypeTypes typeTypes = parser.parseClassFileSignature(classFile);
        ClassFileBodyDeclaration bodyDeclaration = this.convertBodyDeclaration(parser, converter, classFile, typeTypes.getTypeParameters(), outerClassFileBodyDeclaration);
        return new ClassFileInterfaceDeclaration(annotationReferences, classFile.getAccessFlags(), typeTypes.getThisType().getInternalName(), typeTypes.getThisType().getName(), typeTypes.getTypeParameters(), typeTypes.getInterfaces(), bodyDeclaration);
    }

    protected ClassFileEnumDeclaration convertEnumDeclaration(TypeMaker parser, AnnotationConverter converter, ClassFile classFile, ClassFileBodyDeclaration outerClassFileBodyDeclaration) {
        BaseAnnotationReference annotationReferences = this.convertAnnotationReferences(converter, classFile);
        TypeMaker.TypeTypes typeTypes = parser.parseClassFileSignature(classFile);
        ClassFileBodyDeclaration bodyDeclaration = this.convertBodyDeclaration(parser, converter, classFile, typeTypes.getTypeParameters(), outerClassFileBodyDeclaration);
        return new ClassFileEnumDeclaration(annotationReferences, classFile.getAccessFlags(), typeTypes.getThisType().getInternalName(), typeTypes.getThisType().getName(), typeTypes.getInterfaces(), bodyDeclaration);
    }

    protected ClassFileAnnotationDeclaration convertAnnotationDeclaration(TypeMaker parser, AnnotationConverter converter, ClassFile classFile, ClassFileBodyDeclaration outerClassFileBodyDeclaration) {
        BaseAnnotationReference annotationReferences = this.convertAnnotationReferences(converter, classFile);
        TypeMaker.TypeTypes typeTypes = parser.parseClassFileSignature(classFile);
        ClassFileBodyDeclaration bodyDeclaration = this.convertBodyDeclaration(parser, converter, classFile, typeTypes.getTypeParameters(), outerClassFileBodyDeclaration);
        return new ClassFileAnnotationDeclaration(annotationReferences, classFile.getAccessFlags(), typeTypes.getThisType().getInternalName(), typeTypes.getThisType().getName(), bodyDeclaration);
    }

    protected ClassFileClassDeclaration convertClassDeclaration(TypeMaker parser, AnnotationConverter converter, ClassFile classFile, ClassFileBodyDeclaration outerClassFileBodyDeclaration) {
        BaseAnnotationReference annotationReferences = this.convertAnnotationReferences(converter, classFile);
        TypeMaker.TypeTypes typeTypes = parser.parseClassFileSignature(classFile);
        ClassFileBodyDeclaration bodyDeclaration = this.convertBodyDeclaration(parser, converter, classFile, typeTypes.getTypeParameters(), outerClassFileBodyDeclaration);
        return new ClassFileClassDeclaration(annotationReferences, classFile.getAccessFlags(), typeTypes.getThisType().getInternalName(), typeTypes.getThisType().getName(), typeTypes.getTypeParameters(), typeTypes.getSuperType(), typeTypes.getInterfaces(), bodyDeclaration);
    }

    protected ClassFileBodyDeclaration convertBodyDeclaration(TypeMaker parser, AnnotationConverter converter, ClassFile classFile, BaseTypeParameter typeParameters, ClassFileBodyDeclaration outerClassFileBodyDeclaration) {
        Map<String, BaseType> typeBounds;
        Map<String, TypeArgument> bindings;
        if (!classFile.isStatic() && outerClassFileBodyDeclaration != null) {
            bindings = outerClassFileBodyDeclaration.getBindings();
            typeBounds = outerClassFileBodyDeclaration.getTypeBounds();
        } else {
            bindings = Collections.emptyMap();
            typeBounds = Collections.emptyMap();
        }
        if (typeParameters != null) {
            bindings = new HashMap(bindings);
            typeBounds = new HashMap<String, BaseType>(typeBounds);
            this.populateBindingsWithTypeParameterVisitor.init(bindings, typeBounds);
            typeParameters.accept((TypeParameterVisitor)this.populateBindingsWithTypeParameterVisitor);
        }
        ClassFileBodyDeclaration bodyDeclaration = new ClassFileBodyDeclaration(classFile, bindings, typeBounds, outerClassFileBodyDeclaration);
        bodyDeclaration.setFieldDeclarations(this.convertFields(parser, converter, classFile));
        bodyDeclaration.setMethodDeclarations(this.convertMethods(parser, converter, bodyDeclaration, classFile));
        bodyDeclaration.setInnerTypeDeclarations(this.convertInnerTypes(parser, converter, classFile, bodyDeclaration));
        return bodyDeclaration;
    }

    protected List<ClassFileFieldDeclaration> convertFields(TypeMaker parser, AnnotationConverter converter, ClassFile classFile) {
        org.apache.bcel.classfile.Field[] fields = classFile.getFields();
        DefaultList list = new DefaultList(fields.length);
        for (org.apache.bcel.classfile.Field field : fields) {
            BaseAnnotationReference annotationReferences = this.convertAnnotationReferences(converter, (FieldOrMethod)field);
            Type typeField = parser.parseFieldSignature(classFile, field);
            ExpressionVariableInitializer variableInitializer = this.convertFieldInitializer(field, typeField);
            FieldDeclarator fieldDeclarator = new FieldDeclarator(field.getName(), (VariableInitializer)variableInitializer);
            list.add((Object)new ClassFileFieldDeclaration(annotationReferences, field.getAccessFlags(), typeField, (BaseFieldDeclarator)fieldDeclarator));
        }
        return list;
    }

    protected List<ClassFileConstructorOrMethodDeclaration> convertMethods(TypeMaker parser, AnnotationConverter converter, ClassFileBodyDeclaration bodyDeclaration, ClassFile classFile) {
        Method[] methods = classFile.getMethods();
        DefaultList list = new DefaultList(methods.length);
        for (Method method : methods) {
            LineNumberTable lineNumberTable;
            Map<String, BaseType> typeBounds;
            Map<String, TypeArgument> bindings;
            String name = method.getName();
            BaseAnnotationReference annotationReferences = this.convertAnnotationReferences(converter, (FieldOrMethod)method);
            AnnotationDefault annotationDefault = Stream.of(method.getAttributes()).filter(AnnotationDefault.class::isInstance).findAny().orElse(null);
            BaseElementValue defaultAnnotationValue = null;
            if (annotationDefault != null) {
                defaultAnnotationValue = converter.convert(annotationDefault.getDefaultValue());
            }
            TypeMaker.MethodTypes methodTypes = parser.parseMethodSignature(classFile, method);
            if ((method.getAccessFlags() & 8) == 0) {
                bindings = bodyDeclaration.getBindings();
                typeBounds = bodyDeclaration.getTypeBounds();
            } else {
                bindings = Collections.emptyMap();
                typeBounds = Collections.emptyMap();
            }
            if (methodTypes.getTypeParameters() != null) {
                bindings = new HashMap(bindings);
                typeBounds = new HashMap(typeBounds);
                this.populateBindingsWithTypeParameterVisitor.init(bindings, typeBounds);
                methodTypes.getTypeParameters().accept((TypeParameterVisitor)this.populateBindingsWithTypeParameterVisitor);
            }
            Code code = method.getCode();
            int firstLineNumber = 0;
            if (code != null && (lineNumberTable = code.getLineNumberTable()) != null) {
                firstLineNumber = lineNumberTable.getLineNumberTable()[0].getLineNumber();
            }
            if ("<init>".equals(name)) {
                list.add((Object)new ClassFileConstructorDeclaration(bodyDeclaration, classFile, method, annotationReferences, methodTypes.getTypeParameters(), methodTypes.getParameterTypes(), methodTypes.getExceptionTypes(), bindings, typeBounds, firstLineNumber));
                continue;
            }
            if ("<clinit>".equals(name)) {
                list.add((Object)new ClassFileStaticInitializerDeclaration(bodyDeclaration, classFile, method, bindings, typeBounds, firstLineNumber));
                continue;
            }
            ClassFileMethodDeclaration methodDeclaration = new ClassFileMethodDeclaration(bodyDeclaration, classFile, method, annotationReferences, name, methodTypes.getTypeParameters(), methodTypes.getReturnedType(), methodTypes.getParameterTypes(), methodTypes.getExceptionTypes(), defaultAnnotationValue, bindings, typeBounds, firstLineNumber);
            if (classFile.isInterface()) {
                if (methodDeclaration.getFlags() == 1) {
                    methodDeclaration.setFlags(65537);
                }
                if (methodDeclaration.getFlags() == 129) {
                    methodDeclaration.setFlags(65665);
                }
            }
            list.add((Object)methodDeclaration);
        }
        return list;
    }

    protected List<ClassFileTypeDeclaration> convertInnerTypes(TypeMaker parser, AnnotationConverter converter, ClassFile classFile, ClassFileBodyDeclaration outerClassFileBodyDeclaration) {
        List innerClassFiles = classFile.getInnerClassFiles();
        if (innerClassFiles == null) {
            return null;
        }
        DefaultList list = new DefaultList(innerClassFiles.size());
        for (ClassFile innerClassFile : innerClassFiles) {
            ClassFileTypeDeclaration innerTypeDeclaration = innerClassFile.isEnum() ? this.convertEnumDeclaration(parser, converter, innerClassFile, outerClassFileBodyDeclaration) : (innerClassFile.isAnnotation() ? this.convertAnnotationDeclaration(parser, converter, innerClassFile, outerClassFileBodyDeclaration) : (innerClassFile.isInterface() ? this.convertInterfaceDeclaration(parser, converter, innerClassFile, outerClassFileBodyDeclaration) : this.convertClassDeclaration(parser, converter, innerClassFile, outerClassFileBodyDeclaration)));
            list.add((Object)innerTypeDeclaration);
        }
        return list;
    }

    protected BaseAnnotationReference convertAnnotationReferences(AnnotationConverter converter, ClassFile classFile) {
        Annotations visibles = (Annotations)classFile.getAttribute((byte)12);
        Annotations invisibles = (Annotations)classFile.getAttribute((byte)13);
        AnnotationEntry[] visibleEntries = visibles == null ? null : visibles.getAnnotationEntries();
        AnnotationEntry[] invisibleEntries = invisibles == null ? null : invisibles.getAnnotationEntries();
        return converter.convert(visibleEntries, invisibleEntries);
    }

    protected BaseAnnotationReference convertAnnotationReferences(AnnotationConverter converter, FieldOrMethod fieldOrMethod) {
        Annotations visibles = Stream.of(fieldOrMethod.getAttributes()).filter(RuntimeVisibleAnnotations.class::isInstance).findAny().orElse(null);
        Annotations invisibles = Stream.of(fieldOrMethod.getAttributes()).filter(RuntimeInvisibleAnnotations.class::isInstance).findAny().orElse(null);
        AnnotationEntry[] visibleEntries = visibles == null ? null : visibles.getAnnotationEntries();
        AnnotationEntry[] invisibleEntries = invisibles == null ? null : invisibles.getAnnotationEntries();
        return converter.convert(visibleEntries, invisibleEntries);
    }

    protected ExpressionVariableInitializer convertFieldInitializer(org.apache.bcel.classfile.Field field, Type typeField) {
        ConstantValue acv = field.getConstantValue();
        if (acv == null) {
            return null;
        }
        Constant constantValue = acv.getConstantPool().getConstant(acv.getConstantValueIndex());
        IntegerConstantExpression expression = switch (constantValue.getTag()) {
            case 3 -> new IntegerConstantExpression(typeField, ((ConstantInteger)constantValue).getBytes());
            case 4 -> new FloatConstantExpression(((ConstantFloat)constantValue).getBytes());
            case 5 -> new LongConstantExpression(((ConstantLong)constantValue).getBytes());
            case 6 -> new DoubleConstantExpression(((ConstantDouble)constantValue).getBytes());
            case 8 -> new StringConstantExpression(((ConstantString)constantValue).getBytes(acv.getConstantPool()));
            default -> throw new ConvertClassFileException("Invalid attributes");
        };
        return new ExpressionVariableInitializer((Expression)expression);
    }

    protected ModuleDeclaration convertModuleDeclaration(ClassFile classFile) {
        Module attributeModule = (Module)classFile.getAttribute((byte)22);
        String fieldName = "usesIndex";
        int[] usesIndexes = (int[])ConvertClassFileProcessor.getFieldValue(attributeModule, fieldName);
        Object[] usedClassNames = new String[usesIndexes.length];
        for (int i = 0; i < usesIndexes.length; ++i) {
            usedClassNames[i] = classFile.getConstantPool().getConstantString(usesIndexes[i], (byte)7);
        }
        List<ModuleDeclaration.ModuleInfo> requires = this.convertModuleRequiresToModuleInfo(attributeModule.getRequiresTable(), classFile.getConstantPool());
        List<ModuleDeclaration.PackageInfo> exports = this.convertModuleExportsToPackageInfo(attributeModule.getExportsTable(), classFile.getConstantPool());
        List<ModuleDeclaration.PackageInfo> opens = this.convertModuleOpensToPackageInfo(attributeModule.getOpensTable(), classFile.getConstantPool());
        DefaultList uses = new DefaultList(usedClassNames);
        List<ModuleDeclaration.ServiceInfo> provides = this.convertModuleProvidesToServiceInfo(attributeModule.getProvidesTable(), classFile.getConstantPool());
        int moduleFlags = (Integer)ConvertClassFileProcessor.getFieldValue(attributeModule, "moduleFlags");
        int moduleNameIndex = (Integer)ConvertClassFileProcessor.getFieldValue(attributeModule, "moduleNameIndex");
        int moduleVersionIndex = (Integer)ConvertClassFileProcessor.getFieldValue(attributeModule, "moduleVersionIndex");
        String moduleName = classFile.getConstantPool().getConstantString(moduleNameIndex, (byte)19);
        String moduleVersion = classFile.getConstantPool().getConstantString(moduleVersionIndex, (byte)1);
        return new ModuleDeclaration(moduleFlags, classFile.getInternalTypeName(), moduleName, moduleVersion, requires, exports, opens, (List)uses, provides);
    }

    private static <T> T getFieldValue(Object o, String fieldName) {
        try {
            Field f = o.getClass().getDeclaredField(fieldName);
            f.setAccessible(true);
            return (T)f.get(o);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected List<ModuleDeclaration.ModuleInfo> convertModuleRequiresToModuleInfo(ModuleRequires[] moduleRequires, ConstantPool constantPool) {
        if (moduleRequires == null || moduleRequires.length == 0) {
            return null;
        }
        DefaultList list = new DefaultList(moduleRequires.length);
        for (ModuleRequires moduleRequire : moduleRequires) {
            int requiresFlags = (Integer)ConvertClassFileProcessor.getFieldValue(moduleRequire, "requiresFlags");
            int requiresIndex = (Integer)ConvertClassFileProcessor.getFieldValue(moduleRequire, "requiresIndex");
            int requiresVersionIndex = (Integer)ConvertClassFileProcessor.getFieldValue(moduleRequire, "requiresVersionIndex");
            String moduleName = constantPool.constantToString(requiresIndex, (byte)19);
            String version = requiresVersionIndex == 0 ? "0" : constantPool.getConstantString(requiresVersionIndex, (byte)1);
            list.add((Object)new ModuleDeclaration.ModuleInfo(moduleName, requiresFlags, version));
        }
        return list;
    }

    protected List<ModuleDeclaration.PackageInfo> convertModuleOpensToPackageInfo(ModuleOpens[] moduleOpens, ConstantPool constantPool) {
        if (moduleOpens == null || moduleOpens.length == 0) {
            return null;
        }
        DefaultList list = new DefaultList(moduleOpens.length);
        for (ModuleOpens moduleOpen : moduleOpens) {
            int opensToCount = (Integer)ConvertClassFileProcessor.getFieldValue(moduleOpen, "opensToCount");
            int[] opensToIndexes = (int[])ConvertClassFileProcessor.getFieldValue(moduleOpen, "opensToIndex");
            Object[] toModuleNames = new String[opensToCount];
            for (int i = 0; i < opensToCount; ++i) {
                toModuleNames[i] = constantPool.getConstantString(opensToIndexes[i], (byte)19);
            }
            DefaultList moduleInfoNames = new DefaultList(toModuleNames);
            int exportsIndex = (Integer)ConvertClassFileProcessor.getFieldValue(moduleOpen, "opensIndex");
            int opensFlags = (Integer)ConvertClassFileProcessor.getFieldValue(moduleOpen, "opensFlags");
            String packageName = constantPool.constantToString(exportsIndex, (byte)20);
            list.add((Object)new ModuleDeclaration.PackageInfo(packageName, opensFlags, (List)moduleInfoNames));
        }
        return list;
    }

    protected List<ModuleDeclaration.PackageInfo> convertModuleExportsToPackageInfo(ModuleExports[] moduleExports, ConstantPool constantPool) {
        if (moduleExports == null || moduleExports.length == 0) {
            return null;
        }
        DefaultList list = new DefaultList(moduleExports.length);
        for (ModuleExports moduleExport : moduleExports) {
            int exportsToCount = (Integer)ConvertClassFileProcessor.getFieldValue(moduleExport, "exportsToCount");
            int[] exportsToIndexes = (int[])ConvertClassFileProcessor.getFieldValue(moduleExport, "exportsToIndex");
            Object[] toModuleNames = new String[exportsToCount];
            for (int i = 0; i < exportsToCount; ++i) {
                toModuleNames[i] = constantPool.getConstantString(exportsToIndexes[i], (byte)19);
            }
            DefaultList moduleInfoNames = new DefaultList(toModuleNames);
            int exportsIndex = (Integer)ConvertClassFileProcessor.getFieldValue(moduleExport, "exportsIndex");
            int exportsFlags = (Integer)ConvertClassFileProcessor.getFieldValue(moduleExport, "exportsFlags");
            String packageName = constantPool.constantToString(exportsIndex, (byte)20);
            list.add((Object)new ModuleDeclaration.PackageInfo(packageName, exportsFlags, (List)moduleInfoNames));
        }
        return list;
    }

    protected List<ModuleDeclaration.ServiceInfo> convertModuleProvidesToServiceInfo(ModuleProvides[] moduleProvides, ConstantPool constantPool) {
        if (moduleProvides == null || moduleProvides.length == 0) {
            return null;
        }
        DefaultList list = new DefaultList(moduleProvides.length);
        for (ModuleProvides serviceInfo : moduleProvides) {
            int providesIndex = (Integer)ConvertClassFileProcessor.getFieldValue(serviceInfo, "providesIndex");
            int providesWithCount = (Integer)ConvertClassFileProcessor.getFieldValue(serviceInfo, "providesWithCount");
            int[] providesWithIndexes = (int[])ConvertClassFileProcessor.getFieldValue(serviceInfo, "providesWithIndex");
            Object[] implementationClassNames = new String[providesWithCount];
            for (int i = 0; i < providesWithCount; ++i) {
                implementationClassNames[i] = constantPool.getConstantString(providesWithIndexes[i], (byte)7);
            }
            DefaultList implementationTypeNames = new DefaultList(implementationClassNames);
            String interfaceName = constantPool.getConstantString(providesIndex, (byte)7);
            list.add((Object)new ModuleDeclaration.ServiceInfo(interfaceName, (List)implementationTypeNames));
        }
        return list;
    }
}

