/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable;

import java.util.Map;
import java.util.Optional;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.AbstractLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.LocalVariableVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.PrimitiveTypeUtil;

public class PrimitiveLocalVariable
extends AbstractLocalVariable {
    private static final String NON_ZERO_DIMENSION = "Non-zero dimension";
    private int flags;

    public PrimitiveLocalVariable(int index, int offset, PrimitiveType type, String name) {
        super(index, offset, name);
        this.flags = type.getFlags();
    }

    public PrimitiveLocalVariable(int index, int offset, PrimitiveLocalVariable primitiveLocalVariable) {
        super(index, offset, primitiveLocalVariable.getName());
        int valueFlags = primitiveLocalVariable.flags;
        this.flags = (valueFlags & 0x40) != 0 ? valueFlags : ((valueFlags & 0x20) != 0 ? valueFlags | 0x40 : ((valueFlags & 2) != 0 || (valueFlags & 0x10) != 0 ? valueFlags | 0x40 | 0x20 : valueFlags));
    }

    @Override
    public Type getType() {
        return (Type)Optional.ofNullable(PrimitiveTypeUtil.getPrimitiveTypeFromFlags((int)this.flags)).orElse(PrimitiveType.TYPE_INT);
    }

    @Override
    public int getDimension() {
        return 0;
    }

    void setType(PrimitiveType type) {
        this.flags = type.getFlags();
    }

    @Override
    public void accept(LocalVariableVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PrimitiveLocalVariable{");
        if ((this.flags & 1) != 0) {
            sb.append("boolean ");
        }
        if ((this.flags & 2) != 0) {
            sb.append("char ");
        }
        if ((this.flags & 4) != 0) {
            sb.append("float ");
        }
        if ((this.flags & 8) != 0) {
            sb.append("double ");
        }
        if ((this.flags & 0x10) != 0) {
            sb.append("byte ");
        }
        if ((this.flags & 0x20) != 0) {
            sb.append("short ");
        }
        if ((this.flags & 0x40) != 0) {
            sb.append("int ");
        }
        if ((this.flags & 0x80) != 0) {
            sb.append("long ");
        }
        if ((this.flags & 0x100) != 0) {
            sb.append("void ");
        }
        sb.append(this.getName()).append(", index=").append(this.getIndex());
        if (this.getNext() != null) {
            sb.append(", next=").append(this.getNext());
        }
        return sb.append("}").toString();
    }

    @Override
    public boolean isAssignableFrom(Map<String, BaseType> typeBounds, Type type) {
        return type.getDimension() == 0 && type.isPrimitiveType() && (this.flags & ((PrimitiveType)type).getRightFlags()) != 0;
    }

    @Override
    public void typeOnRight(Map<String, BaseType> typeBounds, Type type) {
        if (type.isPrimitiveType()) {
            if (type.getDimension() != 0) {
                throw new IllegalArgumentException(NON_ZERO_DIMENSION);
            }
            int f = ((PrimitiveType)type).getRightFlags();
            if ((this.flags & f) != 0) {
                int old = this.flags;
                this.flags &= f;
                if (old != this.flags) {
                    this.fireChangeEvent(typeBounds);
                }
            }
        }
    }

    @Override
    public void typeOnLeft(Map<String, BaseType> typeBounds, Type type) {
        if (type.isPrimitiveType()) {
            if (type.getDimension() != 0) {
                throw new IllegalArgumentException(NON_ZERO_DIMENSION);
            }
            int f = ((PrimitiveType)type).getLeftFlags();
            if ((this.flags & f) != 0) {
                int old = this.flags;
                this.flags &= f;
                if (old != this.flags) {
                    this.fireChangeEvent(typeBounds);
                }
            }
        }
    }

    @Override
    public boolean isAssignableFrom(Map<String, BaseType> typeBounds, AbstractLocalVariable variable) {
        if (variable.isPrimitiveLocalVariable()) {
            int variableFlags = ((PrimitiveLocalVariable)variable).flags;
            PrimitiveType type = PrimitiveTypeUtil.getPrimitiveTypeFromFlags((int)variableFlags);
            if (type != null) {
                variableFlags = type.getRightFlags();
            }
            return (this.flags & variableFlags) != 0;
        }
        return false;
    }

    @Override
    public void variableOnRight(Map<String, BaseType> typeBounds, AbstractLocalVariable variable) {
        if (variable.getDimension() != 0) {
            throw new IllegalArgumentException(NON_ZERO_DIMENSION);
        }
        this.addVariableOnRight(variable);
        int old = this.flags;
        int variableFlags = ((PrimitiveLocalVariable)variable).flags;
        PrimitiveType type = PrimitiveTypeUtil.getPrimitiveTypeFromFlags((int)variableFlags);
        if (type != null) {
            variableFlags = type.getRightFlags();
        }
        this.flags &= variableFlags;
        if (this.flags == 0) {
            throw new IllegalArgumentException("PrimitiveLocalVariable.variableOnRight(var) : flags = 0 after type reduction");
        }
        if (old != this.flags) {
            this.fireChangeEvent(typeBounds);
        }
    }

    @Override
    public void variableOnLeft(Map<String, BaseType> typeBounds, AbstractLocalVariable variable) {
        if (variable.getDimension() != 0) {
            throw new IllegalArgumentException(NON_ZERO_DIMENSION);
        }
        this.addVariableOnLeft(variable);
        int old = this.flags;
        int variableFlags = ((PrimitiveLocalVariable)variable).flags;
        PrimitiveType type = PrimitiveTypeUtil.getPrimitiveTypeFromFlags((int)variableFlags);
        if (type != null) {
            variableFlags = type.getLeftFlags();
        }
        this.flags &= variableFlags;
        if (this.flags == 0) {
            throw new IllegalArgumentException("PrimitiveLocalVariable.variableOnLeft(var) : flags = 0 after type reduction");
        }
        if (old != this.flags) {
            this.fireChangeEvent(typeBounds);
        }
    }

    @Override
    public boolean isPrimitiveLocalVariable() {
        return true;
    }
}

