/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable;

import org.jd.core.v1.model.javasyntax.type.GenericType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.AbstractLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.Frame;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.GenericLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.ObjectLocalVariable;

public class LocalVariableSet {
    private AbstractLocalVariable[] array = new AbstractLocalVariable[10];
    private int size;

    public void add(int index, AbstractLocalVariable newLV) {
        if (index >= this.array.length) {
            AbstractLocalVariable[] tmp = this.array;
            this.array = new AbstractLocalVariable[index * 2];
            System.arraycopy(tmp, 0, this.array, 0, tmp.length);
            this.array[index] = newLV;
        } else {
            AbstractLocalVariable lv = this.array[index];
            if (lv == null) {
                this.array[index] = newLV;
            } else if (lv.getFromOffset() < newLV.getFromOffset()) {
                if (newLV == lv) {
                    throw new IllegalStateException("newLV == lv");
                }
                newLV.setNext(lv);
                this.array[index] = newLV;
            } else {
                AbstractLocalVariable previous = lv;
                for (lv = lv.getNext(); lv != null && lv.getFromOffset() > newLV.getFromOffset(); lv = lv.getNext()) {
                    previous = lv;
                }
                if (previous == newLV) {
                    throw new IllegalStateException("previous == newLV");
                }
                previous.setNext(newLV);
                if (newLV == lv) {
                    throw new IllegalStateException("newLV == lv");
                }
                newLV.setNext(lv);
            }
        }
        ++this.size;
    }

    public AbstractLocalVariable root(int index) {
        AbstractLocalVariable lv;
        if (index < this.array.length && (lv = this.array[index]) != null) {
            while (lv.getNext() != null) {
                assert (lv != lv.getNext());
                lv = lv.getNext();
            }
            return lv;
        }
        return null;
    }

    public AbstractLocalVariable remove(int index, int offset) {
        if (index < this.array.length) {
            AbstractLocalVariable previous = null;
            for (AbstractLocalVariable lv = this.array[index]; lv != null; lv = lv.getNext()) {
                if (lv.getFromOffset() <= offset) {
                    if (previous == null) {
                        this.array[index] = lv.getNext();
                    } else {
                        previous.setNext(lv.getNext());
                    }
                    --this.size;
                    lv.setNext(null);
                    return lv;
                }
                previous = lv;
                assert (lv != lv.getNext());
            }
        }
        return null;
    }

    public AbstractLocalVariable get(int index, int offset) {
        if (index < this.array.length) {
            for (AbstractLocalVariable lv = this.array[index]; lv != null; lv = lv.getNext()) {
                if (lv.getFromOffset() <= offset && offset <= lv.getToOffset() + 1) {
                    return lv;
                }
                assert (lv != lv.getNext());
            }
        }
        return null;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void update(int index, int offset, ObjectType type) {
        if (index < this.array.length) {
            for (AbstractLocalVariable lv = this.array[index]; lv != null; lv = lv.getNext()) {
                if (lv.getFromOffset() == offset) {
                    ObjectLocalVariable olv = (ObjectLocalVariable)lv;
                    olv.type = type;
                    break;
                }
                assert (lv != lv.getNext());
            }
        }
    }

    public void update(int index, int offset, GenericType type) {
        if (index < this.array.length) {
            AbstractLocalVariable previous = null;
            for (AbstractLocalVariable lv = this.array[index]; lv != null; lv = lv.getNext()) {
                if (lv.getFromOffset() == offset) {
                    GenericLocalVariable glv = new GenericLocalVariable(index, lv.getFromOffset(), type, lv.getName());
                    glv.setNext(lv.getNext());
                    if (previous == null) {
                        this.array[index] = glv;
                        break;
                    }
                    if (previous == glv) {
                        throw new IllegalStateException("previous == glv");
                    }
                    previous.setNext(glv);
                    break;
                }
                previous = lv;
                assert (lv != lv.getNext());
            }
        }
    }

    public AbstractLocalVariable[] initialize(Frame rootFrame) {
        AbstractLocalVariable[] cache = new AbstractLocalVariable[this.array.length];
        for (int index = this.array.length - 1; index >= 0; --index) {
            AbstractLocalVariable lv = this.array[index];
            if (lv == null) continue;
            AbstractLocalVariable previous = null;
            while (lv.getNext() != null) {
                previous = lv;
                assert (lv != lv.getNext());
                lv = lv.getNext();
            }
            if (lv.getFromOffset() != 0) continue;
            if (previous == null) {
                this.array[index] = lv.getNext();
            } else {
                previous.setNext(lv.getNext());
            }
            --this.size;
            lv.setNext(null);
            rootFrame.addLocalVariable(lv);
            cache[index] = lv;
        }
        return cache;
    }
}

