/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable;

import java.util.Map;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.GenericType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.AbstractLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.LocalVariableVisitor;

public class GenericLocalVariable
extends AbstractLocalVariable {
    private GenericType type;

    public GenericLocalVariable(int index, int offset, GenericType type) {
        this(index, offset, type, null);
    }

    public GenericLocalVariable(int index, int offset, GenericType type, String name) {
        super(index, offset, name);
        this.type = type;
    }

    public GenericType getType() {
        return this.type;
    }

    public void setType(GenericType type) {
        this.type = type;
    }

    @Override
    public int getDimension() {
        return this.type.getDimension();
    }

    @Override
    public void accept(LocalVariableVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GenericLocalVariable{");
        sb.append(this.type.getName());
        if (this.type.getDimension() > 0) {
            sb.append(new String(new char[this.type.getDimension()]).replace("\u0000", "[]"));
        }
        sb.append(' ').append(this.getName()).append(", index=").append(this.getIndex());
        if (this.getNext() != null) {
            sb.append(", next=").append(this.getNext());
        }
        return sb.append("}").toString();
    }

    @Override
    public boolean isAssignableFrom(Map<String, BaseType> typeBounds, Type otherType) {
        ObjectType ot;
        BaseType boundType = typeBounds.get(this.type.getName());
        if (boundType instanceof ObjectType && (ot = (ObjectType)boundType).getInternalName().equals(otherType.getInternalName()) && this.getDimension() == otherType.getDimension()) {
            return true;
        }
        return this.type.equals((Object)otherType);
    }

    @Override
    public void typeOnRight(Map<String, BaseType> typeBounds, Type type) {
    }

    @Override
    public void typeOnLeft(Map<String, BaseType> typeBounds, Type type) {
    }

    @Override
    public boolean isAssignableFrom(Map<String, BaseType> typeBounds, AbstractLocalVariable variable) {
        return this.isAssignableFrom(typeBounds, variable.getType());
    }

    @Override
    public void variableOnRight(Map<String, BaseType> typeBounds, AbstractLocalVariable variable) {
    }

    @Override
    public void variableOnLeft(Map<String, BaseType> typeBounds, AbstractLocalVariable variable) {
    }
}

