/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.declaration.BaseLocalVariableDeclarator;
import org.jd.core.v1.model.javasyntax.declaration.ExpressionVariableInitializer;
import org.jd.core.v1.model.javasyntax.declaration.LocalVariableDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.LocalVariableDeclarator;
import org.jd.core.v1.model.javasyntax.declaration.LocalVariableDeclarators;
import org.jd.core.v1.model.javasyntax.declaration.VariableInitializer;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.BinaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor;
import org.jd.core.v1.model.javasyntax.expression.Expressions;
import org.jd.core.v1.model.javasyntax.expression.LocalVariableReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.NewInitializedArray;
import org.jd.core.v1.model.javasyntax.statement.BaseStatement;
import org.jd.core.v1.model.javasyntax.statement.ExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.ForStatement;
import org.jd.core.v1.model.javasyntax.statement.LocalVariableDeclarationStatement;
import org.jd.core.v1.model.javasyntax.statement.Statement;
import org.jd.core.v1.model.javasyntax.statement.StatementVisitor;
import org.jd.core.v1.model.javasyntax.statement.Statements;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.DiamondTypeArgument;
import org.jd.core.v1.model.javasyntax.type.GenericType;
import org.jd.core.v1.model.javasyntax.type.InnerObjectType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeArgumentVisitor;
import org.jd.core.v1.model.javasyntax.type.TypeArguments;
import org.jd.core.v1.model.javasyntax.type.WildcardExtendsTypeArgument;
import org.jd.core.v1.model.javasyntax.type.WildcardSuperTypeArgument;
import org.jd.core.v1.model.javasyntax.type.WildcardTypeArgument;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileLocalVariableDeclarator;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileLocalVariableReferenceExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.statement.ClassFileForStatement;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.AbstractLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.LocalVariableReference;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.ObjectLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.PrimitiveLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.LocalVariableMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.PrimitiveTypeUtil;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.CreateLocalVariableVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.RenameLocalVariablesVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.SearchLocalVariableReferenceVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.SearchLocalVariableVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.SearchUndeclaredLocalVariableVisitor;
import org.jd.core.v1.util.DefaultList;

public class Frame {
    protected static final Set<String> CAPITALIZED_JAVA_LANGUAGE_KEYWORDS = new HashSet<String>(Arrays.asList("Abstract", "Continue", "For", "New", "Switch", "Assert", "Default", "Goto", "Package", "Synchronized", "Boolean", "Do", "If", "Private", "This", "Break", "Double", "Implements", "Protected", "Throw", "Byte", "Else", "Import", "Public", "Throws", "Case", "Enum", "Instanceof", "Return", "Transient", "Catch", "Extends", "Int", "Short", "Try", "Char", "Final", "Interface", "Static", "Void", "Class", "Finally", "Long", "Strictfp", "Volatile", "Const", "Float", "Native", "Super", "While"));
    protected AbstractLocalVariable[] localVariableArray = new AbstractLocalVariable[10];
    protected DefaultList<Frame> children;
    private final Frame parent;
    private final Statements statements;
    private AbstractLocalVariable exceptionLocalVariable;

    public Frame(Frame parent, Statements statements) {
        this.parent = parent;
        this.statements = statements;
    }

    public void addLocalVariable(AbstractLocalVariable lv) {
        AbstractLocalVariable next;
        if (lv.getNext() != null) {
            throw new IllegalArgumentException("Frame.addLocalVariable(lv) : add local variable failed");
        }
        int index = lv.getIndex();
        if (index >= this.localVariableArray.length) {
            AbstractLocalVariable[] tmp = this.localVariableArray;
            this.localVariableArray = new AbstractLocalVariable[index * 2];
            System.arraycopy(tmp, 0, this.localVariableArray, 0, tmp.length);
        }
        if ((next = this.localVariableArray[index]) != lv) {
            this.localVariableArray[index] = lv;
            lv.setNext(next);
            lv.setFrame(this);
        }
    }

    public AbstractLocalVariable getLocalVariable(int index) {
        AbstractLocalVariable lv;
        if (index < this.localVariableArray.length && (lv = this.localVariableArray[index]) != null) {
            return lv;
        }
        return this.parent.getLocalVariable(index);
    }

    public Frame getParent() {
        return this.parent;
    }

    public void setExceptionLocalVariable(AbstractLocalVariable exceptionLocalVariable) {
        this.exceptionLocalVariable = exceptionLocalVariable;
    }

    public void mergeLocalVariable(Map<String, BaseType> typeBounds, LocalVariableMaker localVariableMaker, AbstractLocalVariable lv) {
        int index = lv.getIndex();
        AbstractLocalVariable alvToMerge = index < this.localVariableArray.length ? this.localVariableArray[index] : null;
        if (alvToMerge != null && (!lv.isAssignableFrom(typeBounds, alvToMerge) && !alvToMerge.isAssignableFrom(typeBounds, lv) || lv.getName() != null && alvToMerge.getName() != null && !lv.getName().equals(alvToMerge.getName()))) {
            alvToMerge = null;
        }
        if (alvToMerge == null) {
            if (this.children != null) {
                for (Frame frame : this.children) {
                    frame.mergeLocalVariable(typeBounds, localVariableMaker, lv);
                }
            }
        } else if (lv != alvToMerge) {
            for (LocalVariableReference reference : alvToMerge.getReferences()) {
                reference.setLocalVariable(lv);
            }
            lv.getReferences().addAll(alvToMerge.getReferences());
            lv.setFromOffset(alvToMerge.getFromOffset());
            Type type = lv.getType();
            Type alvToMergeType = alvToMerge.getType();
            if (lv.isAssignableFrom(typeBounds, alvToMerge) || localVariableMaker.isCompatible(lv, alvToMerge.getType())) {
                if (type.isPrimitiveType()) {
                    PrimitiveLocalVariable plv = (PrimitiveLocalVariable)lv;
                    PrimitiveLocalVariable plvToMergeType = (PrimitiveLocalVariable)alvToMerge;
                    PrimitiveType t = PrimitiveTypeUtil.getCommonPrimitiveType((PrimitiveType)((PrimitiveType)plv.getType()), (PrimitiveType)((PrimitiveType)plvToMergeType.getType()));
                    if (t == null) {
                        t = PrimitiveType.TYPE_INT;
                    }
                    plv.setType((PrimitiveType)t.createType(type.getDimension()));
                }
            } else {
                if (type.isPrimitiveType() != alvToMergeType.isPrimitiveType() || type.isObjectType() != alvToMergeType.isObjectType() || type.isGenericType() != alvToMergeType.isGenericType()) {
                    throw new IllegalArgumentException("Frame.mergeLocalVariable(lv) : merge local variable failed");
                }
                if (type.isPrimitiveType()) {
                    PrimitiveLocalVariable plv = (PrimitiveLocalVariable)lv;
                    if (alvToMerge.isAssignableFrom(typeBounds, lv) || localVariableMaker.isCompatible(alvToMerge, lv.getType())) {
                        plv.setType((PrimitiveType)alvToMergeType);
                    } else {
                        plv.setType(PrimitiveType.TYPE_INT);
                    }
                } else if (type.isObjectType()) {
                    ObjectLocalVariable olv = (ObjectLocalVariable)lv;
                    if (alvToMerge.isAssignableFrom(typeBounds, lv) || localVariableMaker.isCompatible(alvToMerge, lv.getType())) {
                        olv.setType(typeBounds, alvToMergeType);
                    } else {
                        int dimension = Math.max(lv.getDimension(), alvToMerge.getDimension());
                        olv.setType(typeBounds, ObjectType.TYPE_OBJECT.createType(dimension));
                    }
                }
            }
            this.localVariableArray[index] = alvToMerge.getNext();
        }
    }

    public void removeLocalVariable(AbstractLocalVariable lv) {
        int index = lv.getIndex();
        AbstractLocalVariable alvToRemove = index < this.localVariableArray.length && this.localVariableArray[index] == lv ? lv : null;
        if (alvToRemove == null) {
            if (this.children != null) {
                for (Frame frame : this.children) {
                    frame.removeLocalVariable(lv);
                }
            }
        } else {
            this.localVariableArray[index] = alvToRemove.getNext();
            alvToRemove.setNext(null);
        }
    }

    public void addChild(Frame child) {
        if (this.children == null) {
            this.children = new DefaultList();
        }
        this.children.add((Object)child);
    }

    public void createNames(Set<String> parentNames) {
        AbstractLocalVariable lv;
        HashSet<String> names = new HashSet<String>(parentNames);
        HashMap<Type, Boolean> types = new HashMap<Type, Boolean>();
        int length = this.localVariableArray.length;
        RenameLocalVariablesVisitor renameLocalVariablesVisitor = new RenameLocalVariablesVisitor();
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (int i = 0; i < length; ++i) {
            for (lv = this.localVariableArray[i]; lv != null; lv = lv.getNext()) {
                if (types.containsKey(lv.getType())) {
                    types.put(lv.getType(), Boolean.TRUE);
                } else {
                    types.put(lv.getType(), Boolean.FALSE);
                }
                if (lv.getName() != null && !names.add(lv.getName())) {
                    lv.setOldName(lv.getName());
                    lv.setName(null);
                }
                assert (lv != lv.getNext());
            }
        }
        if (this.exceptionLocalVariable != null) {
            if (types.containsKey(this.exceptionLocalVariable.getType())) {
                types.put(this.exceptionLocalVariable.getType(), Boolean.TRUE);
            } else {
                types.put(this.exceptionLocalVariable.getType(), Boolean.FALSE);
            }
        }
        if (!types.isEmpty()) {
            GenerateLocalVariableNameVisitor visitor = new GenerateLocalVariableNameVisitor(names, types);
            for (int i = 0; i < length; ++i) {
                for (lv = this.localVariableArray[i]; lv != null; lv = lv.getNext()) {
                    if (lv.getName() != null) continue;
                    lv.getType().accept((TypeArgumentVisitor)visitor);
                    lv.setName(visitor.getName());
                    mapping.put(lv.getOldName(), lv.getName());
                }
            }
            if (this.exceptionLocalVariable != null) {
                this.exceptionLocalVariable.getType().accept((TypeArgumentVisitor)visitor);
                this.exceptionLocalVariable.setName(visitor.getName());
            }
        }
        if (!mapping.isEmpty() && this.statements != null) {
            renameLocalVariablesVisitor.init(mapping, false);
            this.statements.accept((StatementVisitor)renameLocalVariablesVisitor);
        }
        if (this.children != null) {
            for (Frame child : this.children) {
                child.createNames(names);
            }
        }
    }

    public void updateLocalVariableInForStatements(TypeMaker typeMaker) {
        if (this.children != null) {
            for (Frame child : this.children) {
                child.updateLocalVariableInForStatements(typeMaker);
            }
        }
        SearchLocalVariableVisitor searchLocalVariableVisitor = new SearchLocalVariableVisitor();
        HashSet<AbstractLocalVariable> undeclaredInExpressionStatements = new HashSet<AbstractLocalVariable>();
        for (Statement statement : this.statements) {
            if (statement.isForStatement()) {
                if (statement.getInit() != null) continue;
                if (statement.getCondition() != null) {
                    searchLocalVariableVisitor.init();
                    statement.getCondition().accept((ExpressionVisitor)searchLocalVariableVisitor);
                    undeclaredInExpressionStatements.addAll(searchLocalVariableVisitor.getVariables());
                }
                if (statement.getUpdate() != null) {
                    searchLocalVariableVisitor.init();
                    statement.getUpdate().accept((ExpressionVisitor)searchLocalVariableVisitor);
                    undeclaredInExpressionStatements.addAll(searchLocalVariableVisitor.getVariables());
                }
                if (statement.getStatements() == null) continue;
                searchLocalVariableVisitor.init();
                statement.getStatements().accept((StatementVisitor)searchLocalVariableVisitor);
                undeclaredInExpressionStatements.addAll(searchLocalVariableVisitor.getVariables());
                continue;
            }
            searchLocalVariableVisitor.init();
            statement.accept((StatementVisitor)searchLocalVariableVisitor);
            undeclaredInExpressionStatements.addAll(searchLocalVariableVisitor.getVariables());
        }
        SearchUndeclaredLocalVariableVisitor searchUndeclaredLocalVariableVisitor = new SearchUndeclaredLocalVariableVisitor();
        HashMap<AbstractLocalVariable, List> undeclaredInForStatements = new HashMap<AbstractLocalVariable, List>();
        for (Statement statement : this.statements) {
            ClassFileForStatement fs;
            if (!statement.isForStatement() || (fs = (ClassFileForStatement)statement).getInit() == null) continue;
            searchUndeclaredLocalVariableVisitor.init();
            fs.getInit().accept((ExpressionVisitor)searchUndeclaredLocalVariableVisitor);
            searchUndeclaredLocalVariableVisitor.getVariables().removeAll(undeclaredInExpressionStatements);
            for (AbstractLocalVariable lv : searchUndeclaredLocalVariableVisitor.getVariables()) {
                undeclaredInForStatements.computeIfAbsent(lv, k -> new ArrayList()).add(fs);
            }
        }
        if (!undeclaredInForStatements.isEmpty()) {
            CreateLocalVariableVisitor createLocalVariableVisitor = new CreateLocalVariableVisitor(typeMaker);
            for (Map.Entry entry : undeclaredInForStatements.entrySet()) {
                List listFS = (List)entry.getValue();
                AbstractLocalVariable lv = (AbstractLocalVariable)entry.getKey();
                Iterator iteratorFS = listFS.iterator();
                ClassFileForStatement firstFS = (ClassFileForStatement)((Object)iteratorFS.next());
                while (iteratorFS.hasNext()) {
                    this.createNewLocalVariable(createLocalVariableVisitor, (ClassFileForStatement)((Object)iteratorFS.next()), lv);
                }
                if (lv.getFrame() == this) {
                    lv.setFromOffset(firstFS.getFromOffset());
                    lv.setToOffset(firstFS.getToOffset());
                    continue;
                }
                this.createNewLocalVariable(createLocalVariableVisitor, firstFS, lv);
                if (!lv.getReferences().isEmpty()) continue;
                lv.getFrame().removeLocalVariable(lv);
            }
        }
    }

    protected void createNewLocalVariable(CreateLocalVariableVisitor createLocalVariableVisitor, ClassFileForStatement fs, AbstractLocalVariable lv) {
        int fromOffset = fs.getFromOffset();
        int toOffset = fs.getToOffset();
        createLocalVariableVisitor.init(lv.getIndex(), fromOffset);
        lv.accept(createLocalVariableVisitor);
        AbstractLocalVariable newLV = createLocalVariableVisitor.getLocalVariable();
        newLV.setToOffset(toOffset);
        this.addLocalVariable(newLV);
        Iterator iteratorLVR = lv.getReferences().iterator();
        while (iteratorLVR.hasNext()) {
            LocalVariableReference lvr = (LocalVariableReference)iteratorLVR.next();
            int offset = ((ClassFileLocalVariableReferenceExpression)lvr).getOffset();
            if (fromOffset > offset || offset > toOffset) continue;
            lvr.setLocalVariable(newLV);
            newLV.addReference(lvr);
            iteratorLVR.remove();
        }
    }

    public void createDeclarations(boolean containsLineNumber) {
        this.createInlineDeclarations();
        this.createStartBlockDeclarations();
        if (containsLineNumber) {
            this.mergeDeclarations();
        }
        if (this.children != null) {
            for (Frame child : this.children) {
                child.createDeclarations(containsLineNumber);
            }
        }
    }

    protected void createInlineDeclarations() {
        Map<Frame, Set<AbstractLocalVariable>> map = this.createMapForInlineDeclarations();
        if (!map.isEmpty()) {
            SearchUndeclaredLocalVariableVisitor searchUndeclaredLocalVariableVisitor = new SearchUndeclaredLocalVariableVisitor();
            block0: for (Map.Entry<Frame, Set<AbstractLocalVariable>> entry : map.entrySet()) {
                Statements localStatements = entry.getKey().statements;
                ListIterator iterator = localStatements.listIterator();
                Set<AbstractLocalVariable> undeclaredLocalVariables = entry.getValue();
                int statementIndex = 0;
                while (iterator.hasNext()) {
                    Statement statement = (Statement)iterator.next();
                    searchUndeclaredLocalVariableVisitor.init();
                    statement.accept((StatementVisitor)searchUndeclaredLocalVariableVisitor);
                    Set<AbstractLocalVariable> undeclaredLocalVariablesInStatement = searchUndeclaredLocalVariableVisitor.getVariables();
                    undeclaredLocalVariablesInStatement.retainAll(undeclaredLocalVariables);
                    if (!undeclaredLocalVariablesInStatement.isEmpty()) {
                        int index1 = iterator.nextIndex();
                        if (statement.isExpressionStatement()) {
                            this.createInlineDeclarations(undeclaredLocalVariables, undeclaredLocalVariablesInStatement, iterator, (ExpressionStatement)statement, localStatements, statementIndex);
                        } else if (statement.isForStatement()) {
                            this.createInlineDeclarations(undeclaredLocalVariables, undeclaredLocalVariablesInStatement, (ClassFileForStatement)statement);
                        }
                        if (!undeclaredLocalVariablesInStatement.isEmpty()) {
                            int index2 = iterator.nextIndex() + undeclaredLocalVariablesInStatement.size();
                            while (iterator.nextIndex() >= index1) {
                                iterator.previous();
                            }
                            DefaultList sorted = new DefaultList(undeclaredLocalVariablesInStatement);
                            sorted.sort(Comparator.comparing(AbstractLocalVariable::getIndex));
                            for (AbstractLocalVariable lv : sorted) {
                                iterator.add(new LocalVariableDeclarationStatement(lv.getType(), (BaseLocalVariableDeclarator)new ClassFileLocalVariableDeclarator(lv)));
                                lv.setDeclared(true);
                                undeclaredLocalVariables.remove(lv);
                            }
                            while (iterator.nextIndex() < index2) {
                                iterator.next();
                            }
                        }
                    }
                    if (undeclaredLocalVariables.isEmpty()) continue block0;
                    ++statementIndex;
                }
            }
        }
    }

    protected Map<Frame, Set<AbstractLocalVariable>> createMapForInlineDeclarations() {
        HashMap<Frame, Set<AbstractLocalVariable>> map = new HashMap<Frame, Set<AbstractLocalVariable>>();
        int i = this.localVariableArray.length;
        while (i-- > 0) {
            for (AbstractLocalVariable lv = this.localVariableArray[i]; lv != null; lv = lv.getNext()) {
                if (this != lv.getFrame() || lv.isDeclared()) continue;
                map.computeIfAbsent(this, k -> new HashSet()).add(lv);
            }
        }
        return map;
    }

    protected void createInlineDeclarations(Set<AbstractLocalVariable> undeclaredLocalVariables, Set<AbstractLocalVariable> undeclaredLocalVariablesInStatement, ListIterator<Statement> iterator, ExpressionStatement es, Statements localStatements, int statementIndex) {
        Expression boe;
        if (es.getExpression().isBinaryOperatorExpression() && "=".equals((boe = es.getExpression()).getOperator())) {
            ClassFileLocalVariableReferenceExpression reference = (ClassFileLocalVariableReferenceExpression)boe.getLeftExpression();
            AbstractLocalVariable localVariable = reference.getLocalVariable();
            boolean createDeclaration = false;
            if (localVariable.getOldName() == null) {
                createDeclaration = true;
            } else if (statementIndex + 1 < localStatements.size()) {
                List nextStatements = localStatements.subList(statementIndex + 1, localStatements.size());
                SearchLocalVariableReferenceVisitor searchLocalVariableReferenceVisitor = new SearchLocalVariableReferenceVisitor();
                searchLocalVariableReferenceVisitor.init(localVariable);
                if (nextStatements.size() > 1) {
                    searchLocalVariableReferenceVisitor.safeAccept((BaseStatement)new Statements(nextStatements));
                } else {
                    searchLocalVariableReferenceVisitor.safeAccept((BaseStatement)nextStatements.get(0));
                }
                createDeclaration = searchLocalVariableReferenceVisitor.containsReference();
            }
            if (createDeclaration) {
                Expressions expressions = new Expressions();
                this.splitMultiAssignment(Integer.MAX_VALUE, undeclaredLocalVariablesInStatement, (List<Expression>)expressions, boe);
                iterator.remove();
                for (Expression exp : expressions) {
                    iterator.add((Statement)this.newDeclarationStatement(undeclaredLocalVariables, undeclaredLocalVariablesInStatement, exp));
                }
                if (expressions.isEmpty()) {
                    iterator.add((Statement)es);
                }
            } else {
                undeclaredLocalVariables.remove(localVariable);
                undeclaredLocalVariablesInStatement.remove(localVariable);
                if (localVariable.getOldName() != null) {
                    localVariable.setName(localVariable.getOldName());
                }
                localVariable.setDeclared(true);
            }
        }
    }

    protected Expression splitMultiAssignment(int toOffset, Set<AbstractLocalVariable> undeclaredLocalVariablesInStatement, List<Expression> expressions, Expression expression) {
        if (expression.isBinaryOperatorExpression() && "=".equals(expression.getOperator())) {
            ClassFileLocalVariableReferenceExpression lvre;
            AbstractLocalVariable localVariable;
            Expression rightExpression = this.splitMultiAssignment(toOffset, undeclaredLocalVariablesInStatement, expressions, expression.getRightExpression());
            if (expression.getLeftExpression().isLocalVariableReferenceExpression() && undeclaredLocalVariablesInStatement.contains(localVariable = (lvre = (ClassFileLocalVariableReferenceExpression)expression.getLeftExpression()).getLocalVariable()) && localVariable.getToOffset() <= toOffset) {
                if (rightExpression == expression.getRightExpression()) {
                    expressions.add(expression);
                } else {
                    expressions.add((Expression)new BinaryOperatorExpression(expression.getLineNumber(), expression.getType(), (Expression)lvre, "=", rightExpression, expression.getPriority()));
                }
                return lvre;
            }
        }
        return expression;
    }

    protected LocalVariableDeclarationStatement newDeclarationStatement(Set<AbstractLocalVariable> undeclaredLocalVariables, Set<AbstractLocalVariable> undeclaredLocalVariablesInStatement, Expression boe) {
        ClassFileLocalVariableReferenceExpression reference = (ClassFileLocalVariableReferenceExpression)boe.getLeftExpression();
        AbstractLocalVariable localVariable = reference.getLocalVariable();
        undeclaredLocalVariables.remove(localVariable);
        undeclaredLocalVariablesInStatement.remove(localVariable);
        localVariable.setDeclared(true);
        Type type = localVariable.getType();
        Object variableInitializer = !boe.getRightExpression().isNewInitializedArray() || type.isObjectType() && ((ObjectType)type).getTypeArguments() != null ? new ExpressionVariableInitializer(boe.getRightExpression()) : ((NewInitializedArray)boe.getRightExpression()).getArrayInitializer();
        return new LocalVariableDeclarationStatement(type, (BaseLocalVariableDeclarator)new ClassFileLocalVariableDeclarator(boe.getLineNumber(), reference.getLocalVariable(), (VariableInitializer)variableInitializer));
    }

    protected void createInlineDeclarations(Set<AbstractLocalVariable> undeclaredLocalVariables, Set<AbstractLocalVariable> undeclaredLocalVariablesInStatement, ClassFileForStatement fs) {
        BaseExpression init = fs.getInit();
        if (init != null) {
            Expressions expressions = new Expressions();
            int toOffset = fs.getToOffset();
            if (init.isList()) {
                for (Expression exp : init) {
                    this.splitMultiAssignment(toOffset, undeclaredLocalVariablesInStatement, (List<Expression>)expressions, exp);
                    if (!expressions.isEmpty()) continue;
                    expressions.add((Object)exp);
                }
            } else {
                this.splitMultiAssignment(toOffset, undeclaredLocalVariablesInStatement, (List<Expression>)expressions, (Expression)init.getFirst());
                if (expressions.isEmpty()) {
                    expressions.add((Object)((Expression)init.getFirst()));
                }
            }
            if (expressions.size() == 1) {
                this.updateForStatement(undeclaredLocalVariables, undeclaredLocalVariablesInStatement, fs, (Expression)expressions.getFirst());
            } else {
                this.updateForStatement(undeclaredLocalVariables, undeclaredLocalVariablesInStatement, fs, expressions);
            }
        }
    }

    protected void updateForStatement(Set<AbstractLocalVariable> undeclaredLocalVariables, Set<AbstractLocalVariable> undeclaredLocalVariablesInStatement, final ClassFileForStatement forStatement, Expression init) {
        if (!init.isBinaryOperatorExpression() || !init.getLeftExpression().isLocalVariableReferenceExpression()) {
            return;
        }
        ClassFileLocalVariableReferenceExpression reference = (ClassFileLocalVariableReferenceExpression)init.getLeftExpression();
        final AbstractLocalVariable localVariable = reference.getLocalVariable();
        if (localVariable.isDeclared() || localVariable.getToOffset() > forStatement.getToOffset()) {
            return;
        }
        final boolean[] createDeclaration = new boolean[]{true};
        if (localVariable.getOldName() != null && this.parent != null && this.parent.statements != null) {
            this.parent.statements.accept((StatementVisitor)new AbstractJavaSyntaxVisitor(){
                boolean foundFor;

                @Override
                public void visit(ForStatement statement) {
                    if (statement == forStatement) {
                        this.foundFor = true;
                    }
                }

                @Override
                public void visit(LocalVariableReferenceExpression expression) {
                    if (this.foundFor && ((ClassFileLocalVariableReferenceExpression)expression).getLocalVariable().getName().equals(localVariable.getOldName())) {
                        createDeclaration[0] = false;
                    }
                }
            });
        }
        if (createDeclaration[0]) {
            undeclaredLocalVariables.remove(localVariable);
            undeclaredLocalVariablesInStatement.remove(localVariable);
            localVariable.setDeclared(true);
            ExpressionVariableInitializer variableInitializer = init.getRightExpression().isNewInitializedArray() ? ((NewInitializedArray)init.getRightExpression()).getArrayInitializer() : new ExpressionVariableInitializer(init.getRightExpression());
            forStatement.setDeclaration(new LocalVariableDeclaration(localVariable.getType(), (BaseLocalVariableDeclarator)new ClassFileLocalVariableDeclarator(init.getLineNumber(), reference.getLocalVariable(), (VariableInitializer)variableInitializer)));
            forStatement.setInit(null);
        } else {
            undeclaredLocalVariables.remove(localVariable);
            undeclaredLocalVariablesInStatement.remove(localVariable);
            if (localVariable.getOldName() != null) {
                localVariable.setName(localVariable.getOldName());
            }
            localVariable.setDeclared(true);
        }
    }

    protected void updateForStatement(Set<AbstractLocalVariable> variablesToDeclare, Set<AbstractLocalVariable> foundVariables, ClassFileForStatement forStatement, Expressions init) {
        DefaultList boes = new DefaultList();
        DefaultList localVariables = new DefaultList();
        Type type0 = null;
        Type type1 = null;
        int minDimension = 0;
        int maxDimension = 0;
        for (Expression expression : init) {
            if (!expression.isBinaryOperatorExpression() || !expression.getLeftExpression().isLocalVariableReferenceExpression()) {
                return;
            }
            AbstractLocalVariable localVariable = ((ClassFileLocalVariableReferenceExpression)expression.getLeftExpression()).getLocalVariable();
            if (localVariable.isDeclared() || localVariable.getToOffset() > forStatement.getToOffset()) {
                return;
            }
            if (type1 == null) {
                type1 = localVariable.getType();
                type0 = type1.createType(0);
                minDimension = maxDimension = type1.getDimension();
            } else {
                Type type2 = localVariable.getType();
                if (type1.isPrimitiveType() && type2.isPrimitiveType()) {
                    PrimitiveType type = PrimitiveTypeUtil.getCommonPrimitiveType((PrimitiveType)((PrimitiveType)type1), (PrimitiveType)((PrimitiveType)type2));
                    if (type == null) {
                        return;
                    }
                    type0 = type;
                    type1 = type.createType(type1.getDimension());
                    type2 = type.createType(type2.getDimension());
                } else if (!type1.equals(type2) && type0 != null && !type0.equals(type2.createType(0))) {
                    return;
                }
                int dimension = type2.getDimension();
                if (minDimension > dimension) {
                    minDimension = dimension;
                }
                if (maxDimension < dimension) {
                    maxDimension = dimension;
                }
            }
            localVariables.add((Object)localVariable);
            boes.add((Object)expression);
        }
        for (AbstractLocalVariable lv : localVariables) {
            variablesToDeclare.remove(lv);
            foundVariables.remove(lv);
            lv.setDeclared(true);
        }
        if (minDimension == maxDimension) {
            forStatement.setDeclaration(new LocalVariableDeclaration(type1, (BaseLocalVariableDeclarator)this.createDeclarators1((DefaultList<Expression>)boes, false)));
        } else {
            forStatement.setDeclaration(new LocalVariableDeclaration(type0, (BaseLocalVariableDeclarator)this.createDeclarators1((DefaultList<Expression>)boes, true)));
        }
        forStatement.setInit(null);
    }

    protected LocalVariableDeclarators createDeclarators1(DefaultList<Expression> boes, boolean setDimension) {
        LocalVariableDeclarators declarators = new LocalVariableDeclarators(boes.size());
        for (Expression boe : boes) {
            ClassFileLocalVariableReferenceExpression reference = (ClassFileLocalVariableReferenceExpression)boe.getLeftExpression();
            ExpressionVariableInitializer variableInitializer = boe.getRightExpression().isNewInitializedArray() ? ((NewInitializedArray)boe.getRightExpression()).getArrayInitializer() : new ExpressionVariableInitializer(boe.getRightExpression());
            ClassFileLocalVariableDeclarator declarator = new ClassFileLocalVariableDeclarator(boe.getLineNumber(), reference.getLocalVariable(), (VariableInitializer)variableInitializer);
            if (setDimension) {
                declarator.setDimension(reference.getLocalVariable().getDimension());
            }
            declarators.add((Object)declarator);
        }
        return declarators;
    }

    protected void createStartBlockDeclarations() {
        int addIndex = -1;
        int i = this.localVariableArray.length;
        while (i-- > 0) {
            for (AbstractLocalVariable lv = this.localVariableArray[i]; lv != null; lv = lv.getNext()) {
                if (lv.isDeclared()) continue;
                if (addIndex == -1) {
                    addIndex = this.getAddIndex();
                }
                this.statements.add(addIndex, (Object)new LocalVariableDeclarationStatement(lv.getType(), (BaseLocalVariableDeclarator)new ClassFileLocalVariableDeclarator(lv)));
                lv.setDeclared(true);
            }
        }
    }

    protected int getAddIndex() {
        int addIndex;
        if (this.parent.parent == null) {
            int len = this.statements.size();
            for (addIndex = 0; addIndex < len; ++addIndex) {
                Expression expression;
                Statement statement = (Statement)this.statements.get(addIndex);
                if (!statement.isExpressionStatement() || !(expression = statement.getExpression()).isSuperConstructorInvocationExpression() && !expression.isConstructorInvocationExpression()) continue;
                break;
            }
            if (addIndex >= len) {
                addIndex = 0;
            }
        }
        return addIndex;
    }

    protected void mergeDeclarations() {
        int size = this.statements.size();
        if (size > 1) {
            DefaultList declarations = new DefaultList();
            ListIterator iterator = this.statements.listIterator();
            while (iterator.hasNext()) {
                int declarationSize;
                int minDimension;
                Statement previous;
                while (!(previous = (Statement)iterator.next()).isLocalVariableDeclarationStatement() && iterator.hasNext()) {
                }
                if (!previous.isLocalVariableDeclarationStatement()) continue;
                LocalVariableDeclarationStatement lvds1 = (LocalVariableDeclarationStatement)previous;
                Type type1 = lvds1.getType();
                Type type0 = type1.createType(0);
                int maxDimension = minDimension = type1.getDimension();
                int lineNumber1 = lvds1.getLocalVariableDeclarators().getLineNumber();
                declarations.clear();
                declarations.add((Object)lvds1);
                while (iterator.hasNext()) {
                    Statement statement = (Statement)iterator.next();
                    if (!statement.isLocalVariableDeclarationStatement()) {
                        iterator.previous();
                        break;
                    }
                    LocalVariableDeclarationStatement lvds2 = (LocalVariableDeclarationStatement)statement;
                    int lineNumber2 = lvds2.getLocalVariableDeclarators().getLineNumber();
                    if (lineNumber1 != lineNumber2) {
                        iterator.previous();
                        break;
                    }
                    lineNumber1 = lineNumber2;
                    Type type2 = lvds2.getType();
                    if (type1.isPrimitiveType() && type2.isPrimitiveType()) {
                        PrimitiveType type = PrimitiveTypeUtil.getCommonPrimitiveType((PrimitiveType)((PrimitiveType)type1), (PrimitiveType)((PrimitiveType)type2));
                        if (type == null) {
                            iterator.previous();
                            break;
                        }
                        type0 = type;
                        type1 = type.createType(type1.getDimension());
                        type2 = type.createType(type2.getDimension());
                    } else if (!type1.equals(type2) && !type0.equals(type2.createType(0))) {
                        iterator.previous();
                        break;
                    }
                    int dimension = type2.getDimension();
                    if (minDimension > dimension) {
                        minDimension = dimension;
                    }
                    if (maxDimension < dimension) {
                        maxDimension = dimension;
                    }
                    declarations.add((Object)lvds2);
                }
                if ((declarationSize = declarations.size()) <= 1) continue;
                while (--declarationSize > 0) {
                    iterator.previous();
                    iterator.remove();
                }
                iterator.previous();
                if (minDimension == maxDimension) {
                    iterator.set(new LocalVariableDeclarationStatement(type1, (BaseLocalVariableDeclarator)this.createDeclarators2((DefaultList<LocalVariableDeclarationStatement>)declarations, false)));
                } else {
                    iterator.set(new LocalVariableDeclarationStatement(type0, (BaseLocalVariableDeclarator)this.createDeclarators2((DefaultList<LocalVariableDeclarationStatement>)declarations, true)));
                }
                iterator.next();
            }
        }
    }

    protected LocalVariableDeclarators createDeclarators2(DefaultList<LocalVariableDeclarationStatement> declarations, boolean setDimension) {
        LocalVariableDeclarators declarators = new LocalVariableDeclarators(declarations.size());
        for (LocalVariableDeclarationStatement declaration : declarations) {
            LocalVariableDeclarator declarator = (LocalVariableDeclarator)declaration.getLocalVariableDeclarators();
            if (setDimension) {
                declarator.setDimension(declaration.getType().getDimension());
            }
            declarators.add((Object)declarator);
        }
        return declarators;
    }

    protected static class GenerateLocalVariableNameVisitor
    implements TypeArgumentVisitor {
        protected static final String[] INTEGER_NAMES = new String[]{"i", "j", "k", "m", "n"};
        private final StringBuilder sb = new StringBuilder();
        private final Set<String> blackListNames;
        private final Map<Type, Boolean> types;
        private String name;

        public GenerateLocalVariableNameVisitor(Set<String> blackListNames, Map<Type, Boolean> types) {
            this.blackListNames = blackListNames;
            this.types = types;
        }

        public String getName() {
            return this.name;
        }

        public void visit(PrimitiveType type) {
            this.sb.setLength(0);
            switch (type.getJavaPrimitiveFlags()) {
                case 16: {
                    this.sb.append("b");
                    break;
                }
                case 2: {
                    this.sb.append("c");
                    break;
                }
                case 8: {
                    this.sb.append("d");
                    break;
                }
                case 4: {
                    this.sb.append("f");
                    break;
                }
                case 64: {
                    for (String in : INTEGER_NAMES) {
                        if (this.blackListNames.contains(in)) continue;
                        this.name = in;
                        this.blackListNames.add(this.name);
                        return;
                    }
                    this.sb.append("i");
                    break;
                }
                case 128: {
                    this.sb.append("l");
                    break;
                }
                case 32: {
                    this.sb.append("s");
                    break;
                }
                case 1: {
                    this.sb.append("bool");
                }
            }
            this.generate((Type)type);
        }

        public void visit(ObjectType type) {
            this.visit((Type)type, type.getName());
        }

        public void visit(InnerObjectType type) {
            this.visit((Type)type, type.getName());
        }

        public void visit(GenericType type) {
            this.visit((Type)type, type.getName());
        }

        protected void visit(Type type, String str) {
            this.sb.setLength(0);
            if (type.getDimension() == 0) {
                this.sb.append(switch (str) {
                    case "Class" -> "clazz";
                    case "String" -> "str";
                    case "Boolean" -> "bool";
                    default -> {
                        this.uncapitalize(str);
                        yield CAPITALIZED_JAVA_LANGUAGE_KEYWORDS.contains(str) ? "_" : "";
                    }
                });
            } else {
                this.sb.append("arrayOf");
                this.capitalize(str);
            }
            this.generate(type);
        }

        protected void capitalize(String str) {
            int length;
            if (str != null && (length = str.length()) > 0) {
                char firstChar = str.charAt(0);
                if (Character.isUpperCase(firstChar)) {
                    this.sb.append(str);
                } else {
                    this.sb.append(Character.toUpperCase(firstChar));
                    if (length > 1) {
                        this.sb.append(str.substring(1));
                    }
                }
            }
        }

        protected void uncapitalize(String str) {
            int length;
            if (str != null && (length = str.length()) > 0) {
                char firstChar = str.charAt(0);
                if (Character.isLowerCase(firstChar)) {
                    this.sb.append(str);
                } else {
                    this.sb.append(Character.toLowerCase(firstChar));
                    if (length > 1) {
                        this.sb.append(str.substring(1));
                    }
                }
            }
        }

        protected void generate(Type type) {
            int length = this.sb.length();
            int counter = 1;
            if (Boolean.TRUE.equals(this.types.get(type))) {
                this.sb.append(counter);
                ++counter;
            }
            this.name = this.sb.toString();
            while (this.blackListNames.contains(this.name)) {
                this.sb.setLength(length);
                this.sb.append(counter);
                ++counter;
                this.name = this.sb.toString();
            }
            this.blackListNames.add(this.name);
        }

        public void visit(TypeArguments type) {
        }

        public void visit(DiamondTypeArgument type) {
        }

        public void visit(WildcardExtendsTypeArgument type) {
        }

        public void visit(WildcardSuperTypeArgument type) {
        }

        public void visit(WildcardTypeArgument type) {
        }
    }
}

