/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jd.core.v1.model.classfile.ClassFile;
import org.jd.core.v1.model.javasyntax.declaration.BaseMemberDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.BodyDeclaration;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.TypeArgument;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorOrMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileFieldDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileMemberDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileTypeDeclaration;
import org.jd.core.v1.util.DefaultList;

public class ClassFileBodyDeclaration
extends BodyDeclaration
implements ClassFileMemberDeclaration {
    private final ClassFile classFile;
    private List<ClassFileFieldDeclaration> fieldDeclarations;
    private List<ClassFileConstructorOrMethodDeclaration> methodDeclarations;
    private List<ClassFileTypeDeclaration> innerTypeDeclarations;
    private Map<String, ClassFileTypeDeclaration> innerTypeMap = Collections.emptyMap();
    private int firstLineNumber;
    private String outerTypeFieldName;
    private DefaultList<String> syntheticInnerFieldNames;
    private final ClassFileBodyDeclaration outerBodyDeclaration;
    private final Map<String, TypeArgument> bindings;
    private final Map<String, BaseType> typeBounds;

    public ClassFileBodyDeclaration(ClassFile classFile, Map<String, TypeArgument> bindings, Map<String, BaseType> typeBounds, ClassFileBodyDeclaration outerBodyDeclaration) {
        super(classFile.getInternalTypeName(), null);
        this.classFile = classFile;
        this.bindings = bindings;
        this.typeBounds = typeBounds;
        this.outerBodyDeclaration = outerBodyDeclaration;
    }

    public void setMemberDeclarations(BaseMemberDeclaration memberDeclarations) {
        this.memberDeclarations = memberDeclarations;
    }

    public List<ClassFileFieldDeclaration> getFieldDeclarations() {
        return this.fieldDeclarations;
    }

    public void setFieldDeclarations(List<ClassFileFieldDeclaration> fieldDeclarations) {
        this.fieldDeclarations = fieldDeclarations;
        this.updateFirstLineNumber(this.fieldDeclarations);
    }

    public List<ClassFileConstructorOrMethodDeclaration> getMethodDeclarations() {
        return this.methodDeclarations;
    }

    public void setMethodDeclarations(List<ClassFileConstructorOrMethodDeclaration> methodDeclarations) {
        this.methodDeclarations = methodDeclarations;
        this.updateFirstLineNumber(this.methodDeclarations);
    }

    public List<ClassFileTypeDeclaration> getInnerTypeDeclarations() {
        return this.innerTypeDeclarations;
    }

    public boolean hasInnerTypeDeclarations() {
        return this.innerTypeDeclarations != null;
    }

    public void setInnerTypeDeclarations(List<ClassFileTypeDeclaration> innerTypeDeclarations) {
        if (innerTypeDeclarations != null) {
            this.innerTypeDeclarations = innerTypeDeclarations;
            this.updateFirstLineNumber(this.innerTypeDeclarations);
            this.innerTypeMap = new HashMap<String, ClassFileTypeDeclaration>();
            for (ClassFileTypeDeclaration innerType : innerTypeDeclarations) {
                this.innerTypeMap.put(innerType.getInternalTypeName(), innerType);
            }
        }
    }

    public ClassFileTypeDeclaration getInnerTypeDeclaration(String internalName) {
        ClassFileTypeDeclaration declaration = this.innerTypeMap.get(internalName);
        if (declaration == null && this.outerBodyDeclaration != null) {
            return this.outerBodyDeclaration.getInnerTypeDeclaration(internalName);
        }
        return declaration;
    }

    public ClassFileMemberDeclaration removeInnerType(String internalName) {
        ClassFileMemberDeclaration removed = this.innerTypeMap.remove(internalName);
        if (this.innerTypeDeclarations != null) {
            this.innerTypeDeclarations.remove(removed);
        }
        return removed;
    }

    protected void updateFirstLineNumber(List<? extends ClassFileMemberDeclaration> members) {
        for (ClassFileMemberDeclaration classFileMemberDeclaration : members) {
            int lineNumber = classFileMemberDeclaration.getFirstLineNumber();
            if (lineNumber <= 0) continue;
            if (this.firstLineNumber != 0 && this.firstLineNumber <= lineNumber) break;
            this.firstLineNumber = lineNumber;
            break;
        }
    }

    public ClassFile getClassFile() {
        return this.classFile;
    }

    @Override
    public int getFirstLineNumber() {
        return this.firstLineNumber;
    }

    public String getOuterTypeFieldName() {
        return this.outerTypeFieldName;
    }

    public void setOuterTypeFieldName(String outerTypeFieldName) {
        this.outerTypeFieldName = outerTypeFieldName;
    }

    public DefaultList<String> getSyntheticInnerFieldNames() {
        return this.syntheticInnerFieldNames;
    }

    public void setSyntheticInnerFieldNames(DefaultList<String> syntheticInnerFieldNames) {
        this.syntheticInnerFieldNames = syntheticInnerFieldNames;
    }

    public ClassFileBodyDeclaration getOuterBodyDeclaration() {
        return this.outerBodyDeclaration;
    }

    public boolean isMainBodyDeclaration() {
        return this.outerBodyDeclaration == null;
    }

    public Map<String, TypeArgument> getBindings() {
        return this.bindings;
    }

    public Map<String, BaseType> getTypeBounds() {
        return this.typeBounds;
    }

    public String toString() {
        return "ClassFileBodyDeclaration{firstLineNumber=" + this.firstLineNumber + "}";
    }
}

