/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg;

import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg.BasicBlock;

public class Loop {
    private BasicBlock start;
    private final Set<BasicBlock> members;
    private BasicBlock end;

    public Loop(BasicBlock start, Set<BasicBlock> members, BasicBlock end) {
        this.start = start;
        this.members = members;
        this.end = end;
    }

    public BasicBlock getStart() {
        return this.start;
    }

    public void setStart(BasicBlock start) {
        this.start = start;
    }

    public Set<BasicBlock> getMembers() {
        return this.members;
    }

    public int getMemberCount() {
        return this.members.size();
    }

    public BasicBlock getEnd() {
        return this.end;
    }

    public void setEnd(BasicBlock end) {
        this.end = end;
    }

    public void updateEnclosingLoop() {
        this.members.forEach(this::updateEnclosingLoop);
    }

    private void updateEnclosingLoop(BasicBlock member) {
        member.setEnclosingLoop(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Loop loop = (Loop)o;
        return Objects.equals(this.start, loop.start) && Objects.equals(this.members, loop.members) && Objects.equals(this.end, loop.end);
    }

    public int hashCode() {
        int result = 258190310 + this.start.hashCode();
        result = 31 * result + this.members.hashCode();
        return 31 * result + Objects.hash(this.end);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("Loop{start=").append(this.start.getIndex()).append(", members=[");
        if (this.members != null && !this.members.isEmpty()) {
            Iterator<BasicBlock> iterator = this.members.iterator();
            str.append(iterator.next().getIndex());
            while (iterator.hasNext()) {
                str.append(", ").append(iterator.next().getIndex());
            }
        }
        return str + "], end=" + Optional.ofNullable(this.end).map(BasicBlock::getIndex).orElse(-1) + "}";
    }
}

