/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg;

import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.Method;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg.BasicBlock;
import org.jd.core.v1.service.converter.classfiletojavasyntax.processor.block.api.BlockProcessor;
import org.jd.core.v1.util.DefaultList;

public class ControlFlowGraph {
    private final Method method;
    private final DefaultList<BasicBlock> list = new DefaultList<BasicBlock>(){
        private static final long serialVersionUID = 1L;

        public BasicBlock remove(int index) {
            throw new UnsupportedOperationException();
        }
    };
    private int[] offsetToLineNumbers;

    public ControlFlowGraph(Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public DefaultList<BasicBlock> getBasicBlocks() {
        return this.list;
    }

    public BasicBlock getStart() {
        return (BasicBlock)this.list.get(0);
    }

    public BasicBlock newBasicBlock(BasicBlock original) {
        BasicBlock basicBlock = new BasicBlock(this, this.list.size(), original);
        this.list.add((Object)basicBlock);
        return basicBlock;
    }

    public BasicBlock newBasicBlock(int fromOffset, int toOffset) {
        return this.newBasicBlock(0, fromOffset, toOffset);
    }

    public BasicBlock newBasicBlock(int type, int fromOffset, int toOffset) {
        BasicBlock basicBlock = new BasicBlock(this, this.list.size(), type, fromOffset, toOffset, true);
        this.list.add((Object)basicBlock);
        return basicBlock;
    }

    public BasicBlock newBasicBlock(int type, int fromOffset, int toOffset, boolean inverseCondition) {
        BasicBlock basicBlock = new BasicBlock(this, this.list.size(), type, fromOffset, toOffset, inverseCondition);
        this.list.add((Object)basicBlock);
        return basicBlock;
    }

    public BasicBlock newBasicBlock(int type, int fromOffset, int toOffset, Set<BasicBlock> predecessors) {
        BasicBlock basicBlock = new BasicBlock(this, this.list.size(), type, fromOffset, toOffset, true, predecessors);
        this.list.add((Object)basicBlock);
        return basicBlock;
    }

    public BasicBlock newJumpBasicBlock(BasicBlock bb, BasicBlock target) {
        HashSet<BasicBlock> predecessors = new HashSet<BasicBlock>();
        predecessors.add(bb);
        target.getPredecessors().remove(bb);
        return this.newBasicBlock(0x40000000, bb.getFromOffset(), target.getFromOffset(), predecessors);
    }

    public void setOffsetToLineNumbers(int[] offsetToLineNumbers) {
        this.offsetToLineNumbers = offsetToLineNumbers;
    }

    public int getLineNumber(int offset) {
        return this.offsetToLineNumbers == null || offset < 0 ? 0 : this.offsetToLineNumbers[offset];
    }

    public void accept(BlockProcessor blockProcessor) {
        blockProcessor.process(this);
    }

    public boolean contains(int basickBlockType) {
        for (BasicBlock basicBlock : this.list) {
            if (basicBlock.getType() != basickBlockType) continue;
            return true;
        }
        return false;
    }
}

