/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.printer;

import org.jd.core.v1.api.printer.Printer;

public class PlainTextPrinter
implements Printer {
    protected static final String TAB = "  ";
    protected static final String NEWLINE = "\n";
    protected int indentationCount;
    protected StringBuilder sb = new StringBuilder();
    protected int realLineNumber;
    protected String format;
    protected boolean escapeUnicodeCharacters;

    public PlainTextPrinter() {
        this.escapeUnicodeCharacters = false;
    }

    public PlainTextPrinter(boolean escapeUnicodeCharacters) {
        this.escapeUnicodeCharacters = escapeUnicodeCharacters;
    }

    public void init() {
        this.sb.setLength(0);
        this.realLineNumber = 0;
        this.indentationCount = 0;
    }

    public String toString() {
        return this.sb.toString();
    }

    @Override
    public void start(int maxLineNumber, int majorVersion, int minorVersion) {
        this.indentationCount = 0;
        if (maxLineNumber == 0) {
            this.format = "%4d";
        } else {
            int width = 2;
            while (maxLineNumber >= 10) {
                ++width;
                maxLineNumber /= 10;
            }
            this.format = "%" + width + "d";
        }
    }

    @Override
    public void end() {
    }

    @Override
    public void printText(String text) {
        if (this.escapeUnicodeCharacters) {
            int len = text.length();
            for (int i = 0; i < len; ++i) {
                char c = text.charAt(i);
                if (c < '\u007f') {
                    this.sb.append(c);
                    continue;
                }
                int h = c >> 12;
                this.sb.append("\\u");
                this.sb.append((char)(h <= 9 ? h + 48 : h + 55));
                h = c >> 8 & 0xF;
                this.sb.append((char)(h <= 9 ? h + 48 : h + 55));
                h = c >> 4 & 0xF;
                this.sb.append((char)(h <= 9 ? h + 48 : h + 55));
                h = c & 0xF;
                this.sb.append((char)(h <= 9 ? h + 48 : h + 55));
            }
        } else {
            this.sb.append(text);
        }
    }

    @Override
    public void printNumericConstant(String constant) {
        this.sb.append(constant);
    }

    @Override
    public void printStringConstant(String constant, String ownerInternalName) {
        this.printText(constant);
    }

    @Override
    public void printKeyword(String keyword) {
        this.sb.append(keyword);
    }

    @Override
    public void printDeclaration(int type, String internalTypeName, String name, String descriptor) {
        this.printText(name);
    }

    @Override
    public void printReference(int type, String internalTypeName, String name, String descriptor, String ownerInternalName) {
        this.printText(name);
    }

    @Override
    public void indent() {
        ++this.indentationCount;
    }

    @Override
    public void unindent() {
        if (this.indentationCount > 0) {
            --this.indentationCount;
        }
    }

    @Override
    public void startLine(int lineNumber) {
        this.printLineNumber(lineNumber);
        for (int i = 0; i < this.indentationCount; ++i) {
            this.sb.append(TAB);
        }
    }

    @Override
    public void endLine() {
        this.sb.append(NEWLINE);
    }

    @Override
    public void extraLine(int count) {
        while (count-- > 0) {
            this.printLineNumber(0);
            this.sb.append(NEWLINE);
        }
    }

    @Override
    public void startMarker(int type) {
    }

    @Override
    public void endMarker(int type) {
    }

    protected void printLineNumber(int lineNumber) {
        this.sb.append("/*");
        this.sb.append(String.format(this.format, ++this.realLineNumber));
        this.sb.append(':');
        this.sb.append(String.format(this.format, lineNumber));
        this.sb.append(" */ ");
    }
}

