/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.printer;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jd.core.ClassUtil;
import org.jd.core.v1.api.Decompiler;
import org.jd.core.v1.api.loader.Loader;
import org.jd.core.v1.printer.StringBuilderPrinter;

public class LineNumberStringBuilderPrinter
extends StringBuilderPrinter {
    private boolean showLineNumbers;
    private int maxLineNumber;
    private int digitCount;
    private String lineNumberBeginPrefix;
    private String lineNumberEndPrefix;
    private String unknownLineNumberPrefix;

    public void setShowLineNumbers(boolean showLineNumbers) {
        this.showLineNumbers = showLineNumbers;
    }

    protected int printDigit(int dcv, int lineNumber, int divisor, int left) {
        if (this.digitCount >= dcv) {
            if (lineNumber < divisor) {
                this.stringBuffer.append(' ');
            } else {
                int e = (lineNumber - left) / divisor;
                this.stringBuffer.append((char)(48 + e));
                left += e * divisor;
            }
        }
        return left;
    }

    @Override
    public void start(int maxLineNumber, int majorVersion, int minorVersion) {
        super.start(maxLineNumber, majorVersion, minorVersion);
        if (this.showLineNumbers) {
            this.maxLineNumber = maxLineNumber;
            if (maxLineNumber > 0) {
                this.digitCount = 1;
                this.unknownLineNumberPrefix = " ";
                int maximum = 9;
                while (maximum < maxLineNumber) {
                    ++this.digitCount;
                    maximum = maximum * 10 + 9;
                }
                this.unknownLineNumberPrefix = " ".repeat(this.digitCount);
                this.lineNumberBeginPrefix = "/* ";
                this.lineNumberEndPrefix = " */ ";
            } else {
                this.unknownLineNumberPrefix = "";
                this.lineNumberBeginPrefix = "";
                this.lineNumberEndPrefix = "";
            }
        } else {
            this.maxLineNumber = 0;
            this.unknownLineNumberPrefix = "";
            this.lineNumberBeginPrefix = "";
            this.lineNumberEndPrefix = "";
        }
    }

    @Override
    public void startLine(int lineNumber) {
        if (this.maxLineNumber > 0) {
            this.stringBuffer.append(this.lineNumberBeginPrefix);
            if (lineNumber == 0) {
                this.stringBuffer.append(this.unknownLineNumberPrefix);
            } else {
                int left = 0;
                left = this.printDigit(5, lineNumber, 10000, left);
                left = this.printDigit(4, lineNumber, 1000, left);
                left = this.printDigit(3, lineNumber, 100, left);
                left = this.printDigit(2, lineNumber, 10, left);
                this.stringBuffer.append((char)(48 + (lineNumber - left)));
            }
            this.stringBuffer.append(this.lineNumberEndPrefix);
        }
        for (int i = 0; i < this.indentationCount; ++i) {
            this.stringBuffer.append("  ");
        }
    }

    @Override
    public void extraLine(int count) {
        if (this.realignmentLineNumber) {
            while (count-- > 0) {
                this.printLineNumber();
                this.stringBuffer.append("\n");
            }
        }
    }

    private void printLineNumber() {
        if (this.maxLineNumber > 0) {
            this.stringBuffer.append(this.lineNumberBeginPrefix);
            this.stringBuffer.append(this.unknownLineNumberPrefix);
            this.stringBuffer.append(this.lineNumberEndPrefix);
        }
    }

    public String buildDecompiledOutput(Map<String, String> preferences, Loader loader, String entryPath, Decompiler decompiler) throws IOException {
        boolean realignmentLineNumbers = Boolean.parseBoolean(preferences.getOrDefault("ClassFileSaverPreferences.realignLineNumbers", Boolean.FALSE.toString()));
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        configuration.put("realignLineNumbers", realignmentLineNumbers);
        this.setRealignmentLineNumber(realignmentLineNumbers);
        this.setUnicodeEscape(Boolean.parseBoolean(preferences.getOrDefault("ClassFileSaverPreferences.escapeUnicodeCharacters", Boolean.FALSE.toString())));
        this.setShowLineNumbers(Boolean.parseBoolean(preferences.getOrDefault("ClassFileSaverPreferences.writeLineNumbers", Boolean.TRUE.toString())));
        String entryInternalName = ClassUtil.getInternalName((String)entryPath);
        decompiler.decompile(loader, this, entryInternalName, configuration);
        StringBuilder stringBuffer = this.getStringBuffer();
        if (Boolean.parseBoolean(preferences.getOrDefault("ClassFileSaverPreferences.writeMetadata", Boolean.TRUE.toString()))) {
            stringBuffer.append("\n\n/*");
            int majorVersion = this.getMajorVersion();
            if (majorVersion >= 45) {
                stringBuffer.append("\n * Java compiler version: ");
                if (majorVersion >= 49) {
                    stringBuffer.append(majorVersion - 44);
                } else {
                    stringBuffer.append("1.");
                    stringBuffer.append(majorVersion - 44);
                }
                stringBuffer.append(" (");
                stringBuffer.append(majorVersion);
                stringBuffer.append('.');
                stringBuffer.append(this.getMinorVersion());
                stringBuffer.append(')');
            }
            stringBuffer.append("\n * JD-Core Version:       ");
            stringBuffer.append(this.getVersion());
            stringBuffer.append("\n */");
        }
        return stringBuffer.toString();
    }
}

