/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.printer;

import java.util.HashMap;
import java.util.Map;
import jd.core.DecompilationResult;
import jd.core.links.DeclarationData;
import jd.core.links.HyperlinkData;
import jd.core.links.HyperlinkReferenceData;
import jd.core.links.ReferenceData;
import jd.core.links.StringData;
import org.jd.core.v1.printer.LineNumberStringBuilderPrinter;

public class ClassFilePrinter
extends LineNumberStringBuilderPrinter {
    private final Map<String, ReferenceData> referencesCache = new HashMap<String, ReferenceData>();
    private final DecompilationResult result = new DecompilationResult();
    private int textAreaLineNumber = 1;

    @Override
    public void start(int maxLineNumber, int majorVersion, int minorVersion) {
        super.start(maxLineNumber, majorVersion, minorVersion);
        if (maxLineNumber != 0) {
            this.result.setMaxLineNumber(maxLineNumber);
        }
    }

    @Override
    public void printStringConstant(String constant, String ownerInternalName) {
        if (constant == null) {
            constant = "null";
        }
        if (ownerInternalName == null) {
            ownerInternalName = "null";
        }
        this.result.addString(new StringData(this.stringBuffer.length(), constant, ownerInternalName));
        super.printStringConstant(constant, ownerInternalName);
    }

    @Override
    public void printDeclaration(int type, String internalTypeName, String name, String descriptor) {
        if (internalTypeName == null) {
            internalTypeName = "null";
        }
        if (name == null) {
            name = "null";
        }
        if (descriptor == null) {
            descriptor = "null";
        }
        switch (type) {
            case 1: {
                DeclarationData data = new DeclarationData(this.stringBuffer.length(), name.length(), internalTypeName, null, null);
                this.result.addDeclaration(internalTypeName, data);
                this.result.addTypeDeclaration(this.stringBuffer.length(), data);
                break;
            }
            case 4: {
                this.result.addDeclaration(internalTypeName + "-<init>-" + descriptor, new DeclarationData(this.stringBuffer.length(), name.length(), internalTypeName, "<init>", descriptor));
                break;
            }
            default: {
                this.result.addDeclaration(internalTypeName + "-" + name + "-" + descriptor, new DeclarationData(this.stringBuffer.length(), name.length(), internalTypeName, name, descriptor));
            }
        }
        super.printDeclaration(type, internalTypeName, name, descriptor);
    }

    @Override
    public void printReference(int type, String internalTypeName, String name, String descriptor, String ownerInternalName) {
        if (internalTypeName == null) {
            internalTypeName = "null";
        }
        if (name == null) {
            name = "null";
        }
        if (descriptor == null) {
            descriptor = "null";
        }
        switch (type) {
            case 1: {
                this.addHyperlink((HyperlinkData)new HyperlinkReferenceData(this.stringBuffer.length(), name.length(), this.newReferenceData(internalTypeName, null, null, ownerInternalName)));
                break;
            }
            case 4: {
                this.addHyperlink((HyperlinkData)new HyperlinkReferenceData(this.stringBuffer.length(), name.length(), this.newReferenceData(internalTypeName, "<init>", descriptor, ownerInternalName)));
                break;
            }
            default: {
                this.addHyperlink((HyperlinkData)new HyperlinkReferenceData(this.stringBuffer.length(), name.length(), this.newReferenceData(internalTypeName, name, descriptor, ownerInternalName)));
            }
        }
        super.printReference(type, internalTypeName, name, descriptor, ownerInternalName);
    }

    public void addHyperlink(HyperlinkData hyperlinkData) {
        this.result.addHyperLink(hyperlinkData.getStartPosition(), hyperlinkData);
    }

    @Override
    public void startLine(int lineNumber) {
        super.startLine(lineNumber);
        this.result.putLineNumber(this.textAreaLineNumber, lineNumber);
    }

    @Override
    public void endLine() {
        super.endLine();
        ++this.textAreaLineNumber;
    }

    @Override
    public void extraLine(int count) {
        super.extraLine(count);
        if (this.realignmentLineNumber) {
            this.textAreaLineNumber += count;
        }
    }

    public ReferenceData newReferenceData(String internalName, String name, String descriptor, String scopeInternalName) {
        String key = internalName + "-" + name + "-" + descriptor + "-" + scopeInternalName;
        return this.referencesCache.computeIfAbsent(key, k -> {
            ReferenceData reference = new ReferenceData(internalName, name, descriptor, scopeInternalName);
            this.result.addReference(reference);
            return reference;
        });
    }

    public DecompilationResult getResult() {
        return this.result;
    }
}

