/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javafragment;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jd.core.v1.model.fragment.FlexibleFragment;
import org.jd.core.v1.model.javafragment.JavaFragment;
import org.jd.core.v1.model.javafragment.JavaFragmentVisitor;
import org.jd.core.v1.util.DefaultList;

public class ImportsFragment
extends FlexibleFragment
implements JavaFragment {
    private final Map<String, Import> importMap = new HashMap<String, Import>();

    public ImportsFragment(int weight) {
        super(0, -1, -1, weight, "Imports");
    }

    public void addImport(String internalName, String qualifiedName) {
        Import imp = this.importMap.get(internalName);
        if (imp == null) {
            this.importMap.put(internalName, new Import(internalName, qualifiedName));
        } else {
            imp.incCounter();
        }
    }

    public boolean incCounter(String internalName) {
        Import imp = this.importMap.get(internalName);
        if (imp == null) {
            return false;
        }
        imp.incCounter();
        return true;
    }

    public boolean isEmpty() {
        return this.importMap.isEmpty();
    }

    public void initLineCounts() {
        this.initialLineCount = this.lineCount = this.importMap.size();
        this.maximalLineCount = this.lineCount;
    }

    public boolean contains(String internalName) {
        return this.importMap.containsKey(internalName);
    }

    @Override
    public int getLineCount() {
        if (this.lineCount == -1) {
            throw new IllegalStateException("Call initLineCounts() before");
        }
        return this.lineCount;
    }

    public Collection<Import> getImports() {
        int size;
        int lineCount = this.getLineCount();
        if (lineCount >= (size = this.importMap.size())) {
            return this.importMap.values();
        }
        DefaultList imports = new DefaultList(this.importMap.values());
        imports.sort(Comparator.comparing(Import::getCounter).reversed());
        List subList = imports.subList(lineCount, size);
        for (Import imp0rt : subList) {
            this.importMap.remove(imp0rt.getInternalName());
        }
        subList.clear();
        return imports;
    }

    @Override
    public void accept(JavaFragmentVisitor visitor) {
        visitor.visit(this);
    }

    public static class Import {
        private final String internalName;
        private final String qualifiedName;
        private int counter;

        public Import(String internalName, String qualifiedName) {
            this.internalName = internalName;
            this.qualifiedName = qualifiedName;
            this.counter = 1;
        }

        public String getInternalName() {
            return this.internalName;
        }

        public String getQualifiedName() {
            return this.qualifiedName;
        }

        public int getCounter() {
            return this.counter;
        }

        public void incCounter() {
            ++this.counter;
        }
    }
}

