/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.cfg;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.bcel.classfile.Method;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg.BasicBlock;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg.ControlFlowGraph;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ByteCodeWriter;
import org.jd.core.v1.util.DefaultList;

public final class ControlFlowGraphPlantUMLWriter {
    private static final String EOL = "\\n\\\n";
    private static final String REDUCED = "<<Reduced>>\n";
    private static final String AS = "\" as ";
    private static final String STATE = "state \"";
    private static final int MAX_OFFSET = Integer.MAX_VALUE;

    private ControlFlowGraphPlantUMLWriter() {
    }

    public static String write(ControlFlowGraph cfg) {
        if (cfg.getBasicBlocks() == null) {
            return null;
        }
        TreeSet<BasicBlock> set = new TreeSet<BasicBlock>(Comparator.comparingInt(BasicBlock::getIndex));
        ControlFlowGraphPlantUMLWriter.search(set, cfg.getStart());
        DefaultList list = new DefaultList(set);
        StringBuilder sb = new StringBuilder();
        sb.append("@startuml\n");
        sb.append("skinparam state {\n");
        sb.append("  BackgroundColor<<Reduced>> #BBD7B7\n");
        sb.append("  BorderColor<<Reduced>> Green\n");
        sb.append("  BackgroundColor<<Synthetic>> PowderBlue\n");
        sb.append("  BorderColor<<Synthetic>> DodgerBlue\n");
        sb.append("  BackgroundColor<<ToReduce>> Orange\n");
        sb.append("  BorderColor<<ToReduce>> #FF740E\n");
        sb.append("}\n");
        sb.append("skinparam BackgroundColor #2B2B2B\n");
        sb.append("skinparam state {\n");
        sb.append("  StartColor #999999\n");
        sb.append("  BackgroundColor #D6BF55\n");
        sb.append("  BorderColor #F6DF57\n");
        sb.append("}\n");
        sb.append("skinparam sequence {\n");
        sb.append("  ArrowColor #999999\n");
        sb.append("  ArrowFontColor #AAAAAA\n");
        sb.append("}\n");
        Method method = cfg.getMethod();
        for (BasicBlock basicBlock : list) {
            ControlFlowGraphPlantUMLWriter.writeState(sb, method, basicBlock);
        }
        for (BasicBlock basicBlock : list) {
            ControlFlowGraphPlantUMLWriter.writeLink(sb, basicBlock);
        }
        sb.append("@enduml\n");
        return sb.toString();
    }

    private static void search(Set<BasicBlock> set, BasicBlock basicBlock) {
        if (!set.contains(basicBlock)) {
            set.add(basicBlock);
            switch (basicBlock.getType()) {
                case 1: 
                case 4: 
                case 0x400000: 
                case 0x4000000: 
                case 0x10000000: {
                    ControlFlowGraphPlantUMLWriter.search(set, basicBlock.getNext());
                    break;
                }
                case 8192: 
                case 32768: {
                    ControlFlowGraphPlantUMLWriter.search(set, basicBlock.getNext());
                    ControlFlowGraphPlantUMLWriter.search(set, basicBlock.getBranch());
                    break;
                }
                case 128: {
                    ControlFlowGraphPlantUMLWriter.search(set, basicBlock.getNext());
                }
                case 64: {
                    for (BasicBlock.SwitchCase switchCase : basicBlock.getSwitchCases()) {
                        ControlFlowGraphPlantUMLWriter.search(set, switchCase.getBasicBlock());
                    }
                    break;
                }
                case 1024: 
                case 2048: 
                case 4096: {
                    ControlFlowGraphPlantUMLWriter.search(set, basicBlock.getSub1());
                }
                case 512: {
                    ControlFlowGraphPlantUMLWriter.search(set, basicBlock.getNext());
                    for (BasicBlock.ExceptionHandler exceptionHandler : basicBlock.getExceptionHandlers()) {
                        ControlFlowGraphPlantUMLWriter.search(set, exceptionHandler.getBasicBlock());
                    }
                    break;
                }
                case 65536: {
                    ControlFlowGraphPlantUMLWriter.search(set, basicBlock.getCondition());
                    ControlFlowGraphPlantUMLWriter.search(set, basicBlock.getNext());
                    ControlFlowGraphPlantUMLWriter.search(set, basicBlock.getSub1());
                    break;
                }
                case 131072: 
                case 0x20000000: {
                    ControlFlowGraphPlantUMLWriter.search(set, basicBlock.getNext());
                }
                case 0x200000: {
                    ControlFlowGraphPlantUMLWriter.search(set, basicBlock.getCondition());
                }
                case 262144: 
                case 524288: 
                case 0x100000: {
                    ControlFlowGraphPlantUMLWriter.search(set, basicBlock.getSub1());
                    ControlFlowGraphPlantUMLWriter.search(set, basicBlock.getSub2());
                }
            }
        }
    }

    private static void writeState(StringBuilder sb, Method method, BasicBlock basicBlock) {
        if (basicBlock.getFromOffset() > Integer.MAX_VALUE) {
            return;
        }
        String id = ControlFlowGraphPlantUMLWriter.getStateId(basicBlock);
        switch (basicBlock.getType()) {
            case 4: 
            case 1024: 
            case 2048: 
            case 4096: 
            case 65536: 
            case 131072: 
            case 0x20000000: {
                sb.append(STATE).append(basicBlock.getTypeName()).append(" : ").append(basicBlock.getIndex()).append(AS).append(id).append(REDUCED);
                ControlFlowGraphPlantUMLWriter.writeStateOffsets(sb, id, basicBlock);
                ControlFlowGraphPlantUMLWriter.writeLineNumbers(sb, id, basicBlock);
                ControlFlowGraphPlantUMLWriter.writeStateEnd(sb, id, basicBlock.getNext(), "next");
                ControlFlowGraphPlantUMLWriter.writeStatePredecessors(sb, id, basicBlock);
                ControlFlowGraphPlantUMLWriter.writeStateCode(sb, id, method, basicBlock);
                break;
            }
            case 16: {
                if (basicBlock == BasicBlock.RETURN) break;
            }
            case 8: 
            case 32: 
            case 128: 
            case 16384: 
            case 0x8000000: 
            case 0x10000000: {
                sb.append(STATE).append(basicBlock.getTypeName()).append(" : ").append(basicBlock.getIndex()).append(AS).append(id).append(REDUCED);
                ControlFlowGraphPlantUMLWriter.writeStateOffsets(sb, id, basicBlock);
                ControlFlowGraphPlantUMLWriter.writeLineNumbers(sb, id, basicBlock);
                ControlFlowGraphPlantUMLWriter.writeStatePredecessors(sb, id, basicBlock);
                ControlFlowGraphPlantUMLWriter.writeStateCode(sb, id, method, basicBlock);
                break;
            }
            case 262144: 
            case 524288: 
            case 0x100000: 
            case 0x200000: {
                sb.append(STATE).append(basicBlock.getTypeName()).append(" : ").append(basicBlock.getIndex()).append(AS).append(id).append(REDUCED);
                ControlFlowGraphPlantUMLWriter.writeStateOffsets(sb, id, basicBlock);
                ControlFlowGraphPlantUMLWriter.writeLineNumbers(sb, id, basicBlock);
                ControlFlowGraphPlantUMLWriter.writeInverseCondition(sb, id, basicBlock);
                ControlFlowGraphPlantUMLWriter.writeStateCode(sb, id, method, basicBlock);
                break;
            }
            case 8192: {
                sb.append(STATE).append(basicBlock.getTypeName()).append(" : ").append(basicBlock.getIndex()).append(AS).append(id).append('\n');
                ControlFlowGraphPlantUMLWriter.writeStateOffsets(sb, id, basicBlock);
                ControlFlowGraphPlantUMLWriter.writeLineNumbers(sb, id, basicBlock);
                ControlFlowGraphPlantUMLWriter.writeStateEnd(sb, id, basicBlock.getNext(), "next");
                ControlFlowGraphPlantUMLWriter.writeStateEnd(sb, id, basicBlock.getBranch(), "branch");
                ControlFlowGraphPlantUMLWriter.writeStatePredecessors(sb, id, basicBlock);
                ControlFlowGraphPlantUMLWriter.writeStateCode(sb, id, method, basicBlock);
                break;
            }
            case 32768: {
                sb.append(STATE).append(basicBlock.getTypeName()).append(" : ").append(basicBlock.getIndex()).append(AS).append(id).append('\n');
                ControlFlowGraphPlantUMLWriter.writeStateOffsets(sb, id, basicBlock);
                ControlFlowGraphPlantUMLWriter.writeLineNumbers(sb, id, basicBlock);
                ControlFlowGraphPlantUMLWriter.writeStatePredecessors(sb, id, basicBlock);
                ControlFlowGraphPlantUMLWriter.writeStateCode(sb, id, method, basicBlock);
                break;
            }
            case 64: 
            case 512: 
            case 0x4000000: {
                sb.append(STATE).append(basicBlock.getTypeName()).append(" : ").append(basicBlock.getIndex()).append(AS).append(id).append("<<ToReduce>>\n");
                ControlFlowGraphPlantUMLWriter.writeStateOffsets(sb, id, basicBlock);
                ControlFlowGraphPlantUMLWriter.writeLineNumbers(sb, id, basicBlock);
                ControlFlowGraphPlantUMLWriter.writeStatePredecessors(sb, id, basicBlock);
                ControlFlowGraphPlantUMLWriter.writeStateCode(sb, id, method, basicBlock);
                break;
            }
            case 0x400000: {
                sb.append(STATE).append(basicBlock.getTypeName()).append(" : ").append(basicBlock.getIndex()).append(AS).append(id).append(" {\n");
                sb.append("[*] --> ").append(ControlFlowGraphPlantUMLWriter.getStateId(basicBlock.getSub1())).append('\n');
                HashSet<BasicBlock> set = new HashSet<BasicBlock>();
                ControlFlowGraphPlantUMLWriter.search(set, basicBlock.getSub1());
                set.remove(basicBlock);
                for (BasicBlock bb : set) {
                    ControlFlowGraphPlantUMLWriter.writeState(sb, method, bb);
                }
                for (BasicBlock bb : set) {
                    ControlFlowGraphPlantUMLWriter.writeLink(sb, bb);
                }
                sb.append("}\n");
                ControlFlowGraphPlantUMLWriter.writeStateOffsets(sb, id, basicBlock);
                ControlFlowGraphPlantUMLWriter.writeStateEnd(sb, id, basicBlock.getNext(), "next");
                ControlFlowGraphPlantUMLWriter.writeStatePredecessors(sb, id, basicBlock);
                break;
            }
            case 0x40000000: {
                sb.append(STATE).append(basicBlock.getTypeName()).append(" : ").append(basicBlock.getIndex()).append(AS).append(id).append("<<Synthetic>>\n");
                sb.append(id).append(" : offset = ").append(basicBlock.getFromOffset()).append("\n");
                sb.append(id).append(" : targetOffset = ").append(basicBlock.getToOffset()).append("\n");
            }
        }
    }

    private static void writeStateOffsets(StringBuilder sb, String id, BasicBlock basicBlock) {
        sb.append(id).append(" : fromOffset = ").append(basicBlock.getFromOffset()).append("\n");
        sb.append(id).append(" : toOffset = ").append(basicBlock.getToOffset()).append("\n");
    }

    private static void writeStatePredecessors(StringBuilder sb, String id, BasicBlock basicBlock) {
        Set<BasicBlock> predecessors = basicBlock.getPredecessors();
        if (!predecessors.isEmpty()) {
            sb.append(id).append(" : predecessors = [");
            Iterator<BasicBlock> iterator = predecessors.iterator();
            sb.append(iterator.next().getIndex());
            while (iterator.hasNext()) {
                sb.append(", ").append(iterator.next().getIndex());
            }
            sb.append("]\n");
        }
    }

    private static void writeInverseCondition(StringBuilder sb, String id, BasicBlock basicBlock) {
        if (basicBlock.matchType(270794752)) {
            sb.append(id).append(" : inverseCondition = ").append(basicBlock.mustInverseCondition()).append("\n");
        }
    }

    private static void writeStateCode(StringBuilder sb, String id, Method method, BasicBlock basicBlock) {
        if (method != null && basicBlock.matchType(472178940) && basicBlock.getFromOffset() < basicBlock.getToOffset()) {
            String byteCode = new ByteCodeWriter().write("  ", method, basicBlock.getFromOffset(), basicBlock.getToOffset());
            byteCode = byteCode.substring(0, byteCode.length() - 1).replace("\n", EOL).replace('[', '{');
            sb.append(id).append(" : code =").append(EOL).append(byteCode).append("\n");
        }
    }

    private static void writeLineNumbers(StringBuilder sb, String id, BasicBlock basicBlock) {
        if (basicBlock.getFirstLineNumber() > 0) {
            sb.append(id).append(" : firstLineNumber = ").append(basicBlock.getFirstLineNumber()).append("\n");
        }
        if (basicBlock.getLastLineNumber() > 0) {
            sb.append(id).append(" : lastLineNumber = ").append(basicBlock.getLastLineNumber()).append("\n");
        }
    }

    private static void writeStateEnd(StringBuilder sb, String id, BasicBlock basicBlock, String label) {
        if (basicBlock == BasicBlock.END) {
            sb.append(id).append(" : ").append(label).append(" = &#9673;\n");
        }
    }

    private static void writeLink(StringBuilder sb, BasicBlock basicBlock) {
        if (basicBlock.getFromOffset() > Integer.MAX_VALUE) {
            return;
        }
        String id = ControlFlowGraphPlantUMLWriter.getStateId(basicBlock);
        switch (basicBlock.getType()) {
            case 1: {
                sb.append("[*] --> ").append(ControlFlowGraphPlantUMLWriter.getStateId(basicBlock.getNext())).append('\n');
                break;
            }
            case 4: 
            case 0x4000000: 
            case 0x10000000: {
                ControlFlowGraphPlantUMLWriter.writeLink(sb, id, basicBlock.getNext(), "next");
                break;
            }
            case 262144: {
                ControlFlowGraphPlantUMLWriter.writeLink(sb, id, basicBlock.getSub1(), "sub1");
                ControlFlowGraphPlantUMLWriter.writeLink(sb, id, basicBlock.getSub2(), "sub2");
            }
            case 32768: {
                ControlFlowGraphPlantUMLWriter.writeLink(sb, id, basicBlock.getNext(), "next");
                ControlFlowGraphPlantUMLWriter.writeLink(sb, id, basicBlock.getBranch(), "branch");
                break;
            }
            case 128: {
                ControlFlowGraphPlantUMLWriter.writeLink(sb, id, basicBlock.getNext(), "next");
            }
            case 64: {
                BasicBlock next = basicBlock.getNext();
                for (BasicBlock.SwitchCase switchCase : basicBlock.getSwitchCases()) {
                    if (switchCase.getBasicBlock() == BasicBlock.END || switchCase.getBasicBlock() == next) continue;
                    ControlFlowGraphPlantUMLWriter.writeLink(sb, id, switchCase.getBasicBlock(), (String)(switchCase.isDefaultCase() ? "default" : "case: " + switchCase.getValue()));
                }
                break;
            }
            case 1024: 
            case 2048: 
            case 4096: {
                ControlFlowGraphPlantUMLWriter.writeLink(sb, id, basicBlock.getSub1(), "try");
                ControlFlowGraphPlantUMLWriter.writeLink(sb, id, basicBlock.getNext(), "next");
                for (BasicBlock.ExceptionHandler exceptionHandler : basicBlock.getExceptionHandlers()) {
                    sb.append(id).append(" --> ").append(ControlFlowGraphPlantUMLWriter.getStateId(exceptionHandler.getBasicBlock()));
                    if (exceptionHandler.getInternalThrowableName() == null) {
                        sb.append(" : finally");
                    } else {
                        sb.append(" : catch ").append(exceptionHandler.getInternalThrowableName());
                        if (exceptionHandler.getOtherInternalThrowableNames() != null) {
                            for (String name : exceptionHandler.getOtherInternalThrowableNames()) {
                                sb.append("\\ncatch ").append(name);
                            }
                        }
                    }
                    sb.append('\n');
                }
                break;
            }
            case 512: {
                ControlFlowGraphPlantUMLWriter.writeLink(sb, id, basicBlock.getNext(), "try");
                for (BasicBlock.ExceptionHandler exceptionHandler : basicBlock.getExceptionHandlers()) {
                    sb.append(id).append(" --> ").append(ControlFlowGraphPlantUMLWriter.getStateId(exceptionHandler.getBasicBlock()));
                    if (exceptionHandler.getInternalThrowableName() == null) {
                        sb.append(" : finally");
                    } else {
                        sb.append(" : catch ").append(exceptionHandler.getInternalThrowableName());
                        if (exceptionHandler.getOtherInternalThrowableNames() != null) {
                            for (String name : exceptionHandler.getOtherInternalThrowableNames()) {
                                sb.append("\\ncatch ").append(name);
                            }
                        }
                    }
                    sb.append('\n');
                }
                break;
            }
            case 8192: {
                ControlFlowGraphPlantUMLWriter.writeLink(sb, id, basicBlock.getNext(), "next");
                ControlFlowGraphPlantUMLWriter.writeLink(sb, id, basicBlock.getBranch(), "jsr");
                break;
            }
            case 0x400000: {
                if (basicBlock.getNext() == null) break;
                ControlFlowGraphPlantUMLWriter.writeLink(sb, id, basicBlock.getNext(), "next");
                break;
            }
            case 131072: 
            case 0x20000000: {
                ControlFlowGraphPlantUMLWriter.writeLink(sb, id, basicBlock.getSub2(), "else");
            }
            case 65536: {
                ControlFlowGraphPlantUMLWriter.writeLink(sb, id, basicBlock.getCondition(), "condition");
                ControlFlowGraphPlantUMLWriter.writeLink(sb, id, basicBlock.getNext(), "next");
                ControlFlowGraphPlantUMLWriter.writeLink(sb, id, basicBlock.getSub1(), "then");
                break;
            }
            case 0x200000: {
                ControlFlowGraphPlantUMLWriter.writeLink(sb, id, basicBlock.getCondition(), "condition");
            }
            case 524288: 
            case 0x100000: {
                ControlFlowGraphPlantUMLWriter.writeLink(sb, id, basicBlock.getSub1(), "left");
                ControlFlowGraphPlantUMLWriter.writeLink(sb, id, basicBlock.getSub2(), "right");
            }
        }
    }

    private static void writeLink(StringBuilder sb, String fromId, BasicBlock to, String label) {
        if (to.getFromOffset() > Integer.MAX_VALUE) {
            return;
        }
        if (to == BasicBlock.SWITCH_BREAK) {
            sb.append("state \"SWITCH_BREAK\" as switch_break_").append(fromId).append('\n');
            sb.append(fromId).append(" --> switch_break_").append(fromId).append(" : ").append(label).append('\n');
        } else if (to == BasicBlock.LOOP_START) {
            sb.append("state \"LOOP_START\" as start_loop_").append(fromId).append('\n');
            sb.append(fromId).append(" --> start_loop_").append(fromId).append(" : ").append(label).append('\n');
        } else if (to == BasicBlock.LOOP_CONTINUE) {
            sb.append("state \"LOOP_CONTINUE\" as continue_loop_").append(fromId).append('\n');
            sb.append(fromId).append(" --> continue_loop_").append(fromId).append(" : ").append(label).append('\n');
        } else if (to == BasicBlock.LOOP_END) {
            sb.append("state \"LOOP_END\" as end_loop_").append(fromId).append('\n');
            sb.append(fromId).append(" --> end_loop_").append(fromId).append(" : ").append(label).append('\n');
        } else if (to == BasicBlock.RETURN) {
            sb.append("state \"RETURN\" as return_").append(fromId).append('\n');
            sb.append(fromId).append(" --> return_").append(fromId).append(" : ").append(label).append('\n');
        } else if (to != BasicBlock.END) {
            sb.append(fromId).append(" --> state_").append(to.getIndex()).append(" : ").append(label).append('\n');
        }
    }

    private static String getStateId(BasicBlock basicBlock) {
        return basicBlock == BasicBlock.END || basicBlock == BasicBlock.LOOP_END ? "[*]" : "state_" + basicBlock.getIndex();
    }
}

