/*
 * Decompiled with CFR 0.152.
 */
package tim.jarcomp;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class GenericFileFilter
extends FileFilter {
    private String filterDesc;
    private String[] threeCharSuffixes;
    private String[] fourCharSuffixes;

    public GenericFileFilter(String inDescription, String[] inSuffixes) {
        this.filterDesc = inDescription;
        if (inSuffixes != null && inSuffixes.length > 0) {
            this.threeCharSuffixes = new String[inSuffixes.length];
            this.fourCharSuffixes = new String[inSuffixes.length];
            int threeIndex = 0;
            int fourIndex = 0;
            for (int i = 0; i < inSuffixes.length; ++i) {
                String suffix = inSuffixes[i];
                if (suffix == null) continue;
                if ((suffix = suffix.trim().toLowerCase()).length() == 3) {
                    this.threeCharSuffixes[threeIndex++] = suffix;
                    continue;
                }
                if (suffix.length() != 4) continue;
                this.fourCharSuffixes[fourIndex++] = suffix;
            }
        }
    }

    @Override
    public boolean accept(File inFile) {
        return inFile.isDirectory() || this.acceptFilename(inFile.getName());
    }

    public boolean acceptFilename(String inName) {
        int nameLen;
        if (inName != null && (nameLen = inName.length()) > 4) {
            char currChar = inName.charAt(nameLen - 4);
            if (currChar == '.') {
                return this.acceptFilename(inName.substring(nameLen - 3).toLowerCase(), this.threeCharSuffixes);
            }
            currChar = inName.charAt(nameLen - 5);
            if (currChar == '.') {
                return this.acceptFilename(inName.substring(nameLen - 4).toLowerCase(), this.fourCharSuffixes);
            }
        }
        return false;
    }

    public boolean acceptFilename(String inSuffixToCheck, String[] inAllowedSuffixes) {
        if (inSuffixToCheck != null && inAllowedSuffixes != null) {
            for (int i = 0; i < inAllowedSuffixes.length; ++i) {
                if (inAllowedSuffixes[i] == null || !inSuffixToCheck.equals(inAllowedSuffixes[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.filterDesc;
    }
}

