/*
 * Decompiled with CFR 0.152.
 */
package tim.jarcomp;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import tim.jarcomp.EntryDetails;
import tim.jarcomp.SizeChange;

public class EntryTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private transient List<EntryDetails> entries;

    public void reset() {
        this.entries = new ArrayList<EntryDetails>();
    }

    public void setEntryList(List<EntryDetails> inList) {
        this.entries = inList;
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Class<?> getColumnClass(int inColNum) {
        return switch (inColNum) {
            case 0, 1 -> String.class;
            case 2 -> SizeChange.class;
            default -> throw new IllegalArgumentException("Parameter out of range for getColumnClass(...) " + inColNum);
        };
    }

    @Override
    public String getColumnName(int inColNum) {
        return switch (inColNum) {
            case 0 -> "Filename";
            case 1 -> "Status";
            case 2 -> "Size Change";
            default -> throw new IllegalArgumentException("Parameter out of range for getColumnName(...) " + inColNum);
        };
    }

    @Override
    public int getRowCount() {
        if (this.entries == null) {
            return 0;
        }
        return this.entries.size();
    }

    @Override
    public Object getValueAt(int inRowNum, int inColNum) {
        if (inRowNum >= 0 && inRowNum < this.getRowCount()) {
            EntryDetails entry = this.entries.get(inRowNum);
            return switch (inColNum) {
                case 0 -> entry.getName();
                case 1 -> EntryTableModel.getText(entry.getStatus());
                case 2 -> entry.getSizeChange();
                default -> throw new IllegalArgumentException("Parameter out of range for getValueAt(...) " + inColNum);
            };
        }
        return null;
    }

    private static String getText(EntryDetails.EntryStatus inStatus) {
        return switch (inStatus) {
            case EntryDetails.EntryStatus.ADDED -> "Added";
            case EntryDetails.EntryStatus.CHANGED_SIZE -> "Changed size";
            case EntryDetails.EntryStatus.CHANGED_SUM -> "Changed sum";
            case EntryDetails.EntryStatus.EQUAL -> "=";
            case EntryDetails.EntryStatus.REMOVED -> "Removed";
            case EntryDetails.EntryStatus.SAME_SIZE -> "Same size";
            default -> inStatus.toString();
        };
    }

    public boolean areDifferent(int inRowNum) {
        if (inRowNum >= 0 && inRowNum < this.getRowCount()) {
            return this.entries.get(inRowNum).isChanged();
        }
        return false;
    }

    public boolean isModification(int inRowNum) {
        if (inRowNum >= 0 && inRowNum < this.getRowCount()) {
            return switch (this.entries.get(inRowNum).getStatus()) {
                case EntryDetails.EntryStatus.ADDED, EntryDetails.EntryStatus.EQUAL, EntryDetails.EntryStatus.REMOVED, EntryDetails.EntryStatus.SAME_SIZE -> false;
                case EntryDetails.EntryStatus.CHANGED_SIZE, EntryDetails.EntryStatus.CHANGED_SUM -> true;
                default -> throw new IllegalArgumentException("Unknown status");
            };
        }
        return false;
    }
}

