/*
 * Decompiled with CFR 0.152.
 */
package tim.jarcomp;

import tim.jarcomp.SizeChange;

public class EntryDetails {
    private String name;
    private boolean[] present = new boolean[2];
    private long[] sizes = new long[2];
    private long[] crcCheckSums = new long[2];
    private SizeChange sizeChange = new SizeChange();

    public String getName() {
        return this.name;
    }

    public void setName(String inName) {
        this.name = inName;
    }

    public long getSize(int inIndex) {
        if (inIndex < 0 || inIndex > 1) {
            return 0L;
        }
        return this.sizes[inIndex];
    }

    public void setSize(int inIndex, long inSize) {
        if (inIndex == 0 || inIndex == 1) {
            this.sizes[inIndex] = inSize;
            this.present[inIndex] = true;
            this.sizeChange.update(this.sizes[1] - this.sizes[0], this.isChanged());
        }
    }

    public long getCRCChecksum(int inIndex) {
        if (inIndex < 0 || inIndex > 1) {
            return 0L;
        }
        return this.crcCheckSums[inIndex];
    }

    public void setCRCChecksum(int inIndex, long inCRCChecksum) {
        if (inIndex == 0 || inIndex == 1) {
            this.crcCheckSums[inIndex] = inCRCChecksum;
            this.sizeChange.update(this.sizes[1] - this.sizes[0], this.isChanged());
        }
    }

    public boolean isCRCChecked() {
        return this.crcCheckSums[0] != 0L && this.crcCheckSums[1] != 0L;
    }

    public EntryStatus getStatus() {
        if (!this.present[0] && this.present[1]) {
            return EntryStatus.ADDED;
        }
        if (this.present[0] && !this.present[1]) {
            return EntryStatus.REMOVED;
        }
        if (this.sizes[0] != this.sizes[1]) {
            return EntryStatus.CHANGED_SIZE;
        }
        if (!this.isCRCChecked()) {
            return EntryStatus.SAME_SIZE;
        }
        if (this.crcCheckSums[0] != this.crcCheckSums[1]) {
            return EntryStatus.CHANGED_SUM;
        }
        return EntryStatus.EQUAL;
    }

    public long getSizeDifference() {
        return this.sizes[1] - this.sizes[0];
    }

    public SizeChange getSizeChange() {
        return this.sizeChange;
    }

    public boolean isChanged() {
        EntryStatus status = this.getStatus();
        return status != EntryStatus.SAME_SIZE && status != EntryStatus.EQUAL;
    }

    public static enum EntryStatus {
        ADDED,
        REMOVED,
        CHANGED_SIZE,
        SAME_SIZE,
        CHANGED_SUM,
        EQUAL;

    }
}

