/*
 * Decompiled with CFR 0.152.
 */
package tim.jarcomp;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import tim.jarcomp.CompareResults;
import tim.jarcomp.EntryDetails;

public final class Comparer {
    private Comparer() {
    }

    public static CompareResults compare(File inFile1, File inFile2) {
        CompareResults results = new CompareResults();
        results.setSize(0, inFile1.length());
        results.setSize(1, inFile2.length());
        ArrayList<EntryDetails> entryList = new ArrayList<EntryDetails>();
        int numFiles1 = Comparer.makeEntries(entryList, inFile1, 0);
        results.setNumFiles(0, numFiles1);
        int numFiles2 = Comparer.makeEntries(entryList, inFile2, 1);
        results.setNumFiles(1, numFiles2);
        results.setEntryList(entryList);
        Comparer.collectCRCChecksums(results, inFile1, 0);
        Comparer.collectCRCChecksums(results, inFile2, 1);
        return results;
    }

    private static int makeEntries(ArrayList<EntryDetails> inList, File inFile, int inIndex) {
        boolean checkList = !inList.isEmpty();
        int numFiles = 0;
        try (ZipFile zip = new ZipFile(inFile);){
            Enumeration<? extends ZipEntry> zipEntries = zip.entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry ze = zipEntries.nextElement();
                ++numFiles;
                String name = ze.getName();
                EntryDetails details = null;
                if (checkList) {
                    details = Comparer.getEntryFromList(inList, name);
                }
                if (details == null) {
                    details = new EntryDetails();
                    details.setName(name);
                    if (!name.endsWith("/") && !name.contains("$")) {
                        inList.add(details);
                    }
                }
                details.setSize(inIndex, ze.getSize());
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe);
        }
        return numFiles;
    }

    private static EntryDetails getEntryFromList(ArrayList<EntryDetails> inList, String inName) {
        EntryDetails details = null;
        for (EntryDetails element : inList) {
            details = element;
            if (details.getName() == null || !details.getName().equals(inName)) continue;
            return details;
        }
        return null;
    }

    private static void collectCRCChecksums(CompareResults inResults, File inFile, int inIndex) {
        List<EntryDetails> list = inResults.getEntryList();
        try (ZipFile zip = new ZipFile(inFile);){
            for (EntryDetails entry : list) {
                if (entry.getStatus() != EntryDetails.EntryStatus.SAME_SIZE) continue;
                ZipEntry zipEntry = zip.getEntry(entry.getName());
                if (zipEntry == null) {
                    System.err.println("zipEntry for " + entry.getName() + " shouldn't be null!");
                    continue;
                }
                entry.setCRCChecksum(inIndex, zipEntry.getCrc());
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }
}

