/*
 * Decompiled with CFR 0.152.
 */
package tim.jarcomp;

import com.heliosdecompiler.transformerapi.StandardTransformers;
import com.heliosdecompiler.transformerapi.TransformationException;
import de.cismet.custom.visualdiff.DiffPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.zip.ZipFile;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import jd.core.ClassUtil;
import jd.core.DecompilationResult;
import org.apache.commons.io.IOUtils;
import org.jd.core.v1.api.loader.Loader;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.core.v1.util.ZipLoader;
import org.jd.gui.api.API;
import org.jd.gui.util.ImageUtil;
import org.jd.gui.util.loader.LoaderUtils;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.oxbow.swingbits.list.CheckListRenderer;
import org.oxbow.swingbits.table.filter.TableRowFilterSupport;
import tim.jarcomp.CompareResults;
import tim.jarcomp.Comparer;
import tim.jarcomp.EntryDetails;
import tim.jarcomp.EntryTableModel;
import tim.jarcomp.GenericFileFilter;
import tim.jarcomp.JarDetailsDisplay;

public class CompareWindow {
    private static final Color YELLOW = new Color(255, 255, 200);
    private JFrame mainWindow;
    private File[] files = new File[2];
    private JarDetailsDisplay[] detailsDisplays;
    private JLabel statusLabel;
    private JLabel statusLabel2;
    private EntryTableModel tableModel;
    private JFileChooser fileChooser;
    private JButton refreshButton;
    private API api;

    public CompareWindow(API api) {
        this.api = api;
        this.mainWindow = new JFrame("Jar Comparer");
        ImageUtil.addJDIconsToFrame(this.mainWindow);
        this.mainWindow.getContentPane().add(this.makeComponents());
        this.mainWindow.pack();
        this.mainWindow.setVisible(true);
    }

    private JPanel makeComponents() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        JPanel buttonPanel = new JPanel();
        JButton compareButton = new JButton("Compare ...");
        compareButton.addActionListener(e -> this.startCompare());
        buttonPanel.add(compareButton);
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.setEnabled(false);
        this.refreshButton.addActionListener(e -> this.startCompare(this.files[0], this.files[1]));
        buttonPanel.add(this.refreshButton);
        buttonPanel.setAlignmentX(0.0f);
        topPanel.add(buttonPanel);
        JPanel detailsPanel = new JPanel();
        detailsPanel.setLayout(new GridLayout(1, 2, 5, 5));
        this.detailsDisplays = new JarDetailsDisplay[2];
        this.detailsDisplays[0] = new JarDetailsDisplay();
        detailsPanel.add((Component)this.detailsDisplays[0], "West");
        this.detailsDisplays[1] = new JarDetailsDisplay();
        detailsPanel.add((Component)this.detailsDisplays[1], "East");
        topPanel.add(detailsPanel);
        detailsPanel.setAlignmentX(0.0f);
        this.statusLabel = new JLabel("");
        this.statusLabel.setAlignmentX(0.0f);
        this.statusLabel.setBorder(new EmptyBorder(5, 10, 1, 1));
        topPanel.add(this.statusLabel);
        this.statusLabel2 = new JLabel("");
        this.statusLabel2.setAlignmentX(0.0f);
        this.statusLabel2.setBorder(new EmptyBorder(1, 10, 5, 1));
        topPanel.add(this.statusLabel2);
        mainPanel.add((Component)topPanel, "North");
        this.tableModel = new EntryTableModel();
        final JXTable table = new JXTable(this.tableModel){
            private static final long serialVersionUID = 1L;

            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                if (!this.isRowSelected(row)) {
                    int modelRow = this.convertRowIndexToModel(row);
                    boolean isChange = ((EntryTableModel)this.getModel()).areDifferent(modelRow);
                    c.setBackground(isChange ? YELLOW : this.getBackground());
                }
                return c;
            }
        };
        table.setColumnControlVisible(true);
        table.setHighlighters(new Highlighter[]{HighlighterFactory.createSimpleStriping()});
        table.setEditable(false);
        TableRowFilterSupport.forTable((JTable)table).actions(true).searchable(true).checkListRenderer((ListCellRenderer)new CheckListRenderer()).apply();
        table.getColumnModel().getColumn(0).setPreferredWidth(300);
        table.getColumnModel().getColumn(1).setPreferredWidth(70);
        table.getColumnModel().getColumn(2).setPreferredWidth(70);
        table.setAutoCreateRowSorter(true);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                block4: {
                    if (e.getClickCount() == 2) {
                        int modelCol = table.convertColumnIndexToModel(0);
                        int modelRow = table.convertRowIndexToModel(table.getSelectedRow());
                        boolean isChange = CompareWindow.this.tableModel.isModification(modelRow);
                        if (isChange) {
                            String fileName = (String)CompareWindow.this.tableModel.getValueAt(modelRow, modelCol);
                            try {
                                JFrame diffFrame = new JFrame("Comparison view for class " + fileName);
                                ImageUtil.addJDIconsToFrame(diffFrame);
                                DiffPanel diffPanel = new DiffPanel(diffFrame);
                                String contentLeft = CompareWindow.this.getContent(CompareWindow.this.files[0], fileName);
                                String contentRight = CompareWindow.this.getContent(CompareWindow.this.files[1], fileName);
                                diffPanel.setLeftAndRight(contentLeft, "text/x-java", CompareWindow.this.files[0].getName(), contentRight, "text/x-java", CompareWindow.this.files[1].getName());
                                diffFrame.getContentPane().add((Component)diffPanel);
                                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                                diffFrame.setLocation((int)Math.round(screenSize.getWidth() / 6.0), (int)Math.round(screenSize.getHeight() / 6.0));
                                diffFrame.setSize((int)Math.round(screenSize.getWidth() / 1.5), (int)Math.round(screenSize.getHeight() / 1.5));
                                diffFrame.setVisible(true);
                            }
                            catch (Exception ex) {
                                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)ex)) break block4;
                                throw new AssertionError();
                            }
                        }
                    }
                }
            }
        });
        mainPanel.add((Component)new JScrollPane((Component)table), "Center");
        return mainPanel;
    }

    protected String getContent(File file, String entryPath) throws IOException, TransformationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (entryPath.endsWith(".class")) {
            Map<String, String> preferences = this.api.getPreferences();
            preferences.put("ClassFileSaverPreferences.writeLineNumbers", "false");
            preferences.put("ClassFileSaverPreferences.realignLineNumbers", "false");
            try (FileInputStream in = new FileInputStream(file);){
                ZipLoader zipLoader = new ZipLoader((InputStream)in);
                String decompileEngine = preferences.getOrDefault("ClassFileDecompilerPreferences.decompileEngine", "JD-Core v1");
                com.heliosdecompiler.transformerapi.common.Loader apiLoader = LoaderUtils.createLoader(preferences, (Loader)zipLoader, file.toURI());
                String entryInternalName = ClassUtil.getInternalName((String)entryPath);
                DecompilationResult decompilationResult = StandardTransformers.decompile((com.heliosdecompiler.transformerapi.common.Loader)apiLoader, (String)entryInternalName, preferences, (String)decompileEngine);
                String string = decompilationResult.getDecompiledOutput();
                return string;
            }
        }
        try (ZipFile zipFile = new ZipFile(file);){
            String string;
            block17: {
                InputStream in = zipFile.getInputStream(zipFile.getEntry(entryPath));
                try {
                    string = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                    if (in == null) break block17;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return string;
        }
    }

    public void startCompare() {
        this.startCompare(null, null);
    }

    public void startCompare(File inFile1, File inFile2) {
        this.tableModel.reset();
        File file1 = inFile1;
        File file2 = inFile2;
        if (file1 == null || !file1.exists() || !file1.canRead()) {
            file1 = this.selectFile("Select first file", null);
        }
        if (file1 == null) {
            return;
        }
        if (file2 == null || !file2.exists() || !file2.canRead()) {
            file2 = this.selectFile("Select second file", file1);
        }
        if (file2 == null) {
            return;
        }
        this.files[0] = file1;
        this.files[1] = file2;
        this.detailsDisplays[0].clear();
        this.detailsDisplays[1].clear();
        this.statusLabel.setText("comparing...");
        new Thread(this::doCompare).start();
    }

    private void doCompare() {
        boolean archivesDifferent;
        CompareResults results = Comparer.compare(this.files[0], this.files[1]);
        this.tableModel.setEntryList(results.getEntryList());
        boolean bl = archivesDifferent = results.getStatus() == EntryDetails.EntryStatus.CHANGED_SIZE;
        if (archivesDifferent) {
            this.statusLabel.setText("Archives have different size (" + results.getSize(0) + ", " + results.getSize(1) + ")");
        } else {
            this.statusLabel.setText("Archives have the same size (" + results.getSize(0) + ")");
        }
        this.detailsDisplays[0].setContents(this.files[0], results, 0);
        this.detailsDisplays[1].setContents(this.files[1], results, 1);
        if (results.getEntriesDifferent()) {
            this.statusLabel2.setText((archivesDifferent ? "and" : "but") + " the files have different contents");
        } else if (results.isEntriesCRCChecked()) {
            this.statusLabel2.setText((archivesDifferent ? "but" : "and") + " the files have exactly the same contents");
        } else {
            this.statusLabel2.setText((archivesDifferent ? "but" : "and") + " the files appear to have the same contents");
        }
        this.refreshButton.setEnabled(true);
    }

    private File selectFile(String inTitle, File inFirstFile) {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setFileFilter(new GenericFileFilter("Jar files and Zip files", new String[]{"jar", "zip"}));
        }
        this.fileChooser.setDialogTitle(inTitle);
        File file = null;
        boolean rechoose = true;
        while (rechoose) {
            file = null;
            rechoose = false;
            int result = this.fileChooser.showOpenDialog(this.mainWindow);
            if (result == 0) {
                file = this.fileChooser.getSelectedFile();
                boolean bl = rechoose = !file.exists() || !file.canRead();
            }
            if (inFirstFile == null || file == null || !file.equals(inFirstFile)) continue;
            JOptionPane.showMessageDialog(this.mainWindow, "The second file is the same as the first file!\nPlease select another file to compare with '" + inFirstFile.getName() + "'", "Two files equal", 0);
            rechoose = true;
        }
        return file;
    }
}

