/*
 * Decompiled with CFR 0.152.
 */
package org.jd.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;

public final class SHA1Util {
    private SHA1Util() {
    }

    public static Map<File, String> readSHA1File(File file) {
        HashMap<File, String> sha1Map;
        block9: {
            sha1Map = new HashMap<File, String>();
            try (BufferedReader br = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
                String line;
                while ((line = br.readLine()) != null) {
                    String[] tokens = line.split(" +\\*");
                    if (tokens == null || tokens.length != 2) continue;
                    sha1Map.put(new File(tokens[1]), tokens[0]);
                }
            }
            catch (IOException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block9;
                throw new AssertionError();
            }
        }
        return sha1Map;
    }

    public static String computeSHA1(File file) {
        StringBuilder sb;
        block10: {
            sb = new StringBuilder();
            try {
                byte[] array;
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
                byte[] buffer = new byte[2048];
                try (DigestInputStream is = new DigestInputStream(new FileInputStream(file), messageDigest);){
                    while (is.read(buffer) > -1) {
                    }
                }
                for (byte b : array = messageDigest.digest()) {
                    sb.append(SHA1Util.hexa((b & 0xFF) >> 4));
                    sb.append(SHA1Util.hexa(b & 0xF));
                }
            }
            catch (IOException | NoSuchAlgorithmException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block10;
                throw new AssertionError();
            }
        }
        return sb.toString();
    }

    private static char hexa(int i) {
        return (char)(i <= 9 ? 48 + i : 87 + i);
    }
}

