/*
 * Decompiled with CFR 0.152.
 */
package org.jd.util;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_MAX_ENTRIES = 100;
    private final int maxEntries;

    public LRUCache(int maxEntries) {
        super(maxEntries * 3 / 2, 0.7f, true);
        this.maxEntries = maxEntries;
    }

    public LRUCache() {
        this(100);
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.maxEntries;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.maxEntries;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        LRUCache other = (LRUCache)obj;
        return this.maxEntries == other.maxEntries;
    }
}

