/*
 * Decompiled with CFR 0.152.
 */
package org.jd.util;

import java.awt.Desktop;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.jd.core.v1.cfg.ControlFlowGraphPlantUMLWriter;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg.ControlFlowGraph;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;

public final class CFGViewer {
    private CFGViewer() {
    }

    public static void showGraph(ControlFlowGraph cfg, String className) {
        block3: {
            try {
                Desktop desktop;
                SourceStringReader reader = new SourceStringReader(ControlFlowGraphPlantUMLWriter.write((ControlFlowGraph)cfg));
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                reader.outputImage((OutputStream)os, new FileFormatOption(FileFormat.SVG));
                String svg = new String(os.toByteArray(), StandardCharsets.UTF_8);
                Method method = cfg.getMethod();
                String svgFileName = Utility.pathToPackage((String)className) + "." + method.getName().replaceAll("[^a-zA-Z0-9\\.\\-]", "_");
                File svgFile = File.createTempFile(svgFileName, ".svg");
                svgFile.deleteOnExit();
                Files.write(svgFile.toPath(), svg.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                    desktop.browse(svgFile.toURI());
                }
            }
            catch (IOException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block3;
                throw new AssertionError();
            }
        }
    }
}

