/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view.data;

import com.heliosdecompiler.transformerapi.StandardTransformers;
import com.heliosdecompiler.transformerapi.common.Loader;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import javax.swing.SwingWorker;
import jd.core.ClassUtil;
import jd.core.DecompilationResult;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.treenode.ClassFileTreeNodeFactoryProvider;
import org.jd.gui.util.decompiler.ContainerLoader;
import org.jd.gui.util.loader.LoaderUtils;
import org.jd.gui.util.parser.jdt.ASTParserFactory;
import org.jd.gui.view.data.ClassFileTreeNodeState;
import org.jd.gui.view.data.PreferenceKey;
import org.jd.gui.view.data.TreeNodeBean;

public class ClassFileTreeNodeBean
extends TreeNodeBean {
    private final API api;
    private final Container.Entry entry;
    private final Map<PreferenceKey, ClassFileTreeNodeState> decompilerToState = new ConcurrentHashMap<PreferenceKey, ClassFileTreeNodeState>();

    public ClassFileTreeNodeBean(API api, String label, Container.Entry entry) {
        super(label, ClassFileTreeNodeFactoryProvider.CLASS_FILE_ICON);
        this.api = api;
        this.entry = entry;
    }

    @Override
    public Icon getIcon() {
        Map<String, String> preferences = this.api.getPreferences();
        ClassFileTreeNodeState state = this.decompilerToState.get(ClassFileTreeNodeBean.makeKey(preferences));
        if (state != null) {
            if ("true".equals(this.api.getPreferences().get("ClassFileDecompilerPreferences.showCompilerErrors")) && state.hasErrors()) {
                return ClassFileTreeNodeFactoryProvider.CLASS_FILE_ICON_ERROR;
            }
            if ("true".equals(this.api.getPreferences().get("ClassFileDecompilerPreferences.showCompilerWarnings")) && state.hasWarnings()) {
                return ClassFileTreeNodeFactoryProvider.CLASS_FILE_ICON_WARNING;
            }
        } else {
            this.getWorker().execute();
        }
        return ClassFileTreeNodeFactoryProvider.CLASS_FILE_ICON;
    }

    private static PreferenceKey makeKey(Map<String, String> preferences) {
        return new PreferenceKey(preferences.getOrDefault("ClassFileDecompilerPreferences.decompileEngine", "JD-Core v1"), preferences);
    }

    public SwingWorker<Void, Void> getWorker() {
        return new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                Map<String, String> preferences = ClassFileTreeNodeBean.this.api.getPreferences();
                ClassFileTreeNodeBean.this.decompilerToState.computeIfAbsent(ClassFileTreeNodeBean.makeKey(preferences), k -> ClassFileTreeNodeBean.getStateForEntry(ClassFileTreeNodeBean.this.entry, ClassFileTreeNodeBean.this.api, k.engineName()));
                return null;
            }

            @Override
            protected void done() {
                ClassFileTreeNodeBean.this.api.repaint();
            }
        };
    }

    @Override
    public Icon getOpenIcon() {
        return this.getIcon();
    }

    public static synchronized ClassFileTreeNodeState getStateForEntry(Container.Entry entry, API api, String engineName) {
        DecompilationResult decompilationResult;
        String unitName = entry.getPath();
        URI jarURI = entry.getContainer().getRoot().getParent().getUri();
        String entryInternalName = ClassUtil.getInternalName((String)entry.getPath());
        Map<String, String> preferences = api.getPreferences();
        ContainerLoader loader = new ContainerLoader(entry);
        Loader apiLoader = LoaderUtils.createLoader(preferences, loader, entry);
        try {
            decompilationResult = StandardTransformers.decompile((Loader)apiLoader, (String)entryInternalName, preferences, (String)engineName);
        }
        catch (Exception e) {
            assert (ExceptionUtil.printStackTrace((Throwable)e));
            return new ClassFileTreeNodeState(true, false);
        }
        String text = decompilationResult.getDecompiledOutput();
        ASTNode ast = ASTParserFactory.getInstanceWithBindings().newASTParser(text.toCharArray(), unitName, jarURI).createAST(null);
        boolean hasWarning = false;
        boolean hasError = false;
        if (ast instanceof CompilationUnit) {
            IProblem[] problems;
            CompilationUnit cu = (CompilationUnit)ast;
            for (IProblem pb : problems = cu.getProblems()) {
                hasError |= pb.isError();
                hasWarning |= pb.isWarning();
            }
        }
        return new ClassFileTreeNodeState(hasError, hasWarning);
    }
}

