/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view.component.panel;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.PageChangeListener;
import org.jd.gui.api.feature.PageChangeable;
import org.jd.gui.api.feature.PreferencesChangeListener;
import org.jd.gui.api.feature.UriOpenable;
import org.jd.gui.service.platform.PlatformService;
import org.jd.gui.view.component.panel.TabbedPanel;

public class MainTabbedPanel<T extends JComponent>
extends TabbedPanel<T>
implements UriOpenable,
PageChangeListener {
    private static final long serialVersionUID = 1L;
    private final transient List<PageChangeListener> pageChangedListeners = new ArrayList<PageChangeListener>();
    private boolean pageChangedListenersEnabled = true;

    public MainTabbedPanel(API api) {
        super(api);
    }

    @Override
    public void create() {
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        Color bg = MainTabbedPanel.darker(this.getBackground());
        if (PlatformService.getInstance().isWindows()) {
            this.setBackground(bg);
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBackground(bg);
        Color fontColor = panel.getBackground().darker();
        panel.add(Box.createHorizontalGlue());
        JPanel box = new JPanel();
        box.setLayout(new BoxLayout(box, 1));
        box.setBackground(panel.getBackground());
        box.add(Box.createVerticalGlue());
        JLabel title = this.newLabel("No files are open", fontColor);
        title.setFont(title.getFont().deriveFont(1, (float)title.getFont().getSize() + 8.0f));
        box.add(title);
        box.add(this.newLabel("Open a file with menu \"File > Open File...\"", fontColor));
        box.add(this.newLabel("Open recent files with menu \"File > Recent Files\"", fontColor));
        box.add(this.newLabel("Drag and drop files from " + this.getFileManagerLabel(), fontColor));
        box.add(Box.createVerticalGlue());
        panel.add(box);
        panel.add(Box.createHorizontalGlue());
        this.add("panel", panel);
        this.tabbedPane = this.createTabPanel();
        this.tabbedPane.addChangeListener(e -> {
            if (this.pageChangedListenersEnabled) {
                JComponent subPage = (JComponent)this.tabbedPane.getSelectedComponent();
                if (subPage == null) {
                    for (PageChangeListener listener : this.pageChangedListeners) {
                        listener.pageChanged(null);
                    }
                } else {
                    JComponent page = (JComponent)subPage.getClientProperty("currentPage");
                    if (page == null) {
                        page = (JComponent)this.tabbedPane.getSelectedComponent();
                    }
                    for (PageChangeListener listener : this.pageChangedListeners) {
                        listener.pageChanged(page);
                    }
                    if (subPage instanceof PreferencesChangeListener) {
                        PreferencesChangeListener pcl = (PreferencesChangeListener)((Object)subPage);
                        pcl.preferencesChanged(this.preferences);
                    }
                }
            }
        });
        this.add("tabs", this.tabbedPane);
        this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, MainTabbedPanel.darker(MainTabbedPanel.darker(bg))));
    }

    protected String getFileManagerLabel() {
        return switch (PlatformService.getInstance().getOs()) {
            case PlatformService.OS.LINUX -> "your file manager";
            case PlatformService.OS.MAC_OSX -> "the Finder";
            default -> "Explorer";
        };
    }

    protected JLabel newLabel(String text, Color fontColor) {
        JLabel label = new JLabel(text);
        label.setForeground(fontColor);
        return label;
    }

    @Override
    public void addPage(String title, Supplier<Icon> iconSupplier, String tip, T page) {
        super.addPage(title, iconSupplier, tip, page);
        if (page instanceof PageChangeable) {
            PageChangeable pc = (PageChangeable)page;
            pc.addPageChangeListener(this);
        }
    }

    public List<T> getPages() {
        int i = this.tabbedPane.getTabCount();
        ArrayList<JComponent> pages = new ArrayList<JComponent>(i);
        while (i-- > 0) {
            pages.add((JComponent)this.tabbedPane.getComponentAt(i));
        }
        return pages;
    }

    public List<PageChangeListener> getPageChangedListeners() {
        return this.pageChangedListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean openUri(URI uri) {
        try {
            this.pageChangedListenersEnabled = false;
            Object page = this.showPage(uri);
            if (page != null) {
                if (page instanceof UriOpenable) {
                    UriOpenable uo = (UriOpenable)page;
                    this.pageChangedListenersEnabled = true;
                    boolean bl = uo.openUri(uri);
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.pageChangedListenersEnabled = true;
        }
        return false;
    }

    @Override
    public <U extends JComponent> void pageChanged(U page) {
        Component subPage = this.tabbedPane.getSelectedComponent();
        if (subPage != null) {
            ((JComponent)subPage).putClientProperty("currentPage", page);
        }
        if (page == null) {
            page = (JComponent)subPage;
        }
        for (PageChangeListener listener : this.pageChangedListeners) {
            listener.pageChanged(page);
        }
    }

    @Override
    public void preferencesChanged(Map<String, String> preferences) {
        super.preferencesChanged(preferences);
        Component subPage = this.tabbedPane.getSelectedComponent();
        if (subPage instanceof PreferencesChangeListener) {
            PreferencesChangeListener pcl = (PreferencesChangeListener)((Object)subPage);
            pcl.preferencesChanged(preferences);
        }
    }
}

