/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view.component;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jd.core.links.HyperlinkData;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.IndexesChangeListener;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.util.index.IndexesUtil;
import org.jd.gui.util.io.TextReader;
import org.jd.gui.view.component.TypeReferencePage;

public class XmlFilePage
extends TypeReferencePage
implements UriGettable,
IndexesChangeListener {
    private static final long serialVersionUID = 1L;
    private final transient API api;
    private final transient Container.Entry entry;
    private transient Collection<Future<Indexes>> collectionOfFutureIndexes;

    public XmlFilePage(API api, Container.Entry entry) {
        block9: {
            this.api = api;
            this.entry = entry;
            try (InputStream inputStream = entry.getInputStream();){
                String text = TextReader.getText(inputStream);
                Pattern pattern = Pattern.compile("(?s)<\\s*bean[^<]+class\\s*=\\s*\"([^\"]*)\"");
                Matcher matcher = pattern.matcher(this.textArea.getText());
                while (matcher.find()) {
                    String value = matcher.group(1);
                    String trim = value.trim();
                    if (trim == null) continue;
                    int startIndex = matcher.start(1) - 1;
                    int endIndex = startIndex + value.length() + 2;
                    String internalTypeName = trim.replace('.', '/');
                    this.addHyperlink(new TypeReferencePage.TypeHyperlinkData(startIndex, endIndex, internalTypeName));
                }
                this.setText(text);
            }
            catch (IOException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block9;
                throw new AssertionError();
            }
        }
    }

    @Override
    public String getSyntaxStyle() {
        return "text/xml";
    }

    @Override
    protected boolean isHyperlinkEnabled(HyperlinkData hyperlinkData) {
        return ((TypeReferencePage.TypeHyperlinkData)hyperlinkData).isEnabled();
    }

    @Override
    protected void openHyperlink(int x, int y, HyperlinkData hyperlinkData) {
        block7: {
            TypeReferencePage.TypeHyperlinkData data = (TypeReferencePage.TypeHyperlinkData)hyperlinkData;
            if (data.isEnabled()) {
                try {
                    Point location = this.textArea.getLocationOnScreen();
                    int offset = this.textArea.viewToModel2D((Point2D)new Point(x - location.x, y - location.y));
                    URI uri = this.entry.getUri();
                    this.api.addURI(new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), "position=" + offset, null));
                    String internalTypeName = data.getInternalTypeName();
                    List<Container.Entry> entries = IndexesUtil.findInternalTypeName(this.collectionOfFutureIndexes, internalTypeName);
                    String rootUri = this.entry.getContainer().getRoot().getUri().toString();
                    ArrayList<Container.Entry> sameContainerEntries = new ArrayList<Container.Entry>();
                    for (Container.Entry nextEntry : entries) {
                        if (!nextEntry.getUri().toString().startsWith(rootUri)) continue;
                        sameContainerEntries.add(nextEntry);
                    }
                    if (!sameContainerEntries.isEmpty()) {
                        this.api.openURI(x, y, sameContainerEntries, null, data.getInternalTypeName());
                    } else if (!entries.isEmpty()) {
                        this.api.openURI(x, y, entries, null, data.getInternalTypeName());
                    }
                }
                catch (URISyntaxException e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block7;
                    throw new AssertionError();
                }
            }
        }
    }

    @Override
    public URI getUri() {
        return this.entry.getUri();
    }

    @Override
    public String getFileName() {
        String path = this.entry.getPath();
        int index = path.lastIndexOf(47);
        return path.substring(index + 1);
    }

    @Override
    public void indexesChanged(Collection<Future<Indexes>> collectionOfFutureIndexes) {
        this.collectionOfFutureIndexes = collectionOfFutureIndexes;
        boolean refresh = false;
        for (Map.Entry nextEntry : this.hyperlinks.entrySet()) {
            TypeReferencePage.TypeHyperlinkData data = (TypeReferencePage.TypeHyperlinkData)((Object)nextEntry.getValue());
            String internalTypeName = data.getInternalTypeName();
            boolean enabled = IndexesUtil.containsInternalTypeName(collectionOfFutureIndexes, internalTypeName);
            if (data.isEnabled() == enabled) continue;
            data.setEnabled(enabled);
            refresh = true;
        }
        if (refresh) {
            this.textArea.repaint();
        }
    }
}

