/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view.component;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import jd.core.links.HyperlinkData;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.IndexesChangeListener;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.util.index.IndexesUtil;
import org.jd.gui.util.io.TextReader;
import org.jd.gui.util.xml.AbstractXmlPathFinder;
import org.jd.gui.view.component.TypeReferencePage;

public class WebXmlFilePage
extends TypeReferencePage
implements UriGettable,
IndexesChangeListener {
    private static final long serialVersionUID = 1L;
    private final transient API api;
    private final transient Container.Entry entry;
    private transient Collection<Future<Indexes>> collectionOfFutureIndexes;
    private static final List<String> typeHyperlinkPaths = Arrays.asList("web-app/filter/filter-class", "web-app/listener/listener-class", "web-app/servlet/servlet-class");
    private static final List<String> pathHyperlinkPaths = Arrays.asList("web-app/jsp-config/taglib/taglib-location", "web-app/welcome-file-list/welcome-file", "web-app/login-config/form-login-config/form-login-page", "web-app/login-config/form-login-config/form-error-page", "web-app/jsp-config/jsp-property-group/include-prelude", "web-app/jsp-config/jsp-property-group/include-coda");
    private static final List<String> hyperlinkPaths = new ArrayList<String>(typeHyperlinkPaths.size() + pathHyperlinkPaths.size());

    public WebXmlFilePage(API api, Container.Entry entry) {
        block8: {
            this.api = api;
            this.entry = entry;
            try (InputStream inputStream = entry.getInputStream();){
                String text = TextReader.getText(inputStream);
                new PathFinder().find(text);
                this.setText(text);
            }
            catch (IOException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block8;
                throw new AssertionError();
            }
        }
    }

    @Override
    public String getSyntaxStyle() {
        return "text/xml";
    }

    @Override
    protected boolean isHyperlinkEnabled(HyperlinkData hyperlinkData) {
        return ((TypeReferencePage.TypeHyperlinkData)hyperlinkData).isEnabled();
    }

    @Override
    protected void openHyperlink(int x, int y, HyperlinkData hyperlinkData) {
        block10: {
            TypeReferencePage.TypeHyperlinkData data = (TypeReferencePage.TypeHyperlinkData)hyperlinkData;
            if (data.isEnabled()) {
                try {
                    Point location = this.textArea.getLocationOnScreen();
                    int offset = this.textArea.viewToModel2D((Point2D)new Point(x - location.x, y - location.y));
                    URI uri = this.entry.getUri();
                    this.api.addURI(new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), "position=" + offset, null));
                    if (hyperlinkData instanceof PathHyperlinkData) {
                        PathHyperlinkData d = (PathHyperlinkData)hyperlinkData;
                        String path = d.path;
                        Container.Entry nextEntry = WebXmlFilePage.searchEntry(this.entry.getContainer().getRoot(), path);
                        if (nextEntry != null) {
                            this.api.openURI(x, y, Collections.singletonList(nextEntry), null, path);
                        }
                    } else {
                        String internalTypeName = data.getInternalTypeName();
                        List<Container.Entry> entries = IndexesUtil.findInternalTypeName(this.collectionOfFutureIndexes, internalTypeName);
                        String rootUri = this.entry.getContainer().getRoot().getUri().toString();
                        ArrayList<Container.Entry> sameContainerEntries = new ArrayList<Container.Entry>();
                        for (Container.Entry nextEntry : entries) {
                            if (!nextEntry.getUri().toString().startsWith(rootUri)) continue;
                            sameContainerEntries.add(nextEntry);
                        }
                        if (!sameContainerEntries.isEmpty()) {
                            this.api.openURI(x, y, sameContainerEntries, null, data.getInternalTypeName());
                        } else if (!entries.isEmpty()) {
                            this.api.openURI(x, y, entries, null, data.getInternalTypeName());
                        }
                    }
                }
                catch (URISyntaxException e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block10;
                    throw new AssertionError();
                }
            }
        }
    }

    public static Container.Entry searchEntry(Container.Entry parent, String path) {
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return WebXmlFilePage.recursiveSearchEntry(parent, path);
    }

    public static Container.Entry recursiveSearchEntry(Container.Entry parent, String path) {
        Container.Entry entry = null;
        for (Container.Entry child : parent.getChildren().values()) {
            if (!path.equals(child.getPath())) continue;
            entry = child;
            break;
        }
        if (entry != null) {
            return entry;
        }
        for (Container.Entry child : parent.getChildren().values()) {
            if (!path.startsWith(child.getPath() + "/")) continue;
            entry = child;
            break;
        }
        return entry != null ? WebXmlFilePage.searchEntry(entry, path) : null;
    }

    @Override
    public URI getUri() {
        return this.entry.getUri();
    }

    @Override
    public String getFileName() {
        String path = this.entry.getPath();
        int index = path.lastIndexOf(47);
        return path.substring(index + 1);
    }

    @Override
    public void indexesChanged(Collection<Future<Indexes>> collectionOfFutureIndexes) {
        this.collectionOfFutureIndexes = collectionOfFutureIndexes;
        boolean refresh = false;
        for (Map.Entry nextEntry : this.hyperlinks.entrySet()) {
            boolean enabled;
            TypeReferencePage.TypeHyperlinkData data = (TypeReferencePage.TypeHyperlinkData)((Object)nextEntry.getValue());
            if (data instanceof PathHyperlinkData) {
                PathHyperlinkData d = (PathHyperlinkData)data;
                enabled = WebXmlFilePage.searchEntry(this.entry.getContainer().getRoot(), d.path) != null;
            } else {
                String internalTypeName = data.getInternalTypeName();
                enabled = IndexesUtil.containsInternalTypeName(collectionOfFutureIndexes, internalTypeName);
            }
            if (data.isEnabled() == enabled) continue;
            data.setEnabled(enabled);
            refresh = true;
        }
        if (refresh) {
            this.textArea.repaint();
        }
    }

    static {
        hyperlinkPaths.addAll(typeHyperlinkPaths);
        hyperlinkPaths.addAll(pathHyperlinkPaths);
    }

    public class PathFinder
    extends AbstractXmlPathFinder {
        public PathFinder() {
            super(hyperlinkPaths);
        }

        @Override
        public void handle(String path, String text, int position) {
            String trim = text.trim();
            if (trim != null) {
                int startIndex = position + text.indexOf(trim);
                int endIndex = startIndex + trim.length();
                if (pathHyperlinkPaths.contains(path)) {
                    WebXmlFilePage.this.addHyperlink(new PathHyperlinkData(startIndex, endIndex, trim));
                } else {
                    String internalTypeName = trim.replace('.', '/');
                    WebXmlFilePage.this.addHyperlink(new TypeReferencePage.TypeHyperlinkData(startIndex, endIndex, internalTypeName));
                }
            }
        }
    }

    public static class PathHyperlinkData
    extends TypeReferencePage.TypeHyperlinkData {
        private final String path;

        PathHyperlinkData(int startPosition, int endPosition, String path) {
            super(startPosition, endPosition, null);
            this.path = path;
        }
    }
}

