/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view.component;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import jd.core.links.HyperlinkData;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.view.component.HyperlinkPage;

public abstract class TypeReferencePage
extends HyperlinkPage {
    private static final long serialVersionUID = 1L;

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean openUri(URI uri) {
        ranges = new ArrayList<DocumentRange>();
        query = uri.getQuery();
        this.textArea.clearMarkAllHighlights();
        if (query != null) {
            parameters = this.parseQuery(query);
            if (parameters.containsKey("lineNumber")) {
                lineNumber = parameters.get("lineNumber");
                try {
                    this.goToLineNumber(Integer.parseInt(lineNumber));
                    return true;
                }
                catch (NumberFormatException e) {
                    if (!TypeReferencePage.$assertionsDisabled && !ExceptionUtil.printStackTrace((Throwable)e)) {
                        throw new AssertionError();
                    }
                }
            } else if (parameters.containsKey("position")) {
                position = parameters.get("position");
                try {
                    pos = Integer.parseInt(position);
                    if (this.textArea.getDocument().getLength() <= pos) ** GOTO lbl47
                    ranges.add(new DocumentRange(pos, pos));
                }
                catch (NumberFormatException e) {
                    if (!TypeReferencePage.$assertionsDisabled && !ExceptionUtil.printStackTrace((Throwable)e)) {
                        throw new AssertionError();
                    }
                }
            } else {
                highlightFlags = parameters.get("highlightFlags");
                highlightPattern = parameters.get("highlightPattern");
                if (highlightFlags != null && highlightPattern != null) {
                    regexp = TypeReferencePage.createRegExp(highlightPattern);
                    if (highlightFlags.indexOf(115) != -1) {
                        pattern = Pattern.compile(regexp);
                        matcher = pattern.matcher(this.textArea.getText());
                        while (matcher.find()) {
                            ranges.add(new DocumentRange(matcher.start(), matcher.end()));
                        }
                    }
                    if (highlightFlags.indexOf(116) != -1 && highlightFlags.indexOf(114) != -1) {
                        pattern = Pattern.compile(regexp + ".*");
                        for (Map.Entry<K, V> entry : this.hyperlinks.entrySet()) {
                            hyperlink = (TypeHyperlinkData)entry.getValue();
                            name = this.getMostInnerTypeName(hyperlink.getInternalTypeName());
                            if (!pattern.matcher(name).matches()) continue;
                            ranges.add(new DocumentRange(hyperlink.getStartPosition(), hyperlink.getEndPosition()));
                        }
                    }
                }
            }
        }
lbl47:
        // 11 sources

        if (!ranges.isEmpty()) {
            this.textArea.setMarkAllHighlightColor(TypeReferencePage.SELECT_HIGHLIGHT_COLOR);
            this.textArea.markAll(ranges);
            Collections.sort(ranges);
            this.setCaretPositionAndCenter((DocumentRange)ranges.get(0));
        }
        return false;
    }

    public String getMostInnerTypeName(String typeName) {
        int lastPackageSeparatorIndex = typeName.lastIndexOf(47) + 1;
        int lastTypeNameSeparatorIndex = typeName.lastIndexOf(36) + 1;
        int lastIndex = Math.max(lastPackageSeparatorIndex, lastTypeNameSeparatorIndex);
        return typeName.substring(lastIndex);
    }

    public static class TypeHyperlinkData
    extends HyperlinkData {
        private final String internalTypeName;

        public TypeHyperlinkData(int startPosition, int endPosition, String internalTypeName) {
            super(startPosition, endPosition);
            this.internalTypeName = internalTypeName;
        }

        public String getInternalTypeName() {
            return this.internalTypeName;
        }
    }
}

