/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view.component;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jd.core.links.DeclarationData;
import jd.core.links.HyperlinkData;
import jd.core.links.HyperlinkReferenceData;
import jd.core.links.ReferenceData;
import jd.core.links.StringData;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.FocusedTypeGettable;
import org.jd.gui.api.feature.IndexesChangeListener;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.api.model.Type;
import org.jd.gui.util.index.IndexesUtil;
import org.jd.gui.util.matcher.DescriptorMatcher;
import org.jd.gui.util.parser.jdt.ASTParserFactory;
import org.jd.gui.util.parser.jdt.RSyntaxASTParser;
import org.jd.gui.view.component.CustomLineNumbersPage;
import org.jd.gui.view.component.ReferenceListener;

public abstract class TypePage
extends CustomLineNumbersPage
implements UriGettable,
IndexesChangeListener,
FocusedTypeGettable {
    private static final long serialVersionUID = 1L;
    private static final Pattern LINE_COMMENT_PATTERN = Pattern.compile("/\\* *(\\d+) *\\*/");
    protected final transient API api;
    protected final transient Container.Entry entry;
    protected transient Collection<Future<Indexes>> collectionOfFutureIndexes = Collections.emptyList();
    protected final transient ReferenceListener listener;

    protected TypePage(API api, Container.Entry entry) {
        this.api = api;
        this.entry = entry;
        this.listener = new ReferenceListener(entry);
        this.listener.setHyperlinks(this.hyperlinks);
        this.textArea.addParser((Parser)new RSyntaxASTParser(entry, api));
    }

    @Override
    protected boolean isHyperlinkEnabled(HyperlinkData hyperlinkData) {
        return ((HyperlinkReferenceData)hyperlinkData).getReference().isEnabled();
    }

    @Override
    protected void openHyperlink(int x, int y, HyperlinkData hyperlinkData) {
        block11: {
            HyperlinkReferenceData hyperlinkReferenceData = (HyperlinkReferenceData)hyperlinkData;
            if (hyperlinkReferenceData.getReference().isEnabled()) {
                try {
                    Point location = this.textArea.getLocationOnScreen();
                    int offset = this.textArea.viewToModel2D((Point2D)new Point(x - location.x, y - location.y));
                    URI uri = this.entry.getUri();
                    this.api.addURI(new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), "position=" + offset, null));
                    ReferenceData reference = hyperlinkReferenceData.getReference();
                    String typeName = reference.getTypeName();
                    List<Container.Entry> entries = IndexesUtil.findInternalTypeName(this.collectionOfFutureIndexes, typeName);
                    Object fragment = typeName;
                    if (reference.getName() != null) {
                        fragment = (String)fragment + "-" + reference.getName();
                    }
                    if (reference.getDescriptor() != null) {
                        fragment = (String)fragment + "-" + reference.getDescriptor();
                    }
                    if (entries.contains(this.entry)) {
                        this.api.openURI(new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), (String)fragment));
                    } else {
                        String rootUri = this.entry.getContainer().getRoot().getUri().toString();
                        ArrayList<Container.Entry> sameContainerEntries = new ArrayList<Container.Entry>();
                        for (Container.Entry nextEntry : entries) {
                            if (!nextEntry.getUri().toString().startsWith(rootUri)) continue;
                            sameContainerEntries.add(nextEntry);
                        }
                        if (!sameContainerEntries.isEmpty()) {
                            this.api.openURI(x, y, sameContainerEntries, null, (String)fragment);
                        } else if (!entries.isEmpty()) {
                            this.api.openURI(x, y, entries, null, (String)fragment);
                        }
                    }
                }
                catch (URISyntaxException e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block11;
                    throw new AssertionError();
                }
            }
        }
    }

    @Override
    public URI getUri() {
        return this.entry.getUri();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean openUri(URI uri) {
        ranges = new ArrayList<DocumentRange>();
        fragment = uri.getFragment();
        query = uri.getQuery();
        this.textArea.clearMarkAllHighlights();
        if (fragment != null) {
            TypePage.matchFragmentAndAddDocumentRange(fragment, this.listener.getDeclarations(), ranges);
        }
        if (query != null) {
            parameters = this.parseQuery(query);
            if (parameters.containsKey("lineNumber")) {
                lineNumber = parameters.get("lineNumber");
                try {
                    this.goToLineNumber(Integer.parseInt(lineNumber));
                    return true;
                }
                catch (NumberFormatException e) {
                    if (!TypePage.$assertionsDisabled && !ExceptionUtil.printStackTrace((Throwable)e)) {
                        throw new AssertionError();
                    }
                    return false;
                }
            }
            if (parameters.containsKey("position")) {
                position = parameters.get("position");
                try {
                    pos = Integer.parseInt(position);
                    if (this.textArea.getDocument().getLength() <= pos) ** GOTO lbl31
                    ranges.add(new DocumentRange(pos, pos));
                }
                catch (NumberFormatException e) {
                    if (!TypePage.$assertionsDisabled && !ExceptionUtil.printStackTrace((Throwable)e)) {
                        throw new AssertionError();
                    }
                    return false;
                }
            } else {
                TypePage.matchQueryAndAddDocumentRange(parameters, this.listener.getDeclarations(), this.hyperlinks, this.listener.getStrings(), ranges);
            }
        }
lbl31:
        // 5 sources

        if (!ranges.isEmpty()) {
            this.textArea.setMarkAllHighlightColor(TypePage.SELECT_HIGHLIGHT_COLOR);
            this.textArea.markAll(ranges);
            Collections.sort(ranges);
            this.setCaretPositionAndCenter((DocumentRange)ranges.get(0));
        }
        return true;
    }

    public static void matchFragmentAndAddDocumentRange(String fragment, Map<String, DeclarationData> declarations, List<DocumentRange> ranges) {
        if (fragment.indexOf(63) != -1 || fragment.indexOf(42) != -1) {
            int lastDash = fragment.lastIndexOf(45);
            if (lastDash == -1) {
                String slashAndTypeName = fragment.substring(1);
                String typeName = fragment.substring(2);
                for (Map.Entry<String, DeclarationData> entry : declarations.entrySet()) {
                    if (!entry.getKey().endsWith(slashAndTypeName) && !entry.getKey().equals(typeName)) continue;
                    ranges.add(new DocumentRange(entry.getValue().getStartPosition(), entry.getValue().getEndPosition()));
                }
            } else {
                String prefix = fragment.substring(0, lastDash + 1);
                String suffix = fragment.substring(lastDash + 1);
                BiPredicate<String, String> matchDescriptors = suffix.charAt(0) == '(' ? DescriptorMatcher::matchMethodDescriptors : DescriptorMatcher::matchFieldDescriptors;
                if (fragment.charAt(0) == '*') {
                    String slashAndTypeNameAndName = prefix.substring(1);
                    String typeNameAndName = prefix.substring(2);
                    for (Map.Entry<String, DeclarationData> entry : declarations.entrySet()) {
                        int index;
                        String key = entry.getKey();
                        if (key.indexOf(slashAndTypeNameAndName) == -1 && !key.startsWith(typeNameAndName) || !matchDescriptors.test(suffix, key.substring(index = key.lastIndexOf(45) + 1))) continue;
                        ranges.add(new DocumentRange(entry.getValue().getStartPosition(), entry.getValue().getEndPosition()));
                    }
                } else {
                    for (Map.Entry<String, DeclarationData> entry : declarations.entrySet()) {
                        int index;
                        String key = entry.getKey();
                        if (!key.startsWith(prefix) || !matchDescriptors.test(suffix, key.substring(index = key.lastIndexOf(45) + 1))) continue;
                        ranges.add(new DocumentRange(entry.getValue().getStartPosition(), entry.getValue().getEndPosition()));
                    }
                }
            }
        } else {
            DeclarationData data = declarations.get(fragment);
            if (data != null) {
                ranges.add(new DocumentRange(data.getStartPosition(), data.getEndPosition()));
            } else if (fragment.endsWith("-<clinit>-()V")) {
                String typeName = fragment.substring(0, fragment.indexOf(45));
                data = declarations.get(typeName);
                ranges.add(new DocumentRange(data.getStartPosition(), data.getEndPosition()));
            }
        }
    }

    public static void matchQueryAndAddDocumentRange(Map<String, String> parameters, Map<String, DeclarationData> declarations, Map<Integer, HyperlinkData> hyperlinks, List<StringData> strings, List<DocumentRange> ranges) {
        String highlightFlags = parameters.get("highlightFlags");
        String highlightPattern = parameters.get("highlightPattern");
        if (highlightFlags != null && highlightPattern != null) {
            boolean c;
            String highlightScope = parameters.get("highlightScope");
            String regexp = TypePage.createRegExp(highlightPattern);
            Pattern pattern = Pattern.compile(regexp + ".*");
            if (highlightFlags.indexOf(115) != -1) {
                Pattern patternForString = Pattern.compile(regexp);
                for (StringData data : strings) {
                    if (!TypePage.matchScope(highlightScope, data.owner())) continue;
                    Matcher matcher = patternForString.matcher(data.text());
                    int offset = data.startPosition();
                    while (matcher.find()) {
                        ranges.add(new DocumentRange(offset + matcher.start(), offset + matcher.end()));
                    }
                }
            }
            boolean t = highlightFlags.indexOf(116) != -1;
            boolean f = highlightFlags.indexOf(102) != -1;
            boolean m = highlightFlags.indexOf(109) != -1;
            boolean bl = c = highlightFlags.indexOf(99) != -1;
            if (highlightFlags.indexOf(100) != -1) {
                for (Map.Entry<String, DeclarationData> entry : declarations.entrySet()) {
                    DeclarationData declaration = entry.getValue();
                    if (!TypePage.matchScope(highlightScope, declaration.getTypeName())) continue;
                    if (t && declaration.isAType() || c && declaration.isAConstructor()) {
                        TypePage.matchAndAddDocumentRange(pattern, TypePage.getMostInnerTypeName(declaration.getTypeName()), declaration.getStartPosition(), declaration.getEndPosition(), ranges);
                    }
                    if ((!f || !declaration.isAField()) && (!m || !declaration.isAMethod())) continue;
                    TypePage.matchAndAddDocumentRange(pattern, declaration.getName(), declaration.getStartPosition(), declaration.getEndPosition(), ranges);
                }
            }
            if (highlightFlags.indexOf(114) != -1) {
                for (Map.Entry<Integer, HyperlinkData> entry : hyperlinks.entrySet()) {
                    HyperlinkData hyperlink = entry.getValue();
                    ReferenceData reference = ((HyperlinkReferenceData)hyperlink).getReference();
                    if (!TypePage.matchScope(highlightScope, reference.getOwner())) continue;
                    if (t && reference.isAType() || c && reference.isAConstructor()) {
                        TypePage.matchAndAddDocumentRange(pattern, TypePage.getMostInnerTypeName(reference.getTypeName()), hyperlink.getStartPosition(), hyperlink.getEndPosition(), ranges);
                    }
                    if ((!f || !reference.isAField()) && (!m || !reference.isAMethod())) continue;
                    TypePage.matchAndAddDocumentRange(pattern, reference.getName(), hyperlink.getStartPosition(), hyperlink.getEndPosition(), ranges);
                }
            }
        }
    }

    public static boolean matchScope(String scope, String type) {
        if (scope == null || scope.isEmpty()) {
            return true;
        }
        if (scope.charAt(0) == '*') {
            return type.endsWith(scope.substring(1)) || type.equals(scope.substring(2));
        }
        return type.equals(scope);
    }

    public static void matchAndAddDocumentRange(Pattern pattern, String text, int start, int end, List<DocumentRange> ranges) {
        if (pattern.matcher(text).matches()) {
            ranges.add(new DocumentRange(start, end));
        }
    }

    public static String getMostInnerTypeName(String typeName) {
        int lastPackageSeparatorIndex = typeName.lastIndexOf(47) + 1;
        int lastTypeNameSeparatorIndex = typeName.lastIndexOf(36) + 1;
        int lastIndex = Math.max(lastPackageSeparatorIndex, lastTypeNameSeparatorIndex);
        return typeName.substring(lastIndex);
    }

    @Override
    public String getFocusedTypeName() {
        DeclarationData data;
        Map.Entry<Integer, DeclarationData> nextEntry = this.listener.getTypeDeclarations().floorEntry(this.textArea.getCaretPosition());
        if (nextEntry != null && (data = nextEntry.getValue()) != null) {
            return data.getTypeName();
        }
        return null;
    }

    @Override
    public Container.Entry getEntry() {
        return this.entry;
    }

    @Override
    public void indexesChanged(Collection<Future<Indexes>> collectionOfFutureIndexes) {
        this.collectionOfFutureIndexes = collectionOfFutureIndexes;
        boolean refresh = false;
        for (ReferenceData reference : this.listener.getReferences()) {
            boolean enabled;
            String typeName = reference.getTypeName();
            if (reference.getName() == null) {
                enabled = false;
                try {
                    for (Future<Indexes> futureIndexes : collectionOfFutureIndexes) {
                        Map<String, Collection> index;
                        if (!futureIndexes.isDone() || (index = futureIndexes.get().getIndex("typeDeclarations")) == null || index.get(typeName) == null) continue;
                        enabled = true;
                    }
                }
                catch (InterruptedException e) {
                    assert (ExceptionUtil.printStackTrace((Throwable)e));
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    assert (ExceptionUtil.printStackTrace((Throwable)e));
                }
            } else {
                try {
                    typeName = this.searchTypeHavingMember(typeName, reference.getName(), reference.getDescriptor(), this.entry);
                    if (typeName != null) {
                        reference.setTypeName(typeName);
                        enabled = true;
                    } else {
                        enabled = false;
                    }
                }
                catch (OutOfMemoryError | StackOverflowError e) {
                    assert (ExceptionUtil.printStackTrace((Throwable)e));
                    enabled = false;
                }
            }
            if (reference.isEnabled() == enabled) continue;
            reference.setEnabled(enabled);
            refresh = true;
        }
        if (refresh) {
            this.textArea.repaint();
        }
    }

    protected String searchTypeHavingMember(String typeName, String name, String descriptor, Container.Entry entry) {
        ArrayList<Container.Entry> entries;
        block7: {
            entries = new ArrayList<Container.Entry>();
            try {
                for (Future<Indexes> futureIndexes : this.collectionOfFutureIndexes) {
                    Collection collection;
                    Map<String, Collection> index;
                    if (!futureIndexes.isDone() || (index = futureIndexes.get().getIndex("typeDeclarations")) == null || (collection = index.get(typeName)) == null) continue;
                    entries.addAll(collection);
                }
            }
            catch (InterruptedException e) {
                assert (ExceptionUtil.printStackTrace((Throwable)e));
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block7;
                throw new AssertionError();
            }
        }
        String rootUri = entry.getContainer().getRoot().getUri().toString();
        ArrayList<Container.Entry> sameContainerEntries = new ArrayList<Container.Entry>();
        for (Container.Entry e : entries) {
            if (!e.getUri().toString().startsWith(rootUri)) continue;
            sameContainerEntries.add(e);
        }
        if (!sameContainerEntries.isEmpty()) {
            return this.searchTypeHavingMember(typeName, name, descriptor, sameContainerEntries);
        }
        return this.searchTypeHavingMember(typeName, name, descriptor, entries);
    }

    protected String searchTypeHavingMember(String typeName, String name, String descriptor, List<Container.Entry> entries) {
        for (Container.Entry nextEntry : entries) {
            String typeOwnerName;
            Type type = this.api.getTypeFactory(nextEntry).make(this.api, nextEntry, typeName);
            if (type == null) continue;
            if (descriptor.indexOf(40) == -1) {
                for (Type.Field field : type.getFields()) {
                    if (!field.getName().equals(name) || !DescriptorMatcher.matchFieldDescriptors(field.getDescriptor(), descriptor)) continue;
                    return typeName;
                }
            } else {
                for (Type.Method method : type.getMethods()) {
                    if (!method.getName().equals(name) || !DescriptorMatcher.matchMethodDescriptors(method.getDescriptor(), descriptor)) continue;
                    return typeName;
                }
            }
            if ((typeOwnerName = this.searchTypeHavingMember(type.getSuperName(), name, descriptor, nextEntry)) == null) continue;
            return typeOwnerName;
        }
        return null;
    }

    public void parseAndSetText(String text) {
        this.listener.clearData();
        char[] source = text.toCharArray();
        URI jarURI = this.entry.getContainer().getRoot().getParent().getUri();
        String unitName = this.entry.getPath();
        ASTParser astParser = ASTParserFactory.getInstance().newASTParser(source, unitName, jarURI);
        astParser.createAST(null).accept((ASTVisitor)this.listener.getDeclarationListener());
        this.listener.init();
        ASTParser astParserWithBindings = ASTParserFactory.getInstanceWithBindings().newASTParser(source, unitName, jarURI);
        ASTNode astNode = astParserWithBindings.createAST(null);
        astNode.accept((ASTVisitor)this.listener);
        this.setText(text);
        this.initLineNumbers();
        this.setMisalignedLineNumbers(astNode, text);
    }

    private void setMisalignedLineNumbers(ASTNode astNode, String text) {
        if (astNode instanceof CompilationUnit) {
            CompilationUnit cu = (CompilationUnit)astNode;
            List commentList = cu.getCommentList();
            for (Comment comment : commentList) {
                int textAreaLineNumber;
                String lineNumberText;
                int originalLineNumber;
                String commentText;
                Matcher commentMatcher;
                int startPosition = comment.getStartPosition();
                int endPosition = startPosition + comment.getLength();
                int startLineNumber = cu.getLineNumber(startPosition);
                int endLineNumber = cu.getLineNumber(endPosition);
                int columnNumber = cu.getColumnNumber(startPosition);
                if (!comment.isBlockComment() || columnNumber != 0 || startLineNumber != endLineNumber || !(commentMatcher = LINE_COMMENT_PATTERN.matcher(commentText = text.substring(startPosition, endPosition))).matches() || (originalLineNumber = Integer.parseInt(lineNumberText = commentMatcher.group(1))) == (textAreaLineNumber = startLineNumber)) continue;
                this.setLineNumber(textAreaLineNumber, originalLineNumber);
            }
        }
    }
}

