/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;
import org.fife.ui.rsyntaxtextarea.parser.TaskTagParser;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;

public class RoundMarkErrorStrip
extends JComponent {
    private static final long serialVersionUID = 1L;
    private final RSyntaxTextArea textArea;
    private final transient Listener listener;
    private boolean showMarkedOccurrences;
    private boolean showMarkAll;
    private Map<Color, Color> brighterColors;
    private Map<Color, Color> darkerColors;
    private ParserNotice.Level levelThreshold;
    private boolean followCaret;
    private Color caretMarkerColor;
    private int caretLineY;
    private int lastLineY;
    private static final int PREFERRED_WIDTH = 14;
    private static final ResourceBundle msg = ResourceBundle.getBundle("org.fife.ui.rsyntaxtextarea.ErrorStrip");

    public RoundMarkErrorStrip(RSyntaxTextArea textArea) {
        this.textArea = textArea;
        this.listener = new Listener();
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setLayout(null);
        this.addMouseListener(this.listener);
        this.setShowMarkedOccurrences(true);
        this.setShowMarkAll(true);
        this.setLevelThreshold(ParserNotice.Level.WARNING);
        this.setFollowCaret(true);
        this.setCaretMarkerColor(new Color(9881086));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.textArea.addCaretListener((CaretListener)this.listener);
        this.textArea.addPropertyChangeListener("RSTA.parserNotices", (PropertyChangeListener)this.listener);
        this.textArea.addPropertyChangeListener("RSTA.markOccurrences", (PropertyChangeListener)this.listener);
        this.textArea.addPropertyChangeListener("RSTA.markedOccurrencesChanged", (PropertyChangeListener)this.listener);
        this.textArea.addPropertyChangeListener("RTA.markAllOccurrencesChanged", (PropertyChangeListener)this.listener);
        this.refreshMarkers();
    }

    @Override
    public void doLayout() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Marker m = (Marker)this.getComponent(i);
            m.updateLocation();
        }
        this.listener.caretUpdate(null);
    }

    public Color getCaretMarkerColor() {
        return this.caretMarkerColor;
    }

    public boolean getFollowCaret() {
        return this.followCaret;
    }

    @Override
    public Dimension getPreferredSize() {
        int height = this.textArea.getPreferredScrollableViewportSize().height;
        return new Dimension(14, height);
    }

    public ParserNotice.Level getLevelThreshold() {
        return this.levelThreshold;
    }

    public boolean getShowMarkAll() {
        return this.showMarkAll;
    }

    public boolean getShowMarkedOccurrences() {
        return this.showMarkedOccurrences;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        String text = null;
        int line = this.yToLine(e.getY());
        if (line > -1) {
            text = msg.getString("Line");
            text = MessageFormat.format(text, line + 1);
        }
        return text;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.caretLineY > -1) {
            g.setColor(this.getCaretMarkerColor());
            g.fillRect(0, this.caretLineY, this.getWidth(), 2);
        }
    }

    private static int possiblyBrighter(int i) {
        if (i < 255) {
            i += (int)((double)(255 - i) * 0.6);
        }
        return i;
    }

    private static int possiblyDarker(int i) {
        return i - (int)((double)i * 0.4);
    }

    private void refreshMarkers() {
        this.removeAll();
        HashMap<Integer, Marker> markerMap = new HashMap<Integer, Marker>();
        List notices = this.textArea.getParserNotices();
        for (ParserNotice notice : notices) {
            if (!notice.getLevel().isEqualToOrWorseThan(this.levelThreshold) && !(notice instanceof TaskTagParser.TaskNotice)) continue;
            Integer key = notice.getLine();
            Marker m = (Marker)markerMap.get(key);
            if (m == null) {
                m = new Marker(notice);
                m.addMouseListener(this.listener);
                markerMap.put(key, m);
                this.add(m);
                continue;
            }
            m.addNotice(notice);
        }
        if (this.getShowMarkedOccurrences() && this.textArea.getMarkOccurrences()) {
            List occurrences = this.textArea.getMarkedOccurrences();
            this.addMarkersForRanges(occurrences, markerMap, this.textArea.getMarkOccurrencesColor());
        }
        if (this.getShowMarkAll()) {
            Color markAllColor = this.textArea.getMarkAllHighlightColor();
            List ranges = this.textArea.getMarkAllHighlightRanges();
            this.addMarkersForRanges(ranges, markerMap, markAllColor);
        }
        this.revalidate();
        this.repaint();
    }

    private void addMarkersForRanges(List<DocumentRange> ranges, Map<Integer, Marker> markerMap, Color color) {
        for (DocumentRange range : ranges) {
            int line = 0;
            try {
                line = this.textArea.getLineOfOffset(range.getStartOffset());
            }
            catch (BadLocationException ble) {
                assert (ExceptionUtil.printStackTrace((Throwable)ble));
                continue;
            }
            MarkedOccurrenceNotice notice = new MarkedOccurrenceNotice(range, color);
            Integer key = line;
            Marker m = markerMap.get(key);
            if (m == null) {
                m = new Marker(notice);
                m.addMouseListener(this.listener);
                markerMap.put(key, m);
                this.add(m);
                continue;
            }
            if (m.containsMarkedOccurence()) continue;
            m.addNotice(notice);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.textArea.removeCaretListener((CaretListener)this.listener);
        this.textArea.removePropertyChangeListener("RSTA.parserNotices", (PropertyChangeListener)this.listener);
        this.textArea.removePropertyChangeListener("RSTA.markOccurrences", (PropertyChangeListener)this.listener);
        this.textArea.removePropertyChangeListener("RSTA.markedOccurrencesChanged", (PropertyChangeListener)this.listener);
        this.textArea.removePropertyChangeListener("RTA.markAllOccurrencesChanged", (PropertyChangeListener)this.listener);
    }

    private void setCaretMarkerColor(Color color) {
        if (color != null) {
            this.caretMarkerColor = color;
            this.listener.caretUpdate(null);
        }
    }

    private void setFollowCaret(boolean follow) {
        if (this.followCaret != follow) {
            if (this.followCaret) {
                this.repaint(0, this.caretLineY, this.getWidth(), 2);
            }
            this.caretLineY = -1;
            this.lastLineY = -1;
            this.followCaret = follow;
            this.listener.caretUpdate(null);
        }
    }

    private void setLevelThreshold(ParserNotice.Level level) {
        this.levelThreshold = level;
        if (this.isDisplayable()) {
            this.refreshMarkers();
        }
    }

    private void setShowMarkAll(boolean show) {
        if (show != this.showMarkAll) {
            this.showMarkAll = show;
            if (this.isDisplayable()) {
                this.refreshMarkers();
            }
        }
    }

    private void setShowMarkedOccurrences(boolean show) {
        if (show != this.showMarkedOccurrences) {
            this.showMarkedOccurrences = show;
            if (this.isDisplayable()) {
                this.refreshMarkers();
            }
        }
    }

    private int yToLine(int y) {
        int line = -1;
        int h = this.textArea.getVisibleRect().height;
        if (y < h) {
            double at = (double)y / (double)h;
            line = (int)Math.round((double)(this.textArea.getLineCount() - 1) * at);
        }
        return line;
    }

    private class Listener
    extends MouseAdapter
    implements PropertyChangeListener,
    CaretListener {
        private Rectangle visibleRect = new Rectangle();

        private Listener() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            if (RoundMarkErrorStrip.this.getFollowCaret()) {
                int line = RoundMarkErrorStrip.this.textArea.getCaretLineNumber();
                double percent = (double)line / (double)(RoundMarkErrorStrip.this.textArea.getLineCount() - 1);
                RoundMarkErrorStrip.this.textArea.computeVisibleRect(this.visibleRect);
                RoundMarkErrorStrip.this.caretLineY = (int)((double)this.visibleRect.height * percent);
                if (RoundMarkErrorStrip.this.caretLineY != RoundMarkErrorStrip.this.lastLineY) {
                    RoundMarkErrorStrip.this.repaint(0, RoundMarkErrorStrip.this.lastLineY, RoundMarkErrorStrip.this.getWidth(), 2);
                    RoundMarkErrorStrip.this.repaint(0, RoundMarkErrorStrip.this.caretLineY, RoundMarkErrorStrip.this.getWidth(), 2);
                    RoundMarkErrorStrip.this.lastLineY = RoundMarkErrorStrip.this.caretLineY;
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Component source = (Component)e.getSource();
            if (source instanceof Marker) {
                Marker m = (Marker)source;
                m.mouseClicked();
                return;
            }
            int line = RoundMarkErrorStrip.this.yToLine(e.getY());
            if (line > -1) {
                try {
                    int offs = RoundMarkErrorStrip.this.textArea.getLineStartOffset(line);
                    RoundMarkErrorStrip.this.textArea.setCaretPosition(offs);
                }
                catch (BadLocationException ble) {
                    assert (ExceptionUtil.printStackTrace((Throwable)ble));
                    UIManager.getLookAndFeel().provideErrorFeedback((Component)RoundMarkErrorStrip.this.textArea);
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propName = e.getPropertyName();
            if ("RSTA.markOccurrences".equals(propName)) {
                if (RoundMarkErrorStrip.this.getShowMarkedOccurrences()) {
                    RoundMarkErrorStrip.this.refreshMarkers();
                }
            } else if ("RSTA.parserNotices".equals(propName)) {
                RoundMarkErrorStrip.this.refreshMarkers();
            } else if ("RSTA.markedOccurrencesChanged".equals(propName)) {
                if (RoundMarkErrorStrip.this.getShowMarkedOccurrences()) {
                    RoundMarkErrorStrip.this.refreshMarkers();
                }
            } else if ("RTA.markAllOccurrencesChanged".equals(propName) && RoundMarkErrorStrip.this.getShowMarkAll()) {
                RoundMarkErrorStrip.this.refreshMarkers();
            }
        }
    }

    private class Marker
    extends JComponent {
        private static final long serialVersionUID = 1L;
        private transient List<ParserNotice> notices = new ArrayList<ParserNotice>(1);

        public Marker(ParserNotice notice) {
            this.addNotice(notice);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setSize(this.getPreferredSize());
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        public void addNotice(ParserNotice notice) {
            this.notices.add(notice);
        }

        public boolean containsMarkedOccurence() {
            boolean result = false;
            for (int i = 0; i < this.notices.size(); ++i) {
                if (!(this.notices.get(i) instanceof MarkedOccurrenceNotice)) continue;
                result = true;
                break;
            }
            return result;
        }

        public Color getColor() {
            Color c = null;
            int lowestLevel = Integer.MAX_VALUE;
            for (ParserNotice notice : this.notices) {
                if (notice.getLevel().getNumericValue() >= lowestLevel) continue;
                lowestLevel = notice.getLevel().getNumericValue();
                c = notice.getColor();
            }
            return c;
        }

        @Override
        public Dimension getPreferredSize() {
            int w = 10;
            return new Dimension(w, 5);
        }

        @Override
        public String getToolTipText() {
            String text = null;
            if (this.notices.size() == 1) {
                text = this.notices.get(0).getMessage();
            } else {
                StringBuilder sb = new StringBuilder("<html>");
                sb.append(msg.getString("MultipleMarkers"));
                sb.append("<br>");
                for (int i = 0; i < this.notices.size(); ++i) {
                    ParserNotice pn = this.notices.get(i);
                    sb.append("&nbsp;&nbsp;&nbsp;- ");
                    sb.append(pn.getMessage());
                    sb.append("<br>");
                }
                text = sb.toString();
            }
            return text;
        }

        protected void mouseClicked() {
            ParserNotice pn = this.notices.get(0);
            int offs = pn.getOffset();
            int len = pn.getLength();
            if (offs > -1 && len > -1) {
                RoundMarkErrorStrip.this.textArea.setSelectionStart(offs);
                RoundMarkErrorStrip.this.textArea.setSelectionEnd(offs + len);
            } else {
                int line = pn.getLine();
                try {
                    offs = RoundMarkErrorStrip.this.textArea.getLineStartOffset(line);
                    RoundMarkErrorStrip.this.textArea.setCaretPosition(offs);
                }
                catch (BadLocationException ble) {
                    assert (ExceptionUtil.printStackTrace((Throwable)ble));
                    UIManager.getLookAndFeel().provideErrorFeedback((Component)RoundMarkErrorStrip.this.textArea);
                }
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            Color color = this.getColor();
            if (color == null) {
                color = Color.GRAY;
            }
            Color brighterColor = this.getBrighterColor(color);
            Color darkerColor = this.getDarkerColor(color);
            int w = this.getWidth();
            int h = this.getHeight();
            g.setColor(color);
            g.fillRect(0, 0, w, h);
            g.setColor(darkerColor);
            g.drawLine(--w, 0, w, --h);
            g.drawRect(0, h, w, h);
            g.setColor(brighterColor);
            g.drawLine(0, 0, w, 0);
            g.drawRect(0, 0, 0, h);
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            ToolTipManager.sharedInstance().unregisterComponent(this);
            this.removeMouseListener(RoundMarkErrorStrip.this.listener);
        }

        public void updateLocation() {
            int line = this.notices.get(0).getLine();
            int y = this.lineToY(line);
            this.setLocation(2, y);
        }

        private Color getBrighterColor(Color c) {
            if (RoundMarkErrorStrip.this.brighterColors == null) {
                RoundMarkErrorStrip.this.brighterColors = new HashMap<Color, Color>(5);
            }
            return RoundMarkErrorStrip.this.brighterColors.computeIfAbsent(c, k -> {
                int r = RoundMarkErrorStrip.possiblyBrighter(c.getRed());
                int g = RoundMarkErrorStrip.possiblyBrighter(c.getGreen());
                int b = RoundMarkErrorStrip.possiblyBrighter(c.getBlue());
                return new Color(r, g, b);
            });
        }

        private Color getDarkerColor(Color c) {
            if (RoundMarkErrorStrip.this.darkerColors == null) {
                RoundMarkErrorStrip.this.darkerColors = new HashMap<Color, Color>(5);
            }
            return RoundMarkErrorStrip.this.darkerColors.computeIfAbsent(c, k -> {
                int r = RoundMarkErrorStrip.possiblyDarker(c.getRed());
                int g = RoundMarkErrorStrip.possiblyDarker(c.getGreen());
                int b = RoundMarkErrorStrip.possiblyDarker(c.getBlue());
                return new Color(r, g, b);
            });
        }

        private int lineToY(int line) {
            int h = RoundMarkErrorStrip.this.textArea.getVisibleRect().height;
            double lineCount = RoundMarkErrorStrip.this.textArea.getLineCount();
            return (int)((double)(line - 1) / (lineCount - 1.0) * (double)h) - 2;
        }
    }

    private class MarkedOccurrenceNotice
    implements ParserNotice {
        private DocumentRange range;
        private Color color;

        public MarkedOccurrenceNotice(DocumentRange range, Color color) {
            this.range = range;
            this.color = color;
        }

        public int compareTo(ParserNotice other) {
            return 0;
        }

        public boolean containsPosition(int pos) {
            return pos >= this.range.getStartOffset() && pos < this.range.getEndOffset();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.compareTo((ParserNotice)o) == 0;
        }

        public Color getColor() {
            return this.color;
        }

        public boolean getKnowsOffsetAndLength() {
            return true;
        }

        public int getLength() {
            return this.range.getEndOffset() - this.range.getStartOffset();
        }

        public ParserNotice.Level getLevel() {
            return ParserNotice.Level.INFO;
        }

        public int getLine() {
            try {
                return RoundMarkErrorStrip.this.textArea.getLineOfOffset(this.range.getStartOffset()) + 1;
            }
            catch (BadLocationException ble) {
                assert (ExceptionUtil.printStackTrace((Throwable)ble));
                return 0;
            }
        }

        public String getMessage() {
            String text = null;
            try {
                String word = RoundMarkErrorStrip.this.textArea.getText(this.range.getStartOffset(), this.getLength());
                text = msg.getString("OccurrenceOf");
                text = MessageFormat.format(text, word);
            }
            catch (BadLocationException ble) {
                assert (ExceptionUtil.printStackTrace((Throwable)ble));
                UIManager.getLookAndFeel().provideErrorFeedback((Component)RoundMarkErrorStrip.this.textArea);
            }
            return text;
        }

        public int getOffset() {
            return this.range.getStartOffset();
        }

        public Parser getParser() {
            return null;
        }

        public boolean getShowInEditor() {
            return false;
        }

        public String getToolTipText() {
            return null;
        }

        public int hashCode() {
            return 0;
        }
    }
}

