/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view.component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import jd.core.links.DeclarationData;
import jd.core.links.HyperlinkData;
import jd.core.links.HyperlinkReferenceData;
import jd.core.links.ReferenceData;
import jd.core.links.StringData;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.jd.gui.api.model.Container;
import org.jd.gui.util.Key;
import org.jd.gui.util.parser.jdt.core.AbstractJavaListener;
import org.jd.gui.util.parser.jdt.core.TypeDeclarationData;
import org.jd.gui.view.component.DeclarationListener;

public class ReferenceListener
extends AbstractJavaListener {
    private final StringBuilder sbTypeDeclaration = new StringBuilder();
    private final Map<String, ReferenceData> referencesCache = new HashMap<String, ReferenceData>();
    private String currentInternalTypeName;
    private final DeclarationListener declarationListener;
    private final List<ReferenceData> references = new ArrayList<ReferenceData>();
    private final List<StringData> strings = new ArrayList<StringData>();
    private SortedMap<Integer, HyperlinkData> hyperlinks = new TreeMap<Integer, HyperlinkData>();

    public ReferenceListener(Container.Entry entry) {
        super(entry);
        this.declarationListener = new DeclarationListener(entry);
    }

    public void init() {
        this.nameToInternalTypeName.putAll(this.declarationListener.getNameToInternalTypeName());
    }

    @Override
    public boolean visit(PackageDeclaration node) {
        if (super.visit(node) && !this.packageName.isEmpty()) {
            this.sbTypeDeclaration.append(this.packageName).append('/');
        }
        return true;
    }

    @Override
    public boolean visit(ImportDeclaration node) {
        int position = node.getName().getStartPosition();
        String internalTypeName = ReferenceListener.nameToString(node.getName());
        ReferenceData refData = this.newReferenceData(internalTypeName, null, null, null);
        this.addHyperlink(new HyperlinkReferenceData(position, internalTypeName.length(), refData));
        return true;
    }

    @Override
    public boolean enterTypeDeclaration(AbstractTypeDeclaration node, int flag) {
        String typeName = node.getName().getIdentifier();
        int length = this.sbTypeDeclaration.length();
        if (length == 0 || this.sbTypeDeclaration.charAt(length - 1) == '/') {
            this.sbTypeDeclaration.append(typeName);
        } else {
            this.sbTypeDeclaration.append('$').append(typeName);
        }
        this.currentInternalTypeName = this.sbTypeDeclaration.toString();
        return true;
    }

    @Override
    public void exitTypeDeclaration() {
        int index = this.sbTypeDeclaration.lastIndexOf("$");
        if (index == -1) {
            index = this.sbTypeDeclaration.lastIndexOf("/") + 1;
        }
        if (index == -1) {
            this.sbTypeDeclaration.setLength(0);
        } else {
            this.sbTypeDeclaration.setLength(index);
        }
        this.currentInternalTypeName = this.sbTypeDeclaration.toString();
    }

    public boolean visit(SimpleType node) {
        Name name = node.getName();
        String internalTypeName = this.resolveInternalTypeName((Type)node);
        int position = node.getStartPosition();
        ReferenceData refData = this.newReferenceData(internalTypeName, null, null);
        this.addHyperlink(new HyperlinkReferenceData(position, name.getLength(), refData));
        return true;
    }

    public boolean visit(QualifiedName node) {
        SimpleName fieldNameNode = node.getName();
        String fieldName = fieldNameNode.getIdentifier();
        Name qualifier = node.getQualifier();
        if (qualifier instanceof SimpleName) {
            SimpleName qualifierSimpleName = (SimpleName)qualifier;
            String qualifierDescriptor = null;
            IBinding binding = qualifier.resolveBinding();
            if (binding instanceof ITypeBinding) {
                qualifierDescriptor = binding.getKey();
            }
            IVariableBinding variableBinding = null;
            if (binding instanceof IVariableBinding) {
                variableBinding = (IVariableBinding)binding;
                ITypeBinding typeBinding = qualifier.resolveTypeBinding();
                if (typeBinding != null) {
                    qualifierDescriptor = typeBinding.getKey();
                }
            }
            if (qualifierDescriptor != null) {
                String declaringBinaryName;
                ITypeBinding declaringClass;
                if (qualifierDescriptor.charAt(0) == 'L') {
                    String qualifierTypeName = qualifierDescriptor.substring(1, qualifierDescriptor.length() - 1);
                    ReferenceData refData = this.newReferenceData(qualifierTypeName, fieldName, "?");
                    if (binding instanceof ITypeBinding || variableBinding != null && variableBinding.isField()) {
                        ReferenceData qualifierRefData = this.newReferenceData(qualifierTypeName, null, null);
                        this.addHyperlink(new HyperlinkReferenceData(qualifier.getStartPosition(), qualifier.getLength(), qualifierRefData));
                    }
                    this.addHyperlink(new HyperlinkReferenceData(fieldNameNode.getStartPosition(), fieldNameNode.getLength(), refData));
                }
                if (qualifierDescriptor.charAt(0) == '[' && variableBinding != null && (declaringClass = variableBinding.getDeclaringClass()) != null && (declaringBinaryName = declaringClass.getBinaryName()) != null) {
                    String declaringInternalTypeName = declaringBinaryName.replace('.', '/');
                    String qualifierIdentifier = qualifierSimpleName.getIdentifier();
                    ReferenceData refData = this.newReferenceData(declaringInternalTypeName, qualifierIdentifier, "?");
                    this.addHyperlink(new HyperlinkReferenceData(qualifier.getStartPosition(), qualifier.getLength(), refData));
                }
            }
        }
        return true;
    }

    public boolean visit(ClassInstanceCreation node) {
        String descriptor;
        Type type = node.getType();
        String internalTypeName = this.resolveInternalTypeName(type);
        int position = node.getStartPosition();
        List expressionList = node.arguments();
        if (expressionList != null) {
            IMethodBinding constructorBinding = node.resolveConstructorBinding();
            if (constructorBinding != null) {
                ITypeBinding[] parameterTypes = constructorBinding.getParameterTypes();
                descriptor = ReferenceListener.getParametersDescriptor(parameterTypes).append('V').toString();
            } else {
                descriptor = ReferenceListener.getParametersDescriptor(expressionList.size()).append('V').toString();
            }
        } else {
            descriptor = "()V";
        }
        ReferenceData refData = this.newReferenceData(internalTypeName, "<init>", descriptor);
        this.addHyperlink(new HyperlinkReferenceData(position, node.getLength(), refData));
        return true;
    }

    private static StringBuilder getParametersDescriptor(ITypeBinding[] argTypes) {
        StringBuilder sb = new StringBuilder("(");
        for (ITypeBinding argType : argTypes) {
            sb.append(argType.getKey());
        }
        sb.append(')');
        return sb;
    }

    private static StringBuilder getParametersDescriptor(int paramCount) {
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < paramCount; ++i) {
            sb.append('?');
        }
        sb.append(')');
        return sb;
    }

    public boolean visit(ArrayCreation node) {
        if (!node.getType().getElementType().isPrimitiveType()) {
            String internalTypeName = this.resolveInternalTypeName((Type)node.getType());
            int position = node.getStartPosition();
            ReferenceData refData = this.newReferenceData(internalTypeName, null, null);
            this.addHyperlink(new HyperlinkReferenceData(position, node.getType().getLength(), refData));
        }
        return true;
    }

    private void createLinkToVariable(Expression exp) {
        SimpleName simpleName;
        IBinding binding;
        if (exp instanceof SimpleName && (binding = (simpleName = (SimpleName)exp).resolveBinding()) instanceof IVariableBinding) {
            IVariableBinding variableBinding = (IVariableBinding)binding;
            this.createLinkToVariable(simpleName, variableBinding);
        }
    }

    private void createLinkToVariable(SimpleName simpleName, IVariableBinding variableBinding) {
        String binaryName;
        ITypeBinding declaringClass;
        if (variableBinding != null && variableBinding.isField() && (declaringClass = variableBinding.getDeclaringClass()) != null && (binaryName = declaringClass.getBinaryName()) != null) {
            String varTypeName = binaryName.replace('.', '/');
            int position = simpleName.getStartPosition();
            String varName = simpleName.getIdentifier();
            ReferenceData refData = this.newReferenceData(varTypeName, varName, "?");
            this.addHyperlink(new HyperlinkReferenceData(position, varName.length(), refData));
        }
    }

    public boolean visit(ArrayAccess node) {
        this.createLinkToVariable(node.getArray());
        return true;
    }

    public boolean visit(FieldAccess node) {
        IVariableBinding fieldBinding = node.resolveFieldBinding();
        if (fieldBinding != null) {
            this.createLinkToVariable(node.getName(), fieldBinding);
        }
        return true;
    }

    public boolean visit(Assignment node) {
        this.createLinkToVariable(node.getLeftHandSide());
        this.createLinkToVariable(node.getRightHandSide());
        return true;
    }

    public boolean visit(ConstructorInvocation node) {
        String constructorDescriptor;
        List args = node.arguments();
        if (args != null) {
            IMethodBinding constructorBinding = node.resolveConstructorBinding();
            if (constructorBinding != null) {
                ITypeBinding[] parameterTypes = constructorBinding.getParameterTypes();
                constructorDescriptor = ReferenceListener.getParametersDescriptor(parameterTypes).append('V').toString();
            } else {
                constructorDescriptor = ReferenceListener.getParametersDescriptor(args.size()).append('V').toString();
            }
        } else {
            constructorDescriptor = "()V";
        }
        ReferenceData refData = this.newReferenceData(this.currentInternalTypeName, "<init>", constructorDescriptor);
        int position = node.getStartPosition();
        this.addHyperlink(new HyperlinkReferenceData(position, 4, refData));
        return true;
    }

    public boolean visit(SuperConstructorInvocation node) {
        String constructorDescriptor;
        List args = node.arguments();
        if (args != null) {
            IMethodBinding constructorBinding = node.resolveConstructorBinding();
            if (constructorBinding != null) {
                ITypeBinding[] parameterTypes = constructorBinding.getParameterTypes();
                constructorDescriptor = ReferenceListener.getParametersDescriptor(parameterTypes).append('V').toString();
            } else {
                constructorDescriptor = ReferenceListener.getParametersDescriptor(args.size()).append('V').toString();
            }
        } else {
            constructorDescriptor = "()V";
        }
        DeclarationData data = this.getDeclarations().get(this.currentInternalTypeName);
        if (data instanceof TypeDeclarationData) {
            TypeDeclarationData tdd = (TypeDeclarationData)data;
            String methodTypeName = tdd.getSuperTypeName();
            ReferenceData refData = this.newReferenceData(methodTypeName, "<init>", constructorDescriptor);
            int position = node.getStartPosition();
            this.addHyperlink(new HyperlinkReferenceData(position, 5, refData));
        }
        return true;
    }

    public boolean visit(MethodInvocation node) {
        SimpleName subjectName;
        String internalTypeName;
        this.visitMethodBinding(node.getName(), node.resolveMethodBinding());
        Expression subject = node.getExpression();
        if (subject instanceof SimpleName && (internalTypeName = (String)this.nameToInternalTypeName.get((subjectName = (SimpleName)subject).getIdentifier())) != null) {
            ReferenceData refData = this.newReferenceData(internalTypeName, null, null);
            this.addHyperlink(new HyperlinkReferenceData(subjectName.getStartPosition(), subjectName.getLength(), refData));
        }
        return true;
    }

    public boolean visit(ExpressionMethodReference node) {
        return this.visitMethodBinding(node.getName(), node.resolveMethodBinding());
    }

    private boolean visitMethodBinding(SimpleName name, IMethodBinding methodBinding) {
        if (methodBinding != null) {
            String methodName = name.getIdentifier();
            ITypeBinding declaringClass = methodBinding.getDeclaringClass();
            String binaryName = declaringClass.getBinaryName();
            if (binaryName != null) {
                String methodTypeName = binaryName.replace('.', '/');
                ITypeBinding[] args = methodBinding.getParameterTypes();
                ITypeBinding returnType = methodBinding.getReturnType();
                String methodDescriptor = args.length > 0 ? ReferenceListener.getParametersDescriptor(args).append(returnType.getKey()).toString() : "()" + returnType.getKey();
                ReferenceData refData = this.newReferenceData(methodTypeName, methodName, methodDescriptor);
                int position = name.getStartPosition();
                this.addHyperlink(new HyperlinkReferenceData(position, methodName.length(), refData));
            }
        }
        return true;
    }

    public ReferenceData newReferenceData(String internalName, String name, String descriptor, String scopeInternalName) {
        String key = Key.key(internalName, name, descriptor, scopeInternalName);
        return this.referencesCache.computeIfAbsent(key, k -> {
            ReferenceData reference = new ReferenceData(internalName, name, descriptor, scopeInternalName);
            this.references.add(reference);
            return reference;
        });
    }

    public ReferenceData newReferenceData(String internalName, String name, String descriptor) {
        return this.newReferenceData(internalName, name, descriptor, this.currentInternalTypeName);
    }

    public boolean visit(StringLiteral node) {
        this.strings.add(new StringData(node.getStartPosition() + 1, node.getLiteralValue(), this.currentInternalTypeName));
        return true;
    }

    public List<ReferenceData> getReferences() {
        return this.references;
    }

    public List<StringData> getStrings() {
        return this.strings;
    }

    public SortedMap<Integer, HyperlinkData> getHyperlinks() {
        return this.hyperlinks;
    }

    public void setHyperlinks(SortedMap<Integer, HyperlinkData> hyperlinks) {
        this.hyperlinks = hyperlinks;
    }

    public void clearData() {
        this.sbTypeDeclaration.setLength(0);
        this.declarationListener.clearData();
        this.references.clear();
        this.strings.clear();
        this.hyperlinks.clear();
    }

    public void addStringData(StringData stringData) {
        this.strings.add(stringData);
    }

    public void addHyperlink(HyperlinkReferenceData hyperlinkReferenceData) {
        this.hyperlinks.put(hyperlinkReferenceData.getStartPosition(), (HyperlinkData)hyperlinkReferenceData);
    }

    public Map<String, DeclarationData> getDeclarations() {
        return this.declarationListener.getDeclarations();
    }

    public NavigableMap<Integer, DeclarationData> getTypeDeclarations() {
        return this.declarationListener.getTypeDeclarations();
    }

    public void addTypeDeclaration(int position, String internalName, DeclarationData data) {
        this.declarationListener.addTypeDeclaration(position, internalName, data);
    }

    public void addDeclaration(String key, DeclarationData declarationData) {
        this.declarationListener.addDeclaration(key, declarationData);
    }

    public DeclarationListener getDeclarationListener() {
        return this.declarationListener;
    }
}

