/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view.component;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import jd.core.links.HyperlinkData;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.IndexesChangeListener;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.util.index.IndexesUtil;
import org.jd.gui.view.component.TypeReferencePage;

public class OneTypeReferencePerLinePage
extends TypeReferencePage
implements UriGettable,
IndexesChangeListener {
    private static final long serialVersionUID = 1L;
    private final transient API api;
    private final transient Container.Entry entry;
    private transient Collection<Future<Indexes>> collectionOfFutureIndexes;

    public OneTypeReferencePerLinePage(API api, Container.Entry entry) {
        StringBuilder sb;
        block9: {
            this.collectionOfFutureIndexes = Collections.emptyList();
            this.api = api;
            this.entry = entry;
            sb = new StringBuilder();
            int offset = 0;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(entry.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    String trim = line.trim();
                    if (!trim.isEmpty()) {
                        int startIndex = offset + line.indexOf(trim);
                        int endIndex = startIndex + trim.length();
                        String internalTypeName = trim.replace('.', '/');
                        this.addHyperlink(new TypeReferencePage.TypeHyperlinkData(startIndex, endIndex, internalTypeName));
                    }
                    offset += line.length() + 1;
                    sb.append(line).append('\n');
                }
            }
            catch (IOException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block9;
                throw new AssertionError();
            }
        }
        this.setText(sb.toString());
    }

    @Override
    protected boolean isHyperlinkEnabled(HyperlinkData hyperlinkData) {
        return ((TypeReferencePage.TypeHyperlinkData)hyperlinkData).isEnabled();
    }

    @Override
    protected void openHyperlink(int x, int y, HyperlinkData hyperlinkData) {
        block7: {
            TypeReferencePage.TypeHyperlinkData data = (TypeReferencePage.TypeHyperlinkData)hyperlinkData;
            if (data.isEnabled()) {
                try {
                    Point location = this.textArea.getLocationOnScreen();
                    int offset = this.textArea.viewToModel2D((Point2D)new Point(x - location.x, y - location.y));
                    URI uri = this.entry.getUri();
                    this.api.addURI(new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), "position=" + offset, null));
                    String internalTypeName = data.getInternalTypeName();
                    List<Container.Entry> entries = IndexesUtil.findInternalTypeName(this.collectionOfFutureIndexes, internalTypeName);
                    String rootUri = this.entry.getContainer().getRoot().getUri().toString();
                    ArrayList<Container.Entry> sameContainerEntries = new ArrayList<Container.Entry>();
                    for (Container.Entry nextEntry : entries) {
                        if (!nextEntry.getUri().toString().startsWith(rootUri)) continue;
                        sameContainerEntries.add(nextEntry);
                    }
                    if (!sameContainerEntries.isEmpty()) {
                        this.api.openURI(x, y, sameContainerEntries, null, data.getInternalTypeName());
                    } else if (!entries.isEmpty()) {
                        this.api.openURI(x, y, entries, null, data.getInternalTypeName());
                    }
                }
                catch (URISyntaxException e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block7;
                    throw new AssertionError();
                }
            }
        }
    }

    @Override
    public URI getUri() {
        return this.entry.getUri();
    }

    @Override
    public String getFileName() {
        String path = this.entry.getPath();
        int index = path.lastIndexOf(47);
        return path.substring(index + 1);
    }

    @Override
    public void indexesChanged(Collection<Future<Indexes>> collectionOfFutureIndexes) {
        this.collectionOfFutureIndexes = collectionOfFutureIndexes;
        boolean refresh = false;
        for (Map.Entry nextEntry : this.hyperlinks.entrySet()) {
            TypeReferencePage.TypeHyperlinkData entryData = (TypeReferencePage.TypeHyperlinkData)((Object)nextEntry.getValue());
            String internalTypeName = entryData.getInternalTypeName();
            boolean enabled = IndexesUtil.containsInternalTypeName(collectionOfFutureIndexes, internalTypeName);
            if (entryData.isEnabled() == enabled) continue;
            entryData.setEnabled(enabled);
            refresh = true;
        }
        if (refresh) {
            this.textArea.repaint();
        }
    }
}

