/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view.component;

import com.heliosdecompiler.transformerapi.decompilers.jd.JDCoreV1Decompiler;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import javax.swing.text.Segment;
import jd.core.ClassUtil;
import jd.core.links.DeclarationData;
import jd.core.links.HyperlinkData;
import jd.core.links.HyperlinkReferenceData;
import jd.core.links.ReferenceData;
import org.apache.bcel.classfile.Utility;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMaker;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.TokenMap;
import org.jd.core.v1.api.loader.Loader;
import org.jd.core.v1.api.printer.Printer;
import org.jd.core.v1.printer.StringBuilderPrinter;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.util.decompiler.ContainerLoader;
import org.jd.gui.util.index.IndexesUtil;
import org.jd.gui.view.component.ClassFilePage;

public class ModuleInfoFilePage
extends ClassFilePage {
    private static final long serialVersionUID = 1L;
    public static final String SYNTAX_STYLE_JAVA_MODULE = "text/java-module";

    public ModuleInfoFilePage(API api, Container.Entry entry) {
        super(api, entry);
    }

    @Override
    public void decompile(Map<String, String> preferences) {
        try {
            this.clearHyperlinks();
            this.clearLineNumbers();
            this.listener.getTypeDeclarations().clear();
            boolean unicodeEscape = Boolean.parseBoolean(preferences.getOrDefault("ClassFileSaverPreferences.escapeUnicodeCharacters", Boolean.FALSE.toString()));
            ContainerLoader loader = new ContainerLoader(this.entry);
            ModuleInfoFilePrinter printer = new ModuleInfoFilePrinter();
            printer.setUnicodeEscape(unicodeEscape);
            String entryInternalName = ClassUtil.getInternalName((String)this.entry.getPath());
            JDCoreV1Decompiler.DECOMPILER.decompile((Loader)loader, (Printer)printer, entryInternalName);
        }
        catch (Exception t) {
            assert (ExceptionUtil.printStackTrace((Throwable)t));
            this.setText("// INTERNAL ERROR //");
        }
    }

    @Override
    public String getSyntaxStyle() {
        return SYNTAX_STYLE_JAVA_MODULE;
    }

    @Override
    protected void openHyperlink(int x, int y, HyperlinkData hyperlinkData) {
        block13: {
            HyperlinkReferenceData hyperlinkReferenceData = (HyperlinkReferenceData)hyperlinkData;
            if (hyperlinkReferenceData.getReference().isEnabled()) {
                try {
                    List<Container.Entry> entries;
                    String fragment;
                    Point location = this.textArea.getLocationOnScreen();
                    int offset = this.textArea.viewToModel2D((Point2D)new Point(x - location.x, y - location.y));
                    URI uri = this.entry.getUri();
                    this.api.addURI(new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), "position=" + offset, null));
                    ModuleInfoReferenceData moduleInfoReferenceData = (ModuleInfoReferenceData)hyperlinkReferenceData.getReference();
                    switch (moduleInfoReferenceData.type) {
                        case 1: {
                            fragment = moduleInfoReferenceData.getTypeName();
                            entries = IndexesUtil.findInternalTypeName(this.collectionOfFutureIndexes, fragment);
                            break;
                        }
                        case 5: {
                            entries = IndexesUtil.find(this.collectionOfFutureIndexes, "packageDeclarations", moduleInfoReferenceData.getTypeName());
                            fragment = null;
                            break;
                        }
                        default: {
                            entries = IndexesUtil.find(this.collectionOfFutureIndexes, "javaModuleDeclarations", moduleInfoReferenceData.getName());
                            fragment = moduleInfoReferenceData.getTypeName();
                        }
                    }
                    if (entries.contains(this.entry)) {
                        this.api.openURI(uri);
                    } else {
                        String rootUri = this.entry.getContainer().getRoot().getUri().toString();
                        ArrayList<Container.Entry> sameContainerEntries = new ArrayList<Container.Entry>();
                        for (Container.Entry entry : entries) {
                            if (!entry.getUri().toString().startsWith(rootUri)) continue;
                            sameContainerEntries.add(entry);
                        }
                        if (!sameContainerEntries.isEmpty()) {
                            this.api.openURI(x, y, sameContainerEntries, null, fragment);
                        } else if (!entries.isEmpty()) {
                            this.api.openURI(x, y, entries, null, fragment);
                        }
                    }
                }
                catch (URISyntaxException e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block13;
                    throw new AssertionError();
                }
            }
        }
    }

    @Override
    public boolean openUri(URI uri) {
        DeclarationData declaration;
        ArrayList<DocumentRange> ranges = new ArrayList<DocumentRange>();
        String fragment = uri.getFragment();
        String query = uri.getQuery();
        this.textArea.clearMarkAllHighlights();
        if (fragment != null && this.listener.getDeclarations().size() == 1 && fragment.equals((declaration = this.listener.getDeclarations().entrySet().iterator().next().getValue()).getTypeName())) {
            ranges.add(new DocumentRange(declaration.getStartPosition(), declaration.getEndPosition()));
        }
        if (query != null) {
            Map<String, String> parameters = this.parseQuery(query);
            String highlightFlags = parameters.get("highlightFlags");
            String highlightPattern = parameters.get("highlightPattern");
            if (highlightFlags != null && highlightPattern != null) {
                boolean m;
                String regexp = ModuleInfoFilePage.createRegExp(highlightPattern);
                Pattern pattern = Pattern.compile(regexp + ".*");
                boolean t = highlightFlags.indexOf(116) != -1;
                boolean bl = m = highlightFlags.indexOf(77) != -1;
                if (highlightFlags.indexOf(100) != -1) {
                    for (Map.Entry<String, DeclarationData> entry : this.listener.getDeclarations().entrySet()) {
                        DeclarationData declaration2 = entry.getValue();
                        if (!m) continue;
                        ModuleInfoFilePage.matchAndAddDocumentRange(pattern, declaration2.getName(), declaration2.getStartPosition(), declaration2.getEndPosition(), ranges);
                    }
                }
                if (highlightFlags.indexOf(114) != -1) {
                    for (Map.Entry<String, Object> entry : this.hyperlinks.entrySet()) {
                        HyperlinkData hyperlink = (HyperlinkData)entry.getValue();
                        ReferenceData reference = ((HyperlinkReferenceData)hyperlink).getReference();
                        ModuleInfoReferenceData moduleInfoReferenceData = (ModuleInfoReferenceData)reference;
                        if (t && moduleInfoReferenceData.type == 1) {
                            ModuleInfoFilePage.matchAndAddDocumentRange(pattern, ModuleInfoFilePage.getMostInnerTypeName(moduleInfoReferenceData.getTypeName()), hyperlink.getStartPosition(), hyperlink.getEndPosition(), ranges);
                        }
                        if (!m || moduleInfoReferenceData.type != 6) continue;
                        ModuleInfoFilePage.matchAndAddDocumentRange(pattern, moduleInfoReferenceData.getName(), hyperlink.getStartPosition(), hyperlink.getEndPosition(), ranges);
                    }
                }
            }
        }
        if (!ranges.isEmpty()) {
            this.textArea.setMarkAllHighlightColor(SELECT_HIGHLIGHT_COLOR);
            this.textArea.markAll(ranges);
            Collections.sort(ranges);
            this.setCaretPositionAndCenter((DocumentRange)ranges.get(0));
        }
        return true;
    }

    @Override
    public void indexesChanged(Collection<Future<Indexes>> collectionOfFutureIndexes) {
        this.collectionOfFutureIndexes = collectionOfFutureIndexes;
        boolean refresh = false;
        for (ReferenceData reference : this.listener.getReferences()) {
            boolean enabled;
            block11: {
                ModuleInfoReferenceData moduleInfoReferenceData = (ModuleInfoReferenceData)reference;
                enabled = false;
                try {
                    for (Future<Indexes> futureIndexes : collectionOfFutureIndexes) {
                        String key;
                        Map<String, Collection> index;
                        if (!futureIndexes.isDone()) continue;
                        switch (moduleInfoReferenceData.type) {
                            case 1: {
                                index = futureIndexes.get().getIndex("typeDeclarations");
                                String string = reference.getTypeName();
                                break;
                            }
                            case 5: {
                                index = futureIndexes.get().getIndex("packageDeclarations");
                                String string = reference.getTypeName();
                                break;
                            }
                            default: {
                                index = futureIndexes.get().getIndex("javaModuleDeclarations");
                                String string = key = reference.getName();
                            }
                        }
                        if (index == null || index.get(key) == null) continue;
                        enabled = true;
                        break;
                    }
                }
                catch (InterruptedException e) {
                    assert (ExceptionUtil.printStackTrace((Throwable)e));
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block11;
                    throw new AssertionError();
                }
            }
            if (reference.isEnabled() == enabled) continue;
            reference.setEnabled(enabled);
            refresh = true;
        }
        if (refresh) {
            this.textArea.repaint();
        }
    }

    static {
        AbstractTokenMakerFactory atmf = (AbstractTokenMakerFactory)TokenMakerFactory.getDefaultInstance();
        atmf.putMapping(SYNTAX_STYLE_JAVA_MODULE, ModuleInfoTokenMaker.class.getName());
    }

    public class ModuleInfoFilePrinter
    extends StringBuilderPrinter {
        private final Map<String, ReferenceData> referencesCache = new HashMap<String, ReferenceData>();

        public void start(int maxLineNumber, int majorVersion, int minorVersion) {
        }

        public void end() {
            ModuleInfoFilePage.this.setText(this.stringBuffer.toString());
            ModuleInfoFilePage.this.initLineNumbers();
        }

        public void printDeclaration(int type, String internalTypeName, String name, String descriptor) {
            ModuleInfoFilePage.this.listener.addDeclaration(internalTypeName, new DeclarationData(this.stringBuffer.length(), name.length(), internalTypeName, name, descriptor));
            super.printDeclaration(type, internalTypeName, name, descriptor);
        }

        public void printReference(int type, String internalTypeName, String name, String descriptor, String ownerInternalName) {
            String key = type == 6 ? name : internalTypeName;
            ReferenceData reference = this.referencesCache.computeIfAbsent(key, k -> {
                ModuleInfoReferenceData moduleInfoReferenceData = new ModuleInfoReferenceData(type, internalTypeName, name, descriptor, ownerInternalName);
                ModuleInfoFilePage.this.listener.getReferences().add(moduleInfoReferenceData);
                return moduleInfoReferenceData;
            });
            ModuleInfoFilePage.this.addHyperlink((HyperlinkData)new HyperlinkReferenceData(this.stringBuffer.length(), name.length(), reference));
            super.printReference(type, internalTypeName, name, descriptor, ownerInternalName);
        }
    }

    protected static class ModuleInfoReferenceData
    extends ReferenceData {
        private final int type;

        public ModuleInfoReferenceData(int type, String typeName, String name, String descriptor, String owner) {
            super(typeName, name, descriptor, owner);
            this.type = type;
        }

        public String getTypeName() {
            if (this.type == 5) {
                return Utility.packageToPath((String)super.getTypeName());
            }
            return super.getTypeName();
        }
    }

    public static class ModuleInfoTokenMaker
    extends AbstractTokenMaker {
        public TokenMap getWordsToHighlight() {
            TokenMap tokenMap = new TokenMap();
            tokenMap.put("exports", 6);
            tokenMap.put("module", 6);
            tokenMap.put("open", 6);
            tokenMap.put("opens", 6);
            tokenMap.put("provides", 6);
            tokenMap.put("requires", 6);
            tokenMap.put("to", 6);
            tokenMap.put("transitive", 6);
            tokenMap.put("uses", 6);
            tokenMap.put("with", 6);
            return tokenMap;
        }

        public void addToken(Segment segment, int start, int end, int tokenType, int startOffset) {
            int value;
            if (tokenType == 20 && (value = this.wordsToHighlight.get(segment, start, end)) != -1) {
                tokenType = value;
            }
            super.addToken(segment, start, end, tokenType, startOffset);
        }

        public Token getTokenList(Segment text, int startTokenType, int startOffset) {
            this.resetTokenList();
            char[] array = text.array;
            int offset = text.offset;
            int end = offset + text.count;
            int newStartOffset = startOffset - offset;
            int currentTokenStart = offset;
            int currentTokenType = startTokenType;
            block4: for (int i = offset; i < end; ++i) {
                char c = array[i];
                switch (currentTokenType) {
                    case 0: {
                        currentTokenStart = i;
                        if (RSyntaxUtilities.isLetter((char)c) || c == '_') {
                            currentTokenType = 20;
                            continue block4;
                        }
                        currentTokenType = 21;
                        continue block4;
                    }
                    default: {
                        if (!RSyntaxUtilities.isLetter((char)c) && c != '_') continue block4;
                        this.addToken(text, currentTokenStart, i - 1, 21, newStartOffset + currentTokenStart);
                        currentTokenStart = i;
                        currentTokenType = 20;
                        continue block4;
                    }
                    case 20: {
                        if (RSyntaxUtilities.isLetterOrDigit((char)c) || c == '_' || c == '.') continue block4;
                        this.addToken(text, currentTokenStart, i - 1, 20, newStartOffset + currentTokenStart);
                        currentTokenStart = i;
                        currentTokenType = 21;
                    }
                }
            }
            if (currentTokenType != 0) {
                this.addToken(text, currentTokenStart, end - 1, currentTokenType, newStartOffset + currentTokenStart);
            }
            this.addNullToken();
            return this.firstToken;
        }
    }
}

