/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view.component;

import java.awt.Component;
import java.awt.Point;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.concurrent.Future;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.swing.JCheckBox;
import jd.core.links.HyperlinkData;
import org.apache.commons.lang3.StringUtils;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.IndexesChangeListener;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.util.index.IndexesUtil;
import org.jd.gui.util.io.TextReader;
import org.jd.gui.view.component.HyperlinkPage;

public class ManifestFilePage
extends HyperlinkPage
implements UriGettable,
IndexesChangeListener {
    private static final long serialVersionUID = 1L;
    protected API api;
    protected Container.Entry entry;
    protected Collection<Future<Indexes>> collectionOfFutureIndexes = Collections.emptyList();
    protected boolean beautify = false;
    protected JCheckBox beautifyCheckbox = new JCheckBox();

    public ManifestFilePage(API api, Container.Entry entry) {
        this.beautifyCheckbox.setText("Beautify");
        this.beautifyCheckbox.addChangeListener(e -> {
            this.beautify = this.beautifyCheckbox.isSelected();
            this.buildText(entry);
        });
        this.add((Component)this.beautifyCheckbox, "North");
        this.api = api;
        this.entry = entry;
        this.buildText(entry);
    }

    private void buildText(Container.Entry entry) {
        String internalTypeName;
        String typeName;
        int startLineIndex;
        String text = TextReader.getText(entry.getInputStream());
        if (this.beautify) {
            Manifest manifest = new Manifest();
            try {
                manifest.read(entry.getInputStream());
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                ManifestFilePage.dumpManifestHeaders(manifest, printWriter);
                text = stringWriter.toString();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((startLineIndex = text.indexOf("Main-Class:")) != -1) {
            int startIndex = this.skipSeparators(text, startLineIndex + "Main-Class:".length());
            int endIndex = this.searchEndIndexOfValue(text, startLineIndex, startIndex);
            typeName = text.substring(startIndex, endIndex);
            internalTypeName = typeName.replace('.', '/');
            this.addHyperlink(new ManifestHyperlinkData(startIndex, endIndex, internalTypeName + "-main-([Ljava/lang/String;)V"));
        }
        if ((startLineIndex = text.indexOf("Premain-Class:")) != -1) {
            int startIndex = this.skipSeparators(text, startLineIndex + "Premain-Class:".length());
            int endIndex = this.searchEndIndexOfValue(text, startLineIndex, startIndex);
            typeName = text.substring(startIndex, endIndex);
            internalTypeName = typeName.replace('.', '/');
            this.addHyperlink(new ManifestHyperlinkData(startIndex, endIndex, internalTypeName + "-premain-(*)?"));
        }
        this.setText(text);
    }

    public int skipSeparators(String text, int index) {
        int length = text.length();
        block3: while (index < length) {
            switch (text.charAt(index)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++index;
                    continue block3;
                }
            }
            return index;
        }
        return index;
    }

    public int searchEndIndexOfValue(String text, int startLineIndex, int startIndex) {
        int index;
        int length = text.length();
        block4: for (index = startIndex; index < length; ++index) {
            switch (text.charAt(index)) {
                case '\r': {
                    if (index - startLineIndex >= 70 && index + 1 < length && text.charAt(index + 1) == ' ') {
                        startLineIndex = index + 1;
                        continue block4;
                    }
                    if (index - startLineIndex >= 70 && index + 2 < length && text.charAt(index + 1) == '\n' && text.charAt(index + 2) == ' ') {
                        startLineIndex = ++index + 1;
                        continue block4;
                    }
                    return index;
                }
                case '\n': {
                    if (index - startLineIndex >= 70 && index + 1 < length && text.charAt(index + 1) == ' ') {
                        startLineIndex = index + 1;
                        continue block4;
                    }
                    return index;
                }
            }
        }
        return index;
    }

    @Override
    protected boolean isHyperlinkEnabled(HyperlinkData hyperlinkData) {
        return ((ManifestHyperlinkData)hyperlinkData).enabled;
    }

    @Override
    protected void openHyperlink(int x, int y, HyperlinkData hyperlinkData) {
        block7: {
            ManifestHyperlinkData data = (ManifestHyperlinkData)hyperlinkData;
            if (data.enabled) {
                try {
                    Point location = this.textArea.getLocationOnScreen();
                    int offset = this.textArea.viewToModel(new Point(x - location.x, y - location.y));
                    URI uri = this.entry.getUri();
                    this.api.addURI(new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), "position=" + offset, null));
                    String text = this.getText();
                    String textLink = ManifestFilePage.getValue(text, hyperlinkData.getStartPosition(), hyperlinkData.getEndPosition());
                    String internalTypeName = textLink.replace('.', '/');
                    List<Container.Entry> entries = IndexesUtil.findInternalTypeName(this.collectionOfFutureIndexes, internalTypeName);
                    String rootUri = this.entry.getContainer().getRoot().getUri().toString();
                    ArrayList<Container.Entry> sameContainerEntries = new ArrayList<Container.Entry>();
                    for (Container.Entry entry : entries) {
                        if (!entry.getUri().toString().startsWith(rootUri)) continue;
                        sameContainerEntries.add(entry);
                    }
                    if (!sameContainerEntries.isEmpty()) {
                        this.api.openURI(x, y, sameContainerEntries, null, data.fragment);
                    } else if (!entries.isEmpty()) {
                        this.api.openURI(x, y, entries, null, data.fragment);
                    }
                }
                catch (URISyntaxException e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace((Throwable)e)) break block7;
                    throw new AssertionError();
                }
            }
        }
    }

    @Override
    public URI getUri() {
        return this.entry.getUri();
    }

    @Override
    public String getFileName() {
        String path = this.entry.getPath();
        int index = path.lastIndexOf(47);
        return path.substring(index + 1);
    }

    @Override
    public void indexesChanged(Collection<Future<Indexes>> collectionOfFutureIndexes) {
        this.collectionOfFutureIndexes = collectionOfFutureIndexes;
        boolean refresh = false;
        String text = this.getText();
        for (Map.Entry entry : this.hyperlinks.entrySet()) {
            ManifestHyperlinkData entryData = (ManifestHyperlinkData)((Object)entry.getValue());
            String textLink = ManifestFilePage.getValue(text, entryData.getStartPosition(), entryData.getEndPosition());
            String internalTypeName = textLink.replace('.', '/');
            boolean enabled = IndexesUtil.containsInternalTypeName(collectionOfFutureIndexes, internalTypeName);
            if (entryData.enabled == enabled) continue;
            entryData.enabled = enabled;
            refresh = true;
        }
        if (refresh) {
            this.textArea.repaint();
        }
    }

    public static String getValue(String text, int startPosition, int endPosition) {
        return text.substring(startPosition, endPosition).replace("\r\n ", "").replace("\r ", "").replace("\n ", "");
    }

    public static PrintWriter dumpManifestHeaders(Manifest manifest, PrintWriter out) {
        Attributes mainAttributes = manifest.getMainAttributes();
        Map<String, String> sortedMainAttributes = ManifestFilePage.getSortedAttributes(mainAttributes);
        for (Map.Entry<String, String> entry : sortedMainAttributes.entrySet()) {
            out.print(entry.getKey());
            out.print(": ");
            out.println(ManifestFilePage.dumpValue(entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : manifest.getEntries().entrySet()) {
            out.println("");
            out.println("Entry: " + entry.getKey());
            Map<String, String> sortedEntryAttributes = ManifestFilePage.getSortedAttributes((Attributes)entry.getValue());
            for (Map.Entry<String, String> attributeEntry : sortedEntryAttributes.entrySet()) {
                out.print(attributeEntry.getKey());
                out.print(": ");
                out.println(ManifestFilePage.dumpValue(attributeEntry.getValue()));
            }
        }
        return out;
    }

    private static Map<String, String> getSortedAttributes(Attributes mainAttributes) {
        TreeMap<String, String> sortedMainAttributes = new TreeMap<String, String>();
        for (Map.Entry<Object, Object> attributeEntry : mainAttributes.entrySet()) {
            Attributes.Name attributeName = (Attributes.Name)attributeEntry.getKey();
            sortedMainAttributes.put(attributeName.toString(), (String)attributeEntry.getValue());
        }
        return sortedMainAttributes;
    }

    private static String dumpValue(String value) {
        StringTokenizer valueTokenizer = new StringTokenizer(value, "\",", true);
        boolean inString = false;
        ArrayList<String> valueParts = new ArrayList<String>();
        StringBuilder currentPart = new StringBuilder();
        while (valueTokenizer.hasMoreTokens()) {
            String currentToken = valueTokenizer.nextToken();
            if ("\"".equals(currentToken)) {
                inString = !inString;
                currentPart.append(currentToken);
                continue;
            }
            if (",".equals(currentToken) && !inString) {
                valueParts.add(currentPart.toString());
                currentPart = new StringBuilder();
                continue;
            }
            currentPart.append(currentToken);
        }
        if (currentPart.length() > 0) {
            valueParts.add(currentPart.toString());
        }
        return StringUtils.join(valueParts, (String)",\n  ");
    }

    public static class ManifestHyperlinkData
    extends HyperlinkData {
        public boolean enabled = false;
        public String fragment;

        ManifestHyperlinkData(int startPosition, int endPosition, String fragment) {
            super(startPosition, endPosition);
            this.fragment = fragment;
        }
    }
}

